/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.engineering.StaticLogicalDesign;
import oracle.dbtools.crest.swingui.engineering.StaticRelationalDesign;

public class TreeNavigationDesign
implements TreeModel,
ObjectListener {
    private Set listeners = new HashSet();
    private DesignObject despart;

    public TreeNavigationDesign(DesignPart designPart) {
        if (designPart instanceof LogicalDesign) {
            this.despart = new StaticLogicalDesign((LogicalDesign)designPart);
            this.traverseTreeAndRegisterListener(this.despart);
        } else if (designPart instanceof RelationalDesign) {
            this.despart = new StaticRelationalDesign((RelationalDesign)designPart);
            this.traverseTreeAndRegisterListener(this.despart);
        }
    }

    protected void traverseTreeAndRegisterListener(ModelObject modelObject) {
        int n = modelObject.getNumberOfChildren();
        if (modelObject instanceof DesignObject) {
            ((DesignObject)modelObject).addObjectListener(this);
        }
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject2 = modelObject.getChild(i);
            if (modelObject2 == null) continue;
            this.traverseTreeAndRegisterListener(modelObject2);
        }
    }

    protected void traverseTreeAndUnregisterAsListener(ModelObject modelObject) {
        int n = modelObject.getNumberOfChildren();
        if (modelObject instanceof DesignObject) {
            ((DesignObject)modelObject).removeObjectListener(this);
        }
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject2 = modelObject.getChild(i);
            if (modelObject2 == null) continue;
            this.traverseTreeAndUnregisterAsListener(modelObject2);
        }
    }

    @Override
    public Object getRoot() {
        return this.despart;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected ModelObject toModelObject(Object object) {
        return (ModelObject)object;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).isLeaf();
        }
        return true;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.toModelObject(object).getChildPlain(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object2 instanceof ModelObject) {
            return this.toModelObject(object).getIndexForChild(this.toModelObject(object2));
        }
        return this.toModelObject(object).getIndexForChild(object2);
    }

    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        this.fireStructureChanged(containerObject);
        if (containerObjectEvent.isType(0)) {
            containerObjectEvent.getElement().addObjectListener(this);
            this.fireStructureChanged(containerObjectEvent.getElement());
        } else if (containerObjectEvent.isType(1)) {
            containerObjectEvent.getElement().removeObjectListener(this);
            this.fireStructureChanged(containerObjectEvent.getElement());
        }
    }

    protected void fireStructureChanged(ModelObject modelObject) {
        if (modelObject.hasAlternatePaths()) {
            Object[][] objectArray = modelObject.getAlternatePaths();
            for (int i = 0; i < objectArray.length; ++i) {
                this.fireStructureChanged(modelObject, objectArray[i]);
            }
        } else {
            this.fireStructureChanged(modelObject, modelObject.getPath());
        }
    }

    protected void fireStructureChanged(ModelObject modelObject, Object[] objectArray) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, objectArray));
        }
    }

    protected void fireNodeChanged(ModelObject modelObject) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, modelObject.getPath()));
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        this.fireNodeChanged(designObject);
    }

    public void unregisterAsListener() {
        this.traverseTreeAndUnregisterAsListener(this.despart);
    }
}

