/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolderRecursive;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.engineering.Messages;

public class StaticLogicalDesign
extends DesignObject {
    LogicalDesign design;
    DesignObjectCollection entities;
    DesignObjectCollection relations;
    DesignObjectCollection inheritances;
    DesignObjectCollection candkeys;

    public StaticLogicalDesign(LogicalDesign logicalDesign) {
        super(logicalDesign);
        this.setDesign(logicalDesign.getDesign());
        this.setName(Messages.getString("StaticLogicalDesign.LogicalModel"));
        this.design = logicalDesign;
        this.loadEntities();
        this.loadRelations();
        this.loadCandkeys();
    }

    private void loadElements(DesignObjectCollection designObjectCollection, Iterator iterator) {
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            designObjectCollection.add(new DesignObjectPlaceHolder((DesignPart)this.design, designObject));
        }
    }

    private void loadContainerElements(DesignObjectCollection designObjectCollection, Iterator iterator) {
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            designObjectCollection.add(new ContainerObjectPlaceHolderRecursive(this.design, designObject, true));
        }
    }

    private void loadEntities() {
        this.entities = new DesignObjectCollection();
        this.entities.setName(Messages.getString("StaticLogicalDesign.Entities"));
        this.entities.setParent(this);
        this.entities.setElementDescriptor(Entity.class);
        this.loadContainerElements(this.entities, this.design.getEntitySet().iterator());
    }

    private void loadRelations() {
        this.relations = new DesignObjectCollection();
        this.relations.setName(Messages.getString("StaticLogicalDesign.Relations"));
        this.relations.setParent(this);
        this.relations.setElementDescriptor(Relation.class);
        this.loadElements(this.relations, this.design.getRelationSet().iterator());
    }

    private void loadCandkeys() {
        this.candkeys = new DesignObjectCollection();
        this.candkeys.setName(Messages.getString("StaticLogicalDesign.CandidateKeys"));
        this.candkeys.setParent(this);
        this.candkeys.setElementDescriptor(CandidateKey.class);
        this.loadElements(this.candkeys, this.design.getGlobalCandidateKeySet().iterator());
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public void setShouldEngineer(boolean bl) {
        super.setShouldEngineer(bl);
        this.propagateShouldEngineer(bl);
    }

    public void propagateShouldEngineer(boolean bl) {
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject;
            ModelObject modelObject2 = this.getChild(i);
            if (modelObject2 instanceof DesignObject) {
                modelObject = (DesignObject)modelObject2;
                ((DesignObject)modelObject).setShouldEngineer(bl);
                continue;
            }
            if (!(modelObject2 instanceof DesignObjectCollection)) continue;
            modelObject = (DesignObjectCollection)modelObject2;
            Iterator iterator = ((ModelObjectSet)modelObject).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DesignObject)) continue;
                DesignObject designObject = (DesignObject)e;
                designObject.setShouldEngineer(bl);
            }
        }
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.entities;
            }
            case 1: {
                return this.candkeys;
            }
            case 2: {
                return this.relations;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.entities) {
            return 0;
        }
        if (modelObject == this.candkeys) {
            return 1;
        }
        if (modelObject == this.relations) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public void showPropertyDialog() {
    }
}

