/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.SQLTesterPanel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;

public class TestSQLQueryPanel
extends JPanel
implements TesterComponent {
    private final JTextArea m_txtSQL;
    private final JTextArea m_txtMsg = new JTextArea();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TestSQLPanel");

    public TestSQLQueryPanel(JTextArea jTextArea) {
        this.m_txtSQL = jTextArea;
        this.setLayout(new BorderLayout());
        this.add((Component)SQLTesterPanel.newChildPanel(this.m_txtMsg, UIBundle.get((String)"TESTSQL_MSG_LABEL"), "Result", this.m_reshelp, this), "Center");
        this.m_txtMsg.setLineWrap(true);
        this.m_txtMsg.setWrapStyleWord(true);
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public String getName() {
        return UIBundle.get((String)"TESTSQL_TEST");
    }

    public void testSQL(final Database database, final String string) {
        this.m_txtSQL.setText(null);
        if (database == null) {
            this.m_txtMsg.setText(UIBundle.get((String)"TESTSQL_CHOOSE_DB"));
        } else {
            this.m_txtMsg.setText(UIBundle.get((String)"TESTSQL_RUNNING"));
            final ProgressBar progressBar = new ProgressBar((Component)this, this.getName(), null, true);
            progressBar.setRunnable(new Runnable(){

                @Override
                public void run() {
                    TestSQLQueryPanel.this.doTestSQL(database, string);
                    progressBar.setDoneStatus();
                }
            });
            progressBar.start(null, null, 1500);
        }
    }

    private void doTestSQL(Database database, String string) {
        final Holder holder = new Holder((Object)string);
        final Holder holder2 = new Holder((Object)UIBundle.get((String)"TESTSQL_SUCCESS"));
        final Holder holder3 = new Holder();
        try {
            database.testSQLStatement(string);
        }
        catch (InvalidSQLException invalidSQLException) {
            holder2.set((Object)invalidSQLException.getMessage());
            holder.set((Object)invalidSQLException.getSQLWithError());
            holder3.set((Object)invalidSQLException.getOffset());
        }
        catch (DBException dBException) {
            holder2.set((Object)dBException.getMessage());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestSQLQueryPanel.this.setText(TestSQLQueryPanel.this.m_txtMsg, (String)holder2.get());
                String string = (String)holder.get();
                Integer n = (Integer)holder3.get();
                TestSQLQueryPanel.this.setText(TestSQLQueryPanel.this.m_txtSQL, string);
                if (n != null && string != null) {
                    int n2 = TestSQLQueryPanel.this.getWordEnd(string, n);
                    if (n2 == n) {
                        int n3 = string.indexOf("^", (int)n);
                        if (n3 >= 0) {
                            TestSQLQueryPanel.this.m_txtSQL.setCaretPosition(n3);
                        }
                    } else {
                        TestSQLQueryPanel.this.m_txtSQL.setCaretPosition(n);
                        TestSQLQueryPanel.this.m_txtSQL.moveCaretPosition(n2 + 1);
                    }
                    TestSQLQueryPanel.this.m_txtSQL.requestFocusInWindow();
                }
            }
        });
    }

    private int getWordEnd(String string, int n) {
        int n2 = n;
        for (int i = n; i < string.length(); ++i) {
            n2 = i;
            if (Character.isWhitespace(string.charAt(i + 1))) break;
        }
        return n2;
    }

    private void setText(JTextArea jTextArea, String string) {
        jTextArea.setText(string);
        jTextArea.setCaretPosition(0);
    }
}

