/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.SQLTesterPanel;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;

public class DMSQLQueryTester
implements AbstractEditorConstants {
    private static Collection<Class<? extends TesterComponent>> s_registry;
    private final Database m_db;
    private final SQLTesterPanel m_panel;
    private JDialog dialog;
    private ApplicationView appView = ApplicationView.getInstance();
    private JButton bnClose;
    private JPanel pnButtons;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DMSQLQueryTester.this.close();
        }
    };

    public DMSQLQueryTester(Database database) {
        this.m_db = database;
        this.m_panel = new SQLTesterPanel();
        for (TesterComponent testerComponent : DMSQLQueryTester.createComponents()) {
            this.m_panel.addPanel(testerComponent);
        }
    }

    private String getTitle() {
        return UIBundle.get((String)"TESTSQL_TITLE");
    }

    public void showDialog(Component component, String string) {
        this.dialog = new JDialog((Frame)this.appView.getFrame(), this.getTitle());
        this.dialog.setResizable(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(10, 10, 1, 10), 0, 0));
        this.dialog.getContentPane().add((Component)jPanel, "Center");
        jPanel2.add((Component)this.m_panel, "Center");
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        int n = 1;
        JComponent jComponent = (JComponent)this.dialog.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escapeAction);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                DMSQLQueryTester.this.bnClose.requestFocusInWindow();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Rectangle rectangle = new Rectangle(DMSQLQueryTester.this.dialog.getLocation(), DMSQLQueryTester.this.dialog.getSize());
                DMSQLQueryTester.this.appView.getSettings().setDialogSettings(DMSQLQueryTester.class.getName(), rectangle);
            }
        });
        this.dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = DMSQLQueryTester.this.dialog.getWidth();
                int n2 = DMSQLQueryTester.this.dialog.getHeight();
                n = Math.max(500, n);
                n2 = Math.max(600, n2);
                DMSQLQueryTester.this.dialog.setSize(n, n2);
            }
        });
        Rectangle rectangle = this.appView.getSettings().getDialogSettings(DMSQLQueryTester.class.getName());
        if (rectangle == null) {
            this.dialog.setSize(500, 600);
            CommonUtil.centerOnScreen(this.dialog);
        } else {
            this.dialog.setSize(rectangle.getSize());
            this.dialog.setLocation(rectangle.getLocation());
            this.m_panel.getSplitPane().setDividerLocation((int)(rectangle.getHeight() / 2.0));
        }
        this.bnClose = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DMSQLQueryTester.this.close();
            }
        });
        this.bnClose.setMnemonic(67);
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.dialog.getRootPane().setDefaultButton(this.bnClose);
        this.pnButtons = new JPanel(new FlowLayout(2));
        this.pnButtons.add(this.bnClose);
        jPanel2.add((Component)this.pnButtons, "South");
        this.m_panel.testSQL(this.m_db, string);
        this.m_panel.getTabbedPane().setSelectedIndex(SQLTesterPanel.getCurrentTab());
        this.dialog.setVisible(true);
    }

    private void close() {
        SQLTesterPanel.setCurrentTab(this.m_panel.getTabbedPane().getSelectedIndex());
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.appView.getSettings().setDialogSettings(DMSQLQueryTester.class.getName(), rectangle);
        this.dialog.dispose();
    }

    public void setSQLText(String string) {
        this.m_panel.testSQL(this.m_db, string);
    }

    public static void registerComponent(Class<? extends TesterComponent> clazz) {
        if (clazz != null) {
            if (s_registry == null) {
                s_registry = new ArrayList<Class<? extends TesterComponent>>();
            }
            if (!s_registry.contains(clazz)) {
                s_registry.add(clazz);
            }
        }
    }

    private static Collection<TesterComponent> createComponents() {
        List<TesterComponent> list;
        if (s_registry == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList();
            for (Class<? extends TesterComponent> clazz : s_registry) {
                try {
                    list.add(clazz.newInstance());
                }
                catch (Exception exception) {
                    DBLog.getLogger(SQLQueryTester.class).log(Level.WARNING, "Error creating query test component " + clazz.getSimpleName(), exception);
                }
            }
        }
        return list;
    }
}

