/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.viewbuilder.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;

public class ViewBuilder
extends JPanel {
    public static final String MODIFY_LABEL = Messages.getString("ViewBuilder.Modify");
    public static final String ADD_LABEL = Messages.getString("ViewBuilder.Add");
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel tablesPanel = new JPanel(new SpringLayout());
    protected JPanel columnsPanel = new JPanel(new SpringLayout());
    protected JPanel wherePanel = new JPanel(new SpringLayout());
    protected JPanel groupByPanel = new JPanel(new SpringLayout());
    protected JPanel havingPanel = new JPanel(new SpringLayout());
    protected JPanel orderByPanel = new JPanel(new SpringLayout());
    protected JPanel previewPanel = new JPanel(new SpringLayout());
    protected JPanel ddlPanel = new JPanel(new SpringLayout());
    protected JTextArea sqlArea = new JTextArea();
    protected JTextArea defineDDLArea = new JTextArea();
    protected JTextArea whereArea = new JTextArea();
    protected JTextArea groupByArea = new JTextArea();
    protected JTextArea havingArea = new JTextArea();
    protected JCheckBox defineDDLChBox;
    protected JButton defineWhere;
    protected JTable allTablesTable;
    protected DefaultListModel allTablesModel;
    protected JList allTablesList;
    protected SelectedTablesTable selectedTablesTable;
    protected JButton bnAddTables;
    protected JButton bnRemoveTables;
    protected JButton bnMoveUpTable;
    protected JButton bnMoveDownTable;
    private List containerList = new ArrayList();
    protected DefaultListModel allColumnsModel;
    protected JList allColumnsList;
    protected JTable selectedColumnsTable;
    protected JButton bnAddColumns;
    protected JButton bnRemoveColumns;
    protected JButton bnNewExpression;
    private List columnViewList = new ArrayList();
    protected DefaultListModel allColumnsOrderByModel;
    protected JList allColumnsOrderByList;
    protected SelectedOrderByColumnsTable selectedOrderByColumnsTable;
    protected JButton bnAddOrderByColumns;
    protected JButton bnRemoveOrderByColumns;
    protected JButton bnNewOrderByColumns;
    private List orderByList = new ArrayList();
    protected TableView view;
    protected RelationalDesign design;
    private ContainerObject contObject;
    private List expressionList = new ArrayList();

    public ViewBuilder(ContainerObject containerObject) {
        this.contObject = containerObject;
    }

    public JDialog getDialog(ApplicationView applicationView) {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)applicationView.getFrame(), Messages.getString("ViewBuilder.ViewBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "East");
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab("Tables", this.tablesPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Columns"), this.columnsPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Where"), this.wherePanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.GroupByT"), this.groupByPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Having"), this.havingPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.OrderBy"), this.orderByPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.Preview"), this.previewPanel);
            this.tpane.addTab(Messages.getString("ViewBuilder.DefineDDL"), this.ddlPanel);
            this.tpane.addChangeListener(new TabChangeListener());
            this.initTablesPane();
            this.initColumnsPane();
            this.initWherePane();
            this.initGroupByPane();
            this.initHavingPane();
            this.initOrderByPane();
            this.initPreviewPane();
            this.initDefineDDLPane();
            this.dialog.setModal(true);
            this.dialog.setSize(new Dimension(775, 355));
            this.dialog.setResizable(false);
        }
        CommonUtil.centerOnScreen(this.dialog);
        this.clear();
        this.initProperties(this.contObject);
        return this.dialog;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
            JButton jButton = new JButton(Messages.getString("ViewBuilder.OK"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedTablesTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedColumnsTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedOrderByColumnsTable);
                    if (ViewBuilder.this.canExit()) {
                        ViewBuilder.this.setProperties();
                        ViewBuilder.this.dialog.dispose();
                    }
                }
            });
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            JButton jButton2 = new JButton(Messages.getString("ViewBuilder.Apply"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedTablesTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedColumnsTable);
                    ViewBuilder.this.stopTableCellEditing(ViewBuilder.this.selectedOrderByColumnsTable);
                    if (ViewBuilder.this.canExit()) {
                        ViewBuilder.this.setProperties();
                    }
                }
            });
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            JButton jButton3 = new JButton(Messages.getString("ViewBuilder.Cancel"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewBuilder.this.dialog.dispose();
                }
            });
            jButton3.setMnemonic(67);
            jButton3.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            this.buttonPanel.add((Component)jPanel, "North");
        }
        return this.buttonPanel;
    }

    protected SpringLayout getPanelLayout(JPanel jPanel) {
        return (SpringLayout)jPanel.getLayout();
    }

    protected void initTablesPane() {
        this.initAllTablesList();
        this.initSelectedTablesList();
        this.initTablesButtons();
    }

    protected void initColumnsPane() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    protected void initWherePane() {
        this.defineWhere = new JButton(Messages.getString("ViewBuilder.InsertJoinClauseForFK"));
        this.defineWhere.addActionListener(new WhereListener());
        this.wherePanel.add(this.defineWhere);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), this.defineWhere, 10, 12);
        JScrollPane jScrollPane = new JScrollPane(this.whereArea);
        jScrollPane.setPreferredSize(new Dimension(645, 255));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.wherePanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.wherePanel), jScrollPane, 10, 42);
    }

    protected void initGroupByPane() {
        JScrollPane jScrollPane = new JScrollPane(this.groupByArea);
        this.groupByArea.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.groupByPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.groupByPanel), jScrollPane, 10, 12);
    }

    protected void initHavingPane() {
        JScrollPane jScrollPane = new JScrollPane(this.havingArea);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.havingPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.havingPanel), jScrollPane, 10, 12);
    }

    protected void initOrderByPane() {
        this.initAllColumnsOrderByList();
        this.initSelectedColumnsOrderByList();
        this.initColumnsOrderByButtons();
    }

    protected void initPreviewPane() {
        JScrollPane jScrollPane = new JScrollPane(this.sqlArea);
        jScrollPane.setPreferredSize(new Dimension(645, 285));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.previewPanel.add(jScrollPane);
        this.sqlArea.setEnabled(false);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.previewPanel), jScrollPane, 10, 12);
    }

    protected void initDefineDDLPane() {
        this.defineDDLChBox = new JCheckBox(Messages.getString("ViewBuilder.UserDefinedDDL"));
        this.defineDDLChBox.addActionListener(new CheckBoxListener());
        this.ddlPanel.add(this.defineDDLChBox);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), this.defineDDLChBox, 10, 12);
        JScrollPane jScrollPane = new JScrollPane(this.defineDDLArea);
        jScrollPane.setPreferredSize(new Dimension(645, 255));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.ddlPanel.add(jScrollPane);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.ddlPanel), jScrollPane, 10, 42);
    }

    protected void initAllTablesList() {
        JLabel jLabel = new JLabel(Messages.getString("ViewBuilder.AvailableTables"));
        this.tablesPanel.add(jLabel);
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        ListSelectionModel listSelectionModel = this.allTablesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListTablesSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allTablesList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tablesPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.tablesPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedTablesList() {
        this.selectedTablesTable = new SelectedTablesTable();
        this.selectedTablesTable.setModel(new SelectedTablesModel());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.containerList, this.selectedTablesTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedTablesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTablesHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedTablesTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add((Component)jScrollPane, "Center");
        this.tablesPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), jPanel, 332, 14);
    }

    protected void initTablesButtons() {
        this.bnAddTables = new JButton(ADD_LABEL);
        this.bnAddTables.addActionListener(new AddTablesActionListener());
        this.bnAddTables.setPreferredSize(new Dimension(90, 26));
        this.bnAddTables.setEnabled(false);
        this.tablesPanel.add(this.bnAddTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnAddTables, 232, 32);
        this.bnRemoveTables = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveTables.setEnabled(false);
        this.bnRemoveTables.addActionListener(new RemoveTablesActionListener());
        this.bnRemoveTables.setPreferredSize(new Dimension(90, 26));
        this.tablesPanel.add(this.bnRemoveTables);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.tablesPanel), this.bnRemoveTables, 232, 62);
    }

    protected void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("ViewBuilder.AvailableColumns"));
        this.columnsPanel.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.columnsPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedColumnsList() {
        this.selectedColumnsTable = new JTable();
        this.selectedColumnsTable.setModel(new SelectedColumnsModel());
        this.selectedColumnsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn tableColumn = null;
        block5: for (int i = 0; i < 3; ++i) {
            tableColumn = this.selectedColumnsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setCellEditor(new ExpressionCellEditor());
                    tableColumn.setPreferredWidth(120);
                    continue block5;
                }
                case 1: {
                    tableColumn.setCellRenderer(new LabelTableCellRenderer());
                    tableColumn.setCellEditor(new TextCellEditor());
                    tableColumn.setPreferredWidth(60);
                    continue block5;
                }
                case 2: {
                    tableColumn.setCellRenderer(new CheckBoxTableCellRenderer());
                    tableColumn.setCellEditor(new CheckBoxEditor());
                    tableColumn.setPreferredWidth(40);
                }
            }
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.columnViewList, this.selectedColumnsTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add(jScrollPane);
        this.columnsPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), jPanel, 332, 14);
    }

    private void stopEdit() {
        TableCellEditor tableCellEditor;
        int n = this.selectedColumnsTable.getEditingColumn();
        int n2 = this.selectedColumnsTable.getEditingRow();
        if (n > -1 && n2 > -1 && (tableCellEditor = this.selectedColumnsTable.getCellEditor(n2, n)) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    protected void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_LABEL);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnAddColumns, 232, 32);
        this.bnNewExpression = new JButton(Messages.getString("ViewBuilder.New"));
        this.bnNewExpression.setEnabled(false);
        this.bnNewExpression.addActionListener(new NewExpressionActionListener());
        this.bnNewExpression.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnNewExpression);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnNewExpression, 232, 62);
        this.bnRemoveColumns = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.bnRemoveColumns.setPreferredSize(new Dimension(90, 26));
        this.columnsPanel.add(this.bnRemoveColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.columnsPanel), this.bnRemoveColumns, 232, 92);
    }

    protected void initAllColumnsOrderByList() {
        JLabel jLabel = new JLabel(Messages.getString("ViewBuilder.AvailableColumns"));
        this.orderByPanel.add(jLabel);
        this.allColumnsOrderByModel = new DefaultListModel();
        this.allColumnsOrderByList = new JList(this.allColumnsOrderByModel);
        this.allColumnsOrderByList.setCellRenderer(new AllListOrderByColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsOrderByList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListColumnsOrderBySelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsOrderByList);
        jScrollPane.setPreferredSize(new Dimension(210, 265));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.orderByPanel.add(jScrollPane);
        CommonUtil.setLabelConstraints(this.getPanelLayout(this.orderByPanel), jLabel, 12, 14);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), jScrollPane, 10, 32);
    }

    protected void initSelectedColumnsOrderByList() {
        this.selectedOrderByColumnsTable = new SelectedOrderByColumnsTable();
        this.selectedOrderByColumnsTable.setModel(new SelectedOrderByColumnsModel());
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        MoveUpDownListJTable moveUpDownListJTable = new MoveUpDownListJTable(this.orderByList, this.selectedOrderByColumnsTable);
        this.bnMoveUpTable = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        this.bnMoveUpTable.setToolTipText(Messages.getString("ViewBuilder.MoveUp"));
        this.bnMoveUpTable.addActionListener(new MoveUpDownListJTable.MoveUpAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveUpTable);
        this.bnMoveDownTable = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        this.bnMoveDownTable.setToolTipText(Messages.getString("ViewBuilder.MoveDown"));
        this.bnMoveDownTable.addActionListener(new MoveUpDownListJTable.MoveDownAction(moveUpDownListJTable));
        jToolBar.add(this.bnMoveDownTable);
        jPanel.add((Component)jToolBar, "North");
        ListSelectionModel listSelectionModel = this.selectedOrderByColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedOrderByColumnsHandler());
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.selectedOrderByColumnsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(120);
                continue;
            }
            if (i != 1) continue;
            tableColumn.setPreferredWidth(60);
            tableColumn.setCellEditor(new ComboCellEditor());
        }
        JScrollPane jScrollPane = new JScrollPane(this.selectedOrderByColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(325, 248));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        jPanel.add((Component)jScrollPane, "Center");
        this.orderByPanel.add(jPanel);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), jPanel, 332, 14);
    }

    protected void initColumnsOrderByButtons() {
        this.bnAddOrderByColumns = new JButton(ADD_LABEL);
        this.bnAddOrderByColumns.addActionListener(new AddOrderByColumnsActionListener());
        this.bnAddOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.bnAddOrderByColumns.setEnabled(false);
        this.orderByPanel.add(this.bnAddOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnAddOrderByColumns, 232, 32);
        this.bnNewOrderByColumns = new JButton(Messages.getString("ViewBuilder.New"));
        this.bnNewOrderByColumns.setEnabled(false);
        this.bnNewOrderByColumns.addActionListener(new NewOrderByColumnsActionListener());
        this.bnNewOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnNewOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnNewOrderByColumns, 232, 62);
        this.bnRemoveOrderByColumns = new JButton(Messages.getString("ViewBuilder.Remove"));
        this.bnRemoveOrderByColumns.setEnabled(false);
        this.bnRemoveOrderByColumns.addActionListener(new RemoveOrderByColumnsActionListener());
        this.bnRemoveOrderByColumns.setPreferredSize(new Dimension(90, 26));
        this.orderByPanel.add(this.bnRemoveOrderByColumns);
        CommonUtil.setObjectConstraints(this.getPanelLayout(this.orderByPanel), this.bnRemoveOrderByColumns, 232, 92);
    }

    private String appendQuotes(String string) {
        StorageDesign storageDesign = ((RelationalDesign)this.view.getDesignPart()).getStorageDesign();
        if (storageDesign != null) {
            return storageDesign.getFormatedName(string);
        }
        if (string.trim().indexOf(32) > -1) {
            return "\"" + string.trim() + "\"";
        }
        return string;
    }

    protected String generateWhere() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        Object[] objectArray = this.containerList.toArray();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            ContainerElement containerElement = (ContainerElement)objectArray[i];
            if (!(containerElement.getContainerObject() instanceof Table)) continue;
            Table table = (Table)containerElement.getContainerObject();
            String string = containerElement.getContainerAlias();
            for (int j = n = i + 1; j < objectArray.length; ++j) {
                int n2;
                Column[] columnArray;
                int n3;
                FKIndexAssociation[] fKIndexAssociationArray;
                ContainerElement containerElement2 = (ContainerElement)objectArray[j];
                if (!(containerElement2.getContainerObject() instanceof Table)) continue;
                Table table2 = (Table)containerElement2.getContainerObject();
                String string2 = containerElement2.getContainerAlias();
                if (table.getFKIndexAssociationsWith(table2).length > 0) {
                    fKIndexAssociationArray = table.getFKIndexAssociationsWith(table2);
                    for (n3 = 0; n3 < fKIndexAssociationArray.length; ++n3) {
                        if (!bl) {
                            stringBuffer.append("\n");
                            stringBuffer.append("AND ");
                        } else {
                            bl = false;
                        }
                        columnArray = fKIndexAssociationArray[n3].getColumns();
                        for (n2 = 0; n2 < columnArray.length; ++n2) {
                            if (n2 > 0) {
                                stringBuffer.append("\n");
                                stringBuffer.append("AND ");
                            }
                            if (!string.trim().equalsIgnoreCase("")) {
                                stringBuffer.append(this.appendQuotes(string));
                                stringBuffer.append('.');
                            }
                            stringBuffer.append(this.appendQuotes(columnArray[n2].getName()));
                            stringBuffer.append(" = ");
                            if (!string2.trim().equalsIgnoreCase("")) {
                                stringBuffer.append(this.appendQuotes(string2));
                                stringBuffer.append('.');
                            }
                            stringBuffer.append(this.appendQuotes(columnArray[n2].getReferencedColumn(fKIndexAssociationArray[n3]).getName()));
                        }
                    }
                    continue;
                }
                if (table2.getFKIndexAssociationsWith(table).length <= 0) continue;
                fKIndexAssociationArray = table2.getFKIndexAssociationsWith(table);
                for (n3 = 0; n3 < fKIndexAssociationArray.length; ++n3) {
                    if (!bl) {
                        stringBuffer.append("\n");
                        stringBuffer.append("AND ");
                    } else {
                        bl = false;
                    }
                    columnArray = fKIndexAssociationArray[n3].getColumns();
                    for (n2 = 0; n2 < columnArray.length; ++n2) {
                        if (n2 > 0) {
                            stringBuffer.append("\n");
                            stringBuffer.append("AND ");
                        }
                        if (!string.trim().equalsIgnoreCase("")) {
                            stringBuffer.append(this.appendQuotes(string));
                            stringBuffer.append('.');
                        }
                        stringBuffer.append(this.appendQuotes(columnArray[n2].getName()));
                        stringBuffer.append(" = ");
                        if (!string2.trim().equalsIgnoreCase("")) {
                            stringBuffer.append(this.appendQuotes(string2));
                            stringBuffer.append('.');
                        }
                        stringBuffer.append(this.appendQuotes(columnArray[n2].getReferencedColumn(fKIndexAssociationArray[n3]).getName()));
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String generateGroupBy() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (ColumnElement columnElement : this.columnViewList) {
            if (!columnElement.getGroupBy()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getGroupByValue(columnElement.getColumnView()));
        }
        return stringBuffer.toString();
    }

    protected String generateSQL() {
        this.stopEdit();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.selectedColumnsTable.getRowCount() > 0) {
            Object object;
            Object object2;
            stringBuffer = new StringBuffer("CREATE VIEW ");
            stringBuffer.append(this.appendQuotes(this.view.getName()));
            int n = 0;
            for (Object object3 : this.columnViewList) {
                object2 = ((ColumnElement)object3).getColumnView();
                object = ((AbstractViewElement)object2).getAlias().trim();
                if ("".equals(object)) {
                    object = ((ColumnElement)object3).getAlias();
                }
                if (((AbstractViewElement)object2).toString().trim().equalsIgnoreCase("")) continue;
                if (n == 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append("  (");
                } else {
                    stringBuffer.append(",\n   ");
                }
                stringBuffer.append(' ');
                if (!((String)object).trim().equalsIgnoreCase("")) {
                    stringBuffer.append(this.appendQuotes((String)object));
                } else {
                    stringBuffer.append(this.appendQuotes(((AbstractViewElement)object2).getReferencedName()));
                }
                ++n;
            }
            stringBuffer.append(' ');
            stringBuffer.append(')');
            stringBuffer.append("\n");
            stringBuffer.append("AS SELECT\n   ");
            n = 0;
            for (Object object3 : this.columnViewList) {
                if (((ColumnElement)object3).getColumnView().toString().equalsIgnoreCase("")) continue;
                if (n > 0) {
                    stringBuffer.append(",\n   ");
                }
                stringBuffer.append(' ');
                object2 = ((ColumnElement)object3).getAlias().trim();
                object = ((ColumnElement)object3).getColumnView();
                if (((ColumnElement)object3).getColumnView().getTableAlias().equalsIgnoreCase("")) {
                    if (!((AbstractViewElement)object).getExpression().equals("")) {
                        stringBuffer.append(this.appendQuotes(((AbstractViewElement)object).getExpression()));
                        if (!"".equals(object2)) {
                            stringBuffer.append(" ").append((String)object2);
                        }
                    } else if (!((ColumnElement)object3).getColumnView().getAlias().equalsIgnoreCase("")) {
                        stringBuffer.append(this.appendQuotes(((ColumnElement)object3).getColumnView().getAlias()));
                    } else {
                        stringBuffer.append(this.appendQuotes(((ColumnElement)object3).getColumnView().getName()));
                    }
                } else {
                    String string = ((ColumnElement)object3).getColumnView().getTableAlias().trim();
                    if (!((AbstractViewElement)object).getExpression().equals("")) {
                        stringBuffer.append(this.appendQuotes(((AbstractViewElement)object).getExpression()));
                        if (!"".equals(object2)) {
                            stringBuffer.append(" ").append((String)object2);
                        }
                    } else if (!"".equals(string)) {
                        stringBuffer.append(this.appendQuotes(string) + "." + this.appendQuotes(((ColumnElement)object3).getColumnView().getReferencedName()));
                    } else {
                        stringBuffer.append(this.appendQuotes(((ColumnElement)object3).getColumnView().getReferencedName()));
                    }
                    if (((ColumnElement)object3).getColumnView().getAlias().length() > 0) {
                        stringBuffer.append(' ').append(this.appendQuotes(((ColumnElement)object3).getColumnView().getAlias()));
                    }
                }
                ++n;
            }
            if (this.containerList.size() > 0) {
                if (this.containerList.size() > 0) {
                    stringBuffer.append("\n");
                    stringBuffer.append(" FROM \n");
                }
                n = 0;
                for (Object object3 : this.containerList) {
                    if (n > 0) {
                        stringBuffer.append(",\n    ");
                    } else {
                        stringBuffer.append("    ");
                    }
                    if (((ContainerElement)object3).getContainerObject() != null) {
                        object2 = ((ContainerElement)object3).getContainerObject().getName();
                        object = ((ContainerElement)object3).getContainerAlias();
                        stringBuffer.append(this.appendQuotes((String)object2));
                        stringBuffer.append(' ');
                        stringBuffer.append(this.appendQuotes((String)object));
                    }
                    ++n;
                }
            }
            if (!this.whereArea.getText().trim().equalsIgnoreCase("")) {
                stringBuffer.append("\n");
                stringBuffer.append(" WHERE \n");
                stringBuffer.append("    ");
                stringBuffer.append(this.whereArea.getText());
            }
            if (!this.groupByArea.getText().trim().equalsIgnoreCase("")) {
                stringBuffer.append("\n");
                stringBuffer.append(" GROUP BY \n");
                boolean bl = true;
                Iterator iterator = this.columnViewList.iterator();
                stringBuffer.append("    ");
                while (iterator.hasNext()) {
                    object2 = (ColumnElement)iterator.next();
                    if (!((ColumnElement)object2).getGroupBy()) continue;
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(",");
                        stringBuffer.append("\n");
                        stringBuffer.append("    ");
                    }
                    stringBuffer.append(this.appendQuotes(this.getValue(((ColumnElement)object2).getColumnView())));
                }
            }
            if (!this.havingArea.getText().trim().equalsIgnoreCase("")) {
                stringBuffer.append("\n");
                stringBuffer.append(" HAVING \n");
                stringBuffer.append("    ");
                stringBuffer.append(this.havingArea.getText());
            }
            if (this.orderByList.size() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(" ORDER BY \n");
                n = 0;
                for (OrderByElement orderByElement : this.orderByList) {
                    object2 = "";
                    object = orderByElement.getSort();
                    for (ColumnElement columnElement : this.columnViewList) {
                        if (!orderByElement.getContainedObject().getName().equalsIgnoreCase(columnElement.getColumnView().getName())) continue;
                        object2 = columnElement.getAlias();
                        break;
                    }
                    if (((String)object2).equalsIgnoreCase("")) {
                        object2 = orderByElement.getContainedObject().getName();
                    }
                    if (n > 0) {
                        stringBuffer.append(",\n   ");
                    } else {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append((String)object2);
                    stringBuffer.append(' ');
                    stringBuffer.append((String)object);
                    ++n;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public void initProperties(ContainerObject containerObject) {
        if (containerObject instanceof TableView) {
            Object object;
            DesignObject designObject;
            this.view = (TableView)containerObject;
            this.design = (RelationalDesign)this.view.getDesignPart();
            TableSet tableSet = this.design.getTableSet();
            TableViewSet tableViewSet = this.design.getTableViewSet();
            Iterator iterator = tableSet.iterator();
            while (iterator.hasNext()) {
                this.allTablesModel.addElement(iterator.next());
            }
            iterator = tableViewSet.iterator();
            while (iterator.hasNext()) {
                designObject = (TableView)iterator.next();
                if (designObject == this.view) continue;
                this.allTablesModel.addElement(designObject);
            }
            for (int i = 0; i < this.view.getColumns().length; ++i) {
                designObject = (ColumnView)this.view.getColumns()[i];
                if (this.view.getGroupByList().contains(designObject)) {
                    this.columnViewList.add(new ColumnElement((ColumnView)designObject, ((AbstractViewElement)designObject).getAlias(), true));
                } else {
                    this.columnViewList.add(new ColumnElement((ColumnView)designObject, ((AbstractViewElement)designObject).getAlias(), false));
                }
                if (((AbstractViewElement)designObject).getExpression().equalsIgnoreCase("")) continue;
                object = new ColumnAlias((ContainedObject)designObject, ((AbstractViewElement)designObject).getTableAlias());
                this.expressionList.add(object);
                this.allColumnsOrderByModel.addElement(object);
            }
            this.enableAll(!this.view.getUserDefined());
            this.whereArea.setText(this.view.getWhere());
            this.groupByArea.setText(this.view.getGroupBy());
            this.havingArea.setText(this.view.getHaving());
            for (Object object2 : this.view.getUsedContainers()) {
                object = ((AbstractView.ContainerHolder)object2).getAlias();
                ContainerObject containerObject2 = ((AbstractView.ContainerHolder)object2).getContainer();
                if (containerObject2 != null) {
                    ContainedObject[] containedObjectArray = containerObject2.getElements();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        ContainedObject containedObject = containedObjectArray[i];
                        this.allColumnsModel.addElement(new ColumnAlias(containedObject, (String)object));
                        this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, (String)object));
                    }
                }
                if (containerObject2 != null) {
                    this.containerList.add(new ContainerElement(containerObject2, (String)object));
                    continue;
                }
                this.view.getContainerMap().remove(object);
            }
            if (!this.view.getUserDefined()) {
                for (Object object2 : this.view.getOrderByList()) {
                    this.orderByList.add(new OrderByElement((ContainedObject)object2, this.view.getOrderByMap().get(((ModelIDObject)object2).getObjectID()).toString()));
                }
                this.sqlArea.setText(this.generateSQL());
                this.defineDDLChBox.setSelected(false);
                this.defineDDLArea.setEnabled(false);
                this.defineDDLArea.setText("");
            } else {
                this.defineDDLChBox.setSelected(true);
                this.defineDDLArea.setEnabled(true);
                this.defineDDLArea.setText(this.view.getUserDefinedSQL());
            }
        }
    }

    protected void setProperties() {
        if (this.view != null) {
            this.stopEdit();
            if (this.defineDDLChBox.isSelected()) {
                this.view.setUserDefined(true);
                String string = this.defineDDLArea.getText();
                if (!this.getViewName(string).trim().equalsIgnoreCase("")) {
                    this.view.setName(this.getViewName(string));
                }
                this.view.setUserDefinedSQL(string);
                this.view.removeAllElements();
                this.view.removeAllFromElements();
                this.view.removeAllFromOrderBy();
                this.view.removeAllGroupByList();
                this.view.setWhere("");
                this.view.setGroupBy("");
                this.view.setHaving("");
                this.view.getColumns(string.replaceAll("\\s+", " ").replaceAll(" +", " "));
            } else {
                Object object3;
                Object object22;
                this.view.setUserDefined(false);
                this.view.setUserDefinedSQL(this.generateSQL());
                this.view.removeAllFromElements();
                for (Object object22 : this.containerList) {
                    this.view.addToContainers(((ContainerElement)object22).getContainerObject(), ((ContainerElement)object22).getContainerAlias());
                }
                object22 = new ArrayList();
                for (Object object3 : this.view.getElementsCollection()) {
                    if (((ContainedObject)object3).getName().trim().equalsIgnoreCase("")) continue;
                    boolean bl = false;
                    for (ColumnElement columnElement : this.columnViewList) {
                        if (!columnElement.getColumnView().getName().equalsIgnoreCase(((ContainedObject)object3).getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    ((ArrayList)object22).add(object3);
                }
                Iterator iterator = ((ArrayList)object22).iterator();
                while (iterator.hasNext()) {
                    this.view.clear((ColumnView)iterator.next());
                }
                this.view.removeAllElements();
                this.view.removeAllGroupByList();
                object3 = new ArrayList();
                for (ColumnElement columnElement : this.columnViewList) {
                    object3.add(columnElement.getColumnView());
                    if (columnElement.getColumnView().getName().equalsIgnoreCase("")) continue;
                    if (columnElement.getColumnView().getReferencedColumnView() != null) {
                        if (columnElement.getAlias().equalsIgnoreCase("")) {
                            columnElement.getColumnView().setAlias(((ColumnView)columnElement.getColumnView().getReferencedColumnView()).getAlias());
                        } else {
                            columnElement.getColumnView().setAlias(columnElement.getAlias());
                        }
                    } else {
                        columnElement.getColumnView().setAlias(columnElement.getAlias());
                    }
                    this.view.add(columnElement.getColumnView());
                    if (!columnElement.getGroupBy()) continue;
                    this.view.addGroupByList(columnElement.getColumnView());
                }
                for (int i = 0; i < object3.size(); ++i) {
                    this.view.moveToIndex((ContainedObject)object3.get(i), i);
                }
                this.view.removeAllFromOrderBy();
                for (OrderByElement orderByElement : this.orderByList) {
                    this.view.addToOrderBy(orderByElement.getContainedObject(), orderByElement.getSort());
                }
                this.view.setWhere(this.whereArea.getText());
                this.view.setGroupBy(this.generateGroupBy());
                this.view.setHaving(this.havingArea.getText());
            }
            this.view.setDirty(true);
        }
    }

    protected void clear() {
        this.allTablesModel.clear();
        Iterator iterator = this.containerList.iterator();
        while (iterator.hasNext()) {
            this.containerList.remove(0);
        }
        this.allColumnsModel.clear();
        int n = this.selectedColumnsTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.columnViewList.remove(0);
        }
        this.allColumnsOrderByModel.clear();
        iterator = this.orderByList.iterator();
        while (iterator.hasNext()) {
            this.orderByList.remove(0);
        }
    }

    private String getViewName(String string) {
        StringTokenizer stringTokenizer;
        String string2 = "";
        String string3 = "";
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("VIEW")) continue;
            string3 = stringArray[i + 1];
            break;
        }
        if ((stringTokenizer = new StringTokenizer(string3, ".")).countTokens() == 2) {
            string2 = stringTokenizer.nextToken().trim();
            string2 = Token.getValBetweenSquareBrackets(string2);
            string3 = stringTokenizer.nextToken().trim();
            string3 = Token.getValBetweenSquareBrackets(string3);
        }
        return string3;
    }

    private void enableAll(boolean bl) {
        this.whereArea.setEnabled(bl);
        this.groupByArea.setEnabled(bl);
        this.havingArea.setEnabled(bl);
        this.allTablesList.setEnabled(bl);
        this.allColumnsList.setEnabled(bl);
        this.bnNewExpression.setEnabled(bl);
        this.selectedTablesTable.setEnabled(bl);
        this.selectedColumnsTable.setEnabled(bl);
        this.selectedOrderByColumnsTable.setEnabled(bl);
        this.bnNewOrderByColumns.setEnabled(bl);
        this.allColumnsOrderByList.setEnabled(bl);
        if (!bl) {
            this.allTablesList.setSelectedIndices(new int[0]);
            this.allColumnsList.setSelectedIndices(new int[0]);
            this.allColumnsOrderByList.setSelectedIndices(new int[0]);
            this.selectedTablesTable.clearSelection();
            this.selectedColumnsTable.clearSelection();
            this.selectedOrderByColumnsTable.clearSelection();
        }
    }

    protected boolean canExit() {
        Object object;
        Object object2;
        Object object3;
        int n = 1;
        Object[] objectArray = this.containerList.toArray();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            n = i + 1;
            ContainerElement containerElement = (ContainerElement)objectArray[i];
            object3 = containerElement.getContainerObject();
            object2 = containerElement.getContainerAlias();
            for (int j = n; j < objectArray.length; ++j) {
                object = ((ContainerElement)objectArray[j]).getContainerObject();
                String string = ((ContainerElement)objectArray[j]).getContainerAlias();
                if (!string.equalsIgnoreCase("") && !((String)object2).equalsIgnoreCase("") && string.equalsIgnoreCase((String)object2)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreTablesWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (!string.equalsIgnoreCase("") || !((String)object2).equalsIgnoreCase("") || !((DesignObject)object3).getName().equalsIgnoreCase(((DesignObject)object).getName())) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreTablesWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        Object[] objectArray2 = this.columnViewList.toArray();
        for (int i = 0; i <= objectArray2.length - 1; ++i) {
            n = i + 1;
            object3 = (ColumnElement)objectArray2[i];
            object2 = ((ColumnElement)object3).getColumnView();
            String string = ((ColumnElement)object3).getAlias();
            object = ((AbstractViewElement)object2).getExpression();
            if (!this.checkExpression((String)object, string)) {
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnExpressionsWithoutAnAlias"), Messages.getString("ViewBuilder.EmptyAlias"), 0);
                return false;
            }
            for (int j = n; j <= objectArray2.length - 1; ++j) {
                ColumnView columnView = ((ColumnElement)objectArray2[j]).getColumnView();
                String string2 = ((ColumnElement)objectArray2[j]).getAlias();
                if (string2.equalsIgnoreCase("") && string.equalsIgnoreCase("")) {
                    if (!((AbstractViewElement)object2).getReferencedName().equalsIgnoreCase(columnView.getReferencedName())) continue;
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if (string2.equalsIgnoreCase(string)) {
                    JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                    return false;
                }
                if ((!string.equalsIgnoreCase("") || !string2.equalsIgnoreCase(((ContainedObject)object2).getName())) && (!string2.equalsIgnoreCase("") || !string.equalsIgnoreCase(columnView.getName()))) continue;
                JOptionPane.showMessageDialog(this.dialog, Messages.getString("ViewBuilder.ThereAreColumnsWithEqualNames"), Messages.getString("ViewBuilder.WrongAlias"), 0);
                return false;
            }
        }
        return true;
    }

    public List getColumnViewList() {
        return this.columnViewList;
    }

    public void setColumnViewList(List list) {
        this.columnViewList = list;
    }

    public List getContainerList() {
        return this.containerList;
    }

    public void setContainerList(List list) {
        this.containerList = list;
    }

    private String getValue(ColumnView columnView) {
        String string = columnView.getReferencedName();
        ContainerObject containerObject = columnView.getReferencedContainer();
        if (!columnView.getTableAlias().equalsIgnoreCase("")) {
            return string + "(" + columnView.getTableAlias() + ")";
        }
        if (containerObject != null) {
            return string + "(" + containerObject.getName() + ")";
        }
        if (!columnView.getExpression().equalsIgnoreCase("")) {
            return columnView.getExpression();
        }
        return string;
    }

    private String getGroupByValue(ColumnView columnView) {
        if (!"".equals(columnView.getExpression())) {
            return columnView.getExpression();
        }
        String string = this.appendQuotes(columnView.getName());
        if (!columnView.getTableAlias().equalsIgnoreCase("")) {
            return this.appendQuotes(columnView.getTableAlias()) + "." + string;
        }
        return string;
    }

    private void checkOrderByModel() {
        for (ColumnAlias columnAlias : this.expressionList) {
            if (this.allColumnsOrderByModel.contains(columnAlias)) continue;
            this.allColumnsOrderByModel.addElement(columnAlias);
        }
    }

    private ColumnAlias getColumnAlias(ColumnView columnView) {
        for (ColumnAlias columnAlias : this.expressionList) {
            if (columnAlias.getCol() != columnView) continue;
            return columnAlias;
        }
        return null;
    }

    private void checkModelsForValues(ContainerElement containerElement, String string, String string2) {
        ColumnAlias columnAlias;
        for (int i = 0; i < this.allColumnsModel.size(); ++i) {
            columnAlias = (ColumnAlias)this.allColumnsModel.elementAt(i);
            if (!columnAlias.getTableAlias().equalsIgnoreCase(string) || !columnAlias.getCol().getContainer().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) continue;
            columnAlias.setTableAlias(string2);
            this.allColumnsModel.setElementAt(columnAlias, i);
        }
        for (ColumnElement columnElement : this.columnViewList) {
            if ((!columnElement.getColumnView().getTableAlias().equalsIgnoreCase(string) || columnElement.getColumnView().getTable() == null || !columnElement.getColumnView().getTable().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) && (columnElement.getColumnView().getView() == null || !columnElement.getColumnView().getView().getName().equalsIgnoreCase(containerElement.getContainerObject().getName()))) continue;
            columnElement.getColumnView().setTableAlias(string2);
        }
        for (int i = 0; i < this.allColumnsOrderByModel.size(); ++i) {
            columnAlias = (ColumnAlias)this.allColumnsOrderByModel.elementAt(i);
            if (!columnAlias.getTableAlias().equalsIgnoreCase(string) || !columnAlias.getCol().getContainer().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) continue;
            columnAlias.setTableAlias(string2);
            this.allColumnsOrderByModel.setElementAt(columnAlias, i);
        }
        for (OrderByElement orderByElement : this.orderByList) {
            if ((!((ColumnView)orderByElement.getContainedObject()).getTableAlias().equalsIgnoreCase(string) || ((ColumnView)orderByElement.getContainedObject()).getTable() == null || !((ColumnView)orderByElement.getContainedObject()).getTable().getName().equalsIgnoreCase(containerElement.getContainerObject().getName())) && (((ColumnView)orderByElement.getContainedObject()).getView() == null || !((ColumnView)orderByElement.getContainedObject()).getView().getName().equalsIgnoreCase(containerElement.getContainerObject().getName()))) continue;
            ((ColumnView)orderByElement.getContainedObject()).setTableAlias(string2);
        }
    }

    private boolean checkExpression(String string, String string2) {
        return string.equalsIgnoreCase("") || !string2.equalsIgnoreCase("");
    }

    private void stopTableCellEditing(JTable jTable) {
        int n = jTable.getEditingRow();
        int n2 = jTable.getEditingColumn();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor().stopCellEditing();
        }
    }

    class OrderByElement {
        ContainedObject containedObject;
        String sort;

        public OrderByElement(ContainedObject containedObject, String string) {
            this.containedObject = containedObject;
            this.sort = string;
        }

        public ContainedObject getContainedObject() {
            return this.containedObject;
        }

        public void setContainedObject(ContainedObject containedObject) {
            this.containedObject = containedObject;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String string) {
            this.sort = string;
        }
    }

    class ColumnElement {
        ColumnView columnView;
        String alias;
        boolean groupBy;

        public ColumnElement(ColumnView columnView, String string) {
            this.columnView = columnView;
            this.alias = string;
        }

        public ColumnElement(ColumnView columnView, String string, boolean bl) {
            this(columnView, string);
            this.groupBy = bl;
        }

        public ColumnView getColumnView() {
            return this.columnView;
        }

        public void setColumnView(ColumnView columnView) {
            this.columnView = columnView;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String string) {
            this.alias = string;
        }

        public boolean getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(boolean bl) {
            this.groupBy = bl;
        }
    }

    class ContainerElement {
        ContainerObject containerObject;
        String containerAlias;

        public ContainerElement(ContainerObject containerObject, String string) {
            this.containerObject = containerObject;
            this.containerAlias = string;
        }

        public ContainerObject getContainerObject() {
            return this.containerObject;
        }

        public void setContainer(ContainerObject containerObject) {
            this.containerObject = containerObject;
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String string) {
            this.containerAlias = string;
        }
    }

    private class WhereListener
    implements ActionListener {
        private WhereListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewBuilder.this.whereArea.getText().trim().equalsIgnoreCase("")) {
                ViewBuilder.this.whereArea.setText(ViewBuilder.this.generateWhere());
            } else {
                ViewBuilder.this.whereArea.setText(ViewBuilder.this.generateWhere() + "\n" + ViewBuilder.this.whereArea.getText());
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewBuilder.this.defineDDLArea.setEnabled(ViewBuilder.this.defineDDLChBox.isSelected());
            ViewBuilder.this.enableAll(!ViewBuilder.this.defineDDLChBox.isSelected());
            if (ViewBuilder.this.defineDDLChBox.isSelected()) {
                ViewBuilder.this.defineDDLArea.setText(ViewBuilder.this.generateSQL());
            } else {
                ViewBuilder.this.defineDDLArea.setText("");
                ViewBuilder.this.selectedColumnsTable.updateUI();
            }
        }
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (ViewBuilder.this.tpane.getSelectedComponent() == ViewBuilder.this.tpane.getComponentAt(6)) {
                ViewBuilder.this.groupByArea.setText(ViewBuilder.this.generateGroupBy());
                ViewBuilder.this.sqlArea.setText(ViewBuilder.this.generateSQL());
            } else if (ViewBuilder.this.tpane.getSelectedComponent() == ViewBuilder.this.tpane.getComponentAt(3)) {
                ViewBuilder.this.groupByArea.setText(ViewBuilder.this.generateGroupBy());
            }
        }
    }

    class ColumnAlias {
        ContainedObject col;
        String tableAlias;

        public ColumnAlias(ContainedObject containedObject, String string) {
            this.col = containedObject;
            this.tableAlias = string;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public void setTableAlias(String string) {
            this.tableAlias = string;
        }

        public ContainedObject getCol() {
            return this.col;
        }

        public void setCol(ContainedObject containedObject) {
            this.col = containedObject;
        }
    }

    class AllListOrderByColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListOrderByColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColumnAlias columnAlias = (ColumnAlias)object;
            String string = columnAlias.getTableAlias();
            String string2 = columnAlias.getCol().getName();
            StringBuffer stringBuffer = null;
            stringBuffer = !string.equalsIgnoreCase("") ? new StringBuffer(string).append(".").append(string2) : new StringBuffer(string2);
            this.setText(stringBuffer.toString());
            this.setOpaque(true);
            if (bl) {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getBackground());
                this.setForeground(ViewBuilder.this.selectedTablesTable.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CharSequence charSequence;
            ColumnAlias columnAlias = (ColumnAlias)object;
            String string = columnAlias.getTableAlias();
            String string2 = columnAlias.getCol().getName();
            if (columnAlias.getCol() instanceof ColumnView && !"".equals(charSequence = ((ColumnView)columnAlias.getCol()).getAlias().trim())) {
                string2 = charSequence;
            }
            charSequence = null;
            if (!string.equalsIgnoreCase("")) {
                charSequence = new StringBuffer(string).append(".").append(string2);
            } else if (columnAlias.getCol() instanceof Column) {
                charSequence = new StringBuffer(columnAlias.getCol().getContainer().getName()).append(".").append(string2);
            } else if (columnAlias.getCol() instanceof ColumnView) {
                charSequence = new StringBuffer(columnAlias.getCol().getContainer().getName()).append(".").append(string2);
            }
            if (charSequence != null) {
                this.setText(((StringBuffer)charSequence).toString());
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.selectedTablesTable.getBackground());
                this.setForeground(ViewBuilder.this.selectedTablesTable.getForeground());
            }
            return this;
        }
    }

    class AllListColumnsOrderBySelectionHandler
    implements ListSelectionListener {
        AllListColumnsOrderBySelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (ViewBuilder.this.allColumnsOrderByList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddOrderByColumns.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddOrderByColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveOrderByColumnsActionListener
    implements ActionListener {
        RemoveOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewBuilder.this.orderByList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = ViewBuilder.this.selectedOrderByColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(ViewBuilder.this.orderByList.get(nArray[i]));
                }
                for (OrderByElement orderByElement : arrayList) {
                    ViewBuilder.this.orderByList.remove(orderByElement);
                }
                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                ViewBuilder.this.selectedOrderByColumnsTable.clearSelection();
            }
        }
    }

    class NewOrderByColumnsActionListener
    implements ActionListener {
        NewOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnView columnView = new ColumnView(ViewBuilder.this.design);
            columnView.setExpression("");
            columnView.setName("");
            columnView.setDesign(ViewBuilder.this.view.getDesign());
            columnView.setContainer(ViewBuilder.this.view);
            ViewBuilder.this.orderByList.add(new OrderByElement(columnView, ""));
            ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
        }
    }

    class AddOrderByColumnsActionListener
    implements ActionListener {
        AddOrderByColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ViewBuilder.this.allColumnsOrderByModel.isEmpty()) {
                Object[] objectArray = ViewBuilder.this.allColumnsOrderByList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ColumnView columnView;
                    ColumnAlias columnAlias = (ColumnAlias)objectArray[i];
                    ContainedObject containedObject = columnAlias.getCol();
                    if (containedObject instanceof Column) {
                        columnView = new ColumnView(ViewBuilder.this.design);
                        columnView.setReferencedColumn((Column)containedObject);
                        columnView.setName(((Column)containedObject).getName());
                        columnView.setDesign(ViewBuilder.this.view.getDesign());
                        columnView.setTable((Table)containedObject.getContainer());
                        columnView.setContainer(ViewBuilder.this.view);
                        columnView.setTableAlias(columnAlias.getTableAlias());
                        columnView.setDataType(((Column)containedObject).getDataType().toString());
                        ViewBuilder.this.orderByList.add(new OrderByElement(columnView, "ASC"));
                        ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                        continue;
                    }
                    if (!(containedObject instanceof ColumnView)) continue;
                    columnView = new ColumnView(ViewBuilder.this.design);
                    columnView.setReferencedColumnView(containedObject);
                    columnView.setName(containedObject.getName());
                    columnView.setDesign(ViewBuilder.this.view.getDesign());
                    columnView.setView((TableView)containedObject.getContainer());
                    columnView.setContainer(ViewBuilder.this.view);
                    columnView.setTableAlias(columnAlias.getTableAlias());
                    ViewBuilder.this.orderByList.add(new OrderByElement(columnView, "ASC"));
                    ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                }
            }
        }
    }

    class AllListColumnsSelectionHandler
    implements ListSelectionListener {
        AllListColumnsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (ViewBuilder.this.allColumnsList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddColumns.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class RemoveColumnsActionListener
    implements ActionListener {
        RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewBuilder.this.columnViewList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = ViewBuilder.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(ViewBuilder.this.columnViewList.get(nArray[i]));
                }
                for (ColumnElement columnElement : arrayList) {
                    ViewBuilder.this.columnViewList.remove(columnElement);
                    ColumnAlias columnAlias = ViewBuilder.this.getColumnAlias(columnElement.getColumnView());
                    if (columnAlias == null) continue;
                    ViewBuilder.this.expressionList.remove(columnAlias);
                    ViewBuilder.this.allColumnsOrderByModel.removeElement(columnAlias);
                    for (int i = ViewBuilder.this.orderByList.size() - 1; i >= 0; --i) {
                        OrderByElement orderByElement = (OrderByElement)ViewBuilder.this.orderByList.get(i);
                        if (orderByElement.getContainedObject() != columnAlias.getCol()) continue;
                        ViewBuilder.this.orderByList.remove(orderByElement);
                        ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                    }
                }
                ViewBuilder.this.selectedColumnsTable.updateUI();
                ViewBuilder.this.selectedColumnsTable.clearSelection();
            }
        }
    }

    class NewExpressionActionListener
    implements ActionListener {
        NewExpressionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnView columnView = new ColumnView(ViewBuilder.this.design);
            columnView.setExpression("");
            columnView.setName("");
            columnView.setDesign(ViewBuilder.this.view.getDesign());
            columnView.setContainer(ViewBuilder.this.view);
            ViewBuilder.this.columnViewList.add(new ColumnElement(columnView, columnView.getAlias(), false));
            ViewBuilder.this.selectedColumnsTable.updateUI();
            ViewBuilder.this.expressionList.add(new ColumnAlias(columnView, columnView.getAlias()));
        }
    }

    class AddColumnsActionListener
    implements ActionListener {
        AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ViewBuilder.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = ViewBuilder.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ColumnView columnView;
                    ColumnAlias columnAlias = (ColumnAlias)objectArray[i];
                    ContainedObject containedObject = columnAlias.getCol();
                    if (containedObject instanceof Column) {
                        columnView = new ColumnView(ViewBuilder.this.design);
                        columnView.setReferencedColumn((Column)containedObject);
                        columnView.setName(((Column)containedObject).getName());
                        columnView.setDesign(ViewBuilder.this.view.getDesign());
                        columnView.setTable((Table)containedObject.getContainer());
                        columnView.setContainer(ViewBuilder.this.view);
                        columnView.setTableAlias(columnAlias.getTableAlias());
                        columnView.setDataType(((Column)containedObject).getDataType().toString());
                        ViewBuilder.this.columnViewList.add(new ColumnElement(columnView, columnView.getAlias(), false));
                        ViewBuilder.this.selectedColumnsTable.updateUI();
                        continue;
                    }
                    if (!(containedObject instanceof ColumnView)) continue;
                    columnView = new ColumnView(ViewBuilder.this.design);
                    columnView.setReferencedColumn(((ColumnView)containedObject).getReferencedColumn());
                    columnView.setName(containedObject.getName());
                    columnView.setDesign(ViewBuilder.this.view.getDesign());
                    columnView.setReferencedColumnView(containedObject);
                    columnView.setView((TableView)containedObject.getContainer());
                    columnView.setContainer(ViewBuilder.this.view);
                    columnView.setTableAlias(columnAlias.getTableAlias());
                    ViewBuilder.this.columnViewList.add(new ColumnElement(columnView, columnView.getAlias(), false));
                    ViewBuilder.this.selectedColumnsTable.updateUI();
                }
            }
        }
    }

    class SelectedTablesTable
    extends JTable {
        SelectedTablesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (!ViewBuilder.this.defineDDLChBox.isSelected()) {
                if (n2 == 1) {
                    return new TextCellEditor();
                }
                return super.getCellEditor();
            }
            return null;
        }
    }

    class SelectedTablesModel
    extends AbstractTableModel {
        SelectedTablesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.containerList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ViewBuilder.Tables");
            }
            if (n == 1) {
                return Messages.getString("ViewBuilder.Alias");
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainerElement containerElement = (ContainerElement)ViewBuilder.this.containerList.get(n);
            if (n2 == 0) {
                return containerElement.getContainerObject();
            }
            if (n2 == 1) {
                return containerElement.getContainerAlias();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ContainerElement containerElement = (ContainerElement)ViewBuilder.this.containerList.get(n);
            if (n2 == 0) {
                containerElement.setContainer((ContainerObject)object);
            }
            if (n2 == 1) {
                String string = containerElement.getContainerAlias();
                containerElement.setContainerAlias((String)object);
                ViewBuilder.this.checkModelsForValues(containerElement, string, (String)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }
    }

    class SelectedTablesHandler
    implements ListSelectionListener {
        SelectedTablesHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ViewBuilder.this.selectedTablesTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveTables.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveTables.setEnabled(false);
            }
        }
    }

    class ComboCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(new String[]{"ASC", "DESC"}));
            return this.cbox;
        }
    }

    class ExpressionCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        ExpressionCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof ColumnView) {
                ColumnView columnView = (ColumnView)object;
                if (!columnView.getExpression().equalsIgnoreCase("")) {
                    this.tfield.setText(columnView.getExpression());
                } else {
                    this.tfield.setText(columnView.getName());
                }
            } else {
                this.tfield.setText(object == null ? "" : "" + object.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof ColumnView && ((ColumnView)object).getTableAlias().equalsIgnoreCase(ViewBuilder.this.view.getName())) {
                this.tfield.setText(((ColumnView)object).getExpression());
            } else {
                this.tfield.setText(object == null ? "" : "" + object.toString());
            }
            this.tfield.setBorder(null);
            return this.tfield;
        }
    }

    class SelectedOrderByColumnsTable
    extends JTable {
        SelectedOrderByColumnsTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (!ViewBuilder.this.defineDDLChBox.isSelected()) {
                if (n2 == 0) {
                    return new TextCellEditor();
                }
                return new ComboCellEditor();
            }
            return null;
        }
    }

    class SelectedOrderByColumnsModel
    extends AbstractTableModel {
        SelectedOrderByColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.orderByList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ViewBuilder.ColumnsExpression");
            }
            if (n == 1) {
                return Messages.getString("ViewBuilder.Sort");
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)ViewBuilder.this.orderByList.get(n);
            if (n2 == 0) {
                return orderByElement.getContainedObject();
            }
            if (n2 == 1) {
                return orderByElement.getSort();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)ViewBuilder.this.orderByList.get(n);
            if (n2 == 0) {
                if (object instanceof ColumnView) {
                    orderByElement.setContainedObject((ColumnView)object);
                } else {
                    ColumnView columnView = (ColumnView)orderByElement.getContainedObject();
                    columnView.setExpression((String)object);
                    columnView.setName((String)object);
                }
            } else if (n2 == 1) {
                orderByElement.setSort((String)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            OrderByElement orderByElement = (OrderByElement)ViewBuilder.this.orderByList.get(n);
            return n2 != 0 || ((ColumnView)orderByElement.getContainedObject()).getTable() == null && ((ColumnView)orderByElement.getContainedObject()).getView() == null;
        }
    }

    class SelectedOrderByColumnsHandler
    implements ListSelectionListener {
        SelectedOrderByColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ViewBuilder.this.selectedOrderByColumnsTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveOrderByColumns.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveOrderByColumns.setEnabled(false);
            }
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            if (object instanceof ColumnView && ((ColumnView)object).getTableAlias().equalsIgnoreCase(ViewBuilder.this.view.getName())) {
                this.setText(((ColumnView)object).getExpression());
            } else {
                this.setText(object == null ? "" : "" + object.toString());
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(ViewBuilder.this.allTablesList.getSelectionBackground());
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(ViewBuilder.this.allTablesList.getBackground());
                this.setForeground(ViewBuilder.this.allTablesList.getForeground());
            }
            return this;
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        CheckBoxEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
            this.cbox.setHorizontalAlignment(0);
        }
    }

    class SelectedColumnsModel
    extends AbstractTableModel {
        SelectedColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ViewBuilder.this.columnViewList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ViewBuilder.ColumnsExpression");
            }
            if (n == 1) {
                return Messages.getString("ViewBuilder.Alias");
            }
            if (n == 2) {
                return Messages.getString("ViewBuilder.GroupBy");
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            ColumnElement columnElement;
            return n2 != 0 || (columnElement = (ColumnElement)ViewBuilder.this.columnViewList.get(n)).getColumnView().getTable() == null && columnElement.getColumnView().getView() == null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ColumnElement columnElement = (ColumnElement)ViewBuilder.this.columnViewList.get(n);
            if (n2 == 0) {
                if (object instanceof ColumnView) {
                    columnElement.setColumnView((ColumnView)object);
                } else {
                    ColumnView columnView = columnElement.getColumnView();
                    columnView.setExpression((String)object);
                    columnView.setName((String)object);
                    ViewBuilder.this.checkOrderByModel();
                }
            } else if (n2 == 1) {
                columnElement.setAlias((String)object);
            } else if (n2 == 2) {
                columnElement.setGroupBy((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ColumnElement columnElement = (ColumnElement)ViewBuilder.this.columnViewList.get(n);
            if (n2 == 0) {
                return ViewBuilder.this.getValue(columnElement.getColumnView());
            }
            if (n2 == 1) {
                return columnElement.getAlias();
            }
            if (n2 == 2) {
                return columnElement.getGroupBy();
            }
            return new Integer(n * n2);
        }
    }

    class SelectedColumnsHandler
    implements ListSelectionListener {
        SelectedColumnsHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ViewBuilder.this.selectedColumnsTable.getSelectedRow() > -1) {
                ViewBuilder.this.bnRemoveColumns.setEnabled(true);
            } else {
                ViewBuilder.this.bnRemoveColumns.setEnabled(false);
            }
        }
    }

    class AllListTablesSelectionHandler
    implements ListSelectionListener {
        AllListTablesSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (ViewBuilder.this.allTablesList.getSelectedIndex() == -1) {
                    ViewBuilder.this.bnAddTables.setEnabled(false);
                } else {
                    ViewBuilder.this.bnAddTables.setEnabled(true);
                }
            }
        }
    }

    class RemoveTablesActionListener
    implements ActionListener {
        RemoveTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewBuilder.this.containerList.size() > 0) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = ViewBuilder.this.selectedTablesTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(ViewBuilder.this.containerList.get(nArray[i]));
                }
                for (ContainerElement containerElement : arrayList) {
                    Object object;
                    Object object22;
                    Iterator iterator;
                    ContainedObject containedObject;
                    int n;
                    ContainerObject containerObject = containerElement.getContainerObject();
                    if (containerObject instanceof Table) {
                        for (n = 0; n < containerObject.getElements().length; ++n) {
                            containedObject = (Column)containerObject.getElements()[n];
                            iterator = ViewBuilder.this.allColumnsModel.elements();
                            while (iterator.hasMoreElements()) {
                                object22 = (ColumnAlias)iterator.nextElement();
                                if (((ColumnAlias)object22).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object22).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsModel.removeElement(object22);
                            }
                            for (Object object22 : ViewBuilder.this.columnViewList) {
                                if (((ColumnElement)object22).getColumnView().getReferencedColumn() != containedObject || ((ColumnElement)object22).getColumnView().getView() != null && ((ColumnElement)object22).getColumnView().getView() != ViewBuilder.this.view || ((ColumnElement)object22).getColumnView().getContainer() != containerObject && ((ColumnElement)object22).getColumnView().getContainer() != ViewBuilder.this.view) continue;
                                ViewBuilder.this.columnViewList.remove(object22);
                                ViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            object22 = ViewBuilder.this.allColumnsOrderByModel.elements();
                            while (object22.hasMoreElements()) {
                                object = (ColumnAlias)object22.nextElement();
                                if (((ColumnAlias)object).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsOrderByModel.removeElement(object);
                            }
                            for (Object object22 : ViewBuilder.this.orderByList) {
                                object = (ColumnView)((OrderByElement)object22).getContainedObject();
                                if (((AbstractViewElement)object).getReferencedColumn() != containedObject || ((AbstractViewElement)object).getView() != null && ((AbstractViewElement)object).getView() != ViewBuilder.this.view || ((ContainedObject)object).getContainer() != containerObject && ((ContainedObject)object).getContainer() != ViewBuilder.this.view) continue;
                                ViewBuilder.this.orderByList.remove(object22);
                                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    } else if (containerObject instanceof TableView) {
                        for (n = 0; n < ((TableView)containerObject).getColumns().length; ++n) {
                            containedObject = (ColumnView)((TableView)containerObject).getColumns()[n];
                            iterator = ViewBuilder.this.allColumnsModel.elements();
                            while (iterator.hasMoreElements()) {
                                object22 = (ColumnAlias)iterator.nextElement();
                                if (((ColumnAlias)object22).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object22).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsModel.removeElement(object22);
                            }
                            for (Object object22 : ViewBuilder.this.columnViewList) {
                                if (((ColumnElement)object22).getColumnView().getReferencedColumn() != ((AbstractViewElement)containedObject).getReferencedColumn() || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnElement)object22).getColumnView().getTableAlias())) continue;
                                ViewBuilder.this.columnViewList.remove(object22);
                                ViewBuilder.this.selectedColumnsTable.updateUI();
                                break;
                            }
                            object22 = ViewBuilder.this.allColumnsOrderByModel.elements();
                            while (object22.hasMoreElements()) {
                                object = (ColumnAlias)object22.nextElement();
                                if (((ColumnAlias)object).getCol() != containedObject || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnAlias)object).getTableAlias())) continue;
                                ViewBuilder.this.allColumnsOrderByModel.removeElement(object);
                            }
                            for (Object object22 : ViewBuilder.this.orderByList) {
                                if (((ColumnView)((OrderByElement)object22).getContainedObject()).getReferencedColumn() != ((AbstractViewElement)containedObject).getReferencedColumn() || !containerElement.getContainerAlias().equalsIgnoreCase(((ColumnView)((OrderByElement)object22).getContainedObject()).getTableAlias())) continue;
                                ViewBuilder.this.orderByList.remove(object22);
                                ViewBuilder.this.selectedOrderByColumnsTable.updateUI();
                            }
                        }
                    }
                    ViewBuilder.this.containerList.remove(containerElement);
                    ViewBuilder.this.selectedTablesTable.updateUI();
                }
            }
        }
    }

    class AddTablesActionListener
    implements ActionListener {
        AddTablesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ViewBuilder.this.allTablesModel.isEmpty()) {
                Object[] objectArray = ViewBuilder.this.allTablesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ContainedObject containedObject;
                    int n;
                    ContainerObject containerObject = (ContainerObject)objectArray[i];
                    String string = this.generateAlias(containerObject);
                    ViewBuilder.this.containerList.add(new ContainerElement(containerObject, string));
                    ViewBuilder.this.selectedTablesTable.updateUI();
                    if (containerObject instanceof Table) {
                        for (n = 0; n < containerObject.getElements().length; ++n) {
                            containedObject = (Column)containerObject.getElements()[n];
                            ViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(containedObject, string));
                            ViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, string));
                        }
                        continue;
                    }
                    if (!(containerObject instanceof TableView)) continue;
                    for (n = 0; n < ((TableView)containerObject).getColumns().length; ++n) {
                        containedObject = (ColumnView)((TableView)containerObject).getColumns()[n];
                        ViewBuilder.this.allColumnsModel.addElement(new ColumnAlias(containedObject, string));
                        ViewBuilder.this.allColumnsOrderByModel.addElement(new ColumnAlias(containedObject, string));
                    }
                }
            }
        }

        private String generateAlias(ContainerObject containerObject) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = ViewBuilder.this.containerList.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((ContainerElement)iterator.next()).getContainerAlias());
            }
            if (!arrayList.contains(containerObject.getName())) {
                return containerObject.getName();
            }
            StringBuffer stringBuffer = new StringBuffer(containerObject.getName());
            String string = containerObject.getName();
            stringBuffer.append("v");
            int n = stringBuffer.length();
            for (int i = 1; i <= arrayList.size(); ++i) {
                stringBuffer.setLength(n);
                stringBuffer.append(i);
                string = stringBuffer.toString();
                if (arrayList.contains(string)) continue;
                return string;
            }
            return null;
        }
    }
}

