/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.StatisticsOutputColumn;
import com.adbs.querybuilder.StatisticsOutputColumnList;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2SyntaxProvider;
import com.adbs.syntax.FirebirdSyntaxProvider;
import com.adbs.syntax.InformixSyntaxProvider;
import com.adbs.syntax.MSSQLServerVersion;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.syntax.MySQLSyntaxProvider;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.OracleSyntaxProvider;
import com.adbs.syntax.PostgreSQLSyntaxProvider;
import com.adbs.syntax.SQLiteSyntaxProvider;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.utils.Helpers;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTextPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.DSHelper;
import oracle.dbtools.crest.swingui.editor.viewbuilder.DeletedMetadataObject;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryHelper;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.proformatter.SQLFormatCommand;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QBUtils {
    private static List deletedSQLNames;
    private static List dsPositions;
    public static boolean isIncorrectSQL;
    public static String incorrectSQL;
    private static JTextPane jTextPane;
    private static List deletedMDObjects;
    private static Map metadataObjectsMap;
    public static final Map<String, BaseSyntaxProvider> SYNTAX_PROVIDERS;
    private static String previousSyntaxProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initMetadata(DesignPart designPart, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder) {
        Object object;
        isIncorrectSQL = false;
        queryBuilder.setOfflineMode(true);
        queryBuilder.setMetadataProvider(null);
        MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
        metadataContainer.beginUpdate();
        RDBMSType rDBMSType = designPart instanceof LogicalDesign ? designPart.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(designPart.getAppView().getSettings()).getType() : designPart.getSelectedRDBMSType();
        if (StorageDesignOraclev9i.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle9);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignOraclev10g.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle10);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignOraclev11g.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle11);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignSqlServerv2k.RDBMS_TYPE == rDBMSType) {
            object = new MSSQLSyntaxProvider();
            object.setServerVersion(MSSQLServerVersion.MSSQL2000);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rDBMSType) {
            object = new MSSQLSyntaxProvider();
            object.setServerVersion(MSSQLServerVersion.MSSQL2005);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignDB2v70.RDBMS_TYPE == rDBMSType || StorageDesignDB2v80.RDBMS_TYPE == rDBMSType) {
            object = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignUDBv71.RDBMS_TYPE == rDBMSType || StorageDesignUDBv81.RDBMS_TYPE == rDBMSType) {
            object = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        }
        try {
            if (designPart instanceof LogicalDesign) {
                Object object2;
                object = (LogicalDesign)designPart;
                Iterator iterator = ((LogicalDesign)object).getEntitySet().iterator();
                while (iterator.hasNext()) {
                    object2 = (Entity)iterator.next();
                    QBUtils.addEntityToMetadata((Entity)object2, metadataContainer, null, (LogicalDesign)object, false, false);
                }
                object2 = ((LogicalDesign)object).getEntityViewSet().iterator();
                while (object2.hasNext()) {
                    EntityView entityView = (EntityView)object2.next();
                    QBUtils.addViewToMetadata(entityView, metadataContainer, null, null, false, false);
                }
            } else {
                Object object3;
                object = (RelationalDesign)designPart;
                Iterator iterator = ((RelationalDesign)object).getTableSet().iterator();
                while (iterator.hasNext()) {
                    object3 = (Table)iterator.next();
                    QBUtils.addTableToMetadata((Table)object3, metadataContainer, null, (RelationalDesign)object, false, false);
                }
                object3 = ((RelationalDesign)object).getTableViewSet().iterator();
                while (object3.hasNext()) {
                    TableView tableView = (TableView)object3.next();
                    QBUtils.addViewToMetadata(tableView, metadataContainer, null, null, false, false);
                }
            }
            plainTextSQLBuilder.setUseAltNames(false);
        }
        catch (Exception exception) {
        }
        finally {
            metadataContainer.endUpdate();
        }
    }

    public static void initSQL(AbstractView abstractView, QueryBuilder queryBuilder) {
        int n;
        if (!previousSyntaxProvider.equalsIgnoreCase(abstractView.getSyntaxProvider())) {
            queryBuilder.setSyntaxProvider(SYNTAX_PROVIDERS.get(abstractView.getSyntaxProvider()));
            previousSyntaxProvider = abstractView.getSyntaxProvider();
        }
        isIncorrectSQL = false;
        if (abstractView.getSchemaObject() != null) {
            queryBuilder.getMetadataContainer().setDefaultSchemaNamesStr(abstractView.getSchemaObject().getName());
        } else {
            queryBuilder.getMetadataContainer().getDefaultSchemaNames().clear();
        }
        String string = abstractView.getUserDefinedSQL();
        String string2 = string.toUpperCase();
        int n2 = string2.indexOf("WITH READ ONLY");
        String string3 = "";
        if (n2 > -1) {
            string3 = string.substring(n2);
            string = string.substring(0, n2);
        } else {
            n2 = string2.indexOf("WITH CHECK OPTION");
            if (n2 > -1) {
                string3 = string.substring(n2);
                string = string.substring(0, n2);
            }
        }
        String string4 = string.toUpperCase();
        if (string4.indexOf("CREATE") > -1 && (n = string4.indexOf("SELECT")) > 0) {
            char c = string4.charAt(n - 1);
            if (c != ' ' && (c < '\t' || c > '\r')) {
                n = string4.indexOf("SELECT", n + 1);
            }
            string = string.substring(n);
        }
        QBUtils.setSQL(queryBuilder, string, true);
    }

    public static void initProperties(AbstractView abstractView, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, JTextPane jTextPane, DesignPartView designPartView, boolean bl) {
        Object object;
        long l = System.currentTimeMillis();
        boolean bl2 = abstractView instanceof EntityView;
        isIncorrectSQL = false;
        QBUtils.jTextPane = jTextPane;
        deletedSQLNames = abstractView.getDeletedSQLNames();
        deletedMDObjects.clear();
        metadataObjectsMap.clear();
        MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
        System.out.println("init setOfflineMode  " + System.currentTimeMillis());
        queryBuilder.setOfflineMode(true);
        System.out.println("init setMetadataProvider(null)  " + System.currentTimeMillis());
        queryBuilder.setMetadataProvider(null);
        int n = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
        System.out.println("init setDefaultSchemaNamesStr  " + System.currentTimeMillis());
        if (abstractView.getSchemaObject() != null) {
            metadataContainer.setDefaultSchemaNamesStr(abstractView.getSchemaObject().getName());
        }
        System.out.println("init setSyntaxProvider  " + System.currentTimeMillis());
        RDBMSType rDBMSType = bl2 ? abstractView.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(abstractView.getAppView().getSettings()).getType() : ((RelationalDesign)abstractView.getDesignPart()).getSelectedRDBMSType();
        if (!"".equalsIgnoreCase(abstractView.getSyntaxProvider())) {
            queryBuilder.setSyntaxProvider(SYNTAX_PROVIDERS.get(abstractView.getSyntaxProvider()));
        } else if (StorageDesignOraclev9i.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle9);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignOraclev10g.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle10);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignOraclev11g.RDBMS_TYPE == rDBMSType) {
            object = new OracleSyntaxProvider();
            object.setServerVersion(OracleServerVersion.Oracle11);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignSqlServerv2k.RDBMS_TYPE == rDBMSType) {
            object = new MSSQLSyntaxProvider();
            object.setServerVersion(MSSQLServerVersion.MSSQL2000);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rDBMSType) {
            object = new MSSQLSyntaxProvider();
            object.setServerVersion(MSSQLServerVersion.MSSQL2005);
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignDB2v70.RDBMS_TYPE == rDBMSType || StorageDesignDB2v80.RDBMS_TYPE == rDBMSType) {
            object = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        } else if (StorageDesignUDBv71.RDBMS_TYPE == rDBMSType || StorageDesignUDBv81.RDBMS_TYPE == rDBMSType) {
            object = new DB2SyntaxProvider();
            queryBuilder.setSyntaxProvider((BaseSyntaxProvider)object);
        }
        System.out.println("end setSyntaxProvider  " + System.currentTimeMillis());
        try {
            int n2;
            Object object2;
            Object object32;
            Object object4;
            Object object52;
            Iterator iterator;
            boolean bl3;
            object = QBUtils.getSQLNamesMap(abstractView);
            LogicalDesign logicalDesign = null;
            RelationalDesign relationalDesign = null;
            if (bl2) {
                logicalDesign = (LogicalDesign)abstractView.getDesignPart();
            } else {
                relationalDesign = (RelationalDesign)abstractView.getDesignPart();
            }
            System.out.println("init Tables  " + System.currentTimeMillis());
            System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            metadataContainer.beginUpdate();
            boolean bl4 = bl3 = !abstractView.isValidSQL();
            if (abstractView.getSQLNames().size() == 0 || jTextPane != null) {
                if (designPartView != null) {
                    iterator = designPartView.getTopviewsList();
                    object52 = new ArrayList();
                    object4 = iterator.iterator();
                    while (object4.hasNext()) {
                        object32 = (TopView)object4.next();
                        if (((TopView)object32).getModel() instanceof Table) {
                            object2 = (Table)((TopView)object32).getModel();
                            if (object52.contains(((ModelIDObject)object2).getObjectID())) continue;
                            QBUtils.addTableToMetadata((Table)object2, metadataContainer, (Map)object, relationalDesign, bl3, bl);
                            object52.add(((ModelIDObject)object2).getObjectID());
                            continue;
                        }
                        if (((TopView)object32).getModel() instanceof TableView) {
                            object2 = (TableView)((TopView)object32).getModel();
                            if (object52.contains(((ModelIDObject)object2).getObjectID())) continue;
                            QBUtils.addViewToMetadata((AbstractView)object2, metadataContainer, (Map)object, abstractView, bl3, bl);
                            object52.add(((ModelIDObject)object2).getObjectID());
                            continue;
                        }
                        if (((TopView)object32).getModel() instanceof Entity) {
                            object2 = (Entity)((TopView)object32).getModel();
                            if (object52.contains(((ModelIDObject)object2).getObjectID())) continue;
                            QBUtils.addEntityToMetadata((Entity)object2, metadataContainer, (Map)object, logicalDesign, bl3, bl);
                            object52.add(((ModelIDObject)object2).getObjectID());
                            continue;
                        }
                        if (!(((TopView)object32).getModel() instanceof EntityView) || object52.contains(((ModelIDObject)(object2 = (EntityView)((TopView)object32).getModel())).getObjectID())) continue;
                        QBUtils.addViewToMetadata((AbstractView)object2, metadataContainer, (Map)object, abstractView, bl3, false);
                        object52.add(((ModelIDObject)object2).getObjectID());
                    }
                    for (Object object32 : abstractView.getSQLNames()) {
                        if (!((SQLNameHelper)object32).isContainer() || object52.contains(((SQLNameHelper)object32).getID())) continue;
                        if (((SQLNameHelper)object32).isView()) {
                            if (bl2) {
                                object2 = (EntityView)logicalDesign.getEntityViewSet().getObjectByID(((SQLNameHelper)object32).getID());
                                if (object2 == null) continue;
                                QBUtils.addViewToMetadata((AbstractView)object2, metadataContainer, (Map)object, abstractView, bl3, bl);
                                continue;
                            }
                            object2 = (TableView)relationalDesign.getTableViewSet().getObjectByID(((SQLNameHelper)object32).getID());
                            if (object2 == null) continue;
                            QBUtils.addViewToMetadata((AbstractView)object2, metadataContainer, (Map)object, abstractView, bl3, bl);
                            continue;
                        }
                        if (bl2) {
                            object2 = (Entity)logicalDesign.getEntitySet().getObjectByID(((SQLNameHelper)object32).getID());
                            if (object2 == null) continue;
                            QBUtils.addEntityToMetadata((Entity)object2, metadataContainer, (Map)object, logicalDesign, bl3, bl);
                            continue;
                        }
                        object2 = (Table)relationalDesign.getTableSet().getObjectByID(((SQLNameHelper)object32).getID());
                        if (object2 == null) continue;
                        QBUtils.addTableToMetadata((Table)object2, metadataContainer, (Map)object, relationalDesign, bl3, bl);
                    }
                } else if (bl2) {
                    iterator = logicalDesign.getEntitySet().iterator();
                    while (iterator.hasNext()) {
                        object52 = (Entity)iterator.next();
                        QBUtils.addEntityToMetadata((Entity)object52, metadataContainer, (Map)object, logicalDesign, bl3, bl);
                    }
                    System.out.println("init Views  " + System.currentTimeMillis());
                    System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                    object52 = logicalDesign.getEntityViewSet().iterator();
                    while (object52.hasNext()) {
                        object4 = (EntityView)object52.next();
                        QBUtils.addViewToMetadata((AbstractView)object4, metadataContainer, (Map)object, abstractView, bl3, bl);
                    }
                } else {
                    iterator = relationalDesign.getTableSet().iterator();
                    while (iterator.hasNext()) {
                        object52 = (Table)iterator.next();
                        QBUtils.addTableToMetadata((Table)object52, metadataContainer, (Map)object, relationalDesign, bl3, bl);
                    }
                    System.out.println("init Views  " + System.currentTimeMillis());
                    System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                    object52 = relationalDesign.getTableViewSet().iterator();
                    while (object52.hasNext()) {
                        object4 = (TableView)object52.next();
                        QBUtils.addViewToMetadata((AbstractView)object4, metadataContainer, (Map)object, abstractView, bl3, bl);
                    }
                }
            } else {
                for (Object object52 : abstractView.getSQLNames()) {
                    if (!((SQLNameHelper)object52).isContainer()) continue;
                    if (((SQLNameHelper)object52).isView()) {
                        if (bl2) {
                            object4 = (EntityView)logicalDesign.getEntityViewSet().getObjectByID(((SQLNameHelper)object52).getID());
                            if (object4 == null) continue;
                            QBUtils.addViewToMetadata((AbstractView)object4, metadataContainer, (Map)object, abstractView, bl3, bl);
                            continue;
                        }
                        object4 = (TableView)relationalDesign.getTableViewSet().getObjectByID(((SQLNameHelper)object52).getID());
                        if (object4 == null) continue;
                        QBUtils.addViewToMetadata((AbstractView)object4, metadataContainer, (Map)object, abstractView, bl3, bl);
                        continue;
                    }
                    if (bl2) {
                        object4 = (Entity)logicalDesign.getEntitySet().getObjectByID(((SQLNameHelper)object52).getID());
                        if (object4 == null) continue;
                        QBUtils.addEntityToMetadata((Entity)object4, metadataContainer, (Map)object, logicalDesign, bl3, bl);
                        continue;
                    }
                    object4 = (Table)relationalDesign.getTableSet().getObjectByID(((SQLNameHelper)object52).getID());
                    if (object4 == null) continue;
                    QBUtils.addTableToMetadata((Table)object4, metadataContainer, (Map)object, relationalDesign, bl3, bl);
                }
            }
            if (bl3) {
                System.out.println("init Deleted tables  " + System.currentTimeMillis());
                System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                for (Object object52 : QBUtils.getDeletedContainersOnly()) {
                    object4 = ((SQLNameHelper)object52).getSchema() != null && ((SQLNameHelper)object52).getSchema().length() > 0 ? (((SQLNameHelper)object52).isView() ? metadataContainer.addView(((SQLNameHelper)object52).getSchema(), ((SQLNameHelper)object52).getTableName(), false, null) : metadataContainer.addTable(((SQLNameHelper)object52).getSchema(), ((SQLNameHelper)object52).getTableName(), false, null)) : (((SQLNameHelper)object52).isView() ? metadataContainer.addView(null, ((SQLNameHelper)object52).getTableName(), false, null) : metadataContainer.addTable(null, ((SQLNameHelper)object52).getTableName(), false, null));
                    object4.setAltName(object4.getFullNameStr());
                    object4.setShortDescription(((SQLNameHelper)object52).getID());
                    object32 = new DeletedMetadataObject((MetadataObject)object4);
                    deletedMDObjects.add(object32);
                }
                System.out.println("init Deleted columns  " + System.currentTimeMillis());
                for (Object object52 : QBUtils.getDeletedColumnsOnly()) {
                    object4 = ((SQLNameHelper)object52).getTableName();
                    if (((SQLNameHelper)object52).getSchema() != null && ((SQLNameHelper)object52).getSchema().length() > 0) {
                        object4 = ((SQLNameHelper)object52).getSchema() + "." + ((SQLNameHelper)object52).getTableName();
                    }
                    if ((object32 = metadataContainer.findObjectByFullName((String)object4)) == null) continue;
                    object2 = object32.getFields().addField(((SQLNameHelper)object52).getColumnName());
                    object2.setAltName(((SQLNameHelper)object52).getColumnName());
                    object2.setShortDescription(((SQLNameHelper)object52).getID());
                    DeletedMetadataObject deletedMetadataObject = new DeletedMetadataObject((MetadataObject)object32, (MetadataField)object2);
                    deletedMDObjects.add(deletedMetadataObject);
                }
                System.out.println("init Deleted columns End " + System.currentTimeMillis());
            }
            metadataContainer.endUpdate();
            iterator = abstractView.getUserDefinedSQL();
            if (!abstractView.getUserDefined()) {
                iterator = abstractView.getUserDefinedSQL();
            }
            object52 = ((String)((Object)iterator)).toUpperCase();
            int n3 = ((String)object52).indexOf("WITH READ ONLY");
            object32 = "";
            if (n3 > -1) {
                object32 = ((String)((Object)iterator)).substring(n3);
                iterator = ((String)((Object)iterator)).substring(0, n3);
            } else {
                n3 = ((String)object52).indexOf("WITH CHECK OPTION");
                if (n3 > -1) {
                    object32 = ((String)((Object)iterator)).substring(n3);
                    iterator = ((String)((Object)iterator)).substring(0, n3);
                }
            }
            object2 = ((String)((Object)iterator)).toUpperCase();
            if (((String)object2).indexOf("CREATE") > -1 && (n2 = ((String)object2).indexOf("SELECT")) > 0) {
                char c = ((String)object2).charAt(n2 - 1);
                if (c != ' ' && (c < '\t' || c > '\r')) {
                    n2 = ((String)object2).indexOf("SELECT", n2 + 1);
                }
                iterator = ((String)((Object)iterator)).substring(n2);
            }
            System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            String string = abstractView.getLayoutSQL();
            if (string != null && string.length() > 0) {
                QBUtils.parseDSPositions(string);
                long l2 = System.currentTimeMillis();
                queryBuilder.setLayoutSQL(string);
                System.out.println("Total setLayoutSQL: " + (System.currentTimeMillis() - l2));
            } else {
                if (QBUtils.jTextPane != null) {
                    QBUtils.jTextPane.setText((String)((Object)iterator));
                }
                QBUtils.setSQL(queryBuilder, iterator, true);
            }
            QBUtils.saveDSPositions(queryBuilder);
            if (bl3) {
                plainTextSQLBuilder.setUseAltNames(true);
            }
            System.out.println("memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.out.println("Total initProperties Time: " + (System.currentTimeMillis() - l));
    }

    private static void addTableToMetadata(Table table, MetadataContainer metadataContainer, Map map, RelationalDesign relationalDesign, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        DesignObject designObject;
        MetadataFieldList metadataFieldList;
        ContainedObject[] containedObjectArray;
        MetadataTable metadataTable = null;
        SQLNameHelper sQLNameHelper = null;
        if (map != null) {
            sQLNameHelper = (SQLNameHelper)map.get(table.getObjectID());
        }
        String string = table.getName();
        if (sQLNameHelper != null) {
            string = sQLNameHelper.getTableName();
        }
        if (table.getSchemaObject() != null) {
            containedObjectArray = table.getSchemaObject().getName();
            if (sQLNameHelper != null) {
                containedObjectArray = sQLNameHelper.getSchema();
            }
            metadataTable = metadataContainer.addTable((String)containedObjectArray, string, false, null);
        } else {
            containedObjectArray = null;
            if (sQLNameHelper != null) {
                containedObjectArray = sQLNameHelper.getSchema();
            }
            metadataTable = containedObjectArray != null && containedObjectArray.length() > 0 ? metadataContainer.addTable((String)containedObjectArray, string, false, null) : metadataContainer.addTable(null, string, false, null);
        }
        metadataTable.beginUpdate();
        if (bl || bl2) {
            metadataTable.setAltName(metadataTable.getFullNameStr());
        }
        metadataTable.setShortDescription(table.getObjectID());
        metadataTable.setLongDescription(table.getCommentInRDBMS());
        metadataTable.endUpdate();
        containedObjectArray = table.getElements();
        if (containedObjectArray.length > 0) {
            metadataFieldList = metadataTable.getFields();
            metadataFieldList.beginUpdate();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                designObject = (Column)containedObjectArray[i];
                object3 = null;
                if (map != null) {
                    object3 = (SQLNameHelper)map.get(designObject.getObjectID());
                }
                object2 = ((ContainedObject)designObject).getName();
                if (object3 != null) {
                    object2 = ((SQLNameHelper)object3).getColumnName();
                }
                object = metadataFieldList.add();
                object.beginUpdate();
                object.getName().addName((String)object2);
                if (bl) {
                    object.setAltName(((ContainedObject)designObject).getName());
                }
                object.setShortDescription(designObject.getObjectID());
                if (((ContainedObjectWithDomain)designObject).isPKElement()) {
                    object.setPrimaryKey(true);
                }
                object.endUpdate();
            }
            metadataFieldList.endUpdate();
        }
        metadataFieldList = null;
        Iterator iterator = relationalDesign.getFKIndexAssociationSet().getAssociationsWith(table).iterator();
        while (iterator.hasNext()) {
            Object object4;
            Object object5;
            metadataFieldList = metadataTable.getRelations().add();
            metadataFieldList.beginUpdate();
            designObject = (FKIndexAssociation)iterator.next();
            object3 = ((FKIndexAssociation)designObject).getRemoteIndex().getElements();
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object = (Column)object3[i];
                object5 = null;
                if (map != null) {
                    object5 = (SQLNameHelper)map.get(((ModelIDObject)object).getObjectID());
                }
                object4 = ((ContainedObject)object).getName();
                if (object5 != null) {
                    object4 = ((SQLNameHelper)object5).getColumnName();
                }
                metadataFieldList.getKeyFields().add((String)object4);
            }
            object2 = ((FKIndexAssociation)designObject).getTable();
            object = null;
            if (map != null) {
                object = (SQLNameHelper)map.get(((ModelIDObject)object2).getObjectID());
            }
            if (((ContainerObject)object2).getSchemaObject() != null) {
                object5 = ((ContainerObject)object2).getSchemaObject().getName();
                if (object != null) {
                    object5 = ((SQLNameHelper)object).getSchema();
                }
                metadataFieldList.setChildSchemaStr((String)object5);
            }
            metadataFieldList.setChildNameStr(((DesignObject)object2).getName());
            object3 = ((FKIndexAssociation)designObject).getLocalFKIndex().getElements();
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object4 = (Column)object3[i];
                SQLNameHelper sQLNameHelper2 = null;
                if (map != null) {
                    sQLNameHelper2 = (SQLNameHelper)map.get(((ModelIDObject)object4).getObjectID());
                }
                String string2 = ((ContainedObject)object4).getName();
                if (sQLNameHelper2 != null) {
                    string2 = sQLNameHelper2.getColumnName();
                }
                metadataFieldList.getChildFields().add(string2);
            }
            metadataFieldList.endUpdate();
        }
        metadataObjectsMap.put(table.getObjectID(), metadataTable);
    }

    private static void addEntityToMetadata(Entity entity, MetadataContainer metadataContainer, Map map, LogicalDesign logicalDesign, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Attribute[] attributeArray;
        DesignObject designObject;
        MetadataFieldList metadataFieldList;
        ContainedObject[] containedObjectArray;
        MetadataTable metadataTable = null;
        SQLNameHelper sQLNameHelper = null;
        if (map != null) {
            sQLNameHelper = (SQLNameHelper)map.get(entity.getObjectID());
        }
        String string = entity.getName();
        if (sQLNameHelper != null) {
            string = sQLNameHelper.getTableName();
        }
        if (entity.getSchemaObject() != null) {
            containedObjectArray = entity.getSchemaObject().getName();
            if (sQLNameHelper != null) {
                containedObjectArray = sQLNameHelper.getSchema();
            }
            metadataTable = metadataContainer.addTable((String)containedObjectArray, string, false, null);
        } else {
            containedObjectArray = null;
            if (sQLNameHelper != null) {
                containedObjectArray = sQLNameHelper.getSchema();
            }
            metadataTable = containedObjectArray != null && containedObjectArray.length() > 0 ? metadataContainer.addTable((String)containedObjectArray, string, false, null) : metadataContainer.addTable(null, string, false, null);
        }
        metadataTable.beginUpdate();
        metadataTable.setAltName(metadataTable.getFullNameStr());
        metadataTable.setShortDescription(entity.getObjectID());
        metadataTable.setLongDescription(entity.getCommentInRDBMS());
        metadataTable.endUpdate();
        containedObjectArray = entity.getElements();
        if (containedObjectArray.length > 0) {
            metadataFieldList = metadataTable.getFields();
            metadataFieldList.beginUpdate();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                designObject = containedObjectArray[i];
                attributeArray = null;
                if (map != null) {
                    attributeArray = (Attribute[])map.get(designObject.getObjectID());
                }
                object2 = ((ContainedObject)designObject).getName();
                if (attributeArray != null) {
                    object2 = attributeArray.getColumnName();
                }
                object = metadataFieldList.add();
                object.beginUpdate();
                object.getName().addName((String)object2);
                if (bl) {
                    object.setAltName(((ContainedObject)designObject).getName());
                }
                object.setShortDescription(designObject.getObjectID());
                object.endUpdate();
            }
            metadataFieldList.endUpdate();
        }
        metadataFieldList = null;
        Iterator iterator = logicalDesign.getRelationSet().getRelationsToSource(entity).iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object object4;
            Object object5;
            metadataFieldList = metadataTable.getRelations().add();
            metadataFieldList.beginUpdate();
            designObject = (Relation)iterator.next();
            attributeArray = ((Relation)designObject).getFKAttributes(((Relation)designObject).getTargetEntity());
            for (int i = 0; i < attributeArray.length; ++i) {
                object = attributeArray[i];
                object5 = ((ContainedObject)object).getDelegateElement();
                if (object5 == null) continue;
                object4 = null;
                if (map != null) {
                    object4 = (SQLNameHelper)map.get(((ModelIDObject)object5).getObjectID());
                }
                object3 = ((ContainedObject)object5).getName();
                if (object4 != null) {
                    object3 = ((SQLNameHelper)object4).getColumnName();
                }
                metadataFieldList.getKeyFields().add((String)object3);
            }
            object2 = ((Relation)designObject).getTargetEntity();
            object = null;
            if (map != null) {
                object = (SQLNameHelper)map.get(((ModelIDObject)object2).getObjectID());
            }
            if (((ContainerObject)object2).getSchemaObject() != null) {
                object5 = ((ContainerObject)object2).getSchemaObject().getName();
                if (object != null) {
                    object5 = ((SQLNameHelper)object).getSchema();
                }
                metadataFieldList.setChildSchemaStr((String)object5);
            }
            metadataFieldList.setChildNameStr(((DesignObject)object2).getName());
            attributeArray = ((Relation)designObject).getFKAttributes((Entity)object2);
            for (int i = 0; i < attributeArray.length; ++i) {
                object4 = attributeArray[i];
                object3 = null;
                if (map != null) {
                    object3 = (SQLNameHelper)map.get(((ModelIDObject)object4).getObjectID());
                }
                String string2 = ((ContainedObject)object4).getName();
                if (object3 != null) {
                    string2 = ((SQLNameHelper)object3).getColumnName();
                }
                metadataFieldList.getChildFields().add(string2);
            }
            metadataFieldList.endUpdate();
        }
        metadataObjectsMap.put(entity.getObjectID(), metadataTable);
    }

    private static void addViewToMetadata(AbstractView abstractView, MetadataContainer metadataContainer, Map map, AbstractView abstractView2, boolean bl, boolean bl2) {
        if (abstractView != abstractView2) {
            MetadataView metadataView;
            ContainedObject[] containedObjectArray;
            SQLNameHelper sQLNameHelper = null;
            if (map != null) {
                sQLNameHelper = (SQLNameHelper)map.get(abstractView.getObjectID());
            }
            String string = abstractView.getName();
            if (sQLNameHelper != null) {
                string = sQLNameHelper.getTableName();
            }
            if (abstractView.getSchemaObject() != null) {
                containedObjectArray = abstractView.getSchemaObject().getName();
                if (sQLNameHelper != null) {
                    containedObjectArray = sQLNameHelper.getSchema();
                }
                metadataView = metadataContainer.addView((String)containedObjectArray, string, false, null);
            } else {
                containedObjectArray = null;
                if (sQLNameHelper != null) {
                    containedObjectArray = sQLNameHelper.getSchema();
                }
                metadataView = containedObjectArray != null && containedObjectArray.length() > 0 ? metadataContainer.addView((String)containedObjectArray, string, false, null) : metadataContainer.addView(null, string, false, null);
            }
            metadataView.beginUpdate();
            if (bl || bl2) {
                metadataView.setAltName(metadataView.getFullNameStr());
            }
            metadataView.setShortDescription(abstractView.getObjectID());
            metadataView.endUpdate();
            containedObjectArray = abstractView.getElements();
            if (containedObjectArray.length > 0) {
                MetadataFieldList metadataFieldList = metadataView.getFields();
                metadataFieldList.beginUpdate();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    ContainedObject containedObject = containedObjectArray[i];
                    SQLNameHelper sQLNameHelper2 = null;
                    if (map != null) {
                        sQLNameHelper2 = (SQLNameHelper)map.get(containedObject.getObjectID());
                    }
                    String string2 = containedObject.getName();
                    if (sQLNameHelper2 != null) {
                        string2 = sQLNameHelper2.getColumnName();
                    }
                    if (containedObject instanceof AbstractViewElement && ("".equals(string2) || !"".equals(((AbstractViewElement)containedObject).getAlias()))) {
                        string2 = ((AbstractViewElement)containedObject).getAlias();
                    }
                    MetadataField metadataField = metadataFieldList.add();
                    metadataField.beginUpdate();
                    metadataField.getName().addName(string2);
                    if (bl) {
                        metadataField.setAltName(string2);
                    }
                    metadataField.setShortDescription(containedObject.getObjectID());
                    metadataField.beginUpdate();
                }
                metadataFieldList.endUpdate();
            }
            metadataObjectsMap.put(abstractView.getObjectID(), metadataView);
        }
    }

    private static Map getSQLNamesMap(AbstractView abstractView) {
        TreeMap<String, SQLNameHelper> treeMap = new TreeMap<String, SQLNameHelper>();
        for (SQLNameHelper sQLNameHelper : abstractView.getSQLNames()) {
            treeMap.put(sQLNameHelper.getID(), sQLNameHelper);
        }
        return treeMap;
    }

    private static List getDeletedContainersOnly() {
        ArrayList<SQLNameHelper> arrayList = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper sQLNameHelper : deletedSQLNames) {
            if (!sQLNameHelper.isContainer()) continue;
            arrayList.add(sQLNameHelper);
        }
        return arrayList;
    }

    private static List getDeletedColumnsOnly() {
        ArrayList<SQLNameHelper> arrayList = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper sQLNameHelper : deletedSQLNames) {
            if (sQLNameHelper.isContainer()) continue;
            arrayList.add(sQLNameHelper);
        }
        return arrayList;
    }

    public static void setIncludeSchema(AbstractView abstractView, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean bl) {
        if (bl) {
            MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
            String string = plainTextSQLBuilder.getSQL();
            if (!bl) {
                if (abstractView.getSchemaObject() != null) {
                    metadataContainer.setDefaultSchemaNamesStr(abstractView.getSchemaObject().getName());
                }
            } else {
                metadataContainer.getDefaultSchemaNames().clear();
            }
            plainTextSQLBuilder.setUseAltNames(false);
            queryBuilder.setUseAltNames(false);
            QBUtils.setSQL(queryBuilder, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMetadata(AbstractView abstractView, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean bl) {
        if (!isIncorrectSQL) {
            MetadataContainer metadataContainer = queryBuilder.getMetadataContainer();
            String string = plainTextSQLBuilder.getSQL();
            QBUtils.setSQL(queryBuilder, "");
            try {
                if (!bl) {
                    if (abstractView.getSchemaObject() != null) {
                        metadataContainer.setDefaultSchemaNamesStr(abstractView.getSchemaObject().getName());
                    }
                } else {
                    metadataContainer.getDefaultSchemaNames().clear();
                }
                HashMap<String, MetadataObject> hashMap = new HashMap<String, MetadataObject>();
                System.out.println("update change names  " + System.currentTimeMillis());
                for (Object object : abstractView.getSQLNames()) {
                    Object object2;
                    MetadataObject metadataObject;
                    Object object3 = ((SQLNameHelper)object).getTableName();
                    if (((SQLNameHelper)object).getSchema() != null && ((SQLNameHelper)object).getSchema().length() > 0) {
                        object3 = ((SQLNameHelper)object).getSchema() + "." + ((SQLNameHelper)object).getTableName();
                    }
                    if ((metadataObject = (MetadataObject)hashMap.get(object3)) == null) {
                        metadataObject = (MetadataObject)metadataObjectsMap.get(((SQLNameHelper)object).getID());
                        if (metadataObject == null) {
                            metadataObject = metadataContainer.findObjectByFullName((String)object3);
                        }
                        if (metadataObject != null) {
                            hashMap.put((String)object3, metadataObject);
                        }
                    }
                    if (metadataObject == null) continue;
                    if (((SQLNameHelper)object).isContainer()) {
                        ContainerObject containerObject = (ContainerObject)abstractView.getDesign().getDesignObject(((SQLNameHelper)object).getID());
                        if (containerObject == null) continue;
                        if (!((SQLNameHelper)object).getTableName().equalsIgnoreCase(containerObject.getName())) {
                            System.out.println("update table name  start  " + System.currentTimeMillis());
                            metadataObject.beginUpdate();
                            metadataObject.setNameStr(containerObject.getName());
                            metadataObject.endUpdate();
                            System.out.println("update table name  end  " + System.currentTimeMillis());
                        }
                        object2 = "";
                        if (containerObject.getSchemaObject() != null) {
                            object2 = containerObject.getSchemaObject().getName();
                        }
                        if (((SQLNameHelper)object).getSchema() != null && (((SQLNameHelper)object).getSchema() == null || ((SQLNameHelper)object).getSchema().equalsIgnoreCase((String)object2))) continue;
                        metadataObject.beginUpdate();
                        metadataObject.setSchemaStr((String)object2);
                        metadataObject.endUpdate();
                        continue;
                    }
                    int n = metadataObject.getFields().findFieldByName(((SQLNameHelper)object).getColumnName());
                    if (n <= -1) continue;
                    object2 = metadataObject.getFields().get(n);
                    DesignObject designObject = abstractView.getDesign().getDesignObject(object2.getShortDescription());
                    if (designObject == null || ((SQLNameHelper)object).getColumnName().equalsIgnoreCase(designObject.getName())) continue;
                    System.out.println("update column name  start  " + System.currentTimeMillis());
                    object2.beginUpdate();
                    object2.setNameStr(designObject.getName());
                    object2.endUpdate();
                    System.out.println("update column name  end  " + System.currentTimeMillis());
                }
                System.out.println("update plainTextSQLBuilder.setUseAltNames  " + System.currentTimeMillis());
                plainTextSQLBuilder.setUseAltNames(false);
                queryBuilder.setUseAltNames(false);
                System.out.println("update setSQL  " + System.currentTimeMillis());
                QBUtils.setSQL(queryBuilder, string);
                System.out.println("update end setSQL  " + System.currentTimeMillis());
                for (Object object3 : deletedMDObjects) {
                    if (((DeletedMetadataObject)object3).isContainer()) {
                        QBUtils.deleteDataSource(queryBuilder, ((DeletedMetadataObject)object3).getMetadataObject());
                        metadataContainer.remove(((DeletedMetadataObject)object3).getMetadataObject());
                        continue;
                    }
                    if (((DeletedMetadataObject)object3).getMetadataField() == null) continue;
                    QBUtils.deleteColumn(queryBuilder, ((DeletedMetadataObject)object3).getMetadataField());
                    if (((DeletedMetadataObject)object3).getMetadataObject() == null || ((DeletedMetadataObject)object3).getMetadataObject().getFields() == null) continue;
                    ((DeletedMetadataObject)object3).getMetadataObject().getFields().remove(((DeletedMetadataObject)object3).getMetadataField());
                }
            }
            finally {
                int n = 0x100000;
                Runtime runtime = Runtime.getRuntime();
                System.out.println("endUpdate memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            }
            QBUtils.updateDSPositions(queryBuilder);
        }
    }

    private static void parseDSPositions(String string) {
        dsPositions.clear();
        try {
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            Document document = documentBuilder.parse(new InputSource(stringReader));
            Element element2 = document.getDocumentElement();
            if (element2 != null && (element = (Element)Helpers.findChildByName((String)"SubQueries", (Node)element2)) != null) {
                NodeList nodeList = element.getElementsByTagName("SubQuery");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    NodeList nodeList2 = element3.getElementsByTagName("UnionSubQuery");
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element4 = (Element)nodeList2.item(j);
                        NodeList nodeList3 = element4.getElementsByTagName("DataSource");
                        int n = 0;
                        while (n < nodeList3.getLength()) {
                            Element element5 = (Element)nodeList3.item(n);
                            int n2 = Integer.parseInt(element5.getAttribute("X"));
                            int n3 = Integer.parseInt(element5.getAttribute("Y"));
                            int n4 = Integer.parseInt(element5.getAttribute("Width"));
                            int n5 = Integer.parseInt(element5.getAttribute("Height"));
                            DSHelper dSHelper = new DSHelper();
                            dSHelper.queryNbr = i + "." + j;
                            dSHelper.top = n3;
                            dSHelper.Left = n2;
                            dSHelper.width = n4;
                            dSHelper.height = n5;
                            dSHelper.number = n++;
                            dsPositions.add(dSHelper);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveDSPositions(QueryBuilder queryBuilder) {
        List list = QBUtils.getAllDataSources(queryBuilder);
        for (QueryHelper queryHelper : list) {
            DataSource dataSource = queryHelper.dataSource;
            DSHelper dSHelper = QBUtils.findDSHelper(queryHelper, true);
            if (dSHelper == null) continue;
            dSHelper.mo = dataSource.getMetadataObject();
        }
    }

    private static DSHelper findDSHelper(QueryHelper queryHelper, boolean bl) {
        for (DSHelper dSHelper : dsPositions) {
            if (!(bl ? dSHelper.queryNbr.equalsIgnoreCase(queryHelper.queryNbr) && dSHelper.number == queryHelper.number : dSHelper.mo == queryHelper.dataSource.getMetadataObject() && dSHelper.queryNbr.equalsIgnoreCase(queryHelper.queryNbr) && dSHelper.number == queryHelper.number)) continue;
            return dSHelper;
        }
        return null;
    }

    public static void updateDSPositions(QueryBuilder queryBuilder) {
        List list = QBUtils.getAllDataSources(queryBuilder);
        for (QueryHelper queryHelper : list) {
            DataSource dataSource = queryHelper.dataSource;
            DSHelper dSHelper = QBUtils.findDSHelper(queryHelper, false);
            if (dSHelper != null) {
                dataSource.setTop(dSHelper.top);
                dataSource.setLeft(dSHelper.Left);
                dataSource.setWidth(dSHelper.width);
                dataSource.setHeight(dSHelper.height);
                continue;
            }
            System.out.println(queryHelper.number);
        }
    }

    private static List getAllDataSources(QueryBuilder queryBuilder) {
        int n;
        UnionSubQuery unionSubQuery;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        for (n2 = 0; n2 < queryBuilder.getQuery().getCount(); ++n2) {
            arrayList2.clear();
            unionSubQuery = (UnionSubQuery)queryBuilder.getQuery().get(n2);
            unionSubQuery.getFromClause().getDatasourceByClass(DataSource.class, arrayList2);
            n = 0;
            for (Object e : arrayList2) {
                QueryHelper queryHelper = new QueryHelper();
                queryHelper.dataSource = (DataSource)e;
                queryHelper.queryNbr = "0." + n2;
                queryHelper.number = n++;
                arrayList.add(queryHelper);
            }
        }
        for (n2 = 0; n2 < queryBuilder.getQuery().getSubQueryCount(); ++n2) {
            unionSubQuery = queryBuilder.getQuery().getSubQuery(n2);
            for (n = 0; n < unionSubQuery.getCount(); ++n) {
                arrayList2.clear();
                UnionSubQuery unionSubQuery2 = (UnionSubQuery)unionSubQuery.get(n);
                unionSubQuery2.getFromClause().getDatasourceByClass(DataSource.class, arrayList2);
                int n3 = 0;
                for (Object e : arrayList2) {
                    QueryHelper queryHelper = new QueryHelper();
                    queryHelper.dataSource = (DataSource)e;
                    queryHelper.queryNbr = n2 + 1 + "." + n;
                    queryHelper.number = n3++;
                    arrayList.add(queryHelper);
                }
            }
        }
        return arrayList;
    }

    private static List getAllCriteriaLists(QueryBuilder queryBuilder) {
        UnionSubQuery unionSubQuery;
        int n;
        ArrayList<CriteriaList> arrayList = new ArrayList<CriteriaList>();
        for (n = 0; n < queryBuilder.getQuery().getCount(); ++n) {
            unionSubQuery = (UnionSubQuery)queryBuilder.getQuery().get(n);
            arrayList.add(unionSubQuery.getCriteriaList());
        }
        for (n = 0; n < queryBuilder.getQuery().getSubQueryCount(); ++n) {
            unionSubQuery = queryBuilder.getQuery().getSubQuery(n);
            for (int i = 0; i < unionSubQuery.getCount(); ++i) {
                UnionSubQuery unionSubQuery2 = (UnionSubQuery)unionSubQuery.get(i);
                arrayList.add(unionSubQuery2.getCriteriaList());
            }
        }
        return arrayList;
    }

    private static List getAllLinks(QueryBuilder queryBuilder) {
        UnionSubQuery unionSubQuery;
        int n;
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < queryBuilder.getQuery().getCount(); ++n) {
            unionSubQuery = (UnionSubQuery)queryBuilder.getQuery().get(n);
            arrayList.addAll(unionSubQuery.getFromClause().links);
        }
        for (n = 0; n < queryBuilder.getQuery().getSubQueryCount(); ++n) {
            unionSubQuery = queryBuilder.getQuery().getSubQuery(n);
            for (int i = 0; i < unionSubQuery.getCount(); ++i) {
                UnionSubQuery unionSubQuery2 = (UnionSubQuery)unionSubQuery.get(i);
                arrayList.addAll(unionSubQuery2.getFromClause().links);
            }
        }
        return arrayList;
    }

    private static void deleteDataSource(QueryBuilder queryBuilder, MetadataObject metadataObject) {
        try {
            List list = QBUtils.getAllDataSources(queryBuilder);
            for (QueryHelper queryHelper : list) {
                DataSource dataSource = queryHelper.dataSource;
                if (dataSource.getMetadataObject() != metadataObject) continue;
                dataSource.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteColumn(QueryBuilder queryBuilder, MetadataField metadataField) {
        try {
            SQLExpressionOperatorBinary sQLExpressionOperatorBinary;
            int n;
            List list = QBUtils.getAllLinks(queryBuilder);
            for (Object object : list) {
                SQLExpressionColumn sQLExpressionColumn;
                n = 0;
                if (object.getLinkExpression() == null || !(object.getLinkExpression() instanceof SQLExpressionOperatorBinary)) continue;
                sQLExpressionOperatorBinary = (SQLExpressionOperatorBinary)object.getLinkExpression();
                if (sQLExpressionOperatorBinary.lExpression instanceof SQLExpressionColumn) {
                    sQLExpressionColumn = (SQLExpressionColumn)sQLExpressionOperatorBinary.lExpression;
                    if (sQLExpressionColumn.column != null && sQLExpressionColumn.column.getMetadataField() != null && sQLExpressionColumn.column.getMetadataField().getShortDescription().equalsIgnoreCase(metadataField.getShortDescription())) {
                        object.dispose();
                        n = 1;
                    }
                }
                if (n != 0 || !(sQLExpressionOperatorBinary.rExpression instanceof SQLExpressionColumn)) continue;
                sQLExpressionColumn = (SQLExpressionColumn)sQLExpressionOperatorBinary.rExpression;
                if (sQLExpressionColumn.column == null || sQLExpressionColumn.column.getMetadataField() == null || !sQLExpressionColumn.column.getMetadataField().getShortDescription().equalsIgnoreCase(metadataField.getShortDescription())) continue;
                object.dispose();
            }
            list = QBUtils.getAllCriteriaLists(queryBuilder);
            for (Object object : list) {
                for (n = object.getCount() - 1; n >= 0; --n) {
                    sQLExpressionOperatorBinary = object.get(n);
                    if (sQLExpressionOperatorBinary.getExpressionField() == null || !sQLExpressionOperatorBinary.getExpressionField().getShortDescription().equalsIgnoreCase(metadataField.getShortDescription())) continue;
                    sQLExpressionOperatorBinary.dispose();
                }
            }
            list = QBUtils.getAllDataSources(queryBuilder);
            for (Object object : list) {
                DataSource dataSource = object.dataSource;
                sQLExpressionOperatorBinary = dataSource.getFields();
                for (int i = sQLExpressionOperatorBinary.getCount() - 1; i >= 0; --i) {
                    MetadataField metadataField2 = sQLExpressionOperatorBinary.get(i);
                    if (!metadataField.getShortDescription().equalsIgnoreCase(metadataField2.getShortDescription())) continue;
                    sQLExpressionOperatorBinary.delete(i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSQL(QueryBuilder queryBuilder, String string) {
        QBUtils.setSQL(queryBuilder, string, false);
    }

    public static void setSQL(QueryBuilder queryBuilder, String string, boolean bl) {
        block8: {
            isIncorrectSQL = false;
            incorrectSQL = "";
            try {
                queryBuilder.setSQL(string);
            }
            catch (Exception exception) {
                isIncorrectSQL = true;
                incorrectSQL = string;
                queryBuilder.setSQL("");
                if (bl || jTextPane == null) break block8;
                MessageDialogs.showErrorMessage(exception.getMessage());
                int n = -1;
                for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                    if (throwable instanceof ParsingException) {
                        n = ((ParsingException)throwable).errorPos.pos;
                        break;
                    }
                    if (throwable.getCause() == throwable) break;
                }
                if (n > -1) {
                    try {
                        jTextPane.requestFocus();
                        jTextPane.setCaretPosition(n);
                        jTextPane.setSelectionStart(n);
                        int n2 = string.indexOf(" ", n);
                        if (n2 == -1) {
                            n2 = string.length();
                        }
                        jTextPane.setSelectionEnd(n2);
                    }
                    catch (Exception exception2) {}
                }
                jTextPane.setCaretPosition(0);
            }
        }
    }

    private static ContainerObject getContainerObject(AbstractView abstractView, String string) {
        if (abstractView instanceof EntityView) {
            ContainerObject containerObject;
            LogicalDesign logicalDesign = (LogicalDesign)abstractView.getDesignPart();
            Iterator iterator = logicalDesign.getEntitySet().iterator();
            while (iterator.hasNext()) {
                containerObject = (Entity)iterator.next();
                if (!containerObject.getName().equalsIgnoreCase(string)) continue;
                return containerObject;
            }
            iterator = logicalDesign.getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (EntityView)iterator.next();
                if (!containerObject.getName().equalsIgnoreCase(string)) continue;
                return containerObject;
            }
        } else {
            ContainerObject containerObject;
            RelationalDesign relationalDesign = (RelationalDesign)abstractView.getDesignPart();
            Iterator iterator = relationalDesign.getTableSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (Table)iterator.next();
                if (!containerObject.getName().equalsIgnoreCase(string)) continue;
                return containerObject;
            }
            iterator = relationalDesign.getTableViewSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (TableView)iterator.next();
                if (!containerObject.getName().equalsIgnoreCase(string)) continue;
                return containerObject;
            }
        }
        return null;
    }

    private static AbstractViewElement getColumnView(ContainerObject containerObject, AbstractView abstractView, String string, String string2, String string3, String string4, Map map) {
        for (AbstractViewElement abstractViewElement : abstractView.getElementsCollection()) {
            if (map.get(abstractViewElement) != null) {
                return null;
            }
            if (abstractViewElement.getReferencedContainer() != null && containerObject != null) {
                if (abstractViewElement.getReferencedContainer() != containerObject) continue;
                if (string2.length() > 0 && string3.length() > 0 && string4.length() > 0 && string.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression()) && string.equalsIgnoreCase(abstractViewElement.getTableAlias())) {
                    return abstractViewElement;
                }
                if (string2.length() > 0 && string3.length() > 0 && string4.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                    return abstractViewElement;
                }
                if (string2.length() > 0 && string3.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias())) {
                    return abstractViewElement;
                }
                if (string2.length() > 0 && string4.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                    return abstractViewElement;
                }
                if (string3.length() > 0 && string4.length() > 0 && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                    return abstractViewElement;
                }
                if (string3.length() > 0 && string3.equalsIgnoreCase(abstractViewElement.getAlias())) {
                    return abstractViewElement;
                }
                if (string4.length() > 0 && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                    return abstractViewElement;
                }
                if (string2.length() <= 0 || !string2.equalsIgnoreCase(abstractViewElement.getName())) continue;
                return abstractViewElement;
            }
            if (string2.length() > 0 && string3.length() > 0 && string4.length() > 0 && string.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression()) && string.equalsIgnoreCase(abstractViewElement.getTableAlias())) {
                return abstractViewElement;
            }
            if (string2.length() > 0 && string3.length() > 0 && string4.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                return abstractViewElement;
            }
            if (string2.length() > 0 && string3.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string3.equalsIgnoreCase(abstractViewElement.getAlias())) {
                return abstractViewElement;
            }
            if (string2.length() > 0 && string4.length() > 0 && string2.equalsIgnoreCase(abstractViewElement.getName()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                return abstractViewElement;
            }
            if (string3.length() > 0 && string4.length() > 0 && string3.equalsIgnoreCase(abstractViewElement.getAlias()) && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                return abstractViewElement;
            }
            if (string3.length() > 0 && string3.equalsIgnoreCase(abstractViewElement.getAlias())) {
                return abstractViewElement;
            }
            if (string4.length() > 0 && string4.equalsIgnoreCase(abstractViewElement.getExpression())) {
                return abstractViewElement;
            }
            if (string2.length() <= 0 || !string2.equalsIgnoreCase(abstractViewElement.getName())) continue;
            return abstractViewElement;
        }
        return null;
    }

    public static void updateColumns(AbstractView abstractView, QueryBuilder queryBuilder) {
        boolean bl = abstractView instanceof EntityView;
        abstractView.setUserDefined(false);
        abstractView.clearContainers();
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        ArrayList<DesignObject> arrayList2 = new ArrayList<DesignObject>();
        StatisticsOutputColumnList statisticsOutputColumnList = queryBuilder.getQueryStatistics().getOutputColumns();
        HashMap<AbstractViewElement, AbstractViewElement> hashMap = new HashMap<AbstractViewElement, AbstractViewElement>();
        for (int i = 0; i < statisticsOutputColumnList.getCount(); ++i) {
            DesignObject designObject;
            StatisticsOutputColumn statisticsOutputColumn = statisticsOutputColumnList.get(i);
            if (statisticsOutputColumn.getMetadataObject() != null) {
                AbstractViewElement abstractViewElement;
                designObject = QBUtils.getContainerObject(abstractView, statisticsOutputColumn.getMetadataObject().getNameStr());
                if (designObject == null) continue;
                ContainedObject containedObject = null;
                MetadataField metadataField = statisticsOutputColumn.getMetadataField();
                if (metadataField != null) {
                    containedObject = ((ContainerObject)designObject).getElementByName(metadataField.getNameStr());
                }
                if ((abstractViewElement = QBUtils.getColumnView((ContainerObject)designObject, abstractView, statisticsOutputColumn.getObjectAlias(), statisticsOutputColumn.getColumnName(), statisticsOutputColumn.getExpressionAlias(), statisticsOutputColumn.getExpression(), hashMap)) == null) {
                    abstractViewElement = bl ? new AttributeView(abstractView.getDesignPart()) : new ColumnView(abstractView.getDesignPart());
                    if (containedObject != null) {
                        if (containedObject instanceof Column || containedObject instanceof Attribute) {
                            abstractViewElement.setReferencedColumn((ContainedObjectWithDomain)containedObject);
                        } else {
                            abstractViewElement.setReferencedColumnView(containedObject);
                        }
                    }
                    abstractViewElement.setName(statisticsOutputColumn.getColumnName());
                    abstractViewElement.setDesign(designObject.getDesign());
                    if (designObject instanceof Table || designObject instanceof Entity) {
                        abstractViewElement.setTable((ContainerWithKeyObject)designObject);
                    } else {
                        abstractViewElement.setView((AbstractView)designObject);
                    }
                    abstractViewElement.setContainer(abstractView);
                    abstractViewElement.setTableAlias(statisticsOutputColumn.getObjectAlias());
                    if (metadataField != null) {
                        abstractViewElement.setDataType(metadataField.getFieldTypeName());
                    }
                } else if (containedObject != null) {
                    if (containedObject instanceof Column || containedObject instanceof Attribute) {
                        abstractViewElement.setReferencedColumn((ContainedObjectWithDomain)containedObject);
                    } else {
                        abstractViewElement.setReferencedColumnView(containedObject);
                    }
                }
                hashMap.put(abstractViewElement, abstractViewElement);
                abstractViewElement.setAlias(statisticsOutputColumn.getExpressionAlias());
                if ("".equals(statisticsOutputColumn.getObjectName())) {
                    abstractViewElement.setExpression(statisticsOutputColumn.getExpression());
                }
                arrayList2.add(abstractViewElement);
                if (arrayList.contains(designObject)) continue;
                arrayList.add(designObject);
                abstractView.addToContainers((ContainerObject)designObject, statisticsOutputColumn.getObjectAlias());
                continue;
            }
            designObject = QBUtils.getColumnView(null, abstractView, statisticsOutputColumn.getObjectAlias(), statisticsOutputColumn.getColumnName(), statisticsOutputColumn.getExpressionAlias(), statisticsOutputColumn.getExpression(), hashMap);
            if (designObject == null) {
                designObject = bl ? new AttributeView(abstractView.getDesignPart()) : new ColumnView(abstractView.getDesignPart());
                designObject.setName(statisticsOutputColumn.getColumnName());
                designObject.setDesign(abstractView.getDesign());
                ((ContainedObject)designObject).setContainer(abstractView);
                ((AbstractViewElement)designObject).setTableAlias(statisticsOutputColumn.getObjectAlias());
                if (statisticsOutputColumn.getMetadataField() != null) {
                    ((AbstractViewElement)designObject).setDataType(statisticsOutputColumn.getMetadataField().getFieldTypeName());
                } else {
                    ((AbstractViewElement)designObject).setExpression(statisticsOutputColumn.getExpression());
                }
            }
            ((AbstractViewElement)designObject).setAlias(statisticsOutputColumn.getExpressionAlias());
            if ("".equals(statisticsOutputColumn.getObjectName())) {
                ((AbstractViewElement)designObject).setExpression(statisticsOutputColumn.getExpression());
            }
            arrayList2.add(designObject);
        }
        abstractView.clearElements();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            abstractView.add((ContainedObject)iterator.next());
        }
    }

    public static String formatSQL(String string) {
        SQLFormatCommand sQLFormatCommand = new SQLFormatCommand();
        return sQLFormatCommand.reallyDoIt(string);
    }

    public static void setViewSQL(AbstractView abstractView, QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder, boolean bl) {
        abstractView.setUserDefined(true);
        if (isIncorrectSQL) {
            abstractView.setUserDefinedSQL(QBUtils.formatSQL(incorrectSQL));
            abstractView.getElements(incorrectSQL.replaceAll("\\s+", " ").replaceAll(" +", " "), false);
            abstractView.setLayoutSQL("");
            abstractView.getSQLNames().clear();
            abstractView.setIncorrectSQL(true);
        } else {
            String string = plainTextSQLBuilder.getSQL();
            if (bl) {
                string = QBUtils.formatSQL(string);
            }
            abstractView.setUserDefinedSQL(string);
            if (bl) {
                String string2 = queryBuilder.getLayoutSQL();
                abstractView.setLayoutSQL(string2);
            }
            abstractView.updateSQLNames(queryBuilder);
            abstractView.setIncorrectSQL(false);
        }
    }

    static {
        dsPositions = new ArrayList();
        isIncorrectSQL = false;
        incorrectSQL = "";
        deletedMDObjects = new ArrayList();
        metadataObjectsMap = new HashMap();
        SYNTAX_PROVIDERS = new TreeMap<String, BaseSyntaxProvider>();
        previousSyntaxProvider = "Oracle";
        SYNTAX_PROVIDERS.put("DB2", (BaseSyntaxProvider)new DB2SyntaxProvider());
        SYNTAX_PROVIDERS.put("Firebird", (BaseSyntaxProvider)new FirebirdSyntaxProvider());
        SYNTAX_PROVIDERS.put("Informix", (BaseSyntaxProvider)new InformixSyntaxProvider());
        SYNTAX_PROVIDERS.put("MSSQL", (BaseSyntaxProvider)new MSSQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("MySQL", (BaseSyntaxProvider)new MySQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("Oracle", (BaseSyntaxProvider)new OracleSyntaxProvider());
        SYNTAX_PROVIDERS.put("PostgreSQL", (BaseSyntaxProvider)new PostgreSQLSyntaxProvider());
        SYNTAX_PROVIDERS.put("SQLite", (BaseSyntaxProvider)new SQLiteSyntaxProvider());
        SYNTAX_PROVIDERS.put("Sybase", (BaseSyntaxProvider)new SybaseSyntaxProvider());
    }
}

