/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TriggerPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TriggerUDBv81 trigger;
    private JComboBox cbScheme;
    private JComboBox cbAction;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JTextField tfOwner;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfOLD_TABLE_AS;
    private JTextField tfNEW_TABLE_AS;
    private JIntegerField ifOrder;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JTextArea bodyArea;

    public TriggerPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.trigger = (TriggerUDBv81)storageObject;
        this.setHeight(420);
        this.initCommentsView(155);
        this.initCommentsInRDBMS(155);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogUDBv81.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initScheme();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initOLD_TABLE_AS();
        this.initNEW_TABLE_AS();
        this.initCondition();
        this.initOrder();
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDBv81.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.AllColumns"));
        this.panelColumns.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.SelectedColumns"));
        this.panelColumns.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogUDBv81.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 155);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogUDBv81.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 185);
        TriggerPropertyDialogUDBv81.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDBv81.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(jScrollPane);
        this.setObjectConstraints(this.getBodyLayout(), jScrollPane, 10, 12);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initAction() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Action"));
        this.general.add(jLabel);
        this.cbAction = new JComboBox<String>(Trigger.ACTION_TYPES);
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAction.addActionListener(new ActivationListener());
        this.cbAction.addActionListener(new TriggeringTimeListener());
        this.cbAction.addActionListener(new ScopeListener());
        this.general.add(this.cbAction);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbAction, 110);
    }

    private void initTriggeringTime() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.TriggeringTime"));
        this.general.add(jLabel);
        this.cbTriggeringTime = new JComboBox();
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTriggeringTime.addActionListener(new TriggeringTimeListener());
        this.cbTriggeringTime.addActionListener(new ScopeListener());
        this.cbTriggeringTime.addActionListener(new ActivationListener());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbTriggeringTime, 140);
    }

    private void initScope() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Scope"));
        this.general.add(jLabel);
        this.cbScope = new JComboBox<String>(TriggerUDB.SCOPE_TYPES);
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.cbScope.addActionListener(new ScopeListener());
        this.cbScope.addActionListener(new TriggeringTimeListener());
        this.cbScope.addActionListener(new ActivationListener());
        this.general.add(this.cbScope);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbScope, 170);
    }

    private void initRef_OLD_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.RefOLDAS"));
        this.general.add(jLabel);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfRef_OLD_AS, 200);
    }

    private void initRef_NEW_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.RefNEWAS"));
        this.general.add(jLabel);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfRef_NEW_AS, 230);
    }

    private void initOLD_TABLE_AS() {
        JLabel jLabel = new JLabel("OLD TABLE AS:");
        this.general.add(jLabel);
        this.tfOLD_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfOLD_TABLE_AS);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfOLD_TABLE_AS, 260);
    }

    private void initNEW_TABLE_AS() {
        JLabel jLabel = new JLabel("NEW TABLE AS:");
        this.general.add(jLabel);
        this.tfNEW_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfNEW_TABLE_AS);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfNEW_TABLE_AS, 290);
    }

    private void initCondition() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Condition"));
        this.general.add(jLabel);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.tfCondition, 320);
    }

    private void initOrder() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.DefinitionOrder"));
        this.general.add(jLabel);
        this.ifOrder = new JIntegerField(0, 26);
        this.general.add(this.ifOrder);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.ifOrder, 350);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.selectObject(this.cbScheme, this.trigger.getSchema());
        this.cbAction.setSelectedItem(this.trigger.getActions());
        this.fillComboItems(this.trigger.getTriggerTimes(), this.cbTriggeringTime);
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        if (this.trigger.getView() != null) {
            this.cbTriggeringTime.setEnabled(false);
        }
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfOLD_TABLE_AS.setText(this.trigger.getOLD_TABLE_AS());
        this.tfNEW_TABLE_AS.setText(this.trigger.getNEW_TABLE_AS());
        this.tfCondition.setText(this.trigger.getCondition());
        this.ifOrder.setValue((long)this.trigger.getOrder());
        this.bodyArea.setText(this.trigger.getBody());
        if (this.trigger.getTable() != null) {
            ColumnProxy[] columnProxyArray = this.trigger.getTable().getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                ColumnProxy columnProxy = columnProxyArray[i];
                if (this.trigger.getColumnSet().contains(columnProxy.getName())) {
                    this.selectedColumnsModel.addElement(columnProxy);
                    continue;
                }
                this.allColumnsModel.addElement(columnProxy);
            }
        } else if (this.trigger.getView() != null) {
            TableView tableView = (TableView)this.trigger.getView().getObject();
            ContainedObject[] containedObjectArray = tableView.getColumns();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                ContainedObject containedObject = containedObjectArray[i];
                if (this.trigger.getColumnSet().contains(containedObject.getName())) {
                    this.selectedColumnsModel.addElement(containedObject);
                    continue;
                }
                this.allColumnsModel.addElement(containedObject);
            }
        }
        this.getCommentsList().insert(this.trigger.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.trigger.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDBv81) {
                this.trigger.setSchema((SchemaUDBv81)object);
                this.trigger.setOwner(((SchemaUDBv81)object).getOwner());
            } else {
                this.trigger.setSchema(null);
                this.trigger.setOwner(null);
            }
            this.trigger.setName(this.tfName.getText());
            this.trigger.setActions((String)this.cbAction.getSelectedItem());
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setOLD_TABLE_AS(this.tfOLD_TABLE_AS.getText());
            this.trigger.setNEW_TABLE_AS(this.tfNEW_TABLE_AS.getText());
            this.trigger.setCondition(this.tfCondition.getText());
            try {
                this.trigger.setOrder(this.ifOrder.getIntValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.trigger.setOrder(0);
            }
            this.trigger.setBody(this.bodyArea.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                RelationalObjectProxy relationalObjectProxy = (RelationalObjectProxy)objectArray[i];
                this.trigger.setColumns(relationalObjectProxy.getName());
            }
            this.trigger.setComment(this.getCommentsList().getText());
            this.trigger.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbScheme.getSelectedItem();
        if (object instanceof SchemaUDB) {
            string = ((SchemaUDB)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)TriggerPropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDBv81 != null) {
                    TriggerPropertyDialogUDBv81.this.tfOwner.setText(schemaUDBv81.getOwner().toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                TriggerPropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    public class TriggeringTimeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDBv81.this.cbTriggeringTime.getSelectedItem();
            if (string != null) {
                if (string.equalsIgnoreCase("AFTER")) {
                    TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                    TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                } else {
                    TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(false);
                    TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
                }
            }
        }
    }

    public class ScopeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDBv81.this.cbScope.getSelectedItem();
            if (string.equalsIgnoreCase(TriggerUDB.SCOPE_TYPES[1])) {
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
            } else {
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
            }
        }
    }

    public class ActivationListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDBv81.this.cbAction.getSelectedItem();
            boolean bl = false;
            if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                bl = true;
            }
            TriggerPropertyDialogUDBv81.this.allColumnsList.setEnabled(bl);
            TriggerPropertyDialogUDBv81.this.selectedColumnsList.setEnabled(bl);
            if (!bl) {
                TriggerPropertyDialogUDBv81.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogUDBv81.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
            } else if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
            } else {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(false);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDBv81.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDBv81.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDBv81.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogUDBv81.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogUDBv81.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogUDBv81.this.allColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogUDBv81.this.allColumnsModel.addElement(object);
                    TriggerPropertyDialogUDBv81.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDBv81.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDBv81.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDBv81.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogUDBv81.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogUDBv81.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogUDBv81.this.selectedColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogUDBv81.this.selectedColumnsModel.addElement(object);
                    TriggerPropertyDialogUDBv81.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

