/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TableViewPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TableViewProxyUDBv81 view;
    private JComboBox cbSchema;
    private JComboBox cbFederated;
    private JComboBox cbCheckOption;
    private JComboBox cbCheckOptionScope;
    private JTextArea definitionArea;
    private String comment;
    private String commentInRDBMS;
    private JButton bnPermissions;
    private PermissionsPropertyDialogUDB dialog;
    private JTextField tfOwner;
    private JTextField tfOidColumnName;
    private JCheckBox chbOidColumnUniqueness;
    private JTextField tfSuperView;

    public TableViewPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.view = (TableViewProxyUDBv81)storageObject;
        this.setHeight(600);
        this.initCommentsView(260);
        this.initCommentsInRDBMS(260);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertyDialogUDBv81.ViewProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initSchema();
        this.initFederated();
        this.initCheckOption();
        this.initCheckOptionScope();
        this.initOidColumnName();
        this.initOidColumnUniqueness();
        this.initSuperViewName();
        this.initDefinition();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initSchema() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.Schema"));
        this.general.add(jLabel);
        this.cbSchema = new JComboBox();
        this.setBG(this.cbSchema);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbSchema);
        }
        this.cbSchema.addActionListener(new SchemeListener());
        this.cbSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchema);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbSchema, 50);
    }

    private void initFederated() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.Federated"));
        this.general.add(jLabel);
        this.cbFederated = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFederated);
        this.cbFederated.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFederated);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbFederated, 110);
    }

    private void initCheckOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.CheckOption"));
        this.general.add(jLabel);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbCheckOption, 140);
    }

    private void initCheckOptionScope() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.CheckScope"));
        this.general.add(jLabel);
        this.cbCheckOptionScope = new JComboBox<String>(TableViewProxyUDB.getAvailableCheckOptionScopes());
        this.setBG(this.cbCheckOptionScope);
        this.cbCheckOptionScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOptionScope);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCheckOptionScope, 170);
    }

    private void initOidColumnName() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.OidColumnName"));
        this.general.add(jLabel);
        this.tfOidColumnName = new JTextField("", 26);
        this.general.add(this.tfOidColumnName);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfOidColumnName, 200);
    }

    private void initOidColumnUniqueness() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.OidUniqueness"));
        this.general.add(jLabel);
        this.chbOidColumnUniqueness = new JCheckBox("");
        this.chbOidColumnUniqueness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.general.add(this.chbOidColumnUniqueness);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.chbOidColumnUniqueness, 230);
    }

    private void initSuperViewName() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.SuperView"));
        this.general.add(jLabel);
        this.tfSuperView = new JTextField("", 26);
        this.tfSuperView.setEnabled(false);
        this.general.add(this.tfSuperView);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfSuperView, 260);
    }

    private void initDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDBv81.Definition"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 290);
        this.definitionArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.definitionArea);
        jScrollPane.setPreferredSize(new Dimension(395, 250));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.definitionArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 310);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 410);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.cbSchema.setSelectedItem(this.view.getSchema());
        this.cbFederated.setSelectedItem(TableViewPropertyDialogUDBv81.translateYesNoForDisplay(this.view.getFederated()));
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES_NO[0]);
        } else {
            this.cbCheckOption.setSelectedItem(YES_NO[1]);
        }
        this.cbCheckOptionScope.setSelectedItem(this.view.getCheckOptionScope());
        if (this.view.isBasedOnStructuredType()) {
            this.tfOidColumnName.setText(this.view.getOidColumnName());
            this.chbOidColumnUniqueness.setSelected(this.view.isOidColumnUniqueness());
        } else {
            this.tfOidColumnName.setEnabled(false);
            this.chbOidColumnUniqueness.setEnabled(false);
        }
        this.tfSuperView.setText(this.view.getSuperViewName());
        this.definitionArea.setText(this.view.getDefinition());
        this.comment = this.view.getObject().getComment();
        this.commentInRDBMS = this.view.getObject().getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setSchema((SchemaUDBv81)this.cbSchema.getSelectedItem());
            this.view.setFederated(TableViewPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbFederated.getSelectedItem()));
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES_NO[0])) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setCheckOptionScope((String)this.cbCheckOptionScope.getSelectedItem());
            if (this.view.isBasedOnStructuredType()) {
                this.view.setOidColumnName(this.tfOidColumnName.getText());
                this.view.setOidColumnUniqueness(this.chbOidColumnUniqueness.isSelected());
            }
            this.view.setDefinition(this.definitionArea.getText());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.view.setComment(string);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.view.setCommentInRDBMS(string2);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDB schemaUDB = (SchemaUDB)TableViewPropertyDialogUDBv81.this.cbSchema.getSelectedItem();
            try {
                if (schemaUDB != null) {
                    TableViewPropertyDialogUDBv81.this.tfOwner.setText(schemaUDB.getOwner().toString());
                } else {
                    TableViewPropertyDialogUDBv81.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException nullPointerException) {
                TableViewPropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TableViewPropertyDialogUDBv81.this.dialog == null) {
                TableViewPropertyDialogUDBv81.this.dialog = new PermissionsPropertyDialogUDB(TableViewPropertyDialogUDBv81.this.getAppView(), TableViewPropertyDialogUDBv81.this.getStorageDesign(), TableViewPropertyDialogUDBv81.this.view);
            }
            TableViewPropertyDialogUDBv81.this.dialog.setVisible(true);
        }
    }
}

