/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarcharUDB;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TableProxyUDBv81 table;
    private JComboBox cbScheme;
    private JComboBox cbPartKeyHashing;
    private JComboBox cbTS;
    private JComboBox cbIndexTS;
    private JComboBox cbLongTS;
    private JComboBox cbInitialLogging;
    private JComboBox cbDataCapture;
    private JComboBox cbFederated;
    private JComboBox cbRestrictOnDrop;
    private JComboBox cbValueCompression;
    private JPanel partKeys;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbSummaryQuery;
    protected JComboBox cbSummaryStatus;
    protected JComboBox cbSummaryMaintenance;
    protected JComboBox cbSummaryQueryOptimization;
    protected JComboBox cbSummaryIdentityColumn;
    protected JComboBox cbSummaryColumnDefaults;
    protected JComboBox cbSummaryRefreshOptions;
    protected JComboBox cbSummaryReplicated;
    protected JPanel summaryQuery;
    protected JPanel others;
    protected JTextArea queryArea;
    protected JCheckBox chbUseRemoteOptions;
    protected JTextField tfOwner;
    protected JTextField tfRemoteServer;
    protected JTextField tfRemoteSchema;
    protected JTextField tfRemoteTabName;
    protected JCheckBox chbOrganizeByDimensions;
    protected JTextArea taDimesions;
    private String comment;
    private String commentInRDBMS;
    private JButton bnPermissions;
    private PermissionsPropertyDialogUDB dialog;
    private JTextField tfHierarchyName;
    private JTextField tfSuperTable;

    public TablePropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxyUDBv81)storageObject;
        this.setHeight(560);
        this.initCommentsView(230);
        this.initCommentsInRDBMS(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogUDBv81.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initScheme();
        this.initPartKeyHashing();
        this.initTS();
        this.initIndexTS();
        this.initLongTS();
        this.initInitialLogging();
        this.initDataCapture();
        this.initFederated();
        this.initHasSummaryQuery();
        this.initRestrictOnDrop();
        this.initValueCompression();
        this.initHierarchyName();
        this.initSuperTable();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initPartKeyHashing() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.PartKeyHashing"));
        this.general.add(jLabel);
        this.cbPartKeyHashing = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartKeyHashing);
        this.cbPartKeyHashing.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartKeyHashing);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbPartKeyHashing, 110);
    }

    private void initTS() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.TableSpace"));
        this.general.add(jLabel);
        this.cbTS = new JComboBox();
        this.setBG(this.cbTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTS);
        }
        this.cbTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTS);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbTS, 140);
    }

    private void initIndexTS() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.IndexTableSpace"));
        this.general.add(jLabel);
        this.cbIndexTS = new JComboBox();
        this.setBG(this.cbIndexTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTS);
        }
        this.cbIndexTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTS);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbIndexTS, 170);
    }

    private void initLongTS() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.LongTableSpace"));
        this.general.add(jLabel);
        this.cbLongTS = new JComboBox();
        this.setBG(this.cbLongTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbLongTS);
        }
        this.cbLongTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLongTS);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbLongTS, 200);
    }

    private void initInitialLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.InitialLogging"));
        this.general.add(jLabel);
        this.cbInitialLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInitialLogging);
        this.cbInitialLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitialLogging);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbInitialLogging, 230);
    }

    private void initDataCapture() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.DataCapture"));
        this.general.add(jLabel);
        this.cbDataCapture = new JComboBox<String>(TableProxyUDB.getAvailableDataCaptureValues());
        this.setBG(this.cbDataCapture);
        this.cbDataCapture.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataCapture);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbDataCapture, 260);
    }

    private void initFederated() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Federated"));
        this.general.add(jLabel);
        this.cbFederated = new JComboBox<String>(TableProxyUDB.getFederatedChoices());
        this.setBG(this.cbFederated);
        this.cbFederated.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFederated);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbFederated, 290);
    }

    protected void initHasSummaryQuery() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SummaryQueryL"));
        this.general.add(jLabel);
        this.cbSummaryQuery = new JComboBox<String>(YES_NO);
        this.cbSummaryQuery.addActionListener(new SummaryQueryListener());
        this.setBG(this.cbSummaryQuery);
        this.cbSummaryQuery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSummaryQuery);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbSummaryQuery, 320);
    }

    private void enableSummaryPanel(boolean bl) {
        this.cbSummaryStatus.setEnabled(bl);
        this.cbSummaryMaintenance.setEnabled(bl);
        this.cbSummaryQueryOptimization.setEnabled(bl);
        this.cbSummaryIdentityColumn.setEnabled(bl);
        this.cbSummaryColumnDefaults.setEnabled(bl);
        this.cbSummaryRefreshOptions.setEnabled(bl);
        this.cbSummaryReplicated.setEnabled(bl);
        this.queryArea.setEnabled(bl);
    }

    protected void initRestrictOnDrop() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RestrictOnDrop"));
        this.general.add(jLabel);
        this.cbRestrictOnDrop = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRestrictOnDrop);
        this.cbRestrictOnDrop.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRestrictOnDrop);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbRestrictOnDrop, 350);
    }

    protected void initValueCompression() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.ValueCompression"));
        this.general.add(jLabel);
        this.cbValueCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValueCompression);
        this.cbValueCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValueCompression);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbValueCompression, 380);
    }

    private void initHierarchyName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.HierarchyName"));
        this.general.add(jLabel);
        this.tfHierarchyName = new JTextField("", 26);
        this.general.add(this.tfHierarchyName);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.tfHierarchyName, 410);
    }

    private void initSuperTable() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SuperTable"));
        this.general.add(jLabel);
        this.tfSuperTable = new JTextField("", 26);
        this.tfSuperTable.setEnabled(false);
        this.general.add(this.tfSuperTable);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.tfSuperTable, 440);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogUDBv81.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogUDBv81.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogUDBv81.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogUDBv81.this.getAppView(), TablePropertyDialogUDBv81.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 480);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 480);
    }

    @Override
    protected void addTabs() {
        this.initPartKeyView();
        this.initSummaryQueryView();
        this.initROAndDimensionsView();
    }

    protected SpringLayout getROAndDimensionsLayout() {
        return (SpringLayout)this.others.getLayout();
    }

    private void initPartKeyView() {
        this.partKeys = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.PartitioningKeys"), this.partKeys);
        this.initPartKeys();
    }

    protected SpringLayout getPartKeysLayout() {
        return (SpringLayout)this.partKeys.getLayout();
    }

    private void initPartKeys() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.selectObject(this.cbScheme, this.table.getSchema());
        this.cbPartKeyHashing.setSelectedItem(this.table.getPartKeyHashing() ? YES_NO[0] : YES_NO[1]);
        this.selectObject(this.cbTS, this.table.getTableSpace());
        this.selectObject(this.cbIndexTS, this.table.getIndexInTableSpace());
        this.selectObject(this.cbLongTS, this.table.getLongInTableSpace());
        this.cbInitialLogging.setSelectedItem(this.table.getInitialLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDataCapture.setSelectedItem(this.table.getDataCapture());
        this.cbSummaryQuery.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getSummaryQuery()));
        if (this.table.getSummaryQuery().equalsIgnoreCase("YES")) {
            this.enableSummaryPanel(true);
        } else {
            this.enableSummaryPanel(false);
        }
        this.cbFederated.setSelectedItem(this.table.getFederated());
        this.cbRestrictOnDrop.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getRestrictOnDrop()));
        this.cbValueCompression.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getValueCompression()));
        if (((Table)this.table.getObject()).isRoot()) {
            this.tfHierarchyName.setText(this.table.getHierarchyName());
        } else {
            this.tfHierarchyName.setEditable(false);
        }
        this.tfSuperTable.setText(this.table.getSuperTableName());
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (columnProxy.getDataType() instanceof MDBlobUDB && columnProxy.getDataType() instanceof MDLongVarcharUDB && columnProxy.getDataType() instanceof MDLongVarGraphicUDB && columnProxy.getDataType() instanceof MDClobUDB && columnProxy.getDataType() instanceof MDDBClobUDB && columnProxy.getDataType() instanceof MDDataLinkUDB) continue;
            if (this.table.getColumnSet().contains(columnProxy.getName())) {
                this.selectedColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allColumnsModel.addElement(columnProxy);
        }
        this.queryArea.setText(this.table.getSummaryQueryDefinition());
        this.cbSummaryStatus.setSelectedItem(this.table.getSummaryStatus());
        this.cbSummaryMaintenance.setSelectedItem(this.table.getSummaryMaintenance());
        this.cbSummaryRefreshOptions.setSelectedItem(this.table.getSummaryRefreshOptions());
        this.cbSummaryQueryOptimization.setSelectedItem(this.table.getSummaryQueryOptimization());
        this.cbSummaryIdentityColumn.setSelectedItem(this.table.getSummaryIdentityColumn());
        this.cbSummaryColumnDefaults.setSelectedItem(this.table.getSummaryCopyColumnDefaults());
        this.cbSummaryReplicated.setSelectedItem(TablePropertyDialogUDBv81.translateYesNoForDisplay(this.table.getReplicated()));
        this.chbUseRemoteOptions.setSelected(this.table.getUseRemoteOptions());
        this.tfRemoteServer.setText(this.table.getRoRemoteServer());
        this.tfRemoteSchema.setText(this.table.getRoRemoteSchema());
        this.tfRemoteTabName.setText(this.table.getRoRemoteTabName());
        this.tfRemoteServer.setEnabled(this.table.getUseRemoteOptions());
        this.tfRemoteSchema.setEnabled(this.table.getUseRemoteOptions());
        this.tfRemoteTabName.setEnabled(this.table.getUseRemoteOptions());
        this.chbOrganizeByDimensions.setSelected(this.table.getOrganizeByDimensions());
        this.taDimesions.setText(this.table.getDimensions());
        this.taDimesions.setEnabled(this.table.getOrganizeByDimensions());
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            Object object;
            this.table.setName(this.tfName.getText());
            Object object2 = this.cbScheme.getSelectedItem();
            if (object2 instanceof SchemaUDBv81) {
                this.table.setOwner(((SchemaUDBv81)object2).getOwner());
                this.table.setSchema((SchemaUDBv81)object2);
            } else {
                this.table.setOwner(null);
                this.table.setSchema(null);
            }
            object2 = this.cbPartKeyHashing.getSelectedItem();
            boolean bl = String.valueOf(object2).equalsIgnoreCase(YES_NO[0]);
            this.table.setPartKeyHashing(bl);
            object2 = this.cbTS.getSelectedItem();
            if (object2 instanceof TableSpaceUDBv81) {
                this.table.setTableSpace((TableSpaceUDBv81)object2);
            } else {
                this.table.setTableSpace(null);
            }
            object2 = this.cbIndexTS.getSelectedItem();
            if (object2 instanceof TableSpaceUDBv81) {
                this.table.setIndexInTableSpace((TableSpaceUDBv81)object2);
            } else {
                this.table.setIndexInTableSpace(null);
            }
            object2 = this.cbLongTS.getSelectedItem();
            if (object2 instanceof TableSpaceUDBv81) {
                this.table.setLongInTableSpace((TableSpaceUDBv81)object2);
            } else {
                this.table.setLongInTableSpace(null);
            }
            object2 = this.cbInitialLogging.getSelectedItem();
            bl = String.valueOf(object2).equalsIgnoreCase(YES_NO[0]);
            this.table.setInitialLogging(bl);
            this.table.setDataCapture((String)this.cbDataCapture.getSelectedItem());
            this.table.setSummaryQuery(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbSummaryQuery.getSelectedItem()));
            this.table.setFederated((String)this.cbFederated.getSelectedItem());
            this.table.setRestrictOnDrop(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbRestrictOnDrop.getSelectedItem()));
            this.table.setValueCompression(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbValueCompression.getSelectedItem()));
            if (this.tfHierarchyName.isEditable()) {
                this.table.setHierarchyName(this.tfHierarchyName.getText());
            }
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof RelationalObjectProxy)) continue;
                this.table.setPartitioningKey(((RelationalObjectProxy)object).getName());
            }
            this.table.setSummaryQueryDefinition(this.queryArea.getText());
            this.table.setSummaryStatus((String)this.cbSummaryStatus.getSelectedItem());
            this.table.setSummaryMaintenance((String)this.cbSummaryMaintenance.getSelectedItem());
            this.table.setSummaryRefreshOptions((String)this.cbSummaryRefreshOptions.getSelectedItem());
            this.table.setSummaryQueryOptimization((String)this.cbSummaryQueryOptimization.getSelectedItem());
            this.table.setSummaryIdentityColumn((String)this.cbSummaryIdentityColumn.getSelectedItem());
            this.table.setSummaryCopyColumnDefaults((String)this.cbSummaryColumnDefaults.getSelectedItem());
            this.table.setReplicated(TablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbSummaryReplicated.getSelectedItem()));
            this.table.setUseRemoteOptions(this.chbUseRemoteOptions.isSelected());
            this.table.setRoRemoteServer(this.tfRemoteServer.getText());
            this.table.setRoRemoteSchema(this.tfRemoteSchema.getText());
            this.table.setRoRemoteTabName(this.tfRemoteTabName.getText());
            this.table.setOrganizeByDimensions(this.chbOrganizeByDimensions.isSelected());
            this.table.setDimensions(this.taDimesions.getText());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.table.setComment(string);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.table.setCommentInRDBMS((String)object);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.AllColumns"));
        this.partKeys.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 480));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partKeys.add(jScrollPane);
        this.setLabelConstraints(this.getPartKeysLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getPartKeysLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.SelectedColumns"));
        this.partKeys.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 480));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partKeys.add(jScrollPane);
        this.setLabelConstraints(this.getPartKeysLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getPartKeysLayout(), jScrollPane, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("TablePropertyDialogUDBv81.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partKeys.add(this.bnAdd);
        this.setObjectConstraints(this.getPartKeysLayout(), this.bnAdd, 175, 185);
        this.bnRemove = new JButton(Messages.getString("TablePropertyDialogUDBv81.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partKeys.add(this.bnRemove);
        this.setObjectConstraints(this.getPartKeysLayout(), this.bnRemove, 175, 215);
        TablePropertyDialogUDBv81.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected void initSummaryQueryView() {
        this.summaryQuery = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.SummaryQuery"), this.summaryQuery);
        this.initSummaryQuery();
    }

    private void initSummaryQuery() {
        this.initSummaryQueryDefinition();
        this.initSummaryStatus();
        this.initSummaryMaintenance();
        this.initSummaryRefreshOptions();
        this.initSummaryQueryOptimization();
        this.initSummaryIdentityColumn();
        this.initSummaryCopyColumnDefaults();
        this.initReplicated();
    }

    private void initSummaryQueryDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Query"));
        this.summaryQuery.add(jLabel);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 10);
        this.queryArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.queryArea);
        jScrollPane.setPreferredSize(new Dimension(395, 190));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.queryArea.setLineWrap(true);
        this.summaryQuery.add(jScrollPane);
        this.setObjectConstraints(this.getSummaryQueryLayout(), jScrollPane, 10, 30);
    }

    protected SpringLayout getSummaryQueryLayout() {
        return (SpringLayout)this.summaryQuery.getLayout();
    }

    private void initSummaryStatus() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Status"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryStatus = new JComboBox<String>(TableProxyUDB.SUMMARY_STATUS_STATES);
        this.setBG(this.cbSummaryStatus);
        this.cbSummaryStatus.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryStatus);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 230);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryStatus, 230);
    }

    private void initSummaryMaintenance() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Maintenance"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryMaintenance = new JComboBox<String>(TableProxyUDB.SUMMARY_MAINTENANCE_STATES);
        this.setBG(this.cbSummaryMaintenance);
        this.cbSummaryMaintenance.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryMaintenance);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 260);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryMaintenance, 260);
    }

    private void initSummaryRefreshOptions() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RefreshOptions"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryRefreshOptions = new JComboBox<String>(TableProxyUDB.SUMMARY_REFRESH_OPTIONS_STATES);
        this.setBG(this.cbSummaryRefreshOptions);
        this.cbSummaryRefreshOptions.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryRefreshOptions);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 290);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryRefreshOptions, 290);
    }

    private void initSummaryQueryOptimization() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.QueryOptimization"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryQueryOptimization = new JComboBox<String>(TableProxyUDB.SUMMARY_QUERY_OPTIMIZATION_STATES);
        this.setBG(this.cbSummaryQueryOptimization);
        this.cbSummaryQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryQueryOptimization);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 320);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryQueryOptimization, 320);
    }

    private void initSummaryIdentityColumn() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.IdentityColumn"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryIdentityColumn = new JComboBox<String>(TableProxyUDB.SUMMARY_IDENTITY_COLUMN_STATES);
        this.setBG(this.cbSummaryIdentityColumn);
        this.cbSummaryIdentityColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryIdentityColumn);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 350);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryIdentityColumn, 350);
    }

    private void initSummaryCopyColumnDefaults() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.ColumnDefaults"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryColumnDefaults = new JComboBox<String>(TableProxyUDB.SUMMARY_COPY_COLUMN_DEFAULTS_STATES);
        this.setBG(this.cbSummaryColumnDefaults);
        this.cbSummaryColumnDefaults.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryColumnDefaults);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 380);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryColumnDefaults, 380);
    }

    private void initReplicated() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Replicated"));
        this.summaryQuery.add(jLabel);
        this.cbSummaryReplicated = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSummaryReplicated);
        this.cbSummaryReplicated.setPreferredSize(this.tfName.getPreferredSize());
        this.summaryQuery.add(this.cbSummaryReplicated);
        this.setLabelConstraints(this.getSummaryQueryLayout(), jLabel, 410);
        this.setObjectConstraints(this.getSummaryQueryLayout(), this.cbSummaryReplicated, 410);
    }

    protected void initROAndDimensionsView() {
        this.others = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogUDBv81.RemoteOptionsAndDimensions"), this.others);
        this.initROAndDimensions();
    }

    private void initROAndDimensions() {
        this.initUseRemoteOptions();
        this.initRORemoteServer();
        this.initRORemoteSchema();
        this.initRORemoteTabName();
        this.initOrganizeByDimensions();
        this.initDimensions();
    }

    private void initUseRemoteOptions() {
        this.chbUseRemoteOptions = new JCheckBox(Messages.getString("TablePropertyDialogUDBv81.UseRemoteOptions"));
        this.chbUseRemoteOptions.addActionListener(new UseRemoteOptionsListener());
        this.others.add(this.chbUseRemoteOptions);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.chbUseRemoteOptions, 5, 12);
    }

    private void initRORemoteServer() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteServer"));
        this.others.add(jLabel);
        this.tfRemoteServer = new JTextField("", 26);
        this.others.add(this.tfRemoteServer);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteServer, 50);
    }

    private void initRORemoteSchema() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteSchema"));
        this.others.add(jLabel);
        this.tfRemoteSchema = new JTextField("", 26);
        this.others.add(this.tfRemoteSchema);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteSchema, 80);
    }

    private void initRORemoteTabName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.RemoteTABName"));
        this.others.add(jLabel);
        this.tfRemoteTabName = new JTextField("", 26);
        this.others.add(this.tfRemoteTabName);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.tfRemoteTabName, 110);
    }

    private void initOrganizeByDimensions() {
        this.chbOrganizeByDimensions = new JCheckBox(Messages.getString("TablePropertyDialogUDBv81.OrganizeByDimensions"));
        this.chbOrganizeByDimensions.addActionListener(new OrganizeByDimensionsListener());
        this.others.add(this.chbOrganizeByDimensions);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), this.chbOrganizeByDimensions, 5, 150);
    }

    private void initDimensions() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogUDBv81.Dimensions"));
        this.others.add(jLabel);
        this.taDimesions = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taDimesions);
        jScrollPane.setPreferredSize(new Dimension(395, 215));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taDimesions.setLineWrap(true);
        this.others.add(jScrollPane);
        this.setLabelConstraints(this.getROAndDimensionsLayout(), jLabel, 190);
        this.setObjectConstraints(this.getROAndDimensionsLayout(), jScrollPane, 10, 215);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)TablePropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDBv81 != null) {
                    TablePropertyDialogUDBv81.this.tfOwner.setText(schemaUDBv81.getOwner().toString());
                } else {
                    TablePropertyDialogUDBv81.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException nullPointerException) {
                TablePropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogUDBv81.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogUDBv81.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogUDBv81.this.allColumnsModel.contains(object)) continue;
                    TablePropertyDialogUDBv81.this.allColumnsModel.addElement(object);
                    TablePropertyDialogUDBv81.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class OrganizeByDimensionsListener
    implements ActionListener {
        private OrganizeByDimensionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogUDBv81.this.taDimesions.setEnabled(TablePropertyDialogUDBv81.this.chbOrganizeByDimensions.isSelected());
        }
    }

    private class UseRemoteOptionsListener
    implements ActionListener {
        private UseRemoteOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogUDBv81.this.tfRemoteServer.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
            TablePropertyDialogUDBv81.this.tfRemoteSchema.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
            TablePropertyDialogUDBv81.this.tfRemoteTabName.setEnabled(TablePropertyDialogUDBv81.this.chbUseRemoteOptions.isSelected());
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogUDBv81.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogUDBv81.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogUDBv81.this.selectedColumnsModel.contains(object)) continue;
                    TablePropertyDialogUDBv81.this.selectedColumnsModel.addElement(object);
                    TablePropertyDialogUDBv81.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogUDBv81.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogUDBv81.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogUDBv81.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogUDBv81.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogUDBv81.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogUDBv81.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogUDBv81.this.dialog == null) {
                TablePropertyDialogUDBv81.this.dialog = new PermissionsPropertyDialogUDB(TablePropertyDialogUDBv81.this.getAppView(), TablePropertyDialogUDBv81.this.getStorageDesign(), TablePropertyDialogUDBv81.this.table);
            }
            TablePropertyDialogUDBv81.this.dialog.show();
        }
    }

    private class SummaryQueryListener
    implements ActionListener {
        private SummaryQueryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)TablePropertyDialogUDBv81.this.cbSummaryQuery.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES)) {
                TablePropertyDialogUDBv81.this.enableSummaryPanel(true);
            } else {
                TablePropertyDialogUDBv81.this.enableSummaryPanel(false);
            }
        }
    }
}

