/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableCheckConstraintProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableCheckConstraintProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TableCheckConstraintPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    protected TableCheckConstraintProxyUDBv81 tcc;
    private JTextArea taConstraint;
    private JComboBox cbValidation;
    private JComboBox cbQueryOptimization;

    public TableCheckConstraintPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.tcc = (TableCheckConstraintProxyUDBv81)storageObject;
        this.setHeight(280);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableCheckConstraintPropertyDialogUDBv81.TableCheckConstraintProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initConstraint();
        this.initValidation();
        this.initQueryOptimization();
    }

    private void initConstraint() {
        JLabel jLabel = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogUDBv81.Constraint"));
        this.general.add(jLabel);
        this.taConstraint = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taConstraint);
        jScrollPane.setPreferredSize(new Dimension(395, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taConstraint.setLineWrap(true);
        this.taConstraint.setEnabled(false);
        this.general.add(jScrollPane);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(jScrollPane, 10, 70);
    }

    private void initValidation() {
        JLabel jLabel = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogUDBv81.Validation"));
        this.general.add(jLabel);
        this.cbValidation = new JComboBox<String>(TableCheckConstraintProxyUDB.validationChoices);
        this.setBG(this.cbValidation);
        this.cbValidation.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidation);
        this.setLabelConstraints(jLabel, 190);
        this.setObjectConstraints(this.cbValidation, 190);
    }

    private void initQueryOptimization() {
        JLabel jLabel = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogUDBv81.QueryOptimization"));
        this.general.add(jLabel);
        this.cbQueryOptimization = new JComboBox<String>(TableCheckConstraintProxyUDB.queryOptimizationChoices);
        this.setBG(this.cbQueryOptimization);
        this.cbQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQueryOptimization);
        this.setLabelConstraints(jLabel, 220);
        this.setObjectConstraints(this.cbQueryOptimization, 220);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tcc.getName());
        this.tfName.setText(this.tcc.getName());
        if (this.tcc.getTableConstraint() != null) {
            this.taConstraint.setText(this.tcc.getTableConstraint().getRule());
        }
        this.cbValidation.setSelectedItem(this.tcc.getValidation());
        this.cbQueryOptimization.setSelectedItem(this.tcc.getQueryOptimization());
        this.getCommentsList().insert(this.tcc.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tcc != null) {
            this.tcc.setName(this.tfName.getText());
            this.tcc.setValidation((String)this.cbValidation.getSelectedItem());
            this.tcc.setQueryOptimization((String)this.cbQueryOptimization.getSelectedItem());
            this.tcc.setComment(this.getCommentsList().getText());
        }
    }
}

