/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StagingTablePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    protected StagingTableUDBv81 staging;
    protected JTextField tfMQTable;
    protected JComboBox cbGenerateSIC;
    protected JCheckBox chbDefineColumnNames;
    private JTable columnsTable;

    public StagingTablePropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.staging = (StagingTableUDBv81)storageObject;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StagingTablePropertyDialogUDBv81.StagingTableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initMQTable();
        this.initGenerateSIC();
        this.initDefineColumnNames();
        this.initColumnNames();
    }

    private void initMQTable() {
        JLabel jLabel = new JLabel(Messages.getString("StagingTablePropertyDialogUDBv81.MQTable"));
        this.general.add(jLabel);
        this.tfMQTable = new JTextField("", 26);
        this.tfMQTable.setEnabled(false);
        this.general.add(this.tfMQTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfMQTable, 50);
    }

    private void initGenerateSIC() {
        JLabel jLabel = new JLabel(Messages.getString("StagingTablePropertyDialogUDBv81.GenerateSIC"));
        this.general.add(jLabel);
        this.cbGenerateSIC = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGenerateSIC);
        this.cbGenerateSIC.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbGenerateSIC);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbGenerateSIC, 80);
    }

    private void initDefineColumnNames() {
        this.chbDefineColumnNames = new JCheckBox(Messages.getString("StagingTablePropertyDialogUDBv81.DefineColumnNames"));
        this.chbDefineColumnNames.addActionListener(new DefineColumnNamesListener());
        this.general.add(this.chbDefineColumnNames);
        this.setObjectConstraints(this.chbDefineColumnNames, 5, 120);
    }

    private void initColumnNames() {
        this.columnsTable = new ColumnsTable();
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, 210));
        this.setBG(this.columnsTable);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 150);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.staging.getName());
        this.tfName.setText(this.staging.getName());
        this.tfMQTable.setText(this.staging.getTable().getName());
        this.cbGenerateSIC.setSelectedItem(StagingTablePropertyDialogUDBv81.translateYesNoForDisplay(this.staging.getGenerateSIC()));
        this.chbDefineColumnNames.setSelected(this.staging.getDefineColumnNames());
        if (this.staging.getDefineColumnNames()) {
            ColumnsModel columnsModel = (ColumnsModel)this.columnsTable.getModel();
            if (this.chbDefineColumnNames.isSelected()) {
                if (this.staging.getColumnSet().size() > 0) {
                    for (int i = 0; i < this.staging.getColumnSet().size(); ++i) {
                        columnsModel.addRow(new Object[]{this.staging.getColumnSet().elementAt(i)});
                    }
                } else {
                    for (int i = 0; i < this.staging.getTableColumnNames().size(); ++i) {
                        columnsModel.addRow(new Object[]{this.staging.getTableColumnNames().get(i)});
                    }
                }
            } else {
                int n = columnsModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    columnsModel.removeRow(0);
                }
            }
        }
        this.taComments.setText(this.staging.getCommentInRDBMS());
    }

    @Override
    protected void setProperties() {
        if (this.staging != null) {
            this.staging.setName(this.tfName.getText());
            this.staging.setGenerateSIC(StagingTablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbGenerateSIC.getSelectedItem()));
            this.staging.setDefineColumnNames(this.chbDefineColumnNames.isSelected());
            if (this.chbDefineColumnNames.isSelected()) {
                this.staging.clear();
                ColumnsModel columnsModel = (ColumnsModel)this.columnsTable.getModel();
                for (int i = 0; i < columnsModel.getRowCount(); ++i) {
                    this.staging.setColumns((String)columnsModel.getValueAt(i, 0));
                }
            } else {
                this.staging.clear();
            }
            this.staging.setCommentInRDBMS(this.taComments.getText());
        }
    }

    private class DefineColumnNamesListener
    implements ActionListener {
        private DefineColumnNamesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsModel columnsModel = (ColumnsModel)StagingTablePropertyDialogUDBv81.this.columnsTable.getModel();
            if (StagingTablePropertyDialogUDBv81.this.chbDefineColumnNames.isSelected()) {
                if (StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().size() > 0) {
                    for (int i = 0; i < StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().size(); ++i) {
                        columnsModel.addRow(new Object[]{StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().elementAt(i)});
                    }
                } else {
                    for (int i = 0; i < StagingTablePropertyDialogUDBv81.this.staging.getTableColumnNames().size(); ++i) {
                        columnsModel.addRow(new Object[]{StagingTablePropertyDialogUDBv81.this.staging.getTableColumnNames().get(i)});
                    }
                }
            } else {
                int n = columnsModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    columnsModel.removeRow(0);
                }
            }
        }
    }

    class ColumnsModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("StagingTablePropertyDialogUDBv81.ColumnNames")};

        ColumnsModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class ColumnsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ColumnsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setCellRenderer(new ColumnsCellRenderer());
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }
    }
}

