/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    protected SequenceUDBv81 sequence;
    protected JComboBox cbScheme;
    protected JComboBox cbDataType;
    protected JComboBox cbCycle;
    protected JComboBox cbOrder;
    protected JComboBox cbUsedByPublic;
    protected JIntegerField ifStartWith;
    protected JIntegerField ifIncrementBy;
    protected JIntegerField ifMinValue;
    protected JIntegerField ifMaxValue;
    protected JTextField tfOwner;
    protected JTextField ifCache;
    private static final int SEQ_VALUE_MAX_DIGITS_UDB = 19;

    public SequencePropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.sequence = (SequenceUDBv81)storageObject;
        this.setHeight(450);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogUDBv81.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initScheme();
        this.initOwner();
        this.initDataType();
        this.initStartWith();
        this.initIncrementBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        this.initUsedByPublic();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    protected void initDataType() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.DataType"));
        this.general.add(jLabel);
        this.cbDataType = new JComboBox<String>(SequenceUDB.DATA_TYPES);
        this.setBG(this.cbDataType);
        this.cbDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDataType, 110);
    }

    protected void initStartWith() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.StartWith"));
        this.general.add(jLabel);
        this.ifStartWith = new JIntegerField(0, 26);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifStartWith, 140);
    }

    protected void initIncrementBy() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.IncrementBy"));
        this.general.add(jLabel);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.ifIncrementBy, 170);
    }

    protected void initMinValue() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.MinValue"));
        this.general.add(jLabel);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifMinValue, 200);
    }

    protected void initMaxValue() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.MaxValue"));
        this.general.add(jLabel);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifMaxValue, 230);
    }

    protected void initCycle() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Cycle"));
        this.general.add(jLabel);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCycle, 260);
    }

    protected void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Cache"));
        this.general.add(jLabel);
        this.ifCache = new JTextField("", 26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.ifCache, 290);
    }

    protected void initOrder() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.Order"));
        this.general.add(jLabel);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrder);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbOrder, 320);
    }

    protected void initUsedByPublic() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogUDBv81.UsedByPublic"));
        this.general.add(jLabel);
        this.cbUsedByPublic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUsedByPublic);
        this.cbUsedByPublic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUsedByPublic);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbUsedByPublic, 350);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("SequencePropertyDialogUDBv81.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(((StorageDesignUDBv81)SequencePropertyDialogUDBv81.this.getStorageDesign()).getSequenceSet().getElementsList());
                arrayList.remove(SequencePropertyDialogUDBv81.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogUDBv81.this.getAppView(), SequencePropertyDialogUDBv81.this.sequence, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 390);
    }

    @Override
    public void initProperties() {
        double d;
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.cbScheme.setSelectedItem(this.sequence.getSchema());
        this.cbDataType.setSelectedItem(this.sequence.getDatatype());
        this.ifStartWith.setValue((long)this.sequence.getStartWith());
        this.ifIncrementBy.setValue((long)this.sequence.getIncrementBy());
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMinValue())) {
                d = Double.parseDouble(this.sequence.getMinValue());
            }
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifMinValue.setText("");
        }
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMaxValue())) {
                d = Double.parseDouble(this.sequence.getMaxValue());
            }
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifMaxValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogUDBv81.translateYesNoForDisplay(this.sequence.getCycle()));
        if (this.sequence.getCache() == 0) {
            this.ifCache.setText(NO);
        } else {
            this.ifCache.setText(Integer.toString(this.sequence.getCache()));
        }
        this.cbOrder.setSelectedItem(SequencePropertyDialogUDBv81.translateYesNoForDisplay(this.sequence.getOrder()));
        this.cbUsedByPublic.setSelectedItem(SequencePropertyDialogUDBv81.translateYesNoForDisplay(this.sequence.getUsedByPublic()));
        this.getCommentsList().setText(this.sequence.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            double d;
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDBv81) {
                this.sequence.setOwner(((SchemaUDBv81)object).getOwner());
                this.sequence.setSchema((SchemaUDBv81)object);
            } else {
                this.sequence.setOwner(null);
                this.sequence.setSchema(null);
            }
            this.sequence.setName(this.tfName.getText());
            this.sequence.setDatatype((String)this.cbDataType.getSelectedItem());
            this.sequence.setStartWith(this.ifStartWith.getIntValue());
            this.sequence.setIncrementBy(this.ifIncrementBy.getIntValue());
            try {
                if (!"NO".equalsIgnoreCase(this.ifMinValue.getText())) {
                    d = Double.parseDouble(this.ifMinValue.getText());
                }
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setMinValue("");
            }
            try {
                if (!"NO".equalsIgnoreCase(this.ifMaxValue.getText())) {
                    d = Double.parseDouble(this.ifMaxValue.getText());
                }
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setMaxValue("");
            }
            this.sequence.setCycle(SequencePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
            this.sequence.setOrder(SequencePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            String string = this.ifCache.getText();
            if (string.equalsIgnoreCase(NO)) {
                this.sequence.setCache(0);
            } else {
                try {
                    this.sequence.setCache(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sequence.setCache(0);
                }
            }
            this.sequence.setUsedByPublic(SequencePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbUsedByPublic.getSelectedItem()));
            this.sequence.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbScheme.getSelectedItem();
        if (object instanceof SchemaUDB) {
            string = ((SchemaUDB)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)SequencePropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDBv81 != null) {
                    SequencePropertyDialogUDBv81.this.tfOwner.setText(schemaUDBv81.getOwner().toString());
                } else {
                    SequencePropertyDialogUDBv81.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException nullPointerException) {
                SequencePropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }
}

