/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.IndexPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SchemaPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private SchemaUDBv81 schema;
    private JComboBox cbOwner;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;

    public SchemaPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.schema = (SchemaUDBv81)storageObject;
        this.setHeight(130);
        this.initCommentsView(30);
        this.initCommentsInRDBMS(30);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertyDialogUDBv81.SchemaProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    @Override
    protected void addTabs() {
        this.initTablesView();
        this.initViewsView();
        this.initIndexesView();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(jScrollPane);
        this.setObjectConstraints(this.getViewLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDBv81.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.indexList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(jScrollPane);
        this.setObjectConstraints(this.getIndexLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.schema.getName());
        this.tfName.setText(this.schema.getName());
        this.cbOwner.setSelectedItem(this.schema.getOwner());
        Object[] objectArray = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((TableProxyUDBv81)objectArray[i]).getSchema() != this.schema) continue;
            this.tableListModel.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((TableViewProxyUDBv81)objectArray2[i]).getSchema() != this.schema) continue;
            this.viewListModel.addElement(objectArray2[i]);
        }
        Object[] objectArray3 = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            if (((IndexProxyUDBv81)objectArray3[i]).getSchema() != this.schema) continue;
            this.indexListModel.addElement(objectArray3[i]);
        }
        this.getCommentsList().insert(this.schema.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.schema.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.schema != null) {
            this.schema.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof OwnerUDBv81) {
                this.schema.setOwner((OwnerUDBv81)object);
            } else {
                this.schema.setOwner(null);
            }
            this.schema.setComment(this.getCommentsList().getText());
            this.schema.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyUDBv81 indexProxyUDBv81;
            if (mouseEvent.getClickCount() == 2 && (indexProxyUDBv81 = (IndexProxyUDBv81)SchemaPropertyDialogUDBv81.this.indexList.getSelectedValue()) != null && !indexProxyUDBv81.isDialogVisible()) {
                IndexPropertyDialogUDBv81 indexPropertyDialogUDBv81 = new IndexPropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), indexProxyUDBv81);
                indexPropertyDialogUDBv81.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableViewProxyUDBv81 tableViewProxyUDBv81;
            if (mouseEvent.getClickCount() == 2 && (tableViewProxyUDBv81 = (TableViewProxyUDBv81)SchemaPropertyDialogUDBv81.this.viewList.getSelectedValue()) != null && !tableViewProxyUDBv81.isDialogVisible()) {
                TableViewPropertyDialogUDBv81 tableViewPropertyDialogUDBv81 = new TableViewPropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), tableViewProxyUDBv81);
                tableViewPropertyDialogUDBv81.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyUDBv81 tableProxyUDBv81;
            if (mouseEvent.getClickCount() == 2 && (tableProxyUDBv81 = (TableProxyUDBv81)SchemaPropertyDialogUDBv81.this.tableList.getSelectedValue()) != null && !tableProxyUDBv81.isDialogVisible()) {
                TablePropertyDialogUDBv81 tablePropertyDialogUDBv81 = new TablePropertyDialogUDBv81(SchemaPropertyDialogUDBv81.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDBv81.this.getStorageDesign(), tableProxyUDBv81);
                tablePropertyDialogUDBv81.show();
            }
        }
    }
}

