/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StoredProcedureUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserAndGroupPermissionsDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SchemaPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SequencePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TriggerPropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OwnerPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private static final long serialVersionUID = 3281813884019124244L;
    private OwnerUDBv81 owner;
    private JPanel schemas;
    private DefaultListModel schemaListModel;
    private JList schemaList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JPanel sequences;
    private DefaultListModel seqListModel;
    private JList seqList;
    private JButton bnPermissions;
    private UserAndGroupPermissionsDialogUDB dialog;

    public OwnerPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.owner = (OwnerUDBv81)storageObject;
        this.setHeight(150);
        this.initCommentsView(80);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("OwnerPropertyDialogUDBv81.OwnerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPermissionsButton();
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("OwnerPropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 75);
    }

    @Override
    protected void addTabs() {
        this.initSchemasView();
        this.initTablesView();
        this.initTriggersView();
        this.initViewsView();
        this.initStoredProceduresView();
        this.initSequencesView();
    }

    private void initSchemasView() {
        this.schemas = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Schemas"), this.schemas);
        this.initSchemas();
    }

    private void initSchemas() {
        this.schemaListModel = new DefaultListModel();
        this.schemaList = new JList(this.schemaListModel);
        this.schemaList.addMouseListener(new SchemaListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.schemaList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.schemas.add(jScrollPane);
        this.setObjectConstraints(this.getSchemaLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSchemaLayout() {
        return (SpringLayout)this.schemas.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.triggerList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(jScrollPane);
        this.setObjectConstraints(this.getTriggerLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(jScrollPane);
        this.setObjectConstraints(this.getViewLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initStoredProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.StoredProcedures"), this.procedures);
        this.initProcedures();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProcListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.procList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(jScrollPane);
        this.setObjectConstraints(this.getProcedureLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getProcedureLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    private void initSequencesView() {
        this.sequences = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Sequences"), this.sequences);
        this.initSequences();
    }

    private void initSequences() {
        this.seqListModel = new DefaultListModel();
        this.seqList = new JList(this.seqListModel);
        this.seqList.addMouseListener(new SequencesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.seqList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.sequences.add(jScrollPane);
        this.setObjectConstraints(this.getSequencesLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSequencesLayout() {
        return (SpringLayout)this.sequences.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.owner.getName());
        this.tfName.setText(this.owner.getName());
        this.getCommentsList().insert(this.owner.getComment(), 0);
        if (this.owner.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] objectArray = this.getStorageDesign().getSchemaSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((SchemaUDBv81)objectArray[i]).getOwner() != this.owner) continue;
            this.schemaListModel.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableProxySet().toArray();
        TableProxyUDBv81 tableProxyUDBv81 = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            tableProxyUDBv81 = (TableProxyUDBv81)objectArray2[i];
            if (tableProxyUDBv81.getOwner() != this.owner && (tableProxyUDBv81.getSchema() == null || tableProxyUDBv81.getSchema().getOwner() != this.owner)) continue;
            this.tableListModel.addElement(objectArray2[i]);
        }
        Object[] objectArray3 = this.getStorageDesign().getTriggerSet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            if (((TriggerUDBv81)objectArray3[i]).getOwner() != this.owner) continue;
            this.triggerListModel.addElement(objectArray3[i]);
        }
        Object[] objectArray4 = this.getStorageDesign().getTableViewProxySet().toArray();
        TableViewProxyUDBv81 tableViewProxyUDBv81 = null;
        for (int i = 0; i < objectArray4.length; ++i) {
            tableViewProxyUDBv81 = (TableViewProxyUDBv81)objectArray4[i];
            if (tableViewProxyUDBv81.getOwner() != this.owner && (tableViewProxyUDBv81.getSchema() == null || tableViewProxyUDBv81.getSchema().getOwner() != this.owner)) continue;
            this.viewListModel.addElement(objectArray4[i]);
        }
        Object[] objectArray5 = this.getStorageDesign().getStoredProcedureSet().toArray();
        for (int i = 0; i < objectArray5.length; ++i) {
            if (((StoredProcedureUDBv81)objectArray5[i]).getOwner() != this.owner) continue;
            this.procListModel.addElement(objectArray5[i]);
        }
        Object[] objectArray6 = ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet().toArray();
        for (int i = 0; i < objectArray6.length; ++i) {
            if (((SequenceUDBv81)objectArray6[i]).getOwner() != this.owner) continue;
            this.seqListModel.addElement(objectArray6[i]);
        }
    }

    @Override
    protected void setProperties() {
        if (this.owner != null && !this.owner.isNullInstance()) {
            String string = this.owner.getName();
            this.owner.setName(this.tfName.getText());
            this.owner.setComment(this.getCommentsList().getText());
            if (!this.tfName.getText().equals(string)) {
                this.owner.setNameChanged(true);
            }
        }
    }

    private class SequencesListMouseListener
    extends MouseAdapter {
        private SequencesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SequenceUDBv81 sequenceUDBv81;
            if (mouseEvent.getClickCount() == 2 && (sequenceUDBv81 = (SequenceUDBv81)OwnerPropertyDialogUDBv81.this.seqList.getSelectedValue()) != null && !sequenceUDBv81.isDialogVisible()) {
                SequencePropertyDialogUDBv81 sequencePropertyDialogUDBv81 = new SequencePropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), sequenceUDBv81);
                sequencePropertyDialogUDBv81.show();
            }
        }
    }

    private class ProcListMouseListener
    extends MouseAdapter {
        private ProcListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StoredProcedureUDBv81 storedProcedureUDBv81;
            if (mouseEvent.getClickCount() == 2 && (storedProcedureUDBv81 = (StoredProcedureUDBv81)OwnerPropertyDialogUDBv81.this.procList.getSelectedValue()) != null && !storedProcedureUDBv81.isDialogVisible()) {
                StoredProcedurePropertyDialogUDB storedProcedurePropertyDialogUDB = new StoredProcedurePropertyDialogUDB(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), storedProcedureUDBv81);
                storedProcedurePropertyDialogUDB.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableViewProxyUDBv81 tableViewProxyUDBv81;
            if (mouseEvent.getClickCount() == 2 && (tableViewProxyUDBv81 = (TableViewProxyUDBv81)OwnerPropertyDialogUDBv81.this.viewList.getSelectedValue()) != null && !tableViewProxyUDBv81.isDialogVisible()) {
                TableViewPropertyDialogUDBv81 tableViewPropertyDialogUDBv81 = new TableViewPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), tableViewProxyUDBv81);
                tableViewPropertyDialogUDBv81.show();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TriggerUDBv81 triggerUDBv81;
            if (mouseEvent.getClickCount() == 2 && (triggerUDBv81 = (TriggerUDBv81)OwnerPropertyDialogUDBv81.this.triggerList.getSelectedValue()) != null && !triggerUDBv81.isDialogVisible()) {
                TriggerPropertyDialogUDBv81 triggerPropertyDialogUDBv81 = new TriggerPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), triggerUDBv81);
                triggerPropertyDialogUDBv81.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyUDBv81 tableProxyUDBv81;
            if (mouseEvent.getClickCount() == 2 && (tableProxyUDBv81 = (TableProxyUDBv81)OwnerPropertyDialogUDBv81.this.tableList.getSelectedValue()) != null && !tableProxyUDBv81.isDialogVisible()) {
                TablePropertyDialogUDBv81 tablePropertyDialogUDBv81 = new TablePropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), tableProxyUDBv81);
                tablePropertyDialogUDBv81.show();
            }
        }
    }

    private class SchemaListMouseListener
    extends MouseAdapter {
        private SchemaListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SchemaUDBv81 schemaUDBv81;
            if (mouseEvent.getClickCount() == 2 && (schemaUDBv81 = (SchemaUDBv81)OwnerPropertyDialogUDBv81.this.schemaList.getSelectedValue()) != null && !schemaUDBv81.isDialogVisible()) {
                SchemaPropertyDialogUDBv81 schemaPropertyDialogUDBv81 = new SchemaPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), schemaUDBv81);
                schemaPropertyDialogUDBv81.show();
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OwnerPropertyDialogUDBv81.this.dialog == null) {
                OwnerPropertyDialogUDBv81.this.dialog = new UserAndGroupPermissionsDialogUDB(OwnerPropertyDialogUDBv81.this.getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), OwnerPropertyDialogUDBv81.this.owner);
            }
            OwnerPropertyDialogUDBv81.this.dialog.showDialog();
        }
    }
}

