/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DatabasePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private DataBaseUDBv81 database;
    private JTextField tfOnPath;
    private JTextField tfAlias;
    private JTextField tfCodeSet;
    private JTextField tfTerritory;
    private JComboBox cbCollatingSeq;
    private JIntegerField ifNumSegs;
    private JIntegerField ifDefExtentSize;
    private JComboBox cbCatalogTS;
    private JComboBox cbUserTS;
    private JComboBox cbTempTS;
    protected JPanel autoConfigurePanel;
    protected JCheckBox chbUseAutoConfigure;
    protected JComboBox cbApplyChanges;
    private JTable table;
    private OptionsTableModel model;

    public DatabasePropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.database = (DataBaseUDBv81)storageObject;
        this.setHeight(380);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DatabasePropertyDialogUDBv81.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOnPath();
        this.initAlias();
        this.initCodeSet();
        this.initTerritory();
        this.initCollatingSeq();
        this.initNumSegs();
        this.initDiffExtentSize();
        this.initCatalogTableSpace();
        this.initUserTableSpace();
        this.initTempTableSpace();
    }

    @Override
    protected void addTabs() {
        this.initAutoConfigureView();
    }

    protected void initAutoConfigureView() {
        this.autoConfigurePanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigure"), this.autoConfigurePanel);
        this.initAutoConfigure();
    }

    private void initAutoConfigure() {
        this.initUseAutoConfigure();
        this.initApplyChanges();
        this.initTable();
    }

    private void initUseAutoConfigure() {
        this.chbUseAutoConfigure = new JCheckBox(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigure"));
        this.chbUseAutoConfigure.addActionListener(new UseAutoConfigureListener());
        this.autoConfigurePanel.add(this.chbUseAutoConfigure);
        this.setObjectConstraints(this.getAutoConfigureLayout(), this.chbUseAutoConfigure, 5, 12);
    }

    private void initApplyChanges() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.ApplyChanges"));
        this.autoConfigurePanel.add(jLabel);
        this.cbApplyChanges = new JComboBox<String>(DataBaseUDBv81.getApplyChangesChoices());
        this.setBG(this.cbApplyChanges);
        this.cbApplyChanges.setPreferredSize(this.tfName.getPreferredSize());
        this.autoConfigurePanel.add(this.cbApplyChanges);
        this.setLabelConstraints(this.getAutoConfigureLayout(), jLabel, 50);
        this.setObjectConstraints(this.getAutoConfigureLayout(), this.cbApplyChanges, 50);
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.AutoConfigureOptions"));
        this.autoConfigurePanel.add(jLabel);
        this.setLabelConstraints(this.getAutoConfigureLayout(), jLabel, 100);
        this.table = new OptionsTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(392, 144));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.model = (OptionsTableModel)this.table.getModel();
        this.setBG(this.table);
        this.autoConfigurePanel.add(jScrollPane);
        this.setObjectConstraints(this.getAutoConfigureLayout(), jScrollPane, 10, 120);
    }

    protected SpringLayout getAutoConfigureLayout() {
        return (SpringLayout)this.autoConfigurePanel.getLayout();
    }

    private void initOnPath() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.OnPath"));
        this.general.add(jLabel);
        this.tfOnPath = new JTextField("", 26);
        this.general.add(this.tfOnPath);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfOnPath, 50);
    }

    private void initAlias() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.Alias"));
        this.general.add(jLabel);
        this.tfAlias = new JTextField("", 26);
        this.general.add(this.tfAlias);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfAlias, 80);
    }

    private void initCodeSet() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CodeSet"));
        this.general.add(jLabel);
        this.tfCodeSet = new JTextField("", 26);
        this.general.add(this.tfCodeSet);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfCodeSet, 110);
    }

    private void initTerritory() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.Territory"));
        this.general.add(jLabel);
        this.tfTerritory = new JTextField("", 26);
        this.general.add(this.tfTerritory);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfTerritory, 140);
    }

    private void initCollatingSeq() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CollatingSequence"));
        this.general.add(jLabel);
        this.cbCollatingSeq = new JComboBox<String>(DataBaseUDBv81.getCollatingSequencesChoices());
        this.setBG(this.cbCollatingSeq);
        this.cbCollatingSeq.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCollatingSeq);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCollatingSeq, 170);
    }

    private void initNumSegs() {
        JLabel jLabel = new JLabel("NUMSEGS:");
        this.general.add(jLabel);
        this.ifNumSegs = new JIntegerField(0, 26);
        this.general.add(this.ifNumSegs);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifNumSegs, 200);
    }

    private void initDiffExtentSize() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.DftExtentSize"));
        this.general.add(jLabel);
        this.ifDefExtentSize = new JIntegerField(0, 26);
        this.general.add(this.ifDefExtentSize);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifDefExtentSize, 230);
    }

    private void initCatalogTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.CtlgTableSpace"));
        this.general.add(jLabel);
        this.cbCatalogTS = new JComboBox();
        this.setBG(this.cbCatalogTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbCatalogTS);
        }
        this.cbCatalogTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCatalogTS);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCatalogTS, 260);
    }

    private void initUserTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.UserTableSpace"));
        this.general.add(jLabel);
        this.cbUserTS = new JComboBox();
        this.setBG(this.cbUserTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbUserTS);
        }
        this.cbUserTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUserTS);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbUserTS, 290);
    }

    private void initTempTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("DatabasePropertyDialogUDBv81.TempTableSpace"));
        this.general.add(jLabel);
        this.cbTempTS = new JComboBox();
        this.setBG(this.cbTempTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTempTS);
        }
        this.cbTempTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTempTS);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbTempTS, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.tfOnPath.setText(this.database.getOnPath());
        this.tfAlias.setText(this.database.getAlias());
        this.tfCodeSet.setText(this.database.getCodeSet());
        this.tfTerritory.setText(this.database.getTerritory());
        this.cbCollatingSeq.setSelectedItem(this.database.getCollatingSequence());
        this.ifNumSegs.setValue((long)this.database.getSegmentNumber());
        this.ifDefExtentSize.setValue((long)this.database.getDefaultExtentSize());
        this.cbCatalogTS.setSelectedItem(this.database.getCatalogTableSpace());
        this.cbUserTS.setSelectedItem(this.database.getUserTableSpace());
        this.cbTempTS.setSelectedItem(this.database.getTemporaryTableSpace());
        this.chbUseAutoConfigure.setSelected(this.database.getAutoConfigure());
        this.cbApplyChanges.setSelectedItem(this.database.getApplyChanges());
        if (this.database.getAutoConfigure()) {
            if (this.table.getRowCount() == 0) {
                this.model.addRow(new Object[]{this.database.getUseMemPercent(), "mem_percent", "" + this.database.getMemPercent()});
                this.model.addRow(new Object[]{this.database.getUseWorkloadType(), "workload_type", this.database.getWorkloadType()});
                this.model.addRow(new Object[]{this.database.getUseNumStmts(), "num_stmts", "" + this.database.getNumStmts()});
                this.model.addRow(new Object[]{this.database.getUseTpm(), "tpm", "" + this.database.getTpm()});
                this.model.addRow(new Object[]{this.database.getUseAdminProperty(), "admin_property", this.database.getAdminProperty()});
                this.model.addRow(new Object[]{this.database.getUseNumLocalApps(), "num_local_apps", "" + this.database.getNumLocalApps()});
                this.model.addRow(new Object[]{this.database.getUseNumRemoteApps(), "num_remote_apps", "" + this.database.getNumRemoteApps()});
                this.model.addRow(new Object[]{this.database.getUseIsolation(), "isolation", this.database.getIsolation()});
                this.model.addRow(new Object[]{this.database.getUseBpResizeable(), "bp_resizeable", DatabasePropertyDialogUDBv81.translateYesNoForDisplay(this.database.getBpResizeable())});
            } else {
                Boolean bl = this.database.getUseMemPercent();
                this.model.setValueAt(bl, 0, 0);
                this.model.setValueAt(new Integer(this.database.getMemPercent()), 0, 2);
                bl = this.database.getUseWorkloadType();
                this.model.setValueAt(bl, 1, 0);
                this.model.setValueAt(this.database.getWorkloadType(), 1, 2);
                bl = this.database.getUseNumStmts();
                this.model.setValueAt(bl, 2, 0);
                this.model.setValueAt(new Integer(this.database.getNumStmts()), 2, 2);
                bl = this.database.getUseTpm();
                this.model.setValueAt(bl, 3, 0);
                this.model.setValueAt(new Integer(this.database.getTpm()), 3, 2);
                bl = this.database.getUseAdminProperty();
                this.model.setValueAt(bl, 4, 0);
                this.model.setValueAt(this.database.getAdminProperty(), 4, 2);
                bl = this.database.getUseNumLocalApps();
                this.model.setValueAt(bl, 5, 0);
                this.model.setValueAt(new Integer(this.database.getNumLocalApps()), 5, 2);
                bl = this.database.getUseNumRemoteApps();
                this.model.setValueAt(bl, 6, 0);
                this.model.setValueAt(new Integer(this.database.getNumRemoteApps()), 6, 2);
                bl = this.database.getUseIsolation();
                this.model.setValueAt(bl, 7, 0);
                this.model.setValueAt(this.database.getIsolation(), 7, 2);
                bl = this.database.getUseBpResizeable();
                this.model.setValueAt(bl, 8, 0);
                this.model.setValueAt(DatabasePropertyDialogUDBv81.translateYesNoForDisplay(this.database.getBpResizeable()), 8, 2);
            }
        }
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setOnPath(this.tfOnPath.getText());
            this.database.setAlias(this.tfAlias.getText());
            this.database.setCodeSet(this.tfCodeSet.getText());
            this.database.setTerritory(this.tfTerritory.getText());
            this.database.setCollatingSequence((String)this.cbCollatingSeq.getSelectedItem());
            this.database.setSegmentNumber(this.ifNumSegs.getIntValue());
            this.database.setDefaultExtentSize(this.ifDefExtentSize.getIntValue());
            Object object = this.cbCatalogTS.getSelectedItem();
            if (object instanceof TableSpaceUDBv81) {
                this.database.setCatalogTableSpace((TableSpaceUDBv81)object);
            } else {
                this.database.setCatalogTableSpace(null);
            }
            object = this.cbUserTS.getSelectedItem();
            if (object instanceof TableSpaceUDBv81) {
                this.database.setUserTableSpace((TableSpaceUDBv81)object);
            } else {
                this.database.setUserTableSpace(null);
            }
            object = this.cbTempTS.getSelectedItem();
            if (object instanceof TableSpaceUDBv81) {
                this.database.setTemporaryTableSpace((TableSpaceUDBv81)object);
            } else {
                this.database.setTemporaryTableSpace(null);
            }
            this.database.setAutoConfigure(this.chbUseAutoConfigure.isSelected());
            this.database.setApplyChanges((String)this.cbApplyChanges.getSelectedItem());
            if (this.chbUseAutoConfigure.isSelected()) {
                object = this.model.getValueAt(0, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setMemPercent(Integer.parseInt(((String)this.model.getValueAt(0, 2)).trim()));
                        this.database.setUseMemPercent(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseMemPercent(false);
                }
                object = this.model.getValueAt(1, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setWorkloadType((String)this.model.getValueAt(1, 2));
                        this.database.setUseWorkloadType(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseWorkloadType(false);
                }
                object = this.model.getValueAt(2, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumStmts(Integer.parseInt(((String)this.model.getValueAt(2, 2)).trim()));
                        this.database.setUseNumStmts(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumStmts(false);
                }
                object = this.model.getValueAt(3, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setTpm(Integer.parseInt(((String)this.model.getValueAt(3, 2)).trim()));
                        this.database.setUseTpm(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseTpm(false);
                }
                object = this.model.getValueAt(4, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setAdminProperty((String)this.model.getValueAt(4, 2));
                        this.database.setUseAdminProperty(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseAdminProperty(false);
                }
                object = this.model.getValueAt(5, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumLocalApps(Integer.parseInt(((String)this.model.getValueAt(5, 2)).trim()));
                        this.database.setUseNumLocalApps(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumLocalApps(false);
                }
                object = this.model.getValueAt(6, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setNumRemoteApps(Integer.parseInt(((String)this.model.getValueAt(6, 2)).trim()));
                        this.database.setUseNumRemoteApps(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseNumRemoteApps(false);
                }
                object = this.model.getValueAt(7, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setIsolation((String)this.model.getValueAt(7, 2));
                        this.database.setUseIsolation(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseIsolation(false);
                }
                object = this.model.getValueAt(8, 0);
                if (object.equals(Boolean.TRUE)) {
                    try {
                        this.database.setBpResizeable(DatabasePropertyDialogUDBv81.translateYesNoForStorage((String)this.model.getValueAt(8, 2)));
                        this.database.setUseBpResizeable(true);
                    }
                    catch (ClassCastException classCastException) {}
                } else {
                    this.database.setUseBpResizeable(false);
                }
            } else {
                this.database.setUseMemPercent(false);
                this.database.setUseWorkloadType(false);
                this.database.setUseNumStmts(false);
                this.database.setUseTpm(false);
                this.database.setUseAdminProperty(false);
                this.database.setUseNumLocalApps(false);
                this.database.setUseNumRemoteApps(false);
                this.database.setUseIsolation(false);
                this.database.setUseBpResizeable(false);
            }
            this.database.setComment(this.getCommentsList().getText());
        }
    }

    class CheckBoxCellEditor
    extends DefaultCellEditor {
        JCheckBox chBox;

        CheckBoxCellEditor() {
            super(new JCheckBox());
            this.chBox = (JCheckBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.chBox.setSelected((Boolean)object);
            this.chBox.setHorizontalAlignment(0);
            return this.chBox;
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField tfield;

        TextCellEditor() {
            super(new JTextField());
            this.tfield = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tfield.setText(object == null ? "" : "" + object.toString());
            return this.tfield;
        }
    }

    class BPResizeableCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        BPResizeableCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(AbstractPropertyDialog.YES_NO));
            return this.cbox;
        }
    }

    class IsolationCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        IsolationCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getIsolationChoices()));
            return this.cbox;
        }
    }

    class AdminPriorityCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        AdminPriorityCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getAdminPropertyChoices()));
            return this.cbox;
        }
    }

    class WorkloadTypeCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        WorkloadTypeCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cbox.setModel(new DefaultComboBoxModel<String>(DataBaseUDBv81.getWorkloadTypeChoices()));
            return this.cbox;
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class OptionsTable
    extends JTable {
        OptionsTableModel dataModel;

        public OptionsTable() {
            this.dataModel = new OptionsTableModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(150);
                    continue;
                }
                tableColumn.setPreferredWidth(220);
            }
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new CheckBoxTableCellRenderer();
            }
            if (n2 == 1 || n2 == 2) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(n, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return new CheckBoxCellEditor();
            }
            if (n2 == 2) {
                if (n == 1) {
                    return new WorkloadTypeCellEditor();
                }
                if (n == 4) {
                    return new AdminPriorityCellEditor();
                }
                if (n == 7) {
                    return new IsolationCellEditor();
                }
                if (n == 8) {
                    return new BPResizeableCellEditor();
                }
                return new TextCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class OptionsTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("DatabasePropertyDialogUDBv81.Use"), Messages.getString("DatabasePropertyDialogUDBv81.Keyword"), Messages.getString("DatabasePropertyDialogUDBv81.Value")};

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 2;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = DatabasePropertyDialogUDBv81.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }
    }

    private class UseAutoConfigureListener
    implements ActionListener {
        private UseAutoConfigureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabasePropertyDialogUDBv81.this.cbApplyChanges.setEnabled(DatabasePropertyDialogUDBv81.this.chbUseAutoConfigure.isSelected());
            if (DatabasePropertyDialogUDBv81.this.chbUseAutoConfigure.isSelected()) {
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseMemPercent(), "mem_percent", "" + DatabasePropertyDialogUDBv81.this.database.getMemPercent()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseWorkloadType(), "workload_type", DatabasePropertyDialogUDBv81.this.database.getWorkloadType()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumStmts(), "num_stmts", "" + DatabasePropertyDialogUDBv81.this.database.getNumStmts()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseTpm(), "tpm", "" + DatabasePropertyDialogUDBv81.this.database.getTpm()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseAdminProperty(), "admin_property", DatabasePropertyDialogUDBv81.this.database.getAdminProperty()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumLocalApps(), "num_local_apps", "" + DatabasePropertyDialogUDBv81.this.database.getNumLocalApps()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseNumRemoteApps(), "num_remote_apps", "" + DatabasePropertyDialogUDBv81.this.database.getNumRemoteApps()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseIsolation(), "isolation", DatabasePropertyDialogUDBv81.this.database.getIsolation()});
                DatabasePropertyDialogUDBv81.this.model.addRow(new Object[]{DatabasePropertyDialogUDBv81.this.database.getUseBpResizeable(), "bp_resizeable", AbstractPropertyDialog.translateYesNoForDisplay(DatabasePropertyDialogUDBv81.this.database.getBpResizeable())});
            } else {
                int n = DatabasePropertyDialogUDBv81.this.model.getRowCount();
                for (int i = 0; i < n; ++i) {
                    DatabasePropertyDialogUDBv81.this.model.removeRow(0);
                }
            }
        }
    }
}

