/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DBPartitionGroupPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private DBPartitionGroupUDBv81 group;
    private JComboBox cbScope;
    private JTextField tfNodeNumbers;

    public DBPartitionGroupPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.group = (DBPartitionGroupUDBv81)storageObject;
        this.setHeight(140);
        this.initCommentsView(35);
        this.initCommentsInRDBMS(35);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DBPartitionGroupPropertyDialogUDBv81.DatabasePartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initScope();
        this.initNodeNumbers();
    }

    private void initScope() {
        JLabel jLabel = new JLabel(Messages.getString("DBPartitionGroupPropertyDialogUDBv81.Scope"));
        this.general.add(jLabel);
        this.cbScope = new JComboBox<String>(DBPartitionGroupUDBv81.getAvailableScopes());
        this.cbScope.addActionListener(new ScopeListener());
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScope);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScope, 50);
    }

    private void initNodeNumbers() {
        JLabel jLabel = new JLabel(Messages.getString("DBPartitionGroupPropertyDialogUDBv81.PartitionNumbers"));
        this.general.add(jLabel);
        this.tfNodeNumbers = new JTextField("", 26);
        this.general.add(this.tfNodeNumbers);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfNodeNumbers, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.group.getName());
        this.tfName.setText(this.group.getName());
        this.cbScope.setSelectedItem(this.group.getScope());
        this.tfNodeNumbers.setText(this.group.getNodeNumbers());
        if (this.group.getScope().equalsIgnoreCase("ON SOME DBPARTITIONNUMS")) {
            this.tfNodeNumbers.setEnabled(true);
        } else {
            this.tfNodeNumbers.setEnabled(false);
        }
        if (this.group.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbScope.setEnabled(false);
            this.tfNodeNumbers.setEditable(false);
            this.getCommentsList().setEditable(false);
            this.getCommentsInRDBMSList().setEditable(false);
        }
        this.getCommentsList().insert(this.group.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.group.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.group != null && !this.group.isNullInstance()) {
            this.group.setName(this.tfName.getText());
            this.group.setScope((String)this.cbScope.getSelectedItem());
            this.group.setNodeNumbers(this.tfNodeNumbers.getText());
            this.group.setComment(this.getCommentsList().getText());
            this.group.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class ScopeListener
    implements ActionListener {
        private ScopeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)DBPartitionGroupPropertyDialogUDBv81.this.cbScope.getSelectedItem()).equalsIgnoreCase("ON SOME DBPARTITIONNUMS")) {
                DBPartitionGroupPropertyDialogUDBv81.this.tfNodeNumbers.setEnabled(true);
            } else {
                DBPartitionGroupPropertyDialogUDBv81.this.tfNodeNumbers.setEnabled(false);
            }
        }
    }
}

