/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserAndGroupPermissionsDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserGroupPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final long serialVersionUID = 6615266771638196302L;
    private UserGroupUDB group;
    private JButton bnPermissions;
    private UserAndGroupPermissionsDialogUDB dialog;

    public UserGroupPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.group = (UserGroupUDB)storageObject;
        this.setHeight(120);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UserGroupPropertyDialogUDB.UserGroupProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPermissionsButton();
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("UserGroupPropertyDialogUDB.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 60);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.group.getName());
        this.tfName.setText(this.group.getName());
        this.getCommentsList().setText(this.group.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.group != null) {
            this.group.setName(this.tfName.getText());
            this.group.setComment(this.getCommentsList().getText());
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (UserGroupPropertyDialogUDB.this.dialog == null) {
                UserGroupPropertyDialogUDB.this.dialog = new UserAndGroupPermissionsDialogUDB(UserGroupPropertyDialogUDB.this.getAppView(), UserGroupPropertyDialogUDB.this.getStorageDesign(), UserGroupPropertyDialogUDB.this.group);
            }
            UserGroupPropertyDialogUDB.this.dialog.showDialog();
        }
    }
}

