/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TriggerPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TriggerUDB trigger;
    private JComboBox cbScheme;
    private JComboBox cbAction;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JTextField tfOwner;
    private JTextField tfTable;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfOLD_TABLE_AS;
    private JTextField tfNEW_TABLE_AS;
    private JIntegerField ifOrder;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JTextArea bodyArea;

    public TriggerPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.trigger = (TriggerUDB)storageObject;
        this.setHeight(440);
        this.initCommentsView(170);
        this.initCommentsInRDBMS(170);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogUDB.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initOwner();
        this.initScheme();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initOLD_TABLE_AS();
        this.initNEW_TABLE_AS();
        this.initCondition();
        this.initOrder();
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDB.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.AllColumns"));
        this.panelColumns.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.SelectedColumns"));
        this.panelColumns.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogUDB.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 155);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogUDB.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 185);
        TriggerPropertyDialogUDB.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDB.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(jScrollPane);
        this.setObjectConstraints(this.getBodyLayout(), jScrollPane, 10, 12);
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEnabled(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initAction() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Action"));
        this.general.add(jLabel);
        this.cbAction = new JComboBox<String>(Trigger.ACTION_TYPES);
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAction.addActionListener(new ActivationListener());
        this.cbAction.addActionListener(new TriggeringTimeListener());
        this.cbAction.addActionListener(new ScopeListener());
        this.general.add(this.cbAction);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbAction, 140);
    }

    private void initTriggeringTime() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.TriggeringTime"));
        this.general.add(jLabel);
        this.cbTriggeringTime = new JComboBox<String>(TriggerUDB.TRIGGER_TIMES);
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTriggeringTime.addActionListener(new TriggeringTimeListener());
        this.cbTriggeringTime.addActionListener(new ScopeListener());
        this.cbTriggeringTime.addActionListener(new ActivationListener());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbTriggeringTime, 170);
    }

    private void initScope() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Scope"));
        this.general.add(jLabel);
        this.cbScope = new JComboBox<String>(TriggerUDB.SCOPE_TYPES);
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.cbScope.addActionListener(new ScopeListener());
        this.cbScope.addActionListener(new TriggeringTimeListener());
        this.cbScope.addActionListener(new ActivationListener());
        this.general.add(this.cbScope);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbScope, 200);
    }

    private void initRef_OLD_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.RefOLDAS"));
        this.general.add(jLabel);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfRef_OLD_AS, 230);
    }

    private void initRef_NEW_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.RefNEWAS"));
        this.general.add(jLabel);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfRef_NEW_AS, 260);
    }

    private void initOLD_TABLE_AS() {
        JLabel jLabel = new JLabel("OLD TABLE AS:");
        this.general.add(jLabel);
        this.tfOLD_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfOLD_TABLE_AS);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfOLD_TABLE_AS, 290);
    }

    private void initNEW_TABLE_AS() {
        JLabel jLabel = new JLabel("NEW TABLE AS:");
        this.general.add(jLabel);
        this.tfNEW_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfNEW_TABLE_AS);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.tfNEW_TABLE_AS, 320);
    }

    private void initCondition() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.Condition"));
        this.general.add(jLabel);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.tfCondition, 350);
    }

    private void initOrder() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogUDB.DefinitionOrder"));
        this.general.add(jLabel);
        this.ifOrder = new JIntegerField(0, 26);
        this.general.add(this.ifOrder);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.ifOrder, 380);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.tfTable.setText(this.trigger.getTable() != null ? this.trigger.getTable().getName() : "");
        this.selectObject(this.cbScheme, this.trigger.getSchema());
        this.cbAction.setSelectedItem(this.trigger.getActions());
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfOLD_TABLE_AS.setText(this.trigger.getOLD_TABLE_AS());
        this.tfNEW_TABLE_AS.setText(this.trigger.getNEW_TABLE_AS());
        this.tfCondition.setText(this.trigger.getCondition());
        this.ifOrder.setValue((long)this.trigger.getOrder());
        this.bodyArea.setText(this.trigger.getBody());
        if (this.trigger.getTable() != null) {
            ColumnProxy[] columnProxyArray = this.trigger.getTable().getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                ColumnProxy columnProxy = columnProxyArray[i];
                if (this.trigger.getColumnSet().contains(columnProxy.getName())) {
                    this.selectedColumnsModel.addElement(columnProxy);
                    continue;
                }
                this.allColumnsModel.addElement(columnProxy);
            }
        }
        this.getCommentsList().insert(this.trigger.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.trigger.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDB) {
                this.trigger.setSchema((SchemaUDB)object);
                this.trigger.setOwner(((SchemaUDB)object).getOwner());
            } else {
                this.trigger.setSchema(null);
                this.trigger.setOwner(null);
            }
            this.trigger.setName(this.tfName.getText());
            this.trigger.setActions((String)this.cbAction.getSelectedItem());
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setOLD_TABLE_AS(this.tfOLD_TABLE_AS.getText());
            this.trigger.setNEW_TABLE_AS(this.tfNEW_TABLE_AS.getText());
            this.trigger.setCondition(this.tfCondition.getText());
            try {
                this.trigger.setOrder(this.ifOrder.getIntValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.trigger.setOrder(0);
            }
            this.trigger.setBody(this.bodyArea.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof ColumnProxyUDB)) continue;
                this.trigger.setColumns(((ColumnProxyUDB)object2).getName());
            }
            this.trigger.setComment(this.getCommentsList().getText());
            this.trigger.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbScheme.getSelectedItem();
        if (object instanceof SchemaUDB) {
            string = ((SchemaUDB)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDB schemaUDB = (SchemaUDB)TriggerPropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDB != null) {
                    TriggerPropertyDialogUDB.this.tfOwner.setText(schemaUDB.getOwner().toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                TriggerPropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }

    public class TriggeringTimeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDB.this.cbTriggeringTime.getSelectedItem();
            if (string.equalsIgnoreCase(TriggerUDB.TRIGGER_TIMES[1])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.cbScope.setEnabled(true);
            } else {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.cbScope.setSelectedItem(TriggerUDB.SCOPE_TYPES[0]);
                TriggerPropertyDialogUDB.this.cbScope.setEnabled(false);
            }
        }
    }

    public class ScopeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDB.this.cbScope.getSelectedItem();
            if (string.equalsIgnoreCase(TriggerUDB.SCOPE_TYPES[1])) {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
            } else {
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
            }
        }
    }

    public class ActivationListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TriggerPropertyDialogUDB.this.cbAction.getSelectedItem();
            boolean bl = false;
            if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                bl = true;
            }
            TriggerPropertyDialogUDB.this.allColumnsList.setEnabled(bl);
            TriggerPropertyDialogUDB.this.selectedColumnsList.setEnabled(bl);
            if (!bl) {
                TriggerPropertyDialogUDB.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogUDB.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
            } else if (string.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(true);
            } else {
                TriggerPropertyDialogUDB.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDB.this.tfNEW_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDB.this.tfRef_NEW_AS.setEnabled(false);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDB.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDB.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDB.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogUDB.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogUDB.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogUDB.this.allColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogUDB.this.allColumnsModel.addElement(object);
                    TriggerPropertyDialogUDB.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDB.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDB.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDB.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogUDB.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogUDB.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogUDB.this.selectedColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogUDB.this.selectedColumnsModel.addElement(object);
                    TriggerPropertyDialogUDB.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

