/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TableViewPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TableViewProxyUDB view;
    private JComboBox cbSchema;
    private JComboBox cbCheckOption;
    private JComboBox cbCheckOptionScope;
    private JTextArea definitionArea;
    private String comment;
    private String commentInRDBMS;
    private JTextField tfOidColumnName;
    private JCheckBox chbOidColumnUniqueness;
    private JTextField tfSuperView;
    private JTextField tfOwner;
    private JButton bnPermissions;
    private PermissionsPropertyDialogUDB dialog;

    public TableViewPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.view = (TableViewProxyUDB)storageObject;
        this.setHeight(570);
        this.initCommentsView(245);
        this.initCommentsInRDBMS(245);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertyDialogUDB.ViewProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initSchema();
        this.initCheckOption();
        this.initCheckOptionScope();
        this.initOidColumnName();
        this.initOidColumnUniqueness();
        this.initSuperViewName();
        this.initDefinition();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfOwner, 50);
    }

    private void initSchema() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.Schema"));
        this.general.add(jLabel);
        this.cbSchema = new JComboBox();
        this.setBG(this.cbSchema);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbSchema);
        }
        this.cbSchema.addActionListener(new SchemeListener());
        this.cbSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchema);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbSchema, 80);
    }

    private void initCheckOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.CheckOption"));
        this.general.add(jLabel);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCheckOption, 110);
    }

    private void initCheckOptionScope() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.CheckScope"));
        this.general.add(jLabel);
        this.cbCheckOptionScope = new JComboBox<String>(TableViewProxyUDB.getAvailableCheckOptionScopes());
        this.setBG(this.cbCheckOptionScope);
        this.cbCheckOptionScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOptionScope);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbCheckOptionScope, 140);
    }

    private void initOidColumnName() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.OidColumnName"));
        this.general.add(jLabel);
        this.tfOidColumnName = new JTextField("", 26);
        this.general.add(this.tfOidColumnName);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfOidColumnName, 170);
    }

    private void initOidColumnUniqueness() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.OidUniqueness"));
        this.general.add(jLabel);
        this.chbOidColumnUniqueness = new JCheckBox("");
        this.chbOidColumnUniqueness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.general.add(this.chbOidColumnUniqueness);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.chbOidColumnUniqueness, 200);
    }

    private void initSuperViewName() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.SuperView"));
        this.general.add(jLabel);
        this.tfSuperView = new JTextField("", 26);
        this.tfSuperView.setEnabled(false);
        this.general.add(this.tfSuperView);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfSuperView, 230);
    }

    private void initDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogUDB.Definition"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 260);
        this.definitionArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.definitionArea);
        jScrollPane.setPreferredSize(new Dimension(395, 250));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.definitionArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 280);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogUDB.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 480);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.cbSchema.setSelectedItem(this.view.getSchema());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES_NO[0]);
        } else {
            this.cbCheckOption.setSelectedItem(YES_NO[1]);
        }
        this.cbCheckOptionScope.setSelectedItem(this.view.getCheckOptionScope());
        if (this.view.isBasedOnStructuredType()) {
            this.tfOidColumnName.setText(this.view.getOidColumnName());
            this.chbOidColumnUniqueness.setSelected(this.view.isOidColumnUniqueness());
        } else {
            this.tfOidColumnName.setEnabled(false);
            this.chbOidColumnUniqueness.setEnabled(false);
        }
        this.tfSuperView.setText(this.view.getSuperViewName());
        this.definitionArea.setText(this.view.getDefinition());
        this.comment = ((TableView)this.view.getObject()).getComment();
        this.commentInRDBMS = ((TableView)this.view.getObject()).getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setSchema((SchemaUDB)this.cbSchema.getSelectedItem());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES_NO[0])) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setCheckOptionScope((String)this.cbCheckOptionScope.getSelectedItem());
            if (this.view.isBasedOnStructuredType()) {
                this.view.setOidColumnName(this.tfOidColumnName.getText());
                this.view.setOidColumnUniqueness(this.chbOidColumnUniqueness.isSelected());
            }
            this.view.setDefinition(this.definitionArea.getText());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.view.setComment(string);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.view.setCommentInRDBMS(string2);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDB schemaUDB = (SchemaUDB)TableViewPropertyDialogUDB.this.cbSchema.getSelectedItem();
            try {
                if (schemaUDB != null) {
                    TableViewPropertyDialogUDB.this.tfOwner.setText(schemaUDB.getOwner().toString());
                } else {
                    TableViewPropertyDialogUDB.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException nullPointerException) {
                TableViewPropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TableViewPropertyDialogUDB.this.dialog == null) {
                TableViewPropertyDialogUDB.this.dialog = new PermissionsPropertyDialogUDB(TableViewPropertyDialogUDB.this.getAppView(), TableViewPropertyDialogUDB.this.getStorageDesign(), TableViewPropertyDialogUDB.this.view);
            }
            TableViewPropertyDialogUDB.this.dialog.setVisible(true);
        }
    }
}

