/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;

public class TableSpacePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TableSpaceUDB tableSpace;
    private JComboBox cbDBDefinition;
    private JComboBox cbManagedBy;
    private JComboBox cbType;
    private JComboBox cbNodegroup;
    private JComboBox cbPageSize;
    private JTextField ifExtentSize;
    private JTextField ifPrefetchSize;
    private JComboBox cbBufferPool;
    private JDecimalField dfOverhead;
    private JDecimalField dfTransferRate;
    private JComboBox cbDroppedTblRecovery;
    protected JPanel tables;
    protected DefaultListModel tablesListModel;
    protected JList tablesList;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected DefaultListModel allGroupsModel;
    protected DefaultListModel selectedGroupsModel;
    private JList allGroupsList;
    private JList selectedGroupsList;
    private JButton bnAddGroup;
    private JButton bnRemoveGroup;
    protected JComboBox cbGrantOption;

    public TableSpacePropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.tableSpace = (TableSpaceUDB)storageObject;
        this.setHeight(450);
        this.initCommentsView(190);
        this.initCommentsInRDBMS(190);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogUDB.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDBDefinition();
        this.initManagedBy();
        this.initType();
        this.initNodegroup();
        this.initPageSize();
        this.initExtentSize();
        this.initPrefetchSize();
        this.initBufferPool();
        this.initOverhead();
        this.initTransferRate();
        this.initDroppedTblRecovery();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initDBDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DBDefinitionOnly"));
        this.general.add(jLabel);
        this.cbDBDefinition = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDBDefinition);
        this.cbDBDefinition.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDBDefinition);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbDBDefinition, 50);
    }

    private void initManagedBy() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.ManagedBy"));
        this.general.add(jLabel);
        this.cbManagedBy = new JComboBox<Object>(TableSpaceUDB.getAvailableManagedByTypes());
        this.setBG(this.cbManagedBy);
        this.cbManagedBy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbManagedBy);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbManagedBy, 80);
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DataType"));
        this.general.add(jLabel);
        this.cbType = new JComboBox<String>(TableSpaceUDB.getAvailableDataTypes());
        this.cbType.addActionListener(new TypeListener());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbType, 110);
    }

    private void initNodegroup() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.Nodegroup"));
        this.general.add(jLabel);
        this.cbNodegroup = new JComboBox();
        this.setBG(this.cbNodegroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getNodeGroupSet().toArray(), this.cbNodegroup);
        }
        this.cbNodegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNodegroup);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbNodegroup, 140);
    }

    private void initPageSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.PageSize"));
        this.general.add(jLabel);
        this.cbPageSize = new JComboBox<Object>(TableSpaceUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPageSize, 170);
    }

    private void initExtentSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.ExtentSize"));
        this.general.add(jLabel);
        this.ifExtentSize = new JTextField("", 26);
        this.general.add(this.ifExtentSize);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifExtentSize, 200);
    }

    private void initPrefetchSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.PrefetchSize"));
        this.general.add(jLabel);
        this.ifPrefetchSize = new JTextField("", 26);
        this.general.add(this.ifPrefetchSize);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifPrefetchSize, 230);
    }

    private void initBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.BufferPool"));
        this.general.add(jLabel);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbBufferPool, 260);
    }

    private void initOverhead() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.Overhead"));
        this.general.add(jLabel);
        this.dfOverhead = new JDecimalField(0.0, 26);
        this.general.add(this.dfOverhead);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.dfOverhead, 290);
    }

    private void initTransferRate() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.TransferRate"));
        this.general.add(jLabel);
        this.dfTransferRate = new JDecimalField(0.0, 26);
        this.general.add(this.dfTransferRate);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.dfTransferRate, 320);
    }

    private void initDroppedTblRecovery() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.DroppedTableRec"));
        this.general.add(jLabel);
        this.cbDroppedTblRecovery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDroppedTblRecovery);
        this.cbDroppedTblRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDroppedTblRecovery);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbDroppedTblRecovery, 350);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TableSpacePropertyDialogUDB.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TableSpacePropertyDialogUDB.this.getStorageDesign().getTableSpaceSet().getElementsList());
                arrayList.remove(TableSpacePropertyDialogUDB.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogUDB.this.getAppView(), TableSpacePropertyDialogUDB.this.tableSpace, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 390);
    }

    @Override
    protected void addTabs() {
        this.initUsePrivilegesView();
        this.initTablesView();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDB.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initToUserGroups();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.AllUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(190, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.SelectedUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(190, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 315, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 313, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 215, 75);
        this.bnRemoveUser = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 215, 105);
        TableSpacePropertyDialogUDB.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    private void initToUserGroups() {
        this.initAllUserGroupsList();
        this.initSelectedUserGroupsList();
        this.initGroupsButtons();
    }

    private void initAllUserGroupsList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.AllUsersGroups"));
        this.usePrivilegesPanel.add(jLabel);
        this.allGroupsModel = new DefaultListModel();
        this.allGroupsList = new JList(this.allGroupsModel);
        ListSelectionModel listSelectionModel = this.allGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllGroupListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allGroupsList);
        jScrollPane.setPreferredSize(new Dimension(190, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 202);
    }

    private void initSelectedUserGroupsList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.SelectedUserGroups"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedGroupsModel = new DefaultListModel();
        this.selectedGroupsList = new JList(this.selectedGroupsModel);
        ListSelectionModel listSelectionModel = this.selectedGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedGroupListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedGroupsList);
        jScrollPane.setPreferredSize(new Dimension(190, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 315, 184);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 312, 202);
    }

    private void initGroupsButtons() {
        this.bnAddGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Add"));
        this.bnAddGroup.addActionListener(new AddGroupsActionListener());
        this.bnAddGroup.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddGroup, 215, 245);
        this.bnRemoveGroup = new JButton(Messages.getString("TableSpacePropertyDialogUDB.Remove"));
        this.bnRemoveGroup.setEnabled(false);
        this.bnRemoveGroup.addActionListener(new RemoveGroupsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveGroup, 215, 275);
        TableSpacePropertyDialogUDB.equalizeButtonSizes(this.bnAddGroup, this.bnRemoveGroup);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogUDB.GrantOption"));
        this.usePrivilegesPanel.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 350);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 350);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogUDB.Tables"), this.tables);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tablesList);
        jScrollPane.setPreferredSize(new Dimension(495, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTSLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbDBDefinition.setSelectedItem(this.tableSpace.getDBDefOnly() ? YES_NO[0] : YES_NO[1]);
        this.cbManagedBy.setSelectedItem(this.tableSpace.getManagedBy());
        this.cbType.setSelectedItem(this.tableSpace.getDataType());
        if (this.tableSpace.getDataType().equalsIgnoreCase("REGULAR")) {
            this.cbDroppedTblRecovery.setEnabled(true);
        } else {
            this.cbDroppedTblRecovery.setEnabled(false);
        }
        this.cbNodegroup.setSelectedItem(this.tableSpace.getNodeGroup());
        this.cbPageSize.setSelectedItem(this.tableSpace.getPageSize());
        this.ifExtentSize.setText(this.tableSpace.getExtentSize());
        this.ifPrefetchSize.setText(this.tableSpace.getPrefetchSize());
        this.cbBufferPool.setSelectedItem(this.tableSpace.getBufferPool());
        this.dfOverhead.setValue(this.tableSpace.getOverhead());
        this.dfTransferRate.setValue(this.tableSpace.getTransferRate());
        this.cbDroppedTblRecovery.setSelectedItem(this.tableSpace.getDroppedTableRecovery() ? YES_NO[0] : YES_NO[1]);
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            Owner owner = ownerArray[i];
            if (this.tableSpace.getUserSet().contains(owner.getName())) {
                this.selectedUsersModel.addElement(owner);
                continue;
            }
            this.allUsersModel.addElement(owner);
        }
        Object[] objectArray = this.getStorageDesign().getUserGroupSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UserGroupUDB userGroupUDB = (UserGroupUDB)objectArray[i];
            if (this.tableSpace.getUserGroupSet().contains(userGroupUDB.getName())) {
                this.selectedGroupsModel.addElement(userGroupUDB);
                continue;
            }
            this.allGroupsModel.addElement(userGroupUDB);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogUDB.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        Object[] objectArray2 = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((TableProxyUDB)objectArray2[i]).getTableSpace() != this.tableSpace) continue;
            this.tablesListModel.addElement(objectArray2[i]);
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.tableSpace.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null) {
            this.tableSpace.setName(this.tfName.getText());
            Object object = this.cbDBDefinition.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDBDefOnly(bl);
            this.tableSpace.setManagedBy((String)this.cbManagedBy.getSelectedItem());
            this.tableSpace.setDataType((String)this.cbType.getSelectedItem());
            object = this.cbNodegroup.getSelectedItem();
            if (object instanceof NodeGroupUDB) {
                this.tableSpace.setNodeGroup((NodeGroupUDB)object);
            } else {
                this.tableSpace.setNodeGroup(null);
            }
            this.tableSpace.setPageSize((Integer)this.cbPageSize.getSelectedItem());
            this.tableSpace.setExtentSize(this.ifExtentSize.getText());
            this.tableSpace.setPrefetchSize(this.ifPrefetchSize.getText());
            object = this.cbBufferPool.getSelectedItem();
            if (object instanceof BufferPoolUDB) {
                this.tableSpace.setBufferPool((BufferPoolUDB)object);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setOverhead(this.dfOverhead.getFloatValue());
            this.tableSpace.setTransferRate(this.dfTransferRate.getFloatValue());
            object = this.cbDroppedTblRecovery.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setDroppedTableRecovery(bl);
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)object2).getName());
            }
            Object[] objectArray2 = this.selectedGroupsModel.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object3 = objectArray2[i];
                if (!(object3 instanceof UserGroupUDB)) continue;
                this.tableSpace.setGroups(((UserGroupUDB)object3).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogUDB.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.tableSpace.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyUDB tableProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (tableProxyUDB = (TableProxyUDB)TableSpacePropertyDialogUDB.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogUDB tablePropertyDialogUDB = new TablePropertyDialogUDB(TableSpacePropertyDialogUDB.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogUDB.this.getStorageDesign(), tableProxyUDB);
                tablePropertyDialogUDB.show();
            }
        }
    }

    private class SelectedGroupListSelectionHandler
    implements ListSelectionListener {
        private SelectedGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.selectedGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnRemoveGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnRemoveGroup.setEnabled(true);
                }
            }
        }
    }

    private class AllGroupListSelectionHandler
    implements ListSelectionListener {
        private AllGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.allGroupsList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnAddGroup.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnAddGroup.setEnabled(true);
                }
            }
        }
    }

    private class RemoveGroupsActionListener
    implements ActionListener {
        private RemoveGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogUDB.this.selectedGroupsModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogUDB.this.selectedGroupsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogUDB.this.allGroupsModel.contains(object)) continue;
                    TableSpacePropertyDialogUDB.this.allGroupsModel.addElement(object);
                    TableSpacePropertyDialogUDB.this.selectedGroupsModel.removeElement(object);
                }
            }
        }
    }

    private class AddGroupsActionListener
    implements ActionListener {
        private AddGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogUDB.this.allGroupsModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogUDB.this.allGroupsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogUDB.this.selectedGroupsModel.contains(object)) continue;
                    TableSpacePropertyDialogUDB.this.selectedGroupsModel.addElement(object);
                    TableSpacePropertyDialogUDB.this.allGroupsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.selectedUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnRemoveUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogUDB.this.allUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogUDB.this.bnAddUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogUDB.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogUDB.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogUDB.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogUDB.this.allUsersModel.contains(object)) continue;
                    TableSpacePropertyDialogUDB.this.allUsersModel.addElement(object);
                    TableSpacePropertyDialogUDB.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogUDB.this.allUsersModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogUDB.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogUDB.this.selectedUsersModel.contains(object)) continue;
                    TableSpacePropertyDialogUDB.this.selectedUsersModel.addElement(object);
                    TableSpacePropertyDialogUDB.this.allUsersModel.removeElement(object);
                }
            }
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)TableSpacePropertyDialogUDB.this.cbType.getSelectedItem()).equalsIgnoreCase("REGULAR")) {
                TableSpacePropertyDialogUDB.this.cbDroppedTblRecovery.setEnabled(true);
            } else {
                TableSpacePropertyDialogUDB.this.cbDroppedTblRecovery.setEnabled(false);
            }
        }
    }
}

