/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.SchemaPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TriggerPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserAndGroupPermissionsDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OwnerPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final long serialVersionUID = -8699917883424195446L;
    private OwnerUDB owner;
    private JPanel schemas;
    private DefaultListModel schemaListModel;
    private JList schemaList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JButton bnPermissions;
    private UserAndGroupPermissionsDialogUDB dialog;

    public OwnerPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.owner = (OwnerUDB)storageObject;
        this.setHeight(150);
        this.initCommentsView(80);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("OwnerPropertyDialogUDB.OwnerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPermissionsButton();
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("OwnerPropertyDialogUDB.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 75);
    }

    @Override
    protected void addTabs() {
        this.initSchemasView();
        this.initTablesView();
        this.initTriggersView();
        this.initViewsView();
        this.initStoredProceduresView();
    }

    private void initSchemasView() {
        this.schemas = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Schemas"), this.schemas);
        this.initSchemas();
    }

    private void initSchemas() {
        this.schemaListModel = new DefaultListModel();
        this.schemaList = new JList(this.schemaListModel);
        this.schemaList.addMouseListener(new SchemaListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.schemaList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.schemas.add(jScrollPane);
        this.setObjectConstraints(this.getSchemaLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSchemaLayout() {
        return (SpringLayout)this.schemas.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.triggerList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(jScrollPane);
        this.setObjectConstraints(this.getTriggerLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(jScrollPane);
        this.setObjectConstraints(this.getViewLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initStoredProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDB.StoredProcedures"), this.procedures);
        this.initProcedures();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProcListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.procList);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(jScrollPane);
        this.setObjectConstraints(this.getProcedureLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getProcedureLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.owner.getName());
        this.tfName.setText(this.owner.getName());
        this.getCommentsList().insert(this.owner.getComment(), 0);
        if (this.owner.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] objectArray = this.getStorageDesign().getSchemaSet().toArray();
        SchemaUDB schemaUDB = null;
        for (int i = 0; i < objectArray.length; ++i) {
            schemaUDB = (SchemaUDB)objectArray[i];
            if (schemaUDB.getOwner() != this.owner) continue;
            this.schemaListModel.addElement(schemaUDB);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableProxySet().toArray();
        TableProxyUDB tableProxyUDB = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            tableProxyUDB = (TableProxyUDB)objectArray2[i];
            if (tableProxyUDB.getOwner() != this.owner && (tableProxyUDB.getSchema() == null || tableProxyUDB.getSchema().getOwner() != this.owner)) continue;
            this.tableListModel.addElement(tableProxyUDB);
        }
        Object[] objectArray3 = this.getStorageDesign().getTriggerSet().toArray();
        TriggerUDB triggerUDB = null;
        for (int i = 0; i < objectArray3.length; ++i) {
            triggerUDB = (TriggerUDB)objectArray3[i];
            if (triggerUDB.getOwner() != this.owner) continue;
            this.triggerListModel.addElement(triggerUDB);
        }
        Object[] objectArray4 = this.getStorageDesign().getTableViewProxySet().toArray();
        TableViewProxyUDB tableViewProxyUDB = null;
        for (int i = 0; i < objectArray4.length; ++i) {
            tableViewProxyUDB = (TableViewProxyUDB)objectArray4[i];
            if (tableViewProxyUDB.getOwner() != this.owner && (tableViewProxyUDB.getSchema() == null || tableViewProxyUDB.getSchema().getOwner() != this.owner)) continue;
            this.viewListModel.addElement(objectArray4[i]);
        }
        Object[] objectArray5 = this.getStorageDesign().getStoredProcedureSet().toArray();
        StoredProcedureUDB storedProcedureUDB = null;
        for (int i = 0; i < objectArray5.length; ++i) {
            storedProcedureUDB = (StoredProcedureUDB)objectArray5[i];
            if (storedProcedureUDB.getOwner() != this.owner) continue;
            this.procListModel.addElement(objectArray5[i]);
        }
    }

    @Override
    protected void setProperties() {
        if (this.owner != null && !this.owner.isNullInstance()) {
            String string = this.owner.getName();
            this.owner.setName(this.tfName.getText());
            this.owner.setComment(this.getCommentsList().getText());
            if (!this.tfName.getText().equals(string)) {
                this.owner.setNameChanged(true);
            }
        }
    }

    private class ProcListMouseListener
    extends MouseAdapter {
        private ProcListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StoredProcedureUDB storedProcedureUDB;
            if (mouseEvent.getClickCount() == 2 && (storedProcedureUDB = (StoredProcedureUDB)OwnerPropertyDialogUDB.this.procList.getSelectedValue()) != null && !storedProcedureUDB.isDialogVisible()) {
                StoredProcedurePropertyDialogUDB storedProcedurePropertyDialogUDB = new StoredProcedurePropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), storedProcedureUDB);
                storedProcedurePropertyDialogUDB.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableViewProxyUDB tableViewProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (tableViewProxyUDB = (TableViewProxyUDB)OwnerPropertyDialogUDB.this.viewList.getSelectedValue()) != null && !tableViewProxyUDB.isDialogVisible()) {
                TableViewPropertyDialogUDB tableViewPropertyDialogUDB = new TableViewPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), tableViewProxyUDB);
                tableViewPropertyDialogUDB.show();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TriggerUDB triggerUDB;
            if (mouseEvent.getClickCount() == 2 && (triggerUDB = (TriggerUDB)OwnerPropertyDialogUDB.this.triggerList.getSelectedValue()) != null && !triggerUDB.isDialogVisible()) {
                TriggerPropertyDialogUDB triggerPropertyDialogUDB = new TriggerPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), triggerUDB);
                triggerPropertyDialogUDB.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyUDB tableProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (tableProxyUDB = (TableProxyUDB)OwnerPropertyDialogUDB.this.tableList.getSelectedValue()) != null && !tableProxyUDB.isDialogVisible()) {
                TablePropertyDialogUDB tablePropertyDialogUDB = new TablePropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), tableProxyUDB);
                tablePropertyDialogUDB.show();
            }
        }
    }

    private class SchemaListMouseListener
    extends MouseAdapter {
        private SchemaListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SchemaUDB schemaUDB;
            if (mouseEvent.getClickCount() == 2 && (schemaUDB = (SchemaUDB)OwnerPropertyDialogUDB.this.schemaList.getSelectedValue()) != null && !schemaUDB.isDialogVisible()) {
                SchemaPropertyDialogUDB schemaPropertyDialogUDB = new SchemaPropertyDialogUDB(OwnerPropertyDialogUDB.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), schemaUDB);
                schemaPropertyDialogUDB.show();
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OwnerPropertyDialogUDB.this.dialog == null) {
                OwnerPropertyDialogUDB.this.dialog = new UserAndGroupPermissionsDialogUDB(OwnerPropertyDialogUDB.this.getAppView(), OwnerPropertyDialogUDB.this.getStorageDesign(), OwnerPropertyDialogUDB.this.owner);
            }
            OwnerPropertyDialogUDB.this.dialog.showDialog();
        }
    }
}

