/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.MethodProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.MethodProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class MethodPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private MethodProxyUDB method;
    private JTextField tfSpecificName;
    private JTextField tfReturnValue;
    private JComboBox cbReturnSelfAsResult;
    private JComboBox cbLanguage;
    private JComboBox cbDeterministic;
    private JComboBox cbExternalAction;
    private JComboBox cbSqlStatementType;
    private JComboBox cbNullParametersTreatment;
    private JComboBox cbFederated;
    private JComboBox cbExtRParameterStyle;
    private JTextField tfExtRScratchpad;
    private JComboBox cbExtRSafeness;
    private JComboBox cbExtRFinalCall;
    private JComboBox cbExtRParallelInvocation;
    private JComboBox cbExtRDBInfo;
    private JTextField tfExtRName;
    private JTextField tfExtRTransformGroup;
    private JPanel plsqlPanel;
    private JTextArea taSQLBody;

    public MethodPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.method = (MethodProxyUDB)storageObject;
        this.setHeight(590);
        this.initCommentsView(540);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodPropertyDialogUDB.MethodProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initSpecificName();
        this.initReturnValue();
        this.initReturnSelfAsResult();
        this.initLanguage();
        this.initDeterministic();
        this.initExternalAction();
        this.initSqlStatementType();
        this.initNullParametersTreatment();
        this.initFederated();
        this.initExtRParameterStyle();
        this.initExtRScratchpad();
        this.initExtRSafeness();
        this.initExtRFinalCall();
        this.initExtRParallelInvocation();
        this.initExtRDBInfo();
        this.initExtRName();
        this.initExtRTransformGroup();
    }

    @Override
    protected void addTabs() {
        this.initSQLBodyView();
    }

    private void initSQLBodyView() {
        this.plsqlPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("MethodPropertyDialogUDB.SQLBody"), this.plsqlPanel);
        this.initPLSQLBody();
    }

    private void initPLSQLBody() {
        this.taSQLBody = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taSQLBody);
        jScrollPane.setPreferredSize(new Dimension(395, 540));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.plsqlPanel.add(jScrollPane);
        this.setObjectConstraints(this.getSQLLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getSQLLayout() {
        return (SpringLayout)this.plsqlPanel.getLayout();
    }

    private void initSpecificName() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.SpecificName"));
        this.general.add(jLabel);
        this.tfSpecificName = new JTextField("", 26);
        this.general.add(this.tfSpecificName);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfSpecificName, 50);
    }

    private void initReturnValue() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ReturnValue"));
        this.general.add(jLabel);
        this.tfReturnValue = new JTextField("", 26);
        this.general.add(this.tfReturnValue);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfReturnValue, 80);
    }

    private void initReturnSelfAsResult() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ReturnSelfAsResult"));
        this.general.add(jLabel);
        this.cbReturnSelfAsResult = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbReturnSelfAsResult);
        this.cbReturnSelfAsResult.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReturnSelfAsResult);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbReturnSelfAsResult, 110);
    }

    private void initLanguage() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.Language"));
        this.general.add(jLabel);
        this.cbLanguage = new JComboBox<String>(MethodProxyUDB.LANGUAGES);
        this.cbLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MethodPropertyDialogUDB.this.getPane().setEnabledAt(1, MethodPropertyDialogUDB.this.cbLanguage.getSelectedIndex() == 0);
                if (MethodPropertyDialogUDB.this.cbExtRParameterStyle != null) {
                    switch (MethodPropertyDialogUDB.this.cbLanguage.getSelectedIndex()) {
                        case 0: {
                            MethodPropertyDialogUDB.this.cbSqlStatementType.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setSelectedIndex(0);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setEnabled(false);
                            MethodPropertyDialogUDB.this.tfExtRScratchpad.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbNullParametersTreatment.setSelectedIndex(0);
                            MethodPropertyDialogUDB.this.cbNullParametersTreatment.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRSafeness.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRFinalCall.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRParallelInvocation.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRDBInfo.setEnabled(false);
                            MethodPropertyDialogUDB.this.tfExtRName.setEnabled(false);
                            MethodPropertyDialogUDB.this.tfExtRTransformGroup.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbFederated.setEnabled(true);
                            break;
                        }
                        case 1: {
                            if (MethodPropertyDialogUDB.this.method instanceof MethodProxyUDBv81) {
                                MethodPropertyDialogUDB.this.cbSqlStatementType.setSelectedIndex(2);
                            }
                            MethodPropertyDialogUDB.this.cbSqlStatementType.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRScratchpad.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbNullParametersTreatment.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRSafeness.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRFinalCall.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRParallelInvocation.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRDBInfo.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRName.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRTransformGroup.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbFederated.setSelectedIndex(1);
                            MethodPropertyDialogUDB.this.cbFederated.setEnabled(false);
                            break;
                        }
                        case 2: {
                            if (MethodPropertyDialogUDB.this.method instanceof MethodProxyUDBv81) {
                                MethodPropertyDialogUDB.this.cbSqlStatementType.setSelectedIndex(2);
                            }
                            MethodPropertyDialogUDB.this.cbSqlStatementType.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setSelectedIndex(0);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setEnabled(false);
                            MethodPropertyDialogUDB.this.tfExtRScratchpad.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbNullParametersTreatment.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRSafeness.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRFinalCall.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRParallelInvocation.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRDBInfo.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRName.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRTransformGroup.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbFederated.setSelectedIndex(1);
                            MethodPropertyDialogUDB.this.cbFederated.setEnabled(false);
                            break;
                        }
                        case 3: {
                            if (MethodPropertyDialogUDB.this.method instanceof MethodProxyUDBv81) {
                                MethodPropertyDialogUDB.this.cbSqlStatementType.setSelectedIndex(2);
                            }
                            MethodPropertyDialogUDB.this.cbSqlStatementType.setEnabled(false);
                            MethodPropertyDialogUDB.this.cbExtRParameterStyle.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRScratchpad.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbNullParametersTreatment.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRSafeness.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRFinalCall.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRParallelInvocation.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbExtRDBInfo.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRName.setEnabled(true);
                            MethodPropertyDialogUDB.this.tfExtRTransformGroup.setEnabled(true);
                            MethodPropertyDialogUDB.this.cbFederated.setSelectedIndex(1);
                            MethodPropertyDialogUDB.this.cbFederated.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.setBG(this.cbLanguage);
        this.cbLanguage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLanguage);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbLanguage, 140);
    }

    private void initDeterministic() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.Deterministic"));
        this.general.add(jLabel);
        this.cbDeterministic = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbDeterministic);
        this.cbDeterministic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeterministic);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbDeterministic, 170);
    }

    private void initExternalAction() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExternalAction"));
        this.general.add(jLabel);
        this.cbExternalAction = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbExternalAction);
        this.cbExternalAction.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExternalAction);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbExternalAction, 200);
    }

    private void initSqlStatementType() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.SQLStatementType"));
        this.general.add(jLabel);
        this.cbSqlStatementType = new JComboBox();
        this.setBG(this.cbSqlStatementType);
        this.cbSqlStatementType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSqlStatementType);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbSqlStatementType, 230);
    }

    private void initNullParametersTreatment() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.NullParametersTreatment"));
        this.general.add(jLabel);
        this.cbNullParametersTreatment = new JComboBox<String>(MethodProxyUDB.NULL_PARAMETERS_TREATMENTS);
        this.setBG(this.cbNullParametersTreatment);
        this.cbNullParametersTreatment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullParametersTreatment);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbNullParametersTreatment, 260);
    }

    private void initFederated() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.Federated"));
        this.general.add(jLabel);
        this.cbFederated = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbFederated);
        this.cbFederated.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFederated);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbFederated, 290);
    }

    private void initExtRParameterStyle() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRParameterStyle"));
        this.general.add(jLabel);
        this.cbExtRParameterStyle = new JComboBox();
        this.setBG(this.cbExtRParameterStyle);
        this.cbExtRParameterStyle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtRParameterStyle);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbExtRParameterStyle, 320);
    }

    private void initExtRScratchpad() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRScratchpad"));
        this.general.add(jLabel);
        this.tfExtRScratchpad = new JTextField("", 26);
        this.general.add(this.tfExtRScratchpad);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.tfExtRScratchpad, 350);
    }

    private void initExtRSafeness() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRSafeness"));
        this.general.add(jLabel);
        this.cbExtRSafeness = new JComboBox();
        this.setBG(this.cbExtRSafeness);
        this.cbExtRSafeness.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtRSafeness);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbExtRSafeness, 380);
    }

    private void initExtRFinalCall() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRFinalCall"));
        this.general.add(jLabel);
        this.cbExtRFinalCall = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbExtRFinalCall);
        this.cbExtRFinalCall.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtRFinalCall);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbExtRFinalCall, 410);
    }

    private void initExtRParallelInvocation() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRParallelInvocation"));
        this.general.add(jLabel);
        this.cbExtRParallelInvocation = new JComboBox<String>(MethodProxyUDB.EXT_R_PARALLEL_INVOCATION);
        this.setBG(this.cbExtRParallelInvocation);
        this.cbExtRParallelInvocation.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtRParallelInvocation);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbExtRParallelInvocation, 440);
    }

    private void initExtRDBInfo() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRDBINFO"));
        this.general.add(jLabel);
        this.cbExtRDBInfo = new JComboBox<String>(MethodProxyUDB.YES_NO);
        this.setBG(this.cbExtRDBInfo);
        this.cbExtRDBInfo.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtRDBInfo);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbExtRDBInfo, 470);
    }

    private void initExtRName() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRName"));
        this.general.add(jLabel);
        this.tfExtRName = new JTextField("", 26);
        this.general.add(this.tfExtRName);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.tfExtRName, 500);
    }

    private void initExtRTransformGroup() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogUDB.ExtRTransformGroup"));
        this.general.add(jLabel);
        this.tfExtRTransformGroup = new JTextField("", 26);
        this.general.add(this.tfExtRTransformGroup);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.tfExtRTransformGroup, 530);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.method.getName());
        this.fillComboItems((Object[])this.method.getSQL_STATEMENT_TYPES(), this.cbSqlStatementType, (Object)null);
        this.fillComboItems((Object[])this.method.getEXT_R_PARAMETER_STYLES(), this.cbExtRParameterStyle, (Object)null);
        this.fillComboItems((Object[])this.method.getEXT_R_SAFENESS(), this.cbExtRSafeness, (Object)null);
        this.tfName.setText(this.method.getName());
        this.tfSpecificName.setText(this.method.getSpecificName());
        this.tfReturnValue.setText(this.method.getReturnValue());
        this.cbReturnSelfAsResult.setSelectedItem(this.method.getReturnSelfAsResult());
        this.cbLanguage.setSelectedItem(this.method.getLanguage());
        this.cbDeterministic.setSelectedItem(this.method.getDeterministic());
        this.cbExternalAction.setSelectedItem(this.method.getExternalAction());
        this.cbSqlStatementType.setSelectedItem(this.method.getSqlStatementType());
        this.cbNullParametersTreatment.setSelectedItem(this.method.getNullParametersTreatment());
        if (this.method instanceof MethodProxyUDBv71) {
            this.cbFederated.setEnabled(false);
        } else {
            this.cbFederated.setSelectedItem(this.method.getFederated());
        }
        this.cbExtRParameterStyle.setSelectedItem(this.method.getExt_R_ParameterStyle());
        this.tfExtRScratchpad.setText(this.method.getExt_R_Scratchpad());
        this.cbExtRSafeness.setSelectedItem(this.method.getExt_R_Safeness());
        this.cbExtRFinalCall.setSelectedItem(this.method.getExt_R_FinalCall());
        this.cbExtRParallelInvocation.setSelectedItem(this.method.getExt_R_ParallelInvocation());
        this.cbExtRDBInfo.setSelectedItem(this.method.getExt_R_DBInfo());
        this.tfExtRName.setText(this.method.getExt_R_Name());
        this.tfExtRTransformGroup.setText(this.method.getExt_R_TransformGroup());
        this.taSQLBody.setText(this.method.getSqlMethodBody());
        this.getPane().setEnabledAt(1, this.cbLanguage.getSelectedIndex() == 0);
        this.getCommentsList().insert(this.method.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.method != null) {
            this.method.setName(this.tfName.getText());
            this.method.setSpecificName(this.tfSpecificName.getText());
            this.method.setReturnValue(this.tfReturnValue.getText());
            this.method.setReturnSelfAsResult((String)this.cbReturnSelfAsResult.getSelectedItem());
            this.method.setLanguage((String)this.cbLanguage.getSelectedItem());
            this.method.setDeterministic((String)this.cbDeterministic.getSelectedItem());
            this.method.setExternalAction((String)this.cbExternalAction.getSelectedItem());
            this.method.setSqlStatementType((String)this.cbSqlStatementType.getSelectedItem());
            this.method.setNullParametersTreatment((String)this.cbNullParametersTreatment.getSelectedItem());
            this.method.setFederated((String)this.cbFederated.getSelectedItem());
            this.method.setExt_R_ParameterStyle((String)this.cbExtRParameterStyle.getSelectedItem());
            this.method.setExt_R_Scratchpad(this.tfExtRScratchpad.getText());
            this.method.setExt_R_Safeness((String)this.cbExtRSafeness.getSelectedItem());
            this.method.setExt_R_FinalCall((String)this.cbExtRFinalCall.getSelectedItem());
            this.method.setExt_R_ParallelInvocation((String)this.cbExtRParallelInvocation.getSelectedItem());
            this.method.setExt_R_DBInfo((String)this.cbExtRDBInfo.getSelectedItem());
            this.method.setExt_R_Name(this.tfExtRName.getText());
            this.method.setExt_R_TransformGroup(this.tfExtRTransformGroup.getText());
            this.method.setSqlMethodBody(this.taSQLBody.getText());
            this.method.setComment(this.getCommentsList().getText());
        }
    }
}

