/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class XMLSchemaCollectionPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private XMLSchemaCollectionSqlServerv2k5 xmlType;
    private JComboBox cbSchema;
    private JTextField tfDatabase;
    private JTextArea taSchemaDefinition;
    private JScrollPane spSchemaDefinition;

    public XMLSchemaCollectionPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.xmlType = (XMLSchemaCollectionSqlServerv2k5)storageObject;
        this.setHeight(350);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("XMLSchemaCollectionPropertyDialogSqlServerv2k5.XMLSchemaCollectionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSchema();
        this.initDatabase();
        this.initSchemaDefinition();
    }

    private void initDatabase() {
        JLabel jLabel = new JLabel(Messages.getString("XMLSchemaCollectionPropertyDialogSqlServerv2k5.Database"));
        this.general.add(jLabel);
        this.tfDatabase = new JTextField();
        this.setBG(this.tfDatabase);
        this.tfDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initSchema() {
        JLabel jLabel = new JLabel(Messages.getString("XMLSchemaCollectionPropertyDialogSqlServerv2k5.Schema"));
        this.general.add(jLabel);
        this.cbSchema = new JComboBox();
        this.setBG(this.cbSchema);
        this.cbSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchema);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbSchema, 80);
    }

    private void initSchemaDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("XMLSchemaCollectionPropertyDialogSqlServerv2k5.SchemaDefinition"));
        this.general.add(jLabel);
        this.taSchemaDefinition = new JTextArea();
        this.spSchemaDefinition = new JScrollPane(this.taSchemaDefinition);
        this.spSchemaDefinition.setPreferredSize(new Dimension(392, 170));
        this.spSchemaDefinition.setBorder(BorderFactory.createEtchedBorder(0));
        this.setBG(this.taSchemaDefinition);
        this.general.add(this.spSchemaDefinition);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.getGeneralLayout(), this.spSchemaDefinition, 10, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.xmlType.getName());
        this.tfName.setText(this.xmlType.getName());
        if (this.xmlType != null) {
            this.fillComboItems(((DataBaseSqlServerv2k5)this.xmlType.getDatabase()).getSchemas().toArray(), this.cbSchema);
        }
        this.cbSchema.setSelectedItem(this.xmlType.getSchema());
        this.tfDatabase.setText(this.xmlType.getDatabase().toString());
        this.taSchemaDefinition.setText(this.xmlType.getSchemaDefinition());
        this.getCommentsList().insert(this.xmlType.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.xmlType != null) {
            this.xmlType.setSchema((SchemaSqlServer)this.cbSchema.getSelectedItem());
            this.xmlType.setName(this.tfName.getText());
            this.xmlType.setSchemaDefinition(this.taSchemaDefinition.getText());
            this.xmlType.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbSchema.getSelectedItem();
        if (object instanceof SchemaSqlServer) {
            string = ((SchemaSqlServer)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }
}

