/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PermissionsPropertiesDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ViewPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private TableViewProxySqlServer view;
    private String comment = "";
    private String commentInRDBMS = "";
    private ExtPropertiesModel model;
    private JComboBox cbDatabase;
    private JComboBox cbOwner;
    private JComboBox cbCheckOption;
    private JComboBox cbEncryption;
    private JComboBox cbSchemaBinding;
    private JComboBox cbViewMetadata;
    private JTextArea taStatement;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JButton bnPermissions;
    private PermissionsPropertiesDialogSqlServer dialog;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public ViewPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.view = (TableViewProxySqlServer)storageObject;
        this.setHeight(460);
        this.initCommentsView(190);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 210);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 190));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.taStatement.setText(this.view.getDefinition());
        this.cbDatabase.setSelectedItem(this.view.getDataBase());
        this.cbOwner.setSelectedItem(this.view.getSchema());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES);
        } else {
            this.cbCheckOption.setSelectedItem(NO);
        }
        this.cbEncryption.setSelectedItem(ViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.view.getEncryption()));
        this.cbSchemaBinding.setSelectedItem(ViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.view.getSchemaBinding()));
        this.cbViewMetadata.setSelectedItem(ViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.view.getViewMetaData()));
        if (this.view.getExtPropsSet() != null) {
            Object[] objectArray = this.view.getExtPropsSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
        this.comment = this.view.getObject().getComment();
        this.commentInRDBMS = this.view.getObject().getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            Object object;
            this.view.setName(this.tfName.getText());
            this.view.setDataBase((DataBaseSqlServer)this.cbDatabase.getSelectedItem());
            this.view.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setEncryption(ViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbEncryption.getSelectedItem()));
            this.view.setSchemaBinding(ViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbSchemaBinding.getSelectedItem()));
            this.view.setViewMetaData(ViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbViewMetadata.getSelectedItem()));
            this.view.setDefinition(this.taStatement.getText());
            Object[] objectArray = this.model.getRows();
            this.view.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken().trim();
                this.view.setProps(string);
                this.view.setProps(string2);
            }
            String string3 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string3) && !this.comment.equalsIgnoreCase(string3)) {
                this.view.setComment(string3);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.view.setCommentInRDBMS((String)object);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataBase();
        this.initOwner();
        this.initCheckOption();
        this.initEncryption();
        this.initSchemaBinding();
        this.initViewMetadata();
        this.initStatement();
        this.initPermissionsButton();
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("ViewPropertyDialogSqlServerv2k5.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("ViewPropertyDialogSqlServerv2k5.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 400);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 400);
        ViewPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ViewPropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 392));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(416, 395));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    private void initDataBase() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.Database"));
        this.general.add(jLabel);
        this.cbDatabase = new JComboBox<Object>(this.getStorageDesign().getDataBaseSet().toArray());
        this.cbDatabase.addActionListener(new DatabaseListener());
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initCheckOption() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.CheckOption"));
        this.general.add(jLabel);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCheckOption, 110);
    }

    private void initEncryption() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.Encryption"));
        this.general.add(jLabel);
        this.cbEncryption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEncryption);
        this.cbEncryption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEncryption);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbEncryption, 140);
    }

    private void initSchemaBinding() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.SchemaBinding"));
        this.general.add(jLabel);
        this.cbSchemaBinding = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSchemaBinding);
        this.cbSchemaBinding.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaBinding);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSchemaBinding, 170);
    }

    private void initViewMetadata() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.ViewMetadata"));
        this.general.add(jLabel);
        this.cbViewMetadata = new JComboBox<String>(YES_NO);
        this.setBG(this.cbViewMetadata);
        this.cbViewMetadata.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbViewMetadata);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbViewMetadata, 200);
    }

    private void initStatement() {
        JLabel jLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServerv2k5.Definition"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 230);
        this.taStatement = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taStatement);
        jScrollPane.setPreferredSize(new Dimension(395, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taStatement.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 250);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("ViewPropertyDialogSqlServerv2k5.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 400);
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            ViewPropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{string, string2});
            ViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            ViewPropertyDialogSqlServerv2k5.this.extProperties.changeSelection(ViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            ViewPropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewPropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = ViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!ViewPropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    ViewPropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                ViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ViewPropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("ViewPropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ViewPropertyDialogSqlServerv2k5.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = ViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = ViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = ViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = ViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    private class DatabaseListener
    implements ActionListener {
        private DatabaseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)ViewPropertyDialogSqlServerv2k5.this.cbDatabase.getSelectedItem();
            if (dataBaseSqlServer != null) {
                ViewPropertyDialogSqlServerv2k5.this.cbOwner.removeAllItems();
                Iterator iterator = dataBaseSqlServer.getSchemas().iterator();
                while (iterator.hasNext()) {
                    SchemaSqlServer schemaSqlServer = (SchemaSqlServer)iterator.next();
                    ViewPropertyDialogSqlServerv2k5.this.cbOwner.addItem(schemaSqlServer);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewPropertyDialogSqlServerv2k5.this.dialog == null) {
                ViewPropertyDialogSqlServerv2k5.this.dialog = new PermissionsPropertiesDialogSqlServer(ViewPropertyDialogSqlServerv2k5.this.getAppView(), ViewPropertyDialogSqlServerv2k5.this.getStorageDesign(), ViewPropertyDialogSqlServerv2k5.this.view);
            }
            ViewPropertyDialogSqlServerv2k5.this.dialog.show();
        }
    }
}

