/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class UniquePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private UniqueProxySqlServerv2k5 ukey;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private JComboBox cbPartitionScheme;
    private JComboBox cbPartitioningColumn;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbIgnoreDupKey;
    private JComboBox cbAllowRowLocks;
    private JComboBox cbAllowPageLocks;

    public UniquePropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.ukey = (UniqueProxySqlServerv2k5)storageObject;
        this.setHeight(430);
        this.initCommentsView(180);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UniquePropertyDialogSqlServerv2k5.UniqueProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initClustered();
        this.initFileGroup();
        this.initFillFactor();
        this.initPartitionScheme();
        this.initPartitioningColumn();
        this.initPadIndex();
        this.initRecomputeStatistics();
        this.initIgnoreDupKey();
        this.initAllowRowLocks();
        this.initAllowPageLocks();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFilegroup.setToolTipText(Messages.getString("UniquePropertyDialogSqlServerv2k5.IfBothAreDefinedPartitionSchemeWillBeTaken"));
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initPartitionScheme() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(jLabel);
        this.cbPartitionScheme = new JComboBox();
        this.setBG(this.cbPartitionScheme);
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitionScheme.setToolTipText(Messages.getString("UniquePropertyDialogSqlServerv2k5.IfBothAreDefinedPartitionSchemeWillBeTaken"));
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbPartitionScheme, 140);
    }

    private void initPartitioningColumn() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.PartitioningColumn"));
        this.general.add(jLabel);
        this.cbPartitioningColumn = new JComboBox();
        this.setBG(this.cbPartitioningColumn);
        this.cbPartitioningColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioningColumn);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPartitioningColumn, 170);
    }

    private void initPadIndex() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(jLabel);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbPadIndex, 200);
    }

    private void initFillFactor() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(jLabel);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifFillFactor, 230);
    }

    private void initRecomputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(jLabel);
        this.cbRecomputeStatistics = new JComboBox<String>(ConstantsSqlServer.AUTO_NO_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbRecomputeStatistics, 260);
    }

    private void initIgnoreDupKey() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(jLabel);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    private void initAllowRowLocks() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.AllowRowLocks"));
        this.general.add(jLabel);
        this.cbAllowRowLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowRowLocks);
        this.cbAllowRowLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowRowLocks);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbAllowRowLocks, 320);
    }

    private void initAllowPageLocks() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.AllowPageLocks"));
        this.general.add(jLabel);
        this.cbAllowPageLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowPageLocks);
        this.cbAllowPageLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowPageLocks);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbAllowPageLocks, 350);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniquePropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 380));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 200);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 160));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 230);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.ukey.getName());
        this.tfName.setText(this.ukey.getName());
        ColumnProxy[] columnProxyArray = this.ukey.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            object = columnProxyArray[i];
            this.columnListModel.addElement(object);
        }
        this.tfTable.setText(this.ukey.getTableName());
        if (this.ukey.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        if (((TableProxySqlServer)this.ukey.getTableProxy()).existClusteredIndex(this.ukey)) {
            this.cbClustered.setEnabled(false);
        } else {
            this.cbClustered.setEnabled(true);
        }
        this.cbFilegroup.addItem(null);
        this.cbPartitionScheme.addItem(null);
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)((TableProxySqlServer)this.ukey.getTableProxy()).getDatabase();
        if (dataBaseSqlServerv2k5 != null) {
            AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
            object = ((StorageObjectCollection)dataBaseSqlServerv2k5.getChild(0)).iterator();
            while (object.hasNext()) {
                abstractStorageObjectSqlServer = (FileGroupSqlServer)object.next();
                this.cbFilegroup.addItem(abstractStorageObjectSqlServer);
            }
            this.cbFilegroup.setSelectedItem(this.ukey.getFilegroup());
            object = dataBaseSqlServerv2k5.getPartitionFunction().iterator();
            while (object.hasNext()) {
                abstractStorageObjectSqlServer = (PartitionFunctionSqlServerv2k5)object.next();
                Iterator iterator = ((PartitionFunctionSqlServer)abstractStorageObjectSqlServer).getPartitionScheme().iterator();
                while (iterator.hasNext()) {
                    this.cbPartitionScheme.addItem(iterator.next());
                }
            }
            this.cbPartitionScheme.setSelectedItem(this.ukey.getPartitionScheme());
        }
        this.fillComboItems(this.ukey.getTableProxy().getColumnProxies(), this.cbPartitioningColumn);
        this.cbPartitioningColumn.setSelectedItem(this.ukey.getPartitioningColumn());
        this.ifFillFactor.setValue((long)this.ukey.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.ukey.getRecomputeStatistics());
        this.cbIgnoreDupKey.setSelectedItem(UniquePropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.ukey.getIgnoreDupKey()));
        this.cbAllowRowLocks.setSelectedItem(this.ukey.getAllowRowLocks());
        this.cbAllowPageLocks.setSelectedItem(this.ukey.getAllowPageLocks());
        this.cbPadIndex.setSelectedItem(UniquePropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.ukey.getPadIndex()));
        this.comment = this.ukey.getObject().getComment();
        this.commentInRDBMS = this.ukey.getObject().getCommentInRDBMS();
        if (this.ukey.isCommentChanged()) {
            this.getCommentsList().insert(this.ukey.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.ukey.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.ukey.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.ukey != null) {
            this.ukey.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.ukey.setClustered(true);
            } else {
                this.ukey.setClustered(false);
            }
            if (((TableProxySqlServer)this.ukey.getTableProxy()).existClusteredIndex(this.ukey)) {
                this.cbClustered.setEnabled(false);
            } else {
                this.cbClustered.setEnabled(true);
            }
            this.ukey.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.ukey.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.ukey.getFillFactor());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.ukey.setComment(string);
                this.ukey.setCommentChanged(true);
            } else {
                this.ukey.setComment("");
                this.ukey.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.ukey.setCommentInRDBMS(string2);
                this.ukey.setCommentInRDBMSChanged(true);
            } else {
                this.ukey.setCommentInRDBMS("");
                this.ukey.setCommentInRDBMSChanged(false);
            }
            this.applyColumnsSortOrder();
            this.ukey.setPartitionScheme((PartitionSchemeSqlServer)this.cbPartitionScheme.getSelectedItem());
            this.ukey.setPartitioningColumn((ColumnProxy)this.cbPartitioningColumn.getSelectedItem());
            this.ukey.setPadIndex(UniquePropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.ukey.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.ukey.setAllowRowLocks((String)this.cbAllowRowLocks.getSelectedItem());
            this.ukey.setAllowPageLocks((String)this.cbAllowPageLocks.getSelectedItem());
            this.ukey.setIgnoreDupKey(UniquePropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("UniquePropertyDialogSqlServerv2k5.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.ukey.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.ukey.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }
}

