/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.InstanceDescriptorColumnPropertyDialogSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PermissionsPropertiesDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private TableProxySqlServerv2k5 table;
    private String comment = "";
    private String commentInRDBMS = "";
    private JComboBox cbFilegroup;
    private JComboBox cbTextImageFilegroup;
    private JButton bnPermissions;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel instDescriptorPanel;
    private List eList;
    private JTable etable;
    private int attrCounter = 0;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private PermissionsPropertiesDialogSqlServer dialog;
    private JComboBox cbDatabase;
    private JComboBox cbOwner;
    private JComboBox cbPartitionScheme;
    private JComboBox cbPartitionCol;

    public TablePropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxySqlServerv2k5)storageObject;
        this.setHeight(315);
        this.initCommentsView(120);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogSqlServerv2k5.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataBase();
        this.initOwner();
        this.initFilegroup();
        this.initTextImageFilegroup();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
        this.initPartitionScheme();
        this.initPartitionColumn();
    }

    private void initDataBase() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.DatabaseL"));
        this.general.add(jLabel);
        this.cbDatabase = new JComboBox<Object>(this.getStorageDesign().getDataBaseSet().toArray());
        this.cbDatabase.addActionListener(new DatabaseListener());
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.Schema"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initFilegroup() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initTextImageFilegroup() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.TEXTIMAGEGroup"));
        this.general.add(jLabel);
        this.cbTextImageFilegroup = new JComboBox();
        this.setBG(this.cbTextImageFilegroup);
        this.cbTextImageFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTextImageFilegroup);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbTextImageFilegroup, 200);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogSqlServerv2k5.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogSqlServerv2k5.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 240);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 240);
    }

    private void initPartitionScheme() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(jLabel);
        this.cbPartitionScheme = new JComboBox();
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbPartitionScheme);
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbPartitionScheme, 140);
    }

    private void initPartitionColumn() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.PartitionColumn"));
        this.general.add(jLabel);
        this.cbPartitionCol = new JComboBox();
        this.cbPartitionCol.setPreferredSize(this.tfName.getPreferredSize());
        this.setBG(this.cbPartitionCol);
        this.general.add(this.cbPartitionCol);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPartitionCol, 170);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("TablePropertyDialogSqlServerv2k5.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 250);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 250);
        TablePropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(410, 240));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(415, 240));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
        this.initInstanceDescriptorView();
    }

    private void initInstanceDescriptorView() {
        this.instDescriptorPanel = new JPanel();
        this.getPane().addTab(Messages.getString("TablePropertyDialogSqlServerv2k5.InstanceDescriptor"), this.instDescriptorPanel);
        this.initInstanceDescriptor();
    }

    private void initInstanceDescriptor() {
        ElementModel elementModel = new ElementModel();
        this.eList = new ArrayList();
        this.etable = new JTable(elementModel);
        this.etable.setSelectionMode(0);
        this.etable.setFocusTraversalKeysEnabled(false);
        TableColumn tableColumn = this.etable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(400);
        tableColumn = this.etable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        this.etable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow()) != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && n < TablePropertyDialogSqlServerv2k5.this.eList.size() && !(instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n)).isDialogVisible()) {
                    InstanceDescriptorColumnPropertyDialogSqlServer instanceDescriptorColumnPropertyDialogSqlServer = new InstanceDescriptorColumnPropertyDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table.getStorageDesign(), instanceDescriptorColumnSqlServer);
                    instanceDescriptorColumnPropertyDialogSqlServer.initProperties();
                    instanceDescriptorColumnPropertyDialogSqlServer.show();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.etable);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Properties"));
        jButton.addActionListener(new PropertiesAction());
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton2.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Add"));
        jButton2.addActionListener(new AddAction());
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton3.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.Remove"));
        jButton3.addActionListener(new RemoveAction());
        JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        jButton4.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.MoveUp"));
        jButton4.addActionListener(new MoveUpAction());
        JButton jButton5 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        jButton5.setToolTipText(Messages.getString("TablePropertyDialogSqlServerv2k5.MoveDown"));
        jButton5.addActionListener(new MoveDownAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.add(jButton5);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(395, 30));
        jScrollPane.setPreferredSize(new Dimension(395, 165));
        this.instDescriptorPanel.add((Component)jPanel, "North");
        this.instDescriptorPanel.add(jScrollPane);
    }

    protected String generateName() {
        String string = "InstanceDescriptorCol";
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.attrCounter = n2 + 1;
        } else {
            ++this.attrCounter;
            n = this.attrCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.instDescrExists(string2)) {
            n = ++this.attrCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean instDescrExists(String string) {
        for (int i = 0; i < this.eList.size(); ++i) {
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)this.eList.get(i);
            if (!string.equalsIgnoreCase(instanceDescriptorColumnSqlServer.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveElementToIndex(InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer, int n) {
        if (this.eList.contains(instanceDescriptorColumnSqlServer) && this.eList.size() > n && n >= 0) {
            this.eList.remove(instanceDescriptorColumnSqlServer);
            this.eList.add(n, instanceDescriptorColumnSqlServer);
            return true;
        }
        return false;
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 140);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(425, 100));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 160);
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.cbDatabase.setSelectedItem(this.table.getDatabase());
        this.cbOwner.setSelectedItem(this.table.getSchema());
        this.cbFilegroup.setSelectedItem(this.table.getFilegroup());
        this.cbTextImageFilegroup.setSelectedItem(this.table.getTextImageFG());
        this.cbPartitionScheme.addItem(null);
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)this.table.getDatabase();
        if (dataBaseSqlServerv2k5 != null) {
            object2 = dataBaseSqlServerv2k5.getPartitionFunction().iterator();
            while (object2.hasNext()) {
                PartitionFunctionSqlServerv2k5 partitionFunctionSqlServerv2k5 = (PartitionFunctionSqlServerv2k5)object2.next();
                object = partitionFunctionSqlServerv2k5.getPartitionScheme().iterator();
                while (object.hasNext()) {
                    this.cbPartitionScheme.addItem(object.next());
                }
            }
            this.cbPartitionScheme.setSelectedItem(this.table.getPartitionScheme());
        }
        this.cbPartitionScheme.setSelectedItem(this.table.getPartitionScheme());
        this.fillComboItems(this.table.getColumnProxies(), this.cbPartitionCol);
        this.cbPartitionCol.setSelectedItem(this.table.getPartitioningColumn());
        if (this.table.getExtPropsSet() != null) {
            object2 = this.table.getExtPropsSet().toArray();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = (String)object2[i];
                String string = (String)object2[++i];
                Object[] objectArray = new Object[]{object, string};
                this.model.addRow(objectArray);
            }
        }
        if (((ContainerObject)(object2 = (Table)this.table.getObject())).isRoot() && ((ContainerObject)object2).isBST()) {
            int n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, true);
            }
            this.eList.addAll(this.table.getInstanceDescriptorCols().getElementsList());
        } else {
            int n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            Object object;
            Object object2;
            this.table.setName(this.tfName.getText());
            this.table.setDatabase((DataBaseSqlServer)this.cbDatabase.getSelectedItem());
            this.table.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.table.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.table.setTextImageFG((FileGroupSqlServer)this.cbTextImageFilegroup.getSelectedItem());
            this.table.setPartitionScheme((PartitionSchemeSqlServerv2k5)this.cbPartitionScheme.getSelectedItem());
            this.table.setPartitioningColumn((ColumnProxy)this.cbPartitionCol.getSelectedItem());
            Object[] objectArray = this.model.getRows();
            this.table.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                if (!(object3 instanceof String)) continue;
                object2 = new StringTokenizer(object3.toString(), ",");
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    string = ((StringTokenizer)object2).nextToken().trim();
                }
                if (!((StringTokenizer)object2).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object2).nextToken().trim();
                this.table.setProps(string);
                this.table.setProps(string2);
            }
            Object[] objectArray2 = this.table.getInstanceDescriptorCols().toArray();
            for (int i = objectArray2.length - 1; i >= 0; --i) {
                object2 = (InstanceDescriptorColumnSqlServer)objectArray2[i];
                if (this.eList.contains(object2)) continue;
                ((StorageObject)object2).remove();
            }
            Object[] objectArray3 = this.eList.toArray();
            for (int i = 0; i < objectArray3.length; ++i) {
                object = objectArray3[i];
                if (!(object instanceof InstanceDescriptorColumnSqlServer)) continue;
                if (!this.table.getInstanceDescriptorCols().contains((InstanceDescriptorColumnSqlServer)object)) {
                    this.getStorageDesign().getInstanceDescriptorColumnSet().addInstanceDescriptorColumn((InstanceDescriptorColumnSqlServer)object);
                    ((InstanceDescriptorColumnSqlServer)object).setTable(this.table);
                    continue;
                }
                this.table.getInstanceDescriptorCols().moveElementToIndex((InstanceDescriptorColumnSqlServer)object, i);
            }
            String string3 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string3) && !this.comment.equalsIgnoreCase(string3)) {
                this.table.setComment(string3);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.table.setCommentInRDBMS((String)object);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TablePropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("TablePropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return TablePropertyDialogSqlServerv2k5.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = TablePropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            TablePropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{string, string2});
            TablePropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            TablePropertyDialogSqlServerv2k5.this.extProperties.changeSelection(TablePropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            TablePropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = TablePropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!TablePropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    TablePropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                TablePropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n);
                TablePropertyDialogSqlServerv2k5.this.moveElementToIndex(instanceDescriptorColumnSqlServer, n + 1);
                TablePropertyDialogSqlServerv2k5.this.etable.changeSelection(n + 1, 0, false, false);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n);
                TablePropertyDialogSqlServerv2k5.this.moveElementToIndex(instanceDescriptorColumnSqlServer, n - 1);
                TablePropertyDialogSqlServerv2k5.this.etable.changeSelection(n - 1, 0, false, false);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && n < TablePropertyDialogSqlServerv2k5.this.eList.size()) {
                InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n);
                TablePropertyDialogSqlServerv2k5.this.eList.remove(instanceDescriptorColumnSqlServer);
                TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = new InstanceDescriptorColumnSqlServer();
            instanceDescriptorColumnSqlServer.setName(TablePropertyDialogSqlServerv2k5.this.generateName());
            instanceDescriptorColumnSqlServer.setDesign(TablePropertyDialogSqlServerv2k5.this.table.getDesign());
            TablePropertyDialogSqlServerv2k5.this.eList.add(instanceDescriptorColumnSqlServer);
            TablePropertyDialogSqlServerv2k5.this.etable.updateUI();
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer;
            int n = TablePropertyDialogSqlServerv2k5.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogSqlServerv2k5.this.eList.size() > 0 && n < TablePropertyDialogSqlServerv2k5.this.eList.size() && !(instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n)).isDialogVisible()) {
                InstanceDescriptorColumnPropertyDialogSqlServer instanceDescriptorColumnPropertyDialogSqlServer = new InstanceDescriptorColumnPropertyDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.table.getStorageDesign(), instanceDescriptorColumnSqlServer);
                instanceDescriptorColumnPropertyDialogSqlServer.initProperties();
                instanceDescriptorColumnPropertyDialogSqlServer.show();
            }
        }
    }

    public class ElementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogSqlServerv2k5.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TablePropertyDialogSqlServerv2k5.Name");
            }
            if (n == 1) {
                return Messages.getString("TablePropertyDialogSqlServerv2k5.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)TablePropertyDialogSqlServerv2k5.this.eList.get(n);
            if (n2 == 0) {
                return instanceDescriptorColumnSqlServer.getName();
            }
            if (n2 == 1) {
                return instanceDescriptorColumnSqlServer.getDataType();
            }
            return new Integer(n * n2);
        }
    }

    private class DatabaseListener
    implements ActionListener {
        private DatabaseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)TablePropertyDialogSqlServerv2k5.this.cbDatabase.getSelectedItem();
            if (dataBaseSqlServer != null) {
                TablePropertyDialogSqlServerv2k5.this.cbOwner.removeAllItems();
                TablePropertyDialogSqlServerv2k5.this.cbFilegroup.removeAllItems();
                TablePropertyDialogSqlServerv2k5.this.cbTextImageFilegroup.removeAllItems();
                Iterator iterator = dataBaseSqlServer.getSchemas().iterator();
                while (iterator.hasNext()) {
                    SchemaSqlServer schemaSqlServer = (SchemaSqlServer)iterator.next();
                    TablePropertyDialogSqlServerv2k5.this.cbOwner.addItem(schemaSqlServer);
                }
                Iterator iterator2 = ((StorageObjectCollection)dataBaseSqlServer.getChild(0)).iterator();
                while (iterator2.hasNext()) {
                    FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)iterator2.next();
                    TablePropertyDialogSqlServerv2k5.this.cbFilegroup.addItem(fileGroupSqlServer);
                    TablePropertyDialogSqlServerv2k5.this.cbTextImageFilegroup.addItem(fileGroupSqlServer);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogSqlServerv2k5.this.dialog == null) {
                TablePropertyDialogSqlServerv2k5.this.dialog = new PermissionsPropertiesDialogSqlServer(TablePropertyDialogSqlServerv2k5.this.getAppView(), TablePropertyDialogSqlServerv2k5.this.getStorageDesign(), TablePropertyDialogSqlServerv2k5.this.table);
            }
            TablePropertyDialogSqlServerv2k5.this.dialog.setVisible(true);
        }
    }
}

