/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SchemaPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private SchemaSqlServer schema;
    private JComboBox cbOwner;
    private JComboBox cbSchemaObject;
    private JTextField tfDatabase;

    public SchemaPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.schema = (SchemaSqlServer)storageObject;
        this.setHeight(210);
        this.initCommentsView(70);
        this.initCommentsInRDBMS(70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertyDialogSqlServerv2k5.SchemaProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initDatabase();
        this.initSchema();
    }

    private void initDatabase() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogSqlServerv2k5.Database"));
        this.general.add(jLabel);
        this.tfDatabase = new JTextField();
        this.setBG(this.tfDatabase);
        this.tfDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogSqlServerv2k5.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initSchema() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogSqlServerv2k5.ImplementsSchema"));
        this.general.add(jLabel);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbSchemaObject, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.schema.getName());
        this.tfName.setText(this.schema.getName());
        if (this.schema != null) {
            this.fillComboItems(((DataBaseSqlServerv2k5)this.schema.getDatabase()).getUsers().toArray(), this.cbOwner);
        }
        this.cbOwner.setSelectedItem(this.schema.getOwner());
        this.tfDatabase.setText(this.schema.getDatabase().toString());
        this.taComments.setText(this.schema.getComment());
        this.taCommentsInRDBMS.setText(this.schema.getCommentInRDBMS());
        this.cbSchemaObject.setSelectedItem(this.schema.getSchemaObject());
    }

    @Override
    protected void setProperties() {
        if (this.schema != null) {
            this.schema.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.schema.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof UserSqlServer) {
                this.schema.setOwner((UserSqlServer)object);
            } else {
                this.schema.setOwner(null);
            }
            this.schema.setComment(this.taComments.getText());
            this.schema.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        }
    }
}

