/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private IndexProxySqlServerv2k5 indexProxy;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JTextField tfUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private JComboBox cbAllowRowLocks;
    private JComboBox cbAllowPageLocks;
    private JIntegerField ifMaxdop;
    private JTextField tfIndexType;
    private JComboBox cbPartitionScheme;
    private JPanel panelIncludeColumns;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel = new DefaultListModel();
    private JList allColumnsList;
    private DefaultListModel selectedColumnsModel = new DefaultListModel();
    private JButton btnUp;
    private JButton btnDown;
    private JButton btnAddColumns;
    private int preferredIconSize = 16;
    private JButton btnRemoveColumns;
    private JComboBox cbOnline;
    private JComboBox cbPartitioningColumn;
    private JComboBox cbDropExisting;

    public IndexPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.indexProxy = (IndexProxySqlServerv2k5)storageObject;
        this.setHeight(640);
        this.initCommentsView(250);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 130);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogSqlServerv2k5.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initIndexType();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPartitionScheme();
        this.initPartitioningColumn();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
        this.initAllowRowLocks();
        this.initAllowPageLocks();
        this.initMaxdop();
        this.initOnline();
        this.initDropExisting();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initIndexType() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.IndexType"));
        this.general.add(jLabel);
        this.tfIndexType = new JTextField("", 26);
        this.tfIndexType.setEditable(false);
        this.general.add(this.tfIndexType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfIndexType, 80);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Unique"));
        this.general.add(jLabel);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfUnique, 110);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbClustered, 140);
    }

    private void initFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFilegroup.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionSchemeWillBeTaken"));
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbFilegroup, 170);
    }

    private void initPartitionScheme() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(jLabel);
        this.cbPartitionScheme = new JComboBox();
        this.setBG(this.cbPartitionScheme);
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitionScheme.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionSchemeWillBeTaken"));
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbPartitionScheme, 200);
    }

    private void initPartitioningColumn() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitioningColumn"));
        this.general.add(jLabel);
        this.cbPartitioningColumn = new JComboBox();
        this.setBG(this.cbPartitioningColumn);
        this.cbPartitioningColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioningColumn);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbPartitioningColumn, 230);
    }

    private void initPadIndex() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(jLabel);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbPadIndex, 260);
    }

    private void initFillFactor() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(jLabel);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.ifFillFactor, 290);
    }

    private void initRecomputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(jLabel);
        this.cbRecomputeStatistics = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbRecomputeStatistics, 320);
    }

    private void initSortInTempDB() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.SortInTempDB"));
        this.general.add(jLabel);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbSortInTempDB, 350);
    }

    private void initIgnoreDupKey() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(jLabel);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbIgnoreDupKey, 380);
    }

    private void initAllowRowLocks() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.AllowRowLocks"));
        this.general.add(jLabel);
        this.cbAllowRowLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowRowLocks);
        this.cbAllowRowLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowRowLocks);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbAllowRowLocks, 410);
    }

    private void initAllowPageLocks() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.AllowPageLocks"));
        this.general.add(jLabel);
        this.cbAllowPageLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowPageLocks);
        this.cbAllowPageLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowPageLocks);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbAllowPageLocks, 440);
    }

    private void initMaxdop() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.MaxDop"));
        this.general.add(jLabel);
        this.ifMaxdop = new JIntegerField(0, 26);
        this.general.add(this.ifMaxdop);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.ifMaxdop, 470);
    }

    private void initOnline() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Online"));
        this.general.add(jLabel);
        this.cbOnline = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbOnline, 500);
    }

    private void initDropExisting() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.DropExisting"));
        this.general.add(jLabel);
        this.cbDropExisting = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbDropExisting);
        this.cbDropExisting.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDropExisting);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.cbDropExisting, 530);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(IndexPropertyDialogSqlServerv2k5.this.getStorageDesign().getIndexProxySet().getElements());
                arrayList.remove(IndexPropertyDialogSqlServerv2k5.this.indexProxy);
                new PropertiesPropagationDialog(IndexPropertyDialogSqlServerv2k5.this.getAppView(), IndexPropertyDialogSqlServerv2k5.this.indexProxy, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 560);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 550));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 540);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 540);
        IndexPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 530));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(416, 530));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 270);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 270));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 290);
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        Object object3;
        this.initCaption(this.indexProxy.getName());
        this.tfName.setText(this.indexProxy.getName());
        ColumnProxy[] columnProxyArray = this.indexProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            object3 = columnProxyArray[i];
            this.columnListModel.addElement(object3);
        }
        this.tfTable.setText(this.indexProxy.getTableName());
        this.tfUnique.setText(this.indexProxy.getUnique());
        if (this.indexProxy.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        this.cbFilegroup.addItem(null);
        this.cbPartitionScheme.addItem(null);
        DataBaseSqlServerv2k5 dataBaseSqlServerv2k5 = (DataBaseSqlServerv2k5)((TableProxySqlServer)this.indexProxy.getTableProxy()).getDatabase();
        if (dataBaseSqlServerv2k5 != null) {
            AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
            object3 = ((StorageObjectCollection)dataBaseSqlServerv2k5.getChild(0)).iterator();
            while (object3.hasNext()) {
                abstractStorageObjectSqlServer = (FileGroupSqlServer)object3.next();
                this.cbFilegroup.addItem(abstractStorageObjectSqlServer);
            }
            this.cbFilegroup.setSelectedItem(this.indexProxy.getFilegroup());
            object3 = dataBaseSqlServerv2k5.getPartitionFunction().iterator();
            while (object3.hasNext()) {
                abstractStorageObjectSqlServer = (PartitionFunctionSqlServerv2k5)object3.next();
                object2 = ((PartitionFunctionSqlServer)abstractStorageObjectSqlServer).getPartitionScheme().iterator();
                while (object2.hasNext()) {
                    this.cbPartitionScheme.addItem(object2.next());
                }
            }
            this.cbPartitionScheme.setSelectedItem(this.indexProxy.getPartitionScheme());
        }
        if (this.indexProxy.getExtPropsSet() != null) {
            object3 = this.indexProxy.getExtPropsSet().toArray();
            for (int i = 0; i < ((Object[])object3).length; ++i) {
                object2 = (String)object3[i];
                object = (String)object3[++i];
                Object[] objectArray = new Object[]{object2, object};
                this.model.addRow(objectArray);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getPadIndex()));
        this.ifFillFactor.setValue((long)this.indexProxy.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.indexProxy.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getIgnoreDupKey()));
        this.tfIndexType.setText(this.indexProxy.getIndexType());
        if (this.indexProxy.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.comment = this.indexProxy.getObject().getComment();
        this.commentInRDBMS = this.indexProxy.getObject().getCommentInRDBMS();
        if (this.indexProxy.isCommentChanged()) {
            this.getCommentsList().insert(this.indexProxy.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.indexProxy.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.indexProxy.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.fillComboItems(this.indexProxy.getTableProxy().getColumnProxies(), this.cbPartitioningColumn);
        this.cbPartitioningColumn.setSelectedItem(this.indexProxy.getPartitioningColumn());
        this.initColumnsSortOrder();
        this.cbAllowRowLocks.setSelectedItem(this.indexProxy.getAllowRowLocks());
        this.cbAllowPageLocks.setSelectedItem(this.indexProxy.getAllowPageLocks());
        this.ifMaxdop.setValue((long)this.indexProxy.getMaxdop());
        this.cbOnline.setSelectedItem(this.indexProxy.getOnlineChoise());
        this.cbDropExisting.setSelectedItem(this.indexProxy.getDropExisting());
        this.cbDropExisting.setEnabled(this.indexProxy.isPrimaryXmlIndex());
        object3 = (Index)this.indexProxy.getObject();
        Column[] columnArray = (Column[])this.indexProxy.getTable().getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!this.indexProxy.getIncludeColumnsSet().contains(columnArray[i].getObjectID())) continue;
            this.selectedColumnsModel.addElement(columnArray[i]);
        }
        ContainedObject[] containedObjectArray = this.indexProxy.getTable().getElements();
        object = Arrays.asList(((ContainerObject)object3).getElements());
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (this.selectedColumnsModel.contains(containedObjectArray[i]) || object.contains(containedObjectArray[i])) continue;
            this.allColumnsModel.addElement(containedObjectArray[i]);
        }
        this.initIncludeColumnsView();
        this.setEnableComponent(!this.indexProxy.isPrimaryXmlIndex());
    }

    @Override
    protected void setProperties() {
        if (this.indexProxy != null) {
            Object[] objectArray;
            Object object;
            this.indexProxy.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.indexProxy.setClustered(true);
            } else {
                this.indexProxy.setClustered(false);
            }
            this.indexProxy.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.indexProxy.setPadIndex(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.indexProxy.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.indexProxy.setSortInTempDB(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.indexProxy.setIgnoreDupKey(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.indexProxy.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.indexProxy.getFillFactor());
            this.indexProxy.setAllowRowLocks((String)this.cbAllowRowLocks.getSelectedItem());
            this.indexProxy.setAllowPageLocks((String)this.cbAllowPageLocks.getSelectedItem());
            this.indexProxy.setMaxdop(this.ifMaxdop.getIntValue());
            this.indexProxy.setPartitionScheme((PartitionSchemeSqlServer)this.cbPartitionScheme.getSelectedItem());
            this.indexProxy.setOnlineChoise((String)this.cbOnline.getSelectedItem());
            this.indexProxy.setPartitioningColumn((ColumnProxy)this.cbPartitioningColumn.getSelectedItem());
            this.indexProxy.setDropExisting((String)this.cbDropExisting.getSelectedItem());
            Object[] objectArray2 = this.model.getRows();
            this.indexProxy.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray2.length; ++i) {
                object = objectArray2[i];
                if (!(object instanceof String)) continue;
                objectArray = new StringTokenizer(object.toString(), ",");
                if (objectArray.hasMoreTokens()) {
                    string = objectArray.nextToken().trim();
                }
                if (!objectArray.hasMoreTokens()) continue;
                string2 = objectArray.nextToken().trim();
                this.indexProxy.setProps(string);
                this.indexProxy.setProps(string2);
            }
            this.applyColumnsSortOrder();
            String string3 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string3) && !this.comment.equalsIgnoreCase(string3)) {
                this.indexProxy.setComment(string3);
                this.indexProxy.setCommentChanged(true);
            } else {
                this.indexProxy.setComment("");
                this.indexProxy.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.indexProxy.setCommentInRDBMS((String)object);
                this.indexProxy.setCommentInRDBMSChanged(true);
            } else {
                this.indexProxy.setCommentInRDBMS("");
                this.indexProxy.setCommentInRDBMSChanged(false);
            }
            this.indexProxy.clear();
            objectArray = this.selectedColumnsModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Column)) continue;
                Column column = (Column)objectArray[i];
                this.indexProxy.setIncludeColumns(column.getObjectID());
            }
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.indexProxy.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.indexProxy.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }

    private void initIncludeColumnsView() {
        this.panelIncludeColumns = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.IncludeColumns"), this.panelIncludeColumns);
        this.initIncludeColumns();
    }

    private void initIncludeColumns() {
        this.initAllColumnsList();
        if (this.isEditable()) {
            this.initColumnsButtons();
        }
        this.initSelectedColumnsList();
    }

    private void initAllColumnsList() {
        JPanel jPanel = new JPanel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(180, 550));
        jPanel.add(jScrollPane);
        this.panelIncludeColumns.add((Component)jPanel, "West");
    }

    private void initSelectedColumnsList() {
        JPanel jPanel = new JPanel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(180, 550));
        jPanel.add(jScrollPane);
        this.panelIncludeColumns.add((Component)jPanel, "East");
    }

    private void initColumnsButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.Add"));
        this.btnRemoveColumns = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.Remove"));
        this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        this.btnUp.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        this.btnDown.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        jToolBar.add(this.btnAddColumns);
        jToolBar.add(this.btnRemoveColumns);
        jToolBar.addSeparator();
        jToolBar.add(this.btnUp);
        jToolBar.add(this.btnDown);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 350));
        this.panelIncludeColumns.add((Component)jPanel, "Center");
    }

    public boolean moveToIndex(Object object, int n) {
        if (this.selectedColumnsModel.contains(object) && this.selectedColumnsModel.size() > n && n >= 0) {
            this.selectedColumnsModel.removeElement(object);
            this.selectedColumnsModel.add(n, object);
            return true;
        }
        return false;
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    private List getComponentsList() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(this.tfUnique);
        arrayList.add(this.cbClustered);
        arrayList.add(this.cbFilegroup);
        arrayList.add(this.cbPartitionScheme);
        arrayList.add(this.cbPartitioningColumn);
        arrayList.add(this.panelIncludeColumns);
        return arrayList;
    }

    private void setEnableComponent(boolean bl) {
        for (JComponent jComponent : this.getComponentsList()) {
            int n = this.getPane().indexOfComponent(jComponent);
            if (n > -1) {
                this.getPane().setEnabledAt(n, bl);
                continue;
            }
            jComponent.setEnabled(bl);
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.get(n);
                    IndexPropertyDialogSqlServerv2k5.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.setSelectedIndices(nArray);
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndices();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.get(n);
                    IndexPropertyDialogSqlServerv2k5.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.setSelectedIndices(nArray);
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.contains(object)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.addElement(object);
                    IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogSqlServerv2k5.this.btnRemoveColumns.setEnabled(false);
                    IndexPropertyDialogSqlServerv2k5.this.btnUp.setEnabled(false);
                    IndexPropertyDialogSqlServerv2k5.this.btnDown.setEnabled(false);
                } else {
                    IndexPropertyDialogSqlServerv2k5.this.btnRemoveColumns.setEnabled(true);
                    IndexPropertyDialogSqlServerv2k5.this.btnUp.setEnabled(true);
                    IndexPropertyDialogSqlServerv2k5.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.contains(object)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.addElement(object);
                    IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogSqlServerv2k5.this.btnAddColumns.setEnabled(false);
                } else {
                    IndexPropertyDialogSqlServerv2k5.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexPropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                IndexPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            IndexPropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{string, string2});
            IndexPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            IndexPropertyDialogSqlServerv2k5.this.extProperties.changeSelection(IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            IndexPropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexPropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("IndexPropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return IndexPropertyDialogSqlServerv2k5.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }
}

