/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class UsedUDDTPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private UsedUserDefinedData usedUDDT;
    private JTextField tfDistinctType;
    private JTextField tfType;
    private JTextField tfNullSettings;
    private JComboBox cbDefault;
    private JComboBox cbRule;
    private JTextField tfDomain;
    private JButton buttonDomain;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JPanel panelExtProperties;
    private ExtPropertiesModel model;
    private ExtProperties extProperties;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfOwner;

    public UsedUDDTPropertyDialog(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.usedUDDT = (UsedUserDefinedData)storageObject;
        this.setHeight(300);
        this.initDefaults();
        this.initRules();
        this.initCommentsView(100);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.usedUDDT.getName());
        if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.tfDistinctType.setText(this.usedUDDT.getDistinctTypeProxy().getName());
            this.tfNullSettings.setText(this.usedUDDT.getDistinctTypeProxy().getNullType());
        }
        this.cbDefault.setSelectedItem(this.usedUDDT.getDefaultObject());
        this.cbRule.setSelectedItem(this.usedUDDT.getRuleObject());
        if (this.usedUDDT.getUserDefinedType() != null) {
            this.tfDomain.setText(this.usedUDDT.getUserDefinedType().getDomain());
            this.tfNullSettings.setText(this.usedUDDT.getUserDefinedType().getNullType());
        }
        this.tfDistinctType.setEnabled(this.usedUDDT.isBaseOnDistinctType());
        this.buttonDomain.setEnabled(!this.usedUDDT.isBaseOnDistinctType());
        this.tfDomain.setEnabled(!this.usedUDDT.isBaseOnDistinctType());
        this.tfType.setText(this.usedUDDT.getDataTypeString());
        if (this.usedUDDT.getSchema() != null) {
            this.tfOwner.setText(this.usedUDDT.getSchema().getName());
        }
        if (this.usedUDDT.getExtPropsSet() != null) {
            Object[] objectArray = this.usedUDDT.getExtPropsSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
        if (this.usedUDDT.isBaseOnDistinctType()) {
            this.insertDTComment();
        } else {
            this.insertDomainComment();
        }
    }

    private void insertDTComment() {
        this.comment = this.usedUDDT.getDistinctTypeProxy().getDistinctType().getComment();
        this.commentInRDBMS = this.usedUDDT.getDistinctTypeProxy().getDistinctType().getCommentInRDBMS();
        if (this.usedUDDT.getDistinctTypeProxy().isCommentChanged()) {
            this.getCommentsList().insert(this.usedUDDT.getDistinctTypeProxy().getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.usedUDDT.getDistinctTypeProxy().isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.usedUDDT.getDistinctTypeProxy().getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void insertDomainComment() {
        this.comment = this.usedUDDT.getUserDefinedType().getComment();
        this.commentInRDBMS = this.usedUDDT.getUserDefinedType().getCommentInRDBMS();
        this.taComments.insert(this.comment, 0);
        this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
    }

    @Override
    protected void setProperties() {
        this.usedUDDT.setName(this.tfName.getText());
        this.usedUDDT.setDefaultObject((DefaultSqlServer)this.cbDefault.getSelectedItem());
        this.usedUDDT.setRuleObject((RuleSqlServer)this.cbRule.getSelectedItem());
        Object[] objectArray = this.model.getRows();
        this.usedUDDT.clear();
        String string = null;
        String string2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof String)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken().trim();
            this.usedUDDT.setProps(string);
            this.usedUDDT.setProps(string2);
        }
        this.setDTComment();
    }

    private void setDTComment() {
        String string = this.getCommentsList().getText();
        if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
            if (this.usedUDDT.getDistinctTypeProxy() != null) {
                this.usedUDDT.getDistinctTypeProxy().setComment(string);
                this.usedUDDT.getDistinctTypeProxy().setCommentChanged(true);
            } else {
                this.usedUDDT.getUserDefinedType().setComment(string);
            }
        } else if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.usedUDDT.getDistinctTypeProxy().setComment("");
            this.usedUDDT.getDistinctTypeProxy().setCommentChanged(false);
        } else {
            this.usedUDDT.getUserDefinedType().setComment("");
        }
        String string2 = this.taCommentsInRDBMS.getText();
        if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
            if (this.usedUDDT.getDistinctTypeProxy() != null) {
                this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMS(string2);
                this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMSChanged(true);
            } else {
                this.usedUDDT.getUserDefinedType().setCommentInRDBMS(string2);
            }
        } else if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMS("");
            this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMSChanged(false);
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDistinctType();
        this.initOwner();
        this.initType();
        this.initNullSettings();
        this.initDomains();
    }

    private void initDistinctType() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.DistinctType"));
        this.general.add(jLabel);
        this.tfDistinctType = new JTextField();
        this.tfDistinctType.setEditable(false);
        this.setBG(this.tfDistinctType);
        this.tfDistinctType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDistinctType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDistinctType, 50);
    }

    private void initDomains() {
        this.buttonDomain = new JButton("...");
        this.buttonDomain.setPreferredSize(new Dimension(30, 20));
        this.buttonDomain.setToolTipText(Messages.getString("UsedUDDTPropertyDialog.DomainProperties"));
        this.buttonDomain.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(this.buttonDomain);
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Domain"));
        this.general.add(jLabel);
        this.tfDomain = new JTextField();
        this.tfDomain.setEditable(false);
        this.setBG(this.tfDomain);
        this.tfDomain.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.tfDomain);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfDomain, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.setObjectConstraints(this.buttonDomain, 80);
        this.buttonDomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Domain domain = UsedUDDTPropertyDialog.this.usedUDDT.getUserDefinedType().getDomainObj();
                if (domain != null && domain instanceof Domain) {
                    Domain domain2 = domain;
                    domain2.showPropertyDialog();
                }
            }
        });
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Schema"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField();
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOwner.setEditable(false);
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Type"));
        this.general.add(jLabel);
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.tfName.getPreferredSize());
        this.tfType.setEditable(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfType, 140);
    }

    private void initNullSettings() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.NullSettings"));
        this.general.add(jLabel);
        this.tfNullSettings = new JTextField();
        this.tfNullSettings.setEditable(false);
        this.tfNullSettings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfNullSettings);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfNullSettings, 170);
    }

    private void initDefaults() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Default"));
        this.general.add(jLabel);
        this.cbDefault = new JComboBox();
        this.fillComboItems(this.usedUDDT.getDatabase().getDefaults().toArray(), this.cbDefault);
        this.cbDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefault);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbDefault, 200);
    }

    private void initRules() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Rule"));
        this.general.add(jLabel);
        this.cbRule = new JComboBox();
        this.fillComboItems(this.usedUDDT.getDatabase().getRules().toArray(), this.cbRule);
        this.cbRule.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRule);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbRule, 230);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("UsedUDDTPropertyDialog.Add"));
        this.bnRemoveProperty = new JButton(Messages.getString("UsedUDDTPropertyDialog.Remove"));
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 250);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 90, 250);
        UsedUDDTPropertyDialog.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UsedUDDTPropertyDialog.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 230));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(445, 240));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("UsedUDDTPropertyDialog.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 120);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(this.getPane().getPreferredSize().width - 25, 120));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 140);
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("UsedUDDTPropertyDialog.PropertyName"), Messages.getString("UsedUDDTPropertyDialog.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (UsedUDDTPropertyDialog.this.model.getRowCount() >= 1) {
                for (int i = UsedUDDTPropertyDialog.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!UsedUDDTPropertyDialog.this.extProperties.isRowSelected(i)) continue;
                    UsedUDDTPropertyDialog.this.model.removeRow(i);
                }
                UsedUDDTPropertyDialog.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            UsedUDDTPropertyDialog.this.model.addRow(new Object[]{string, string2});
            UsedUDDTPropertyDialog.this.extProperties.updateUI();
            UsedUDDTPropertyDialog.this.extProperties.changeSelection(UsedUDDTPropertyDialog.this.model.getRowCount() - 1, 0, false, false);
            UsedUDDTPropertyDialog.this.extProperties.requestFocus();
        }
    }
}

