/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class UniquePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private UniqueProxySqlServer ukey;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public UniquePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.ukey = (UniqueProxySqlServer)storageObject;
        this.setHeight(200);
        this.initCommentsView(60);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UniquePropertyDialogSqlServer.UniqueProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initClustered();
        this.initFileGroup();
        this.initFillFactor();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServer.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServer.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServer.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initFillFactor() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServer.FillFactor"));
        this.general.add(jLabel);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifFillFactor, 140);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniquePropertyDialogSqlServer.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("UniquePropertyDialogSqlServer.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 80);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 60));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 100);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.ukey.getName());
        this.tfName.setText(this.ukey.getName());
        ColumnProxy[] columnProxyArray = this.ukey.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            object = columnProxyArray[i];
            this.columnListModel.addElement(object);
        }
        this.tfTable.setText(this.ukey.getTableName());
        if (this.ukey.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        if (((TableProxySqlServer)this.ukey.getTableProxy()).existClusteredIndex(this.ukey)) {
            this.cbClustered.setEnabled(false);
        } else {
            this.cbClustered.setEnabled(true);
        }
        DataBaseSqlServer dataBaseSqlServer = ((TableProxySqlServer)this.ukey.getTableProxy()).getDatabase();
        if (dataBaseSqlServer != null) {
            object = ((StorageObjectCollection)dataBaseSqlServer.getChild(0)).iterator();
            while (object.hasNext()) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)object.next();
                this.cbFilegroup.addItem(fileGroupSqlServer);
            }
        }
        this.ifFillFactor.setValue((long)this.ukey.getFillFactor());
        this.comment = this.ukey.getObject().getComment();
        this.commentInRDBMS = this.ukey.getObject().getCommentInRDBMS();
        if (this.ukey.isCommentChanged()) {
            this.getCommentsList().insert(this.ukey.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.ukey.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.ukey.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.ukey != null) {
            this.ukey.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.ukey.setClustered(true);
            } else {
                this.ukey.setClustered(false);
            }
            if (((TableProxySqlServer)this.ukey.getTableProxy()).existClusteredIndex(this.ukey)) {
                this.cbClustered.setEnabled(false);
            } else {
                this.cbClustered.setEnabled(true);
            }
            this.ukey.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.ukey.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.ukey.getFillFactor());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.ukey.setComment(string);
                this.ukey.setCommentChanged(true);
            } else {
                this.ukey.setComment("");
                this.ukey.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.ukey.setCommentInRDBMS(string2);
                this.ukey.setCommentInRDBMSChanged(true);
            } else {
                this.ukey.setCommentInRDBMS("");
                this.ukey.setCommentInRDBMSChanged(false);
            }
            this.applyColumnsSortOrder();
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("UniquePropertyDialogSqlServer.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.ukey.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.ukey.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }
}

