/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SynonymPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private JComboBox cbOwner;
    private SynonymSqlServer synonym;

    public SynonymPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.synonym = (SynonymSqlServer)storageObject;
        this.setHeight(120);
        this.initCommentsView();
        this.initOwner();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SynonymPropertyDialogSqlServer.SynonymProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.synonym.getName());
        this.tfName.setText(this.synonym.getName());
        this.selectObject(this.cbOwner, this.synonym.getSchema());
        this.getCommentsList().insert(this.synonym.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.synonym != null) {
            this.synonym.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof SchemaSqlServer) {
                this.synonym.setSchema((SchemaSqlServer)object);
            } else {
                this.synonym.setSchema(null);
            }
            this.synonym.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogSqlServer.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            if (this.synonym.getTable() != null) {
                this.fillComboItems(this.synonym.getTable().getDatabase().getSchemas().toArray(), this.cbOwner);
            } else if (this.synonym.getProcedure() != null) {
                this.fillComboItems(this.synonym.getProcedure().getDatabase().getSchemas().toArray(), this.cbOwner);
            } else if (this.synonym.getView() != null) {
                this.fillComboItems(this.synonym.getView().getDataBase().getSchemas().toArray(), this.cbOwner);
            }
        }
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }
}

