/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.UserAndRolePermissionsDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RolePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private RoleSqlServer role;
    private ButtonGroup bGroup;
    private JRadioButton rbIsApplication;
    private JRadioButton rbIsDB;
    private JPasswordField passField;
    private JComboBox cbOwner;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel panelPrivileges;
    private JList allPrivilegesList;
    private JList selectedPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private DefaultListModel selectedPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogSqlServer dialog;

    public RolePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.role = (RoleSqlServer)storageObject;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertyDialogSqlServer.RoleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.bGroup = new ButtonGroup();
        this.initIsApplRole();
        this.initPassword();
        this.initIsDBRole();
        this.initUsers();
        this.initOwner();
        this.initPermissionsButton();
    }

    private void initPassword() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.Password"));
        this.general.add(jLabel);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.AllUsers"));
        this.general.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getUsersLayout(), jLabel, 12, 184);
        this.setObjectConstraints(this.getUsersLayout(), jScrollPane, 10, 202);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.SelectedUsers"));
        this.general.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getUsersLayout(), jLabel, 267, 184);
        this.setObjectConstraints(this.getUsersLayout(), jScrollPane, 265, 202);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("RolePropertyDialogSqlServer.Add"));
        this.bnAdd.addActionListener(new AddUsersActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getUsersLayout(), this.bnAdd, 160, 235);
        this.bnRemove = new JButton(Messages.getString("RolePropertyDialogSqlServer.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveUsersActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getUsersLayout(), this.bnRemove, 160, 265);
        RolePropertyDialogSqlServer.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getUsersLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    private void setIsApplication(boolean bl) {
        this.passField.setEnabled(bl);
        this.allUsersList.setEnabled(!bl);
        this.selectedUsersList.setEnabled(!bl);
        this.cbOwner.setEnabled(!bl);
    }

    private void setIsDB(boolean bl) {
        this.passField.setEnabled(!bl);
        this.allUsersList.setEnabled(bl);
        this.selectedUsersList.setEnabled(bl);
        this.cbOwner.setEnabled(bl);
    }

    private void initIsApplRole() {
        this.rbIsApplication = new JRadioButton(Messages.getString("RolePropertyDialogSqlServer.ApplicationRole"));
        this.rbIsApplication.addActionListener(new AppRoleListener());
        this.bGroup.add(this.rbIsApplication);
        this.general.add(this.rbIsApplication);
        this.setObjectConstraints(this.rbIsApplication, 8, 50);
    }

    private void initIsDBRole() {
        this.rbIsDB = new JRadioButton(Messages.getString("RolePropertyDialogSqlServer.DatabaseRole"));
        this.rbIsDB.addActionListener(new DBRoleListener());
        this.bGroup.add(this.rbIsDB);
        this.general.add(this.rbIsDB);
        this.setObjectConstraints(this.rbIsDB, 8, 120);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 150);
        this.setObjectConstraints(this.cbOwner, 150);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("RolePropertyDialogSqlServer.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 340);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.panelPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogSqlServer.Privileges"), this.panelPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServer.Add"));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnAddPrivileges, 160, 160);
        this.bnRemovePrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServer.Remove"));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnRemovePrivileges, 160, 190);
        RolePropertyDialogSqlServer.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllPrivilegesList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.AllPrivileges"));
        this.panelPrivileges.add(jLabel);
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(144, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(jScrollPane);
        this.setLabelConstraints(this.getPrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedPrivilegesList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServer.SelectedPrivileges"));
        this.panelPrivileges.add(jLabel);
        this.selectedPrivilegesModel = new DefaultListModel();
        this.selectedPrivilegesList = new JList(this.selectedPrivilegesModel);
        ListSelectionModel listSelectionModel = this.selectedPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(145, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(jScrollPane);
        this.setLabelConstraints(this.getPrivilegesLayout(), jLabel, 267, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), jScrollPane, 265, 32);
    }

    protected SpringLayout getPrivilegesLayout() {
        return (SpringLayout)this.panelPrivileges.getLayout();
    }

    @Override
    public void initProperties() {
        Object[] objectArray;
        this.initCaption(this.role.getName());
        this.tfName.setText(this.role.getName());
        this.rbIsApplication.setSelected(this.role.getIsApplicationRole());
        this.passField.setText(this.role.decodePassword());
        this.rbIsDB.setSelected(!this.role.getIsApplicationRole());
        Iterator iterator = this.role.getDatabase().getUsers().iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (objectArray.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(objectArray);
        }
        this.cbOwner.setSelectedItem(this.role.getOwner());
        objectArray = this.role.getDatabase().getUsers().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UserSqlServer userSqlServer = (UserSqlServer)objectArray[i];
            if (userSqlServer.getName().equalsIgnoreCase("GUEST")) continue;
            if (this.role.getUserSet().contains(userSqlServer.getName())) {
                this.addElementToSortedListModel(this.selectedUsersModel, userSqlServer);
                continue;
            }
            this.addElementToSortedListModel(this.allUsersModel, userSqlServer);
        }
        this.passField.setEnabled(this.role.getIsApplicationRole());
        this.allUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.selectedUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.cbOwner.setEnabled(!this.role.getIsApplicationRole());
        if (this.role.isNullInstance()) {
            this.tfName.setEnabled(false);
            this.rbIsApplication.setEnabled(false);
            this.passField.setEnabled(false);
            this.rbIsDB.setEnabled(false);
            this.cbOwner.setEnabled(false);
            this.allUsersList.setEnabled(false);
            this.selectedUsersList.setEnabled(false);
            this.selectedPrivilegesList.setEnabled(false);
            this.allPrivilegesList.setEnabled(false);
        }
        String[] stringArray = (String[])UserSqlServer.getPrivilegesValues().toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.role.getPrivilegesSet().contains(string)) {
                this.addElementToSortedListModel(this.selectedPrivilegesModel, string);
                continue;
            }
            this.addElementToSortedListModel(this.allPrivilegesModel, string);
        }
        this.getCommentsList().insert(this.role.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.role != null) {
            this.role.setName(this.tfName.getText());
            this.role.setIsApplicationRole(this.rbIsApplication.isSelected());
            this.role.encodePassword(String.valueOf(this.passField.getPassword()));
            this.role.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.role.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof UserSqlServer)) continue;
                this.role.setUsers(((UserSqlServer)object).getName());
            }
            Object[] objectArray2 = this.selectedPrivilegesModel.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                if (!(object instanceof String)) continue;
                this.role.setSystemPrivileges((String)object);
            }
            this.role.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private SelectedPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.allPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServer.this.selectedPrivilegesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServer.this.selectedPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServer.this.allPrivilegesModel.contains(object)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.allPrivilegesModel, object);
                    RolePropertyDialogSqlServer.this.selectedPrivilegesModel.removeElement(object);
                }
            }
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServer.this.allPrivilegesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServer.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServer.this.selectedPrivilegesModel.contains(object)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.selectedPrivilegesModel, object);
                    RolePropertyDialogSqlServer.this.allPrivilegesModel.removeElement(object);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RolePropertyDialogSqlServer.this.dialog == null) {
                RolePropertyDialogSqlServer.this.dialog = new UserAndRolePermissionsDialogSqlServer(RolePropertyDialogSqlServer.this.getAppView(), RolePropertyDialogSqlServer.this.getStorageDesign(), RolePropertyDialogSqlServer.this.role);
            }
            RolePropertyDialogSqlServer.this.dialog.showDialog();
        }
    }

    private class DBRoleListener
    implements ActionListener {
        private DBRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RolePropertyDialogSqlServer.this.setIsDB(RolePropertyDialogSqlServer.this.rbIsDB.isSelected());
        }
    }

    private class AppRoleListener
    implements ActionListener {
        private AppRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RolePropertyDialogSqlServer.this.setIsApplication(RolePropertyDialogSqlServer.this.rbIsApplication.isSelected());
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.selectedUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnRemove.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServer.this.allUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServer.this.bnAdd.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServer.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServer.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServer.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServer.this.allUsersModel.contains(object)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.allUsersModel, object);
                    RolePropertyDialogSqlServer.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServer.this.allUsersModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServer.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServer.this.selectedUsersModel.contains(object)) continue;
                    RolePropertyDialogSqlServer.this.addElementToSortedListModel(RolePropertyDialogSqlServer.this.selectedUsersModel, object);
                    RolePropertyDialogSqlServer.this.allUsersModel.removeElement(object);
                }
            }
        }
    }
}

