/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PartitionSchemePropertyDialog
extends AbstractSqlServerPropertyDialog {
    private PartitionSchemeSqlServer partScheme;
    private JComboBox cbMappingType;
    private JPanel panelBoundaryValues;
    private BoundaryValuesModel model;
    private JTextField tfPartFunction;
    private JComboBox cbSingleFGroup;
    private JPanel pMappingTable;
    private TypesTable mappingTable;
    private TypesTableModel modelMappingTable;
    private DataBaseSqlServer database;
    public JComboBox cbox1;

    public PartitionSchemePropertyDialog(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partScheme = (PartitionSchemeSqlServer)storageObject;
        this.database = this.partScheme.getPartitionFunction().getDatabase();
        this.setHeight(200);
        this.initGeneral();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initPartitionFunction();
        this.initMappingType();
        this.initSingleFileGroup();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.partScheme.getName());
        this.tfPartFunction.setText(this.partScheme.getPartitionFunction().getName());
        this.cbMappingType.setSelectedItem(this.partScheme.getMappingType());
        this.cbSingleFGroup.setSelectedItem(this.partScheme.getSingleFileGroup());
        this.fillComboItems(this.database.getFilegroups().toArray(), this.cbox1, (Object)null);
        this.cbox1.insertItemAt(" ", 0);
        this.getCommentsList().insert(this.partScheme.getComment(), 0);
        if (this.partScheme.getPartitionFunction().getBValuesSet() != null) {
            Object[] objectArray = this.partScheme.getPartitionFunction().getBValuesSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2;
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                String string3 = " ";
                if (this.partScheme.getMappingTableSet() != null && i < (objectArray2 = this.partScheme.getMappingTableSet().toArray()).length) {
                    string3 = (String)objectArray2[i];
                }
                this.modelMappingTable.addRow(new Object[]{string, string3, string2});
            }
            String string = " ";
            if (this.partScheme.getMappingTableSet().contains("MAXVALUE")) {
                string = (String)this.partScheme.getMappingTableSet().lastElement();
            }
            this.modelMappingTable.addRow(new Object[]{"MAXVALUE", string, " "});
        }
    }

    @Override
    protected void setProperties() {
        this.partScheme.setName(this.tfName.getText());
        this.partScheme.setMappingType((String)this.cbMappingType.getSelectedItem());
        if (this.cbSingleFGroup.isEnabled()) {
            this.partScheme.setSingleFileGroup((FileGroupSqlServer)this.cbSingleFGroup.getSelectedItem());
        } else {
            this.partScheme.setSingleFileGroup(null);
        }
        this.partScheme.clear();
        this.modelMappingTable.initMappingTablePair();
        this.partScheme.setComment(this.getCommentsList().getText());
    }

    private void initPartitionFunction() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionSchemePropertyDialog.PartitionFunction"));
        this.general.add(jLabel);
        this.tfPartFunction = new JTextField();
        this.tfPartFunction.setPreferredSize(this.tfName.getPreferredSize());
        this.tfPartFunction.setEditable(false);
        this.general.add(this.tfPartFunction);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfPartFunction, 50);
    }

    private void initMappingType() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionSchemePropertyDialog.MappingType"));
        this.general.add(jLabel);
        this.cbMappingType = new JComboBox<String>(PartitionSchemeSqlServer.getMapTypeChoices());
        this.cbMappingType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMappingType.setEditable(false);
        this.cbMappingType.addActionListener(new MappingTypeListener());
        this.general.add(this.cbMappingType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbMappingType, 80);
    }

    private void initSingleFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionSchemePropertyDialog.SingleFileGroup"));
        this.general.add(jLabel);
        this.cbSingleFGroup = new JComboBox();
        this.cbSingleFGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.fillComboItems(this.getFileGroups(), this.cbSingleFGroup);
        this.cbSingleFGroup.setEnabled(this.partScheme.isSingleFileGroupSelected());
        this.general.add(this.cbSingleFGroup);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbSingleFGroup, 110);
    }

    private Object[] getFileGroups() {
        if (this.database != null) {
            return this.database.getFilegroups().toArray();
        }
        return new Object[0];
    }

    private void initMappingTable() {
        this.pMappingTable = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PartitionSchemePropertyDialog.PartitionMappingTable"), this.pMappingTable);
        this.mappingTable = new TypesTable();
        this.mappingTable.setPreferredScrollableViewportSize(new Dimension(410, 150));
        JScrollPane jScrollPane = new JScrollPane(this.mappingTable);
        this.modelMappingTable = (TypesTableModel)this.mappingTable.getModel();
        this.setBG(this.mappingTable);
        this.pMappingTable.add(jScrollPane);
    }

    @Override
    protected void addTabs() {
        this.initMappingTable();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelBoundaryValues.getLayout();
    }

    class TypesTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("PartitionSchemePropertyDialog.BoundaryValue"), Messages.getString("PartitionSchemePropertyDialog.FileGroup"), Messages.getString("PartitionSchemePropertyDialog.Comments")};

        public TypesTableModel() {
            this.addTableModelListener(this);
        }

        public void initMappingTablePair() {
            int n = PartitionSchemePropertyDialog.this.modelMappingTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                PartitionSchemePropertyDialog.this.partScheme.setMappingTable((String)this.getValueAt(i, 0));
                Object object = this.getValueAt(i, 1);
                if (object != null) {
                    PartitionSchemePropertyDialog.this.partScheme.setMappingTable(object.toString());
                    continue;
                }
                PartitionSchemePropertyDialog.this.partScheme.setMappingTable(" ");
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PartitionSchemePropertyDialog.this.isEditable()) {
                return false;
            }
            return n2 == 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            if (this.getValueAt(0, n) != null) {
                return this.getValueAt(0, n).getClass();
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
        }
    }

    class TypesTable
    extends JTable {
        TypesTableModel dataModel;

        public TypesTable() {
            this.dataModel = new TypesTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setCellRenderer(new UsersTableCellRenderer());
            tableColumnModel.getColumn(2).setCellRenderer(new UsersTableCellRenderer());
            tableColumnModel.getColumn(1).setCellEditor(new SchemaComboBoxEditor());
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(100);
                    continue;
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(150);
                    continue;
                }
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    public class SchemaComboBoxEditor
    extends DefaultCellEditor {
        public SchemaComboBoxEditor() {
            super(new JComboBox());
            PartitionSchemePropertyDialog.this.cbox1 = (JComboBox)this.getComponent();
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    public class MappingTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PartitionSchemePropertyDialog.this.getPane().indexOfComponent(PartitionSchemePropertyDialog.this.pMappingTable);
            if (PartitionSchemePropertyDialog.this.cbMappingType.getSelectedItem().toString().equalsIgnoreCase("SINGLE FILE GROUP")) {
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setEnabled(true);
                PartitionSchemePropertyDialog.this.partScheme.clear();
                PartitionSchemePropertyDialog.this.getPane().setEnabledAt(n, false);
            } else {
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setEnabled(false);
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setSelectedIndex(0);
                PartitionSchemePropertyDialog.this.getPane().setEnabledAt(n, true);
            }
        }
    }

    class BoundaryValuesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("PartitionSchemePropertyDialog.BoundaryValue"), Messages.getString("PartitionSchemePropertyDialog.Comment")};

        BoundaryValuesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }
}

