/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PartitionFunctionPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private PartitionFunctionSqlServer partFunction;
    private JTextField tfInputType;
    private JComboBox cbRangeType;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JPanel panelBoundaryValues;
    private BoundaryValuesModel model;
    private BoundaryValues boundaryValues;

    public PartitionFunctionPropertyDialog(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partFunction = (PartitionFunctionSqlServer)storageObject;
        this.setHeight(200);
        this.initGeneral();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initInputType();
        this.initRangeType();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.partFunction.getName());
        this.tfInputType.setText(this.partFunction.getInputType());
        this.cbRangeType.setSelectedItem(this.partFunction.getRangeType());
        this.getCommentsList().insert(this.partFunction.getComment(), 0);
        if (this.partFunction.getBValuesSet() != null) {
            Object[] objectArray = this.partFunction.getBValuesSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
    }

    @Override
    protected void setProperties() {
        this.partFunction.setName(this.tfName.getText());
        this.partFunction.setInputType(this.tfInputType.getText());
        this.partFunction.setRangeType((String)this.cbRangeType.getSelectedItem());
        this.partFunction.setComment(this.getCommentsList().getText());
        this.partFunction.clear();
        this.model.initPropSet();
    }

    private void initInputType() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionFunctionPropertyDialog.InputType"));
        this.general.add(jLabel);
        this.tfInputType = new JTextField();
        this.tfInputType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfInputType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfInputType, 50);
    }

    private void initRangeType() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionFunctionPropertyDialog.RangeType"));
        this.general.add(jLabel);
        this.cbRangeType = new JComboBox<String>(PartitionFunctionSqlServer.getLEFT_RIGHT());
        this.cbRangeType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbRangeType.setEditable(false);
        this.general.add(this.cbRangeType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbRangeType, 80);
    }

    @Override
    protected void addTabs() {
        this.initBoundaryValues();
    }

    private void initBoundaryValues() {
        this.initAllBoundaryValues();
        this.initBoundaryValuesButtons();
    }

    private void initBoundaryValuesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("PartitionFunctionPropertyDialog.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("PartitionFunctionPropertyDialog.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddBoundaryValuesActionListener());
        this.panelBoundaryValues.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 145);
        this.bnRemoveProperty.addActionListener(new RemoveUsersActionListener());
        this.panelBoundaryValues.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 145);
        PartitionFunctionPropertyDialog.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllBoundaryValues() {
        this.panelBoundaryValues = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PartitionFunctionPropertyDialog.BoundaryValues"), this.panelBoundaryValues);
        this.boundaryValues = new BoundaryValues();
        this.boundaryValues.setPreferredScrollableViewportSize(new Dimension(414, 135));
        JScrollPane jScrollPane = new JScrollPane(this.boundaryValues);
        jScrollPane.setPreferredSize(new Dimension(414, 140));
        this.model = (BoundaryValuesModel)this.boundaryValues.getModel();
        this.setBG(this.boundaryValues);
        this.panelBoundaryValues.add(jScrollPane);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelBoundaryValues.getLayout();
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PartitionFunctionPropertyDialog.this.model.getRowCount() >= 1) {
                Iterator iterator = PartitionFunctionPropertyDialog.this.partFunction.getPartitionScheme().iterator();
                String string = (String)PartitionFunctionPropertyDialog.this.model.getValueAt(PartitionFunctionPropertyDialog.this.model.getRowCount() - 1, 0);
                while (iterator.hasNext()) {
                    PartitionSchemeSqlServer partitionSchemeSqlServer = (PartitionSchemeSqlServer)iterator.next();
                    partitionSchemeSqlServer.removeBoundaruValue(string);
                }
                PartitionFunctionPropertyDialog.this.model.removeRow(PartitionFunctionPropertyDialog.this.model.getRowCount() - 1);
            }
        }
    }

    class BoundaryValuesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("PartitionFunctionPropertyDialog.BoundaryValue"), Messages.getString("PartitionFunctionPropertyDialog.Comment")};

        BoundaryValuesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return PartitionFunctionPropertyDialog.this.isEditable();
        }

        public void initPropSet() {
            int n = PartitionFunctionPropertyDialog.this.model.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (((String)this.getValueAt(i, 0)).equalsIgnoreCase("")) continue;
                PartitionFunctionPropertyDialog.this.partFunction.setBoundaryValues((String)this.getValueAt(i, 0));
                PartitionFunctionPropertyDialog.this.partFunction.setBoundaryValues((String)this.getValueAt(i, 1));
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    class BoundaryValues
    extends JTable {
        BoundaryValuesModel dataModel;

        public BoundaryValues() {
            this.dataModel = new BoundaryValuesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new BoundaryValuesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class BoundaryValuesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BoundaryValuesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class AddBoundaryValuesActionListener
    implements ActionListener {
        private AddBoundaryValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            PartitionFunctionPropertyDialog.this.model.addRow(new Object[]{string, string2});
        }
    }
}

