/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectLogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class InstanceDescriptorColumnPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private InstanceDescriptorColumnSqlServer instDescriptor;
    private JButton bnLogicalType;
    private ButtonGroup bGroup;
    private JRadioButton rbLogicalType;
    private JRadioButton rbDistinctType;
    private JRadioButton rbStructuredType;
    private SelectLogicalTypeDialog logicalDialog = null;
    private JComboBox cbDistinctType;
    private JComboBox cbStructuredType;
    private JCheckBox chbReference;

    public InstanceDescriptorColumnPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.instDescriptor = (InstanceDescriptorColumnSqlServer)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
    }

    @Override
    public String getCaption() {
        return Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.InstanceDescriptorColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.bGroup = new ButtonGroup();
        this.initLogicalType();
        this.initDistinctType();
        this.initStructuredType();
    }

    private void initLogicalType() {
        this.rbLogicalType = new JRadioButton(Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.LogicalType"));
        this.rbLogicalType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbLogicalType);
        this.general.add(this.rbLogicalType);
        this.setObjectConstraints(this.rbLogicalType, 8, 50);
        this.bnLogicalType = new JButton(Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.Logical"));
        this.bnLogicalType.setPreferredSize(new Dimension(229, 20));
        this.bnLogicalType.setHorizontalAlignment(0);
        this.general.add(this.bnLogicalType);
        this.setObjectConstraints(this.bnLogicalType, 175, 50);
    }

    private void initDistinctType() {
        this.rbDistinctType = new JRadioButton(Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.DistinctType"));
        this.rbDistinctType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbDistinctType);
        this.general.add(this.rbDistinctType);
        this.setObjectConstraints(this.rbDistinctType, 8, 80);
        this.cbDistinctType = new JComboBox();
        this.cbDistinctType.setPreferredSize(new Dimension(229, 20));
        this.cbDistinctType.setMaximumRowCount(8);
        this.cbDistinctType.setBackground(Color.WHITE);
        this.general.add(this.cbDistinctType);
        this.setObjectConstraints(this.cbDistinctType, 175, 80);
    }

    private void initStructuredType() {
        this.rbStructuredType = new JRadioButton(Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.StructuredType"));
        this.rbStructuredType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbStructuredType);
        this.general.add(this.rbStructuredType);
        this.setObjectConstraints(this.rbStructuredType, 8, 110);
        this.cbStructuredType = new JComboBox();
        this.cbStructuredType.setPreferredSize(new Dimension(229, 20));
        this.cbStructuredType.setMaximumRowCount(8);
        this.cbStructuredType.setBackground(Color.WHITE);
        this.general.add(this.cbStructuredType);
        this.setObjectConstraints(this.cbStructuredType, 175, 110);
        this.chbReference = new JCheckBox(Messages.getString("InstanceDescriptorColumnPropertyDialogSqlServer.Reference"));
        this.general.add(this.chbReference);
        this.setObjectConstraints(this.chbReference, 175, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.instDescriptor.getName());
        this.tfName.setText(this.instDescriptor.getName());
        this.cbDistinctType.removeAllItems();
        this.cbStructuredType.removeAllItems();
        if (this.instDescriptor.getType() instanceof LogicalDatatype) {
            this.bnLogicalType.setText(this.instDescriptor.formatDataType());
        } else {
            this.bnLogicalType.setText(this.instDescriptor.getDesign().getLogicalDatatypeSet().getDefaultType().getName());
        }
        this.bnLogicalType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstanceDescriptorColumnPropertyDialogSqlServer.this.logicalDialog = new SelectLogicalTypeDialog(InstanceDescriptorColumnPropertyDialogSqlServer.this.getAppView(), InstanceDescriptorColumnPropertyDialogSqlServer.this.instDescriptor, InstanceDescriptorColumnPropertyDialogSqlServer.this.bnLogicalType, InstanceDescriptorColumnPropertyDialogSqlServer.this.instDescriptor.getSelectedRDBMSType().getName(), false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.logicalDialog.initProperties();
                InstanceDescriptorColumnPropertyDialogSqlServer.this.logicalDialog.show();
            }
        });
        Iterator iterator = this.getStorageObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbDistinctType.addItem(iterator.next());
        }
        if (this.instDescriptor.getType() instanceof DistinctType) {
            this.cbDistinctType.setSelectedItem(this.instDescriptor.getType());
        }
        iterator = this.getStorageObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            this.cbStructuredType.addItem(iterator.next());
        }
        if (this.instDescriptor.getType() instanceof StructuredType) {
            this.cbStructuredType.setSelectedItem(this.instDescriptor.getType());
        }
        if (this.instDescriptor.getType() instanceof LogicalDatatype) {
            this.bnLogicalType.setEnabled(true);
            this.cbDistinctType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbLogicalType.setSelected(true);
        } else if (this.instDescriptor.getType() instanceof DistinctType) {
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(true);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbDistinctType.setSelected(true);
        } else if (this.instDescriptor.getType() instanceof StructuredType) {
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbStructuredType.setEnabled(true);
            this.chbReference.setEnabled(true);
            this.chbReference.setSelected(this.instDescriptor.isReference());
            this.rbStructuredType.setSelected(true);
        } else {
            this.bnLogicalType.setEnabled(true);
            this.cbDistinctType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.rbLogicalType.setSelected(true);
        }
        this.getCommentsList().insert(this.instDescriptor.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.instDescriptor != null) {
            this.instDescriptor.setName(this.tfName.getText());
            if (this.rbDistinctType.isSelected()) {
                this.instDescriptor.setSize("");
                this.instDescriptor.setPrecision(0);
                this.instDescriptor.setScale(0);
                this.instDescriptor.setType((DesignObject)this.cbDistinctType.getSelectedItem());
            } else if (this.rbStructuredType.isSelected()) {
                this.instDescriptor.setSize("");
                this.instDescriptor.setPrecision(0);
                this.instDescriptor.setScale(0);
                this.instDescriptor.setType((DesignObject)this.cbStructuredType.getSelectedItem());
                this.instDescriptor.setReference(this.chbReference.isSelected());
            }
            this.instDescriptor.setComment(this.getCommentsList().getText());
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InstanceDescriptorColumnPropertyDialogSqlServer.this.rbLogicalType.isSelected()) {
                InstanceDescriptorColumnPropertyDialogSqlServer.this.bnLogicalType.setEnabled(true);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbDistinctType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbStructuredType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setSelected(false);
            } else if (InstanceDescriptorColumnPropertyDialogSqlServer.this.rbDistinctType.isSelected()) {
                InstanceDescriptorColumnPropertyDialogSqlServer.this.bnLogicalType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbDistinctType.setEnabled(true);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbStructuredType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setSelected(false);
            } else if (InstanceDescriptorColumnPropertyDialogSqlServer.this.rbStructuredType.isSelected()) {
                InstanceDescriptorColumnPropertyDialogSqlServer.this.bnLogicalType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbDistinctType.setEnabled(false);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.cbStructuredType.setEnabled(true);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setEnabled(true);
                InstanceDescriptorColumnPropertyDialogSqlServer.this.chbReference.setSelected(InstanceDescriptorColumnPropertyDialogSqlServer.this.instDescriptor.isReference());
            }
        }
    }
}

