/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private IndexProxySqlServer index;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JTextField tfUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public IndexPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (IndexProxySqlServer)storageObject;
        this.setHeight(390);
        this.initCommentsView(140);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogSqlServer.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Unique"));
        this.general.add(jLabel);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfUnique, 80);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbClustered, 110);
    }

    private void initFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbFilegroup, 140);
    }

    private void initPadIndex() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.PadIndex"));
        this.general.add(jLabel);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPadIndex, 170);
    }

    private void initFillFactor() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.FillFactor"));
        this.general.add(jLabel);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifFillFactor, 200);
    }

    private void initRecomputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.RecomputeStat"));
        this.general.add(jLabel);
        this.cbRecomputeStatistics = new JComboBox<String>(ConstantsSqlServer.AUTO_NO_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbRecomputeStatistics, 230);
    }

    private void initSortInTempDB() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.SortInTempDB"));
        this.general.add(jLabel);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbSortInTempDB, 260);
    }

    private void initIgnoreDupKey() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.IgnoreDupKey"));
        this.general.add(jLabel);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("IndexPropertyDialogSqlServer.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(IndexPropertyDialogSqlServer.this.getStorageDesign().getIndexProxySet().getElements());
                arrayList.remove(IndexPropertyDialogSqlServer.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogSqlServer.this.getAppView(), IndexPropertyDialogSqlServer.this.index, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 330);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServer.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServer.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 292);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 292);
        IndexPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 288));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(416, 288));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    private void initCommentsInRDBMS() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogSqlServer.CommentsInRDBMS"));
        this.comments.add(jLabel);
        this.setLabelConstraints(this.getCommentsLayout(), jLabel, 10, 160);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 130));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 180);
    }

    @Override
    public void initProperties() {
        Object[] objectArray;
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        ColumnProxy[] columnProxyArray = this.index.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            objectArray = columnProxyArray[i];
            this.columnListModel.addElement(objectArray);
        }
        this.tfTable.setText(this.index.getTableName());
        this.tfUnique.setText(this.index.getUnique());
        if (this.index.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        DataBaseSqlServer dataBaseSqlServer = ((TableProxySqlServer)this.index.getTableProxy()).getDatabase();
        if (dataBaseSqlServer != null) {
            objectArray = ((StorageObjectCollection)dataBaseSqlServer.getChild(0)).iterator();
            while (objectArray.hasNext()) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)objectArray.next();
                this.cbFilegroup.addItem(fileGroupSqlServer);
            }
        }
        if (this.index.getExtPropsSet() != null) {
            objectArray = this.index.getExtPropsSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getPadIndex()));
        this.ifFillFactor.setValue((long)this.index.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.index.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexPropertyDialogSqlServer.translateYesNoForDisplay(this.index.getIgnoreDupKey()));
        if (this.index.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.comment = this.index.getObject().getComment();
        this.commentInRDBMS = this.index.getObject().getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object object;
            this.index.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.index.setClustered(true);
            } else {
                this.index.setClustered(false);
            }
            this.index.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.index.setPadIndex(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.index.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.index.setSortInTempDB(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.index.setIgnoreDupKey(IndexPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.index.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.index.getFillFactor());
            Object[] objectArray = this.model.getRows();
            this.index.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken().trim();
                this.index.setProps(string);
                this.index.setProps(string2);
            }
            this.applyColumnsSortOrder();
            String string3 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string3) && !this.comment.equalsIgnoreCase(string3)) {
                this.index.setComment(string3);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.index.setCommentInRDBMS((String)object);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServer.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.index.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IndexPropertyDialogSqlServer.this.model.getRowCount() >= 1) {
                for (int i = IndexPropertyDialogSqlServer.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexPropertyDialogSqlServer.this.extProperties.isRowSelected(i)) continue;
                    IndexPropertyDialogSqlServer.this.model.removeRow(i);
                }
                IndexPropertyDialogSqlServer.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            IndexPropertyDialogSqlServer.this.model.addRow(new Object[]{string, string2});
            IndexPropertyDialogSqlServer.this.extProperties.updateUI();
            IndexPropertyDialogSqlServer.this.extProperties.changeSelection(IndexPropertyDialogSqlServer.this.model.getRowCount() - 1, 0, false, false);
            IndexPropertyDialogSqlServer.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexPropertyDialogSqlServer.PropertyName"), Messages.getString("IndexPropertyDialogSqlServer.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return IndexPropertyDialogSqlServer.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = IndexPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }
}

