/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DataFilePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private DataFileSqlServer datafile;
    private JIntegerField ifSize;
    private JIntegerField ifGrowthValue;
    private JIntegerField ifMaxSize;
    private JTextField tfFileName;
    private JComboBox cbGrowth;
    private JCheckBox chbUnlimited;

    public DataFilePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.datafile = (DataFileSqlServer)storageObject;
        this.setHeight(280);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataFilePropertyDialogSqlServer.DatafileProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileName();
        this.initSize();
        this.initGrowthMethod();
        this.initGrowthValue();
        this.initUseUnlimited();
        this.initMaxSize();
    }

    private void initFileName() {
        JLabel jLabel = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.FileName"));
        this.general.add(jLabel);
        this.tfFileName = new JTextField("", 26);
        this.general.add(this.tfFileName);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfFileName, 50);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.InitialSizeInMB"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifSize, 80);
    }

    private void initGrowthMethod() {
        JLabel jLabel = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.GrowthMethod"));
        this.general.add(jLabel);
        this.cbGrowth = new JComboBox<String>(DataFileSqlServer.getGrowthChoices());
        this.setBG(this.cbGrowth);
        this.cbGrowth.setPreferredSize(this.ifSize.getPreferredSize());
        this.general.add(this.cbGrowth);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbGrowth, 110);
    }

    private void initGrowthValue() {
        JLabel jLabel = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.GrowthValue"));
        this.general.add(jLabel);
        this.ifGrowthValue = new JIntegerField(0, 26);
        this.general.add(this.ifGrowthValue);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifGrowthValue, 140);
    }

    private void initMaxSize() {
        JLabel jLabel = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.MaxSizeInMB"));
        this.general.add(jLabel);
        this.ifMaxSize = new JIntegerField(0, 26);
        this.general.add(this.ifMaxSize);
        this.setLabelConstraints(jLabel, 210);
        this.setObjectConstraints(this.ifMaxSize, 210);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.datafile.getName());
        this.tfName.setText(this.datafile.getName());
        this.tfFileName.setText(this.datafile.getFileName());
        this.ifSize.setValue((long)this.datafile.getInitialSize());
        this.ifMaxSize.setValue((long)this.datafile.getMaxSize());
        this.cbGrowth.setSelectedItem(this.datafile.getGrowthMethod());
        this.ifGrowthValue.setValue((long)this.datafile.getGrowthValue());
        this.chbUnlimited.setSelected(this.datafile.getIsUnlimited());
        this.setUnlimited(this.datafile.getIsUnlimited());
        this.ifMaxSize.setEnabled(!this.datafile.getIsUnlimited());
        this.getCommentsList().insert(this.datafile.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.datafile != null) {
            this.datafile.setName(this.tfName.getText());
            this.datafile.setFileName(this.tfFileName.getText());
            this.datafile.setInitialSize(this.ifSize.getIntValue());
            this.ifSize.setValue((long)this.datafile.getInitialSize());
            this.datafile.setMaxSize(this.ifMaxSize.getIntValue());
            this.ifMaxSize.setValue((long)this.datafile.getMaxSize());
            this.datafile.setGrowthMethod((String)this.cbGrowth.getSelectedItem());
            this.datafile.setGrowthValue(this.ifGrowthValue.getIntValue());
            this.ifGrowthValue.setValue((long)this.datafile.getGrowthValue());
            this.datafile.setIsUnlimited(this.chbUnlimited.isSelected());
            this.datafile.setComment(this.getCommentsList().getText());
        }
    }

    private void setUnlimited(boolean bl) {
        this.ifMaxSize.setEnabled(!bl);
    }

    private void initUseUnlimited() {
        this.chbUnlimited = new JCheckBox(Messages.getString("DataFilePropertyDialogSqlServer.UnlimitedMaxSize"));
        this.chbUnlimited.addActionListener(new CheckBoxListener());
        this.general.add(this.chbUnlimited);
        this.setObjectConstraints(this.chbUnlimited, 8, 180);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataFilePropertyDialogSqlServer.this.setUnlimited(DataFilePropertyDialogSqlServer.this.chbUnlimited.isSelected());
        }
    }
}

