/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DataBasePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private DataBaseSqlServer database;
    private JComboBox cbState;
    private JComboBox cbCursorCloseOnCommit;
    private JComboBox cbCursorDefault;
    private JComboBox cbAutoClose;
    private JComboBox cbAutoCreateStatistics;
    private JComboBox cbAutoUpdateStatistics;
    private JComboBox cbRecovery;
    private JComboBox cbTornPageDetection;
    private JComboBox cbAutoShrink;
    private JComboBox cbAnsiNulls;
    private JComboBox cbAnsiPadding;
    private JComboBox cbAnsiWarnings;
    private JComboBox cbArithabort;
    private JComboBox cbConcatNullYieldsNull;
    private JComboBox cbNumericRoundabort;
    private JComboBox cbQuotedIdentifier;
    private JComboBox cbRecursiveTriggers;
    private JTextField tfCollationName;

    public DataBasePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.database = (DataBaseSqlServer)storageObject;
        this.setHeight(640);
        this.initCommentsView();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataBasePropertyDialogSqlServer.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initState();
        this.initCollationName();
        this.initCursorCloseOnCommit();
        this.initCursorDefault();
        this.initAutoClose();
        this.initAutoCreateStatistics();
        this.initAutoUpdateStatistics();
        this.initRecovery();
        this.initTornPageDetection();
        this.initAutoShrink();
        this.initAnsiPadding();
        this.initAnsiNulls();
        this.initAnsiWarnings();
        this.initArithabort();
        this.initConcatNullYieldsNull();
        this.initNumericRoundabort();
        this.initQuotedIdentifier();
        this.initRecursiveTriggers();
    }

    private void initState() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.State"));
        this.general.add(jLabel);
        this.cbState = new JComboBox<String>(DataBaseSqlServer.USER_STATES);
        this.setBG(this.cbState);
        this.cbState.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbState);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbState, 50);
    }

    private void initCollationName() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.CollationName"));
        this.general.add(jLabel);
        this.tfCollationName = new JTextField("", 26);
        this.general.add(this.tfCollationName);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfCollationName, 80);
    }

    private void initCursorCloseOnCommit() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.CursorClose"));
        this.general.add(jLabel);
        this.cbCursorCloseOnCommit = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbCursorCloseOnCommit);
        this.cbCursorCloseOnCommit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCursorCloseOnCommit);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCursorCloseOnCommit, 110);
    }

    private void initCursorDefault() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.CursorDefault"));
        this.general.add(jLabel);
        this.cbCursorDefault = new JComboBox<String>(DataBaseSqlServer.CURSOR_DEFAULT_STATES);
        this.setBG(this.cbCursorDefault);
        this.cbCursorDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCursorDefault);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbCursorDefault, 140);
    }

    private void initAutoClose() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AutoClose"));
        this.general.add(jLabel);
        this.cbAutoClose = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoClose);
        this.cbAutoClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoClose);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbAutoClose, 170);
    }

    private void initAutoCreateStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AutoCreateStat"));
        this.general.add(jLabel);
        this.cbAutoCreateStatistics = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoCreateStatistics);
        this.cbAutoCreateStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoCreateStatistics);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbAutoCreateStatistics, 200);
    }

    private void initAutoUpdateStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AutoUpdateStat"));
        this.general.add(jLabel);
        this.cbAutoUpdateStatistics = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoUpdateStatistics);
        this.cbAutoUpdateStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoUpdateStatistics);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbAutoUpdateStatistics, 230);
    }

    private void initAutoShrink() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AutoShrink"));
        this.general.add(jLabel);
        this.cbAutoShrink = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAutoShrink);
        this.cbAutoShrink.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoShrink);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbAutoShrink, 260);
    }

    private void initRecovery() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.Recovery"));
        this.general.add(jLabel);
        this.cbRecovery = new JComboBox<String>(DataBaseSqlServer.RECOVERY_STATES);
        this.setBG(this.cbRecovery);
        this.cbRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecovery);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbRecovery, 290);
    }

    private void initTornPageDetection() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.TornPage"));
        this.general.add(jLabel);
        this.cbTornPageDetection = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbTornPageDetection);
        this.cbTornPageDetection.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTornPageDetection);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbTornPageDetection, 320);
    }

    private void initAnsiPadding() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AnsiPadding"));
        this.general.add(jLabel);
        this.cbAnsiPadding = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiPadding);
        this.cbAnsiPadding.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiPadding);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbAnsiPadding, 350);
    }

    private void initAnsiNulls() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AnsiNulls"));
        this.general.add(jLabel);
        this.cbAnsiNulls = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiNulls);
        this.cbAnsiNulls.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiNulls);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbAnsiNulls, 380);
    }

    private void initAnsiWarnings() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.AnsiWarnings"));
        this.general.add(jLabel);
        this.cbAnsiWarnings = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbAnsiWarnings);
        this.cbAnsiWarnings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAnsiWarnings);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbAnsiWarnings, 410);
    }

    private void initArithabort() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.Arithabort"));
        this.general.add(jLabel);
        this.cbArithabort = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbArithabort);
        this.cbArithabort.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbArithabort);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbArithabort, 440);
    }

    private void initConcatNullYieldsNull() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.ConcatNullYields"));
        this.general.add(jLabel);
        this.cbConcatNullYieldsNull = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbConcatNullYieldsNull);
        this.cbConcatNullYieldsNull.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbConcatNullYieldsNull);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbConcatNullYieldsNull, 470);
    }

    private void initNumericRoundabort() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.RoundAbort"));
        this.general.add(jLabel);
        this.cbNumericRoundabort = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbNumericRoundabort);
        this.cbNumericRoundabort.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNumericRoundabort);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbNumericRoundabort, 500);
    }

    private void initQuotedIdentifier() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.QuotedId"));
        this.general.add(jLabel);
        this.cbQuotedIdentifier = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbQuotedIdentifier);
        this.cbQuotedIdentifier.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQuotedIdentifier);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.cbQuotedIdentifier, 530);
    }

    private void initRecursiveTriggers() {
        JLabel jLabel = new JLabel(Messages.getString("DataBasePropertyDialogSqlServer.RecursiveTriggers"));
        this.general.add(jLabel);
        this.cbRecursiveTriggers = new JComboBox<String>(DataBaseSqlServer.ON_OFF_STATES);
        this.setBG(this.cbRecursiveTriggers);
        this.cbRecursiveTriggers.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecursiveTriggers);
        this.setLabelConstraints(jLabel, 560);
        this.setObjectConstraints(this.cbRecursiveTriggers, 560);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.cbState.setSelectedItem(this.database.getUserState());
        if (this.database.getCollationName() != null && !this.database.getCollationName().equalsIgnoreCase("null")) {
            this.tfCollationName.setText(this.database.getCollationName());
        }
        this.cbCursorCloseOnCommit.setSelectedItem(this.database.getCursorCloseOnCommit());
        this.cbCursorDefault.setSelectedItem(this.database.getCursorDefault());
        this.cbAutoClose.setSelectedItem(this.database.getAutoClose());
        this.cbAutoCreateStatistics.setSelectedItem(this.database.getAutoCreateStatistics());
        this.cbAutoUpdateStatistics.setSelectedItem(this.database.getAutoUpdateStatistics());
        this.cbRecovery.setSelectedItem(this.database.getRecovery());
        this.cbTornPageDetection.setSelectedItem(this.database.getTornPageDetection());
        this.cbAutoShrink.setSelectedItem(this.database.getAutoShrink());
        this.cbAnsiNulls.setSelectedItem(this.database.getAnsiNulls());
        this.cbAnsiPadding.setSelectedItem(this.database.getAnsiPadding());
        this.cbAnsiWarnings.setSelectedItem(this.database.getAnsiWarnings());
        this.cbArithabort.setSelectedItem(this.database.getArithabort());
        this.cbConcatNullYieldsNull.setSelectedItem(this.database.getConcatNullYieldsNull());
        this.cbNumericRoundabort.setSelectedItem(this.database.getNumericRoundabort());
        this.cbQuotedIdentifier.setSelectedItem(this.database.getQuotedIdentifier());
        this.cbRecursiveTriggers.setSelectedItem(this.database.getRecursiveTriggers());
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setUserState((String)this.cbState.getSelectedItem());
            this.database.setCollationName(this.tfCollationName.getText());
            this.database.setCursorCloseOnCommit((String)this.cbCursorCloseOnCommit.getSelectedItem());
            this.database.setCursorDefault((String)this.cbCursorDefault.getSelectedItem());
            this.database.setAutoClose((String)this.cbAutoClose.getSelectedItem());
            this.database.setAutoCreateStatistics((String)this.cbAutoCreateStatistics.getSelectedItem());
            this.database.setAutoUpdateStatistics((String)this.cbAutoUpdateStatistics.getSelectedItem());
            this.database.setRecovery((String)this.cbRecovery.getSelectedItem());
            this.database.setTornPageDetection((String)this.cbTornPageDetection.getSelectedItem());
            this.database.setAutoShrink((String)this.cbAutoShrink.getSelectedItem());
            this.database.setAnsiNulls((String)this.cbAnsiNulls.getSelectedItem());
            this.database.setAnsiPadding((String)this.cbAnsiPadding.getSelectedItem());
            this.database.setAnsiWarnings((String)this.cbAnsiWarnings.getSelectedItem());
            this.database.setArithabort((String)this.cbArithabort.getSelectedItem());
            this.database.setConcatNullYieldsNull((String)this.cbConcatNullYieldsNull.getSelectedItem());
            this.database.setNumericRoundabort((String)this.cbNumericRoundabort.getSelectedItem());
            this.database.setQuotedIdentifier((String)this.cbQuotedIdentifier.getSelectedItem());
            this.database.setRecursiveTriggers((String)this.cbRecursiveTriggers.getSelectedItem());
            this.database.setComment(this.getCommentsList().getText());
        }
    }
}

