/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PermissionsPropertiesDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogSqlServer
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    protected static final String EDIT = Messages.getString("ColumnsPermissionsDialogSqlServer.Edit");
    private StorageObject storageObject;
    private Object[] columnsSet;
    private StorageObject user;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private PermissionsPropertiesDialogSqlServer permDialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogSqlServer.this.bnCancel.doClick();
        }
    };
    private ColumnsTable columnsTable;

    public ColumnsPermissionsDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, StorageObject storageObject2, PermissionsPropertiesDialogSqlServer permissionsPropertiesDialogSqlServer) {
        super(applicationView.getFrame());
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = storageObject;
        this.user = storageObject2;
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ColumnsPermissionsDialogSqlServer.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("ColumnsPermissionsDialogSqlServer.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(Messages.getString("ColumnsPermissionsDialogSqlServer.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel.add(jButton2);
        this.bnCancel = new JButton(Messages.getString("ColumnsPermissionsDialogSqlServer.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(jButton2, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(jButton, this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initColumnsTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
        this.setResizable(false);
        this.permDialog = permissionsPropertiesDialogSqlServer;
    }

    public void initProperties() {
        for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
            ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)this.columnsTable.getValueAt(i, 0);
            for (int j = 0; j < this.columnsTable.getColumnCount(); ++j) {
                if (!(this.columnsTable.getValueAt(i, j) instanceof JButton)) continue;
                JButton jButton = (JButton)this.columnsTable.getValueAt(i, j);
                if (this.getPermission(this.user, this.storageObject, columnProxySqlServer) != null) {
                    if (this.getPermission(this.user, this.storageObject, columnProxySqlServer).getPrivs(columnProxySqlServer).indexOf(this.columnsTable.getColumnName(j)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.setBackground(Color.WHITE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.setBackground(Color.WHITE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.setBackground(Color.WHITE);
                jButton.updateUI();
            }
        }
    }

    private void initColumnsTable() {
        this.columnsSet = ((TableProxySqlServer)this.storageObject).getColumnProxies();
        this.columnsTable = new ColumnsTable();
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(600, 180));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(jScrollPane);
        this.columnsTable.updateUI();
        ColumnsModel columnsModel = (ColumnsModel)this.columnsTable.getModel();
        for (int i = 0; i < this.columnsSet.length; ++i) {
            ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)this.columnsSet[i];
            String[] stringArray = (String[])PermissionsSqlServer.getColumnPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(columnProxySqlServer);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            columnsModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedColumnsPrivileges(int n) {
        for (int i = 1; i < this.columnsTable.getColumnCount(); ++i) {
            JButton jButton;
            if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
            return true;
        }
        return false;
    }

    protected void setProperties() {
        int n;
        PermissionsSqlServer permissionsSqlServer = this.getPermission(this.user, this.storageObject);
        if (permissionsSqlServer != null) {
            permissionsSqlServer.clearColPermissions();
        }
        for (n = 0; n < this.columnsTable.getRowCount(); ++n) {
            ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)this.columnsTable.getValueAt(n, 0);
            if (this.hasSelectedColumnsPrivileges(n)) {
                if (permissionsSqlServer == null) {
                    permissionsSqlServer = this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.user instanceof UserSqlServer) {
                        permissionsSqlServer.setUser((UserSqlServer)this.user);
                    } else if (this.user instanceof RoleSqlServer) {
                        permissionsSqlServer.setRole((RoleSqlServer)this.user);
                    }
                    permissionsSqlServer.setTable((TableProxySqlServer)this.storageObject);
                }
                String string = "";
                string = string.concat(columnProxySqlServer.getName());
                for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                    JButton jButton;
                    if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
                    string = string.concat(", ").concat(this.columnsTable.getColumnName(i));
                    this.permDialog.setColumnPermissions(this.user, this.columnsTable.getColumnName(i));
                }
                permissionsSqlServer.setColumnList(string);
                continue;
            }
            if (permissionsSqlServer == null || !permissionsSqlServer.getColumns().isEmpty()) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsSqlServer);
            for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                if (!(this.columnsTable.getValueAt(n, i) instanceof JButton)) continue;
                this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(i));
            }
        }
        for (n = 1; n < this.columnsTable.getColumnCount(); ++n) {
            boolean bl = false;
            for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
                if (!((JButton)this.columnsTable.getValueAt(i, n)).getText().equalsIgnoreCase(CHECKED)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(n));
        }
    }

    public String getCaption() {
        return Messages.getString("ColumnsPermissionsDialogSqlServer.Permissions");
    }

    private PermissionsSqlServer getPermission(StorageObject storageObject, StorageObject storageObject2, StorageObject storageObject3) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2 && permissionsSqlServer.getView() != storageObject2 || !permissionsSqlServer.getColumns().contains(storageObject3.getName())) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    private PermissionsSqlServer getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2 && permissionsSqlServer.getView() != storageObject2) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    public StorageObject getUser() {
        return this.user;
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (object != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(false);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            try {
                this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            if (object == null) {
                this.setText("");
            } else if (object instanceof ColumnProxySqlServer) {
                this.setText(" " + ((ColumnProxySqlServer)object).getName());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogSqlServer.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogSqlServer.this.setProperties();
            ColumnsPermissionsDialogSqlServer.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogSqlServer.this.setProperties();
            ColumnsPermissionsDialogSqlServer.this.storageObject.setDirty(true);
            ColumnsPermissionsDialogSqlServer.this.dispose();
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(220);
                    continue;
                }
                tableColumn.setPreferredWidth(80);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class ColumnsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsSqlServer.getColumnPermissionsValues().toArray();
            return objectArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsSqlServer.getColumnPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("ColumnsPermissionsDialogSqlServer.Column");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

