/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ColumnProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JNumericField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnProxyPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private static final int MAX_DIGITS = 31;
    private ColumnProxySqlServerv2k column;
    private String comment = "";
    private String commentInRDBMS = "";
    private String formula = "";
    private boolean computed = false;
    private JTextField tfDataType;
    private JTextField tfBelongsToPK;
    private JTextField tfNullsAllowed;
    private JTextField tfDefaultValue;
    private JTextField tfFormula;
    private JTextField tfCollation;
    private JTextField tfIdentitySeed;
    private JIntegerField ifIdentityIncrement;
    private JCheckBox chbDefineDefault;
    private JCheckBox chbAsIdentity;
    private JCheckBox chbComputed;
    private JComboBox cbDefaultObject;
    private JComboBox cbIdentityForReplication;
    private JComboBox cbRowGuidCol;
    private ExtPropertiesModel model;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private String startWith;
    private Integer incrementBy;
    private boolean asIdentity;

    public ColumnProxyPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.column = (ColumnProxySqlServerv2k)storageObject;
        this.setHeight(520);
        this.initCommentsView(220);
        this.initCommentsInRDBMS(220);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnProxyPropertyDialogSqlServer.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initBelongsToPK();
        this.initNullsAllowed();
        this.initDefineDefault();
        this.initDefaultValue();
        this.initDefaultObject();
        this.initAsIdentity();
        this.initIdentitySeed();
        this.initIdentityIncrement();
        this.initIdentityForReplication();
        this.initRowGuidCol();
        this.initComputed();
        this.initFormula();
        this.initCollation();
    }

    private void initDataType() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DataType"));
        this.general.add(jLabel);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initBelongsToPK() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.BelongsToPK"));
        this.general.add(jLabel);
        this.tfBelongsToPK = new JTextField("", 26);
        this.tfBelongsToPK.setEnabled(false);
        this.general.add(this.tfBelongsToPK);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfBelongsToPK, 80);
    }

    private void initNullsAllowed() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.NullsAllowed"));
        this.general.add(jLabel);
        this.tfNullsAllowed = new JTextField("", 26);
        this.tfNullsAllowed.setEnabled(false);
        this.general.add(this.tfNullsAllowed);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfNullsAllowed, 110);
    }

    private void initRowGuidCol() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.ROWGIUDCOL"));
        this.general.add(jLabel);
        this.cbRowGuidCol = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowGuidCol);
        this.cbRowGuidCol.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbRowGuidCol);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbRowGuidCol, 140);
    }

    private void initDefineDefault() {
        this.chbDefineDefault = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.UseDefaultObject"));
        this.chbDefineDefault.addActionListener(new DefaultListener());
        this.general.add(this.chbDefineDefault);
        this.setObjectConstraints(this.chbDefineDefault, 8, 170);
    }

    private void initDefaultValue() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DefaultValue"));
        this.general.add(jLabel);
        this.tfDefaultValue = new JTextField("", 26);
        this.general.add(this.tfDefaultValue);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfDefaultValue, 200);
    }

    private void initDefaultObject() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.DefaultObject"));
        this.general.add(jLabel);
        this.cbDefaultObject = new JComboBox();
        this.setBG(this.cbDefaultObject);
        this.cbDefaultObject.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbDefaultObject);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbDefaultObject, 230);
    }

    private void initAsIdentity() {
        this.chbAsIdentity = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.AsIdentity"));
        this.chbAsIdentity.addActionListener(new IdentityListener());
        this.general.add(this.chbAsIdentity);
        this.setObjectConstraints(this.chbAsIdentity, 8, 270);
    }

    private void initIdentitySeed() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentitySeed"));
        this.general.add(jLabel);
        this.tfIdentitySeed = new JNumericField(31, 26);
        this.general.add(this.tfIdentitySeed);
        this.setLabelConstraints(jLabel, 300);
        this.setObjectConstraints(this.tfIdentitySeed, 300);
    }

    private void initIdentityIncrement() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentityIncrement"));
        this.general.add(jLabel);
        this.ifIdentityIncrement = new JIntegerField(0, 26);
        this.general.add(this.ifIdentityIncrement);
        this.setLabelConstraints(jLabel, 330);
        this.setObjectConstraints(this.ifIdentityIncrement, 330);
    }

    private void initIdentityForReplication() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.IdentityForRepl"));
        this.general.add(jLabel);
        this.cbIdentityForReplication = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIdentityForReplication);
        this.cbIdentityForReplication.setPreferredSize(this.tfDataType.getPreferredSize());
        this.general.add(this.cbIdentityForReplication);
        this.setLabelConstraints(jLabel, 360);
        this.setObjectConstraints(this.cbIdentityForReplication, 360);
    }

    private void initComputed() {
        this.chbComputed = new JCheckBox(Messages.getString("ColumnProxyPropertyDialogSqlServer.Computed"));
        this.chbComputed.addActionListener(new ComputedListener());
        this.general.add(this.chbComputed);
        this.setObjectConstraints(this.chbComputed, 8, 390);
    }

    private void initFormula() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.Formula"));
        this.general.add(jLabel);
        this.tfFormula = new JTextField("", 26);
        this.general.add(this.tfFormula);
        this.setLabelConstraints(jLabel, 420);
        this.setObjectConstraints(this.tfFormula, 420);
    }

    private void initCollation() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnProxyPropertyDialogSqlServer.Collation"));
        this.general.add(jLabel);
        this.tfCollation = new JTextField("", 26);
        this.general.add(this.tfCollation);
        this.setLabelConstraints(jLabel, 450);
        this.setObjectConstraints(this.tfCollation, 450);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("ColumnProxyPropertyDialogSqlServer.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("ColumnProxyPropertyDialogSqlServer.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 463);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 463);
        ColumnProxyPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnProxyPropertyDialogSqlServer.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 457));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(416, 459));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    @Override
    public void initProperties() {
        Object[] objectArray;
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.tfBelongsToPK.setText(this.column.belongsToPK() ? YES : NO);
        this.tfNullsAllowed.setText(this.column.getNullsAllowed() ? YES : NO);
        this.tfDefaultValue.setText(this.column.getDefaultValue());
        this.cbDefaultObject.setSelectedItem(this.column.getDefaultObject());
        this.chbDefineDefault.setSelected(this.column.getDefineDefault());
        this.chbDefineDefault.setEnabled(this.column.getDefineDefault() || !this.column.getAsIdentity() && !this.column.getComputed());
        this.tfDefaultValue.setEnabled(!this.column.getDefineDefault());
        this.cbDefaultObject.setEnabled(this.column.getDefineDefault());
        if (this.column.getTableProxy().getDatabase() != null) {
            objectArray = ((StorageObjectCollection)this.column.getTableProxy().getDatabase().getChild(2)).iterator();
            while (objectArray.hasNext()) {
                DefaultSqlServer defaultSqlServer = (DefaultSqlServer)objectArray.next();
                this.cbDefaultObject.addItem(defaultSqlServer);
            }
        }
        this.initColumnIdentityProperties();
        this.cbRowGuidCol.setSelectedItem(ColumnProxyPropertyDialogSqlServer.translateYesNoForDisplay(this.column.getRowGuidCol()));
        if (this.column.getDataTypeName().equalsIgnoreCase("uniqueidentifier") && !this.column.getTableProxy().existRowGuidColUniqueID(this.column)) {
            this.cbRowGuidCol.setEnabled(true);
        } else {
            this.cbRowGuidCol.setEnabled(false);
        }
        this.computed = this.column.getComputed();
        this.chbComputed.setSelected(this.computed);
        this.chbComputed.setEnabled(this.computed || !this.column.getDefineDefault() && !this.column.getAsIdentity());
        this.formula = this.column.getFormula();
        this.tfFormula.setText(this.formula);
        this.tfCollation.setText(this.column.getCollation());
        if (this.column.getExtPropsSet() != null) {
            objectArray = this.column.getExtPropsSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.getCommentsInRDBMSList().insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.getCommentsInRDBMSList().insert(this.commentInRDBMS, 0);
        }
    }

    protected void initColumnIdentityProperties() {
        Column column = (Column)this.column.getObject();
        this.startWith = column.getAutoIncrementStartWith();
        this.incrementBy = column.getAutoIncrementIncrementBy();
        this.asIdentity = column.isIdentityColumn();
        if (this.column.isAsIdentityChanged()) {
            this.chbAsIdentity.setSelected(this.column.getAsIdentity());
            this.chbAsIdentity.setEnabled(this.column.getAsIdentity() || !this.column.getDefineDefault() && !this.column.getComputed());
        } else {
            this.chbAsIdentity.setSelected(this.asIdentity);
            this.chbAsIdentity.setEnabled(this.asIdentity || !this.column.getDefineDefault() && !this.column.getComputed());
        }
        if (!this.column.isAsIdentityChanged() && !this.asIdentity) {
            this.chbAsIdentity.setEnabled(false);
        }
        if (this.column.isStartWithChanged()) {
            this.tfIdentitySeed.setText(this.column.getIdentitySeed());
        } else {
            this.tfIdentitySeed.setText(this.startWith);
        }
        if (this.column.isIncrementByChanged()) {
            this.ifIdentityIncrement.setValue((long)this.column.getIdentityIncrement());
        } else {
            this.ifIdentityIncrement.setValue(this.incrementBy);
        }
        this.cbIdentityForReplication.setSelectedItem(ColumnProxyPropertyDialogSqlServer.translateYesNoForDisplay(this.column.getIdentityForReplication()));
        this.tfIdentitySeed.setEnabled(this.column.getAsIdentity());
        this.ifIdentityIncrement.setEnabled(this.column.getAsIdentity());
        this.cbIdentityForReplication.setEnabled(this.column.getAsIdentity());
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            Object object;
            this.column.setName(this.tfName.getText());
            this.column.setDefineDefault(this.chbDefineDefault.isSelected());
            this.column.setDefaultValue(this.tfDefaultValue.getText());
            this.column.setDefaultObject((DefaultSqlServer)this.cbDefaultObject.getSelectedItem());
            this.setColumnIdentityProperties();
            this.column.setRowGuidCol(ColumnProxyPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbRowGuidCol.getSelectedItem()));
            if (this.chbComputed.isSelected() != this.computed) {
                this.column.setComputed(this.chbComputed.isSelected());
                this.column.setComputedChanged(true);
            }
            if (!this.tfFormula.getText().equals(this.formula)) {
                this.column.setFormula(this.tfFormula.getText());
                this.column.setFormulaChanged(true);
            }
            this.column.setCollation(this.tfCollation.getText());
            Object[] objectArray = this.model.getRows();
            this.column.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken().trim();
                this.column.setProps(string);
                this.column.setProps(string2);
            }
            String string3 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string3) && !this.comment.equals(string3)) {
                this.column.setComment(string3);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equals(object)) {
                this.column.setCommentInRDBMS((String)object);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void setColumnIdentityProperties() {
        if (this.asIdentity != this.chbAsIdentity.isSelected()) {
            this.column.setAsIdentity(this.chbAsIdentity.isSelected());
            this.column.setAsIdentityChanged(true);
        } else {
            this.column.setAsIdentityChanged(false);
        }
        if (this.notEquals(this.startWith, this.tfIdentitySeed)) {
            this.column.setIdentitySeed(this.tfIdentitySeed.getText());
            this.column.setStartWithChanged(true);
        } else {
            this.column.setStartWithChanged(false);
        }
        if (this.notEquals(this.incrementBy, this.ifIdentityIncrement)) {
            this.column.setIdentityIncrement(this.ifIdentityIncrement.getIntValue());
            this.column.setIncrementByChanged(true);
        } else {
            this.column.setIncrementByChanged(false);
        }
        this.column.setIdentityForReplication(ColumnProxyPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbIdentityForReplication.getSelectedItem()));
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() >= 1) {
                for (int i = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!ColumnProxyPropertyDialogSqlServer.this.extProperties.isRowSelected(i)) continue;
                    ColumnProxyPropertyDialogSqlServer.this.model.removeRow(i);
                }
                ColumnProxyPropertyDialogSqlServer.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            ColumnProxyPropertyDialogSqlServer.this.model.addRow(new Object[]{string, string2});
            ColumnProxyPropertyDialogSqlServer.this.extProperties.updateUI();
            ColumnProxyPropertyDialogSqlServer.this.extProperties.changeSelection(ColumnProxyPropertyDialogSqlServer.this.model.getRowCount() - 1, 0, false, false);
            ColumnProxyPropertyDialogSqlServer.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ColumnProxyPropertyDialogSqlServer.PropertyName"), Messages.getString("ColumnProxyPropertyDialogSqlServer.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ColumnProxyPropertyDialogSqlServer.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = ColumnProxyPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    private class ComputedListener
    implements ActionListener {
        private ComputedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbComputed.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbComputed.isSelected());
        }
    }

    private class IdentityListener
    implements ActionListener {
        private IdentityListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnProxyPropertyDialogSqlServer.this.tfIdentitySeed.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.ifIdentityIncrement.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.cbIdentityForReplication.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbComputed.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.isSelected());
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnProxyPropertyDialogSqlServer.this.tfDefaultValue.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.cbDefaultObject.setEnabled(ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbAsIdentity.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
            ColumnProxyPropertyDialogSqlServer.this.chbComputed.setEnabled(!ColumnProxyPropertyDialogSqlServer.this.chbDefineDefault.isSelected());
        }
    }
}

