/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TableProxyOraclev9i table;
    private PartitionListOraclev9i partList;
    private static final String YES_PRESERVE = Messages.getString("TablePropertyDialogOracle.YES_PRESERVE_ROWS");
    private static final String YES_DELETE = Messages.getString("TablePropertyDialogOracle.YES_DELETE_ROWS");
    private static final String[] NO_PRESERVE_DELETE = new String[]{NO, YES_PRESERVE, YES_DELETE};
    private JComboBox cbUser;
    private JComboBox cbTemporary;
    private JComboBox cbTableSpace;
    private JComboBox cbOrganization;
    private JComboBox cbCluster;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbCache;
    private JComboBox cbMonitoring;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbPartRowMovement;
    private JComboBox cbDataSegmentCompression;
    private JIntegerField ifIotCompress;
    private JIntegerField ifIotPctThreshold;
    private JComboBox cbIotIncluding;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbIotMappingTable;
    private JPanel iotProperties;
    private JPanel supplementalLog;
    private JComboBox cbSnapshot;
    private JTextField tfBasedOnStructuredType;
    private JTextField tfSupplementalLogGroupName;
    private JComboBox cbSupplementalLogCondition;
    private JList allSupplementalColumnsList;
    private JList selectedSupplementalColumnsList;
    private DefaultListModel allSupplementalColumnsModel;
    private DefaultListModel selectedSupplementalColumnsModel;
    private JButton bnSupplementalAdd;
    private JButton bnSupplementalRemove;
    private JPanel clusterColumns;
    private JList allClusterColumnsList;
    private JList selectedClusterColumnsList;
    private DefaultListModel allClusterColumnsModel;
    private DefaultListModel selectedClusterColumnsModel;
    private JButton bnAddClusterColumn;
    private JButton bnRemoveClusterColumn;
    private JPanel hashPTS;
    private int hashPTSTabIndex;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel pnPartitioning;
    private JPanel pnPartGeneral;
    private JTabbedPane tpPartitions;
    private JComboBox cbPartType;
    private JComboBox cbUseSubpartitionsStorageTemplate;
    private JIntegerField ifHashPQuantity;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartColumns;
    private int subPartColumnsTabIndex;
    private JList allSubPartColumnsList;
    private JList selectedSubPartColumnsList;
    private DefaultListModel allSubPartColumnsModel;
    private DefaultListModel selectedSubPartColumnsModel;
    private JButton bnAddSubPartColumns;
    private JButton bnRemoveSubPartColumns;
    private JPanel subPartTS;
    private int subPartTSTabIndex;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private String comment;
    private String commentInRDBMS;
    private JPanel oidProperties;
    private JTextField tfOidIndexName;
    private JComboBox cbOidIndexSegment;
    private JTextField tfOidType;
    private JPanel xmlTypeProperties;
    private JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    private JComboBox cbStoreAs;
    private JTextField tfLobSegmentName;
    private JComboBox cbXmlTypeTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbXmlTypeLogging;
    private JComboBox cbXmlTypeCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    private JIntegerField ifFreePools;
    private JPanel partitionsOrder;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private JTable partitionsOrderTable;
    private List partitions;
    private DefaultListSelectionModel partSelectionModel;
    private PartitionsOrderModel partitionsOrderModel;
    private boolean ordered = false;

    public TablePropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxyOraclev9i)storageObject;
        this.partList = (PartitionListOraclev9i)this.table.getPartitionList();
        this.setHeight(650);
        this.initCommentsView(270);
        this.initCommentsInRDBMS(275);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogOracle.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initUser();
        this.initTemporary();
        this.initTableSpace();
        this.initOrganization();
        this.initCluster();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initMonitoring();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataSegmentCompression();
        this.initSnapshot();
        this.initBasedOnStructuredType();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTemporary() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Temporary"));
        this.general.add(jLabel);
        this.cbTemporary = new JComboBox<String>(NO_PRESERVE_DELETE);
        this.setBG(this.cbTemporary);
        this.cbTemporary.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTemporary, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initOrganization() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Organization"));
        this.general.add(jLabel);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.setBG(this.cbOrganization);
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.cbOrganization.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbOrganization, 140);
    }

    private void initCluster() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cluster"));
        this.general.add(jLabel);
        this.cbCluster = new JComboBox();
        this.setBG(this.cbCluster);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.cbCluster.addActionListener(new ClusterListener());
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbLogging, 200);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbSegment, 230);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCache, 260);
    }

    private void initMonitoring() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Monitoring"));
        this.general.add(jLabel);
        this.cbMonitoring = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMonitoring);
        this.cbMonitoring.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMonitoring);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbMonitoring, 290);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbParallel, 320);
    }

    private void initDegree() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(jLabel);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDegree);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.tfDegree, 350);
    }

    private void initRowDependency() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.RowDependency"));
        this.general.add(jLabel);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbRowDependency, 380);
    }

    private void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbPartitioned, 410);
    }

    private void initPartRowMovement() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.RowMovement"));
        this.general.add(jLabel);
        this.cbPartRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.setBG(this.cbPartRowMovement);
        this.cbPartRowMovement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartRowMovement);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbPartRowMovement, 440);
    }

    private void initDataSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.DataCompression"));
        this.general.add(jLabel);
        this.cbDataSegmentCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDataSegmentCompression);
        this.cbDataSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataSegmentCompression);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbDataSegmentCompression, 470);
    }

    private List getSnapshots() {
        ArrayList<SnapshotOracle> arrayList = new ArrayList<SnapshotOracle>();
        Iterator iterator = this.getStorageDesign().getSnapshotSet().iterator();
        while (iterator.hasNext()) {
            SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
            if (snapshotOracle.getImplementedTable() != null && snapshotOracle.getImplementedTable() != this.getStorageObject()) continue;
            arrayList.add(snapshotOracle);
        }
        return arrayList;
    }

    private void initSnapshot() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.ImplementAsSnapshot"));
        this.general.add(jLabel);
        this.cbSnapshot = new JComboBox();
        this.cbSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertyDialogOraclev9i.this.snapshotChanged();
            }
        });
        this.setBG(this.cbSnapshot);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getSnapshots().toArray(), this.cbSnapshot);
        }
        this.cbSnapshot.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSnapshot);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbSnapshot, 500);
    }

    private void initBasedOnStructuredType() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StructuredType"));
        this.general.add(jLabel);
        this.tfBasedOnStructuredType = new JTextField();
        this.setBG(this.tfBasedOnStructuredType);
        this.tfBasedOnStructuredType.setEnabled(false);
        this.tfBasedOnStructuredType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfBasedOnStructuredType);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.tfBasedOnStructuredType, 530);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogOraclev9i.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogOraclev9i.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogOraclev9i.this.getAppView(), TablePropertyDialogOraclev9i.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 570);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 570);
    }

    protected SpringLayout getIOTPropertiesLayout() {
        return (SpringLayout)this.iotProperties.getLayout();
    }

    protected SpringLayout getSupplementalLogLayout() {
        return (SpringLayout)this.supplementalLog.getLayout();
    }

    private void initIOTCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTCompress"));
        this.iotProperties.add(jLabel);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.iotProperties.add(this.ifIotCompress);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 20);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotCompress, 20);
    }

    private void initIOTPCTThershold() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTPCTThreshold"));
        this.iotProperties.add(jLabel);
        this.ifIotPctThreshold = new JIntegerField(0, 26);
        this.iotProperties.add(this.ifIotPctThreshold);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 50);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotPctThreshold, 50);
    }

    private void initIOTIncluding() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTIncluding"));
        this.iotProperties.add(jLabel);
        this.cbIotIncluding = new JComboBox();
        this.setBG(this.cbIotIncluding);
        this.cbIotIncluding.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotIncluding);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 80);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotIncluding, 80);
    }

    private void initIOTOverflowSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowSegment"));
        this.iotProperties.add(jLabel);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 110);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowSegment, 110);
    }

    private void initIOTMappingTable() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.MappingTable"));
        this.iotProperties.add(jLabel);
        this.cbIotMappingTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIotMappingTable);
        this.cbIotMappingTable.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotMappingTable);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 140);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotMappingTable, 140);
    }

    @Override
    protected void addTabs() {
        this.initClusterColumnsView();
        this.initPartitioningView();
        this.initIOTPropertiesView();
        this.initSupplementalLogView();
        this.initOIDView();
        this.initXMLTypeView();
    }

    private void initXMLTypeView() {
        this.xmlTypeProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.XMLTypeProperties"), this.xmlTypeProperties);
        this.initXMLTypeProperties();
    }

    private void initXMLTypeProperties() {
        this.initXMLSchemaURL();
        this.initXMLSchemaElement();
        this.initStoreAs();
        this.initLobSegmentName();
        this.initXmlTypeTableSpace();
        this.initStorageInRow();
        this.initXmlTypeLogging();
        this.initXmlTypeCache();
        this.initChunk();
        this.initOldVersions();
        this.initPctVersion();
        this.initFreePools();
    }

    private void initStoreAs() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StoreAs"));
        this.xmlTypeProperties.add(jLabel);
        this.cbStoreAs = new JComboBox<String>(TableProxyOraclev9i.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 80);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStoreAs, 80);
    }

    private void initXMLSchemaURL() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaURL"));
        this.xmlTypeProperties.add(jLabel);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaUrl);
        this.xmlTypeProperties.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 20);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaUrl, 20);
    }

    private void initXMLSchemaElement() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaElem"));
        this.xmlTypeProperties.add(jLabel);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaElement);
        this.xmlTypeProperties.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 50);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaElement, 50);
    }

    private void initLobSegmentName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.LobSegmentName"));
        this.xmlTypeProperties.add(jLabel);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeProperties.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 110);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfLobSegmentName, 110);
    }

    private void initXmlTypeTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeTableSpace = new JComboBox();
        this.setBG(this.cbXmlTypeTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbXmlTypeTableSpace);
        }
        this.cbXmlTypeTableSpace.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeTableSpace);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 140);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeTableSpace, 140);
    }

    private void initStorageInRow() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StorageInRow"));
        this.xmlTypeProperties.add(jLabel);
        this.cbStorageInRow = new JComboBox<String>(TableProxyOracle.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 170);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStorageInRow, 170);
    }

    private void initXmlTypeLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbXmlTypeLogging);
        this.cbXmlTypeLogging.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeLogging);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 200);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeLogging, 200);
    }

    private void initXmlTypeCache() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeCache = new JComboBox<String>(TableProxyOracle.getXmlTypeCacheValues());
        this.setBG(this.cbXmlTypeCache);
        this.cbXmlTypeCache.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeCache);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 230);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeCache, 230);
    }

    private void initChunk() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Chunk"));
        this.xmlTypeProperties.add(jLabel);
        this.ifChunk = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifChunk);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 260);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifChunk, 260);
    }

    private void initOldVersions() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OldVersions"));
        this.xmlTypeProperties.add(jLabel);
        this.cbOldVersions = new JComboBox<String>(TableProxyOraclev9i.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 290);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbOldVersions, 290);
    }

    private void initPctVersion() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.PCTVersion"));
        this.xmlTypeProperties.add(jLabel);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 320);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifPctVersion, 320);
    }

    private void initFreePools() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.FreePools"));
        this.xmlTypeProperties.add(jLabel);
        this.ifFreePools = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifFreePools);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, 350);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifFreePools, 350);
    }

    private void enableXMLTypeClobOptions(boolean bl) {
        this.tfLobSegmentName.setEnabled(bl);
        this.cbXmlTypeTableSpace.setEnabled(bl);
        this.cbStorageInRow.setEnabled(bl);
        this.cbXmlTypeLogging.setEnabled(bl);
        this.cbXmlTypeCache.setEnabled(bl);
        this.ifChunk.setEnabled(bl);
        this.cbOldVersions.setEnabled(bl);
        this.ifPctVersion.setEnabled(bl);
        this.ifFreePools.setEnabled(bl);
    }

    protected SpringLayout getXMLTypePropertiesLayout() {
        return (SpringLayout)this.xmlTypeProperties.getLayout();
    }

    private void initOIDView() {
        this.oidProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.OIDProperties"), this.oidProperties);
        this.initOIDProperties();
    }

    private void initOIDProperties() {
        this.initOidType();
        this.initOidIndexName();
        this.initOidIndexSegment();
    }

    private void initOidType() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDType"));
        this.oidProperties.add(jLabel);
        this.tfOidType = new JTextField();
        this.tfOidType.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.tfOidType.setEnabled(false);
        this.oidProperties.add(this.tfOidType);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 20);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidType, 20);
    }

    private void initOidIndexName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexName"));
        this.oidProperties.add(jLabel);
        this.tfOidIndexName = new JTextField();
        this.tfOidIndexName.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.tfOidIndexName);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 50);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidIndexName, 50);
    }

    private void initOidIndexSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexSegment"));
        this.oidProperties.add(jLabel);
        this.cbOidIndexSegment = new JComboBox();
        this.setBG(this.cbOidIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbOidIndexSegment);
        }
        this.cbOidIndexSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.cbOidIndexSegment);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 80);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.cbOidIndexSegment, 80);
    }

    protected SpringLayout getOIDPropertiesLayout() {
        return (SpringLayout)this.oidProperties.getLayout();
    }

    private void initSupplementalLogView() {
        this.supplementalLog = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.SupplementalLog"), this.supplementalLog);
        this.initSupplementalLog();
    }

    private void initSupplementalLog() {
        this.initSupplementalLogGroupName();
        this.initSupplementalLogCondition();
        this.initSupplementalLogColumns();
    }

    private void initSupplementalLogColumns() {
        this.initAllSupplementalColumnsList();
        this.initSelectedSupplementalColumnsList();
        this.initSupplementalButtons();
    }

    private void initAllSupplementalColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.supplementalLog.add(jLabel);
        this.allSupplementalColumnsModel = new DefaultListModel();
        this.allSupplementalColumnsList = new JList(this.allSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.allSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSupplementalSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSupplementalColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 470));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(jScrollPane);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 8, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), jScrollPane, 6, 112);
    }

    private void initSelectedSupplementalColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SupplementalColumns"));
        this.supplementalLog.add(jLabel);
        this.selectedSupplementalColumnsModel = new DefaultListModel();
        this.selectedSupplementalColumnsList = new JList(this.selectedSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSupplementalSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSupplementalColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 470));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(jScrollPane);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 292, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), jScrollPane, 290, 112);
    }

    private void initSupplementalButtons() {
        this.bnSupplementalAdd = new JButton(ADD_CAPTION);
        this.bnSupplementalAdd.addActionListener(new AddSupplementalColumnsActionListener());
        this.bnSupplementalAdd.setEnabled(false);
        this.supplementalLog.add(this.bnSupplementalAdd);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalAdd, 175, 280);
        this.bnSupplementalRemove = new JButton(REMOVE_CAPTION);
        this.bnSupplementalRemove.setEnabled(false);
        this.bnSupplementalRemove.addActionListener(new RemoveSupplementalColumnsActionListener());
        this.supplementalLog.add(this.bnSupplementalRemove);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalRemove, 175, 310);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnSupplementalAdd, this.bnSupplementalRemove);
    }

    private void initSupplementalLogGroupName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.GroupName"));
        this.supplementalLog.add(jLabel);
        this.tfSupplementalLogGroupName = new JTextField("", 26);
        this.supplementalLog.add(this.tfSupplementalLogGroupName);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 20);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.tfSupplementalLogGroupName, 20);
    }

    private void initSupplementalLogCondition() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Condition"));
        this.supplementalLog.add(jLabel);
        this.cbSupplementalLogCondition = new JComboBox<String>(TableProxyOraclev9i.suplementalLogConditionChoices);
        this.setBG(this.cbSupplementalLogCondition);
        this.cbSupplementalLogCondition.setPreferredSize(this.tfSupplementalLogGroupName.getPreferredSize());
        this.supplementalLog.add(this.cbSupplementalLogCondition);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 50);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.cbSupplementalLogCondition, 50);
    }

    private void initIOTPropertiesView() {
        this.iotProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.IOTProperties"), this.iotProperties);
        this.initIOTProperties();
    }

    private void initIOTProperties() {
        this.initIOTCompress();
        this.initIOTPCTThershold();
        this.initIOTIncluding();
        this.initIOTOverflowSegment();
        this.initIOTMappingTable();
    }

    private void initClusterColumnsView() {
        this.clusterColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.ClusterColumns"), this.clusterColumns);
        this.initClusterColumns();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumns.getLayout();
    }

    private void initClusterColumns() {
        this.initAllClusterColumnsList();
        this.initSelectedClusterColumnsList();
        this.initClusterColumnsButtons();
    }

    private void initAllClusterColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.clusterColumns.add(jLabel);
        this.allClusterColumnsModel = new DefaultListModel();
        this.allClusterColumnsList = new JList(this.allClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.allClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllClusterColumnListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allClusterColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 560));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(jScrollPane);
        this.setLabelConstraints(this.getClusterColumnsLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedClusterColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.clusterColumns.add(jLabel);
        this.selectedClusterColumnsModel = new DefaultListModel();
        this.selectedClusterColumnsList = new JList(this.selectedClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedClusterColumnListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedClusterColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 560));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(jScrollPane);
        this.setLabelConstraints(this.getClusterColumnsLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 290, 22);
    }

    private void initClusterColumnsButtons() {
        this.bnAddClusterColumn = new JButton(ADD_CAPTION);
        this.bnAddClusterColumn.addActionListener(new AddClusterColumnsActionListener());
        this.bnAddClusterColumn.setEnabled(false);
        this.clusterColumns.add(this.bnAddClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnAddClusterColumn, 175, 240);
        this.bnRemoveClusterColumn = new JButton(REMOVE_CAPTION);
        this.bnRemoveClusterColumn.setEnabled(false);
        this.bnRemoveClusterColumn.addActionListener(new RemoveClusterColumnsActionListener());
        this.clusterColumns.add(this.bnRemoveClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnRemoveClusterColumn, 175, 270);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddClusterColumn, this.bnRemoveClusterColumn);
    }

    private void initPartitioningView() {
        this.pnPartitioning = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.Partitioning"), this.pnPartitioning);
        this.tpPartitions = new JTabbedPane();
        this.pnPartitioning.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.General"), this.pnPartGeneral);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.HashSubPartTableSpaces"), this.subPartTS);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.PartitionsOrder"), this.partitionsOrder);
        this.hashPTSTabIndex = this.tpPartitions.indexOfComponent(this.hashPTS);
        this.subPartColumnsTabIndex = this.tpPartitions.indexOfComponent(this.subPartColumns);
        this.subPartTSTabIndex = this.tpPartitions.indexOfComponent(this.subPartTS);
        this.initPartitioning();
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
        this.initPartitionsOrder();
    }

    private void initGeneralPartitioning() {
        this.initPartType();
        this.initUseSubpartitionsStorageTemplate();
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initHashPTS() {
        this.initHashPQuantity();
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    private void initSubPartColumns() {
        this.initAllSubPartColumnsList();
        this.initSelectedSubPartColumnsList();
        this.initSubPartColumnsButtons();
    }

    private void initSubPartTS() {
        this.initSubPartQuantity();
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartitionsOrder() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogOracle.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("TablePropertyDialogOracle.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new MoveUpAction2());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("TablePropertyDialogOracle.MoveDown"));
            jButton2.addActionListener(new MoveDownAction2());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add((Component)jPanel, "North");
        this.partitionsOrderModel = new PartitionsOrderModel();
        this.partSelectionModel = new DefaultListSelectionModel();
        this.partSelectionModel.setSelectionMode(2);
        this.partitionsOrderTable = new JTable(this.partitionsOrderModel);
        this.partitionsOrderTable.setSelectionModel(this.partSelectionModel);
        jComponent = new JScrollPane(this.partitionsOrderTable);
        jComponent.setPreferredSize(new Dimension(400, 500));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 40);
    }

    private void initPartType() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.PartitionType"));
        this.pnPartGeneral.add(jLabel);
        this.cbPartType = new JComboBox<String>(PartitionListOraclev9i.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.addActionListener(new PartitionTypeListener());
        this.cbPartType.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    private void initUseSubpartitionsStorageTemplate() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.UseSPTemplate"));
        this.pnPartGeneral.add(jLabel);
        this.cbUseSubpartitionsStorageTemplate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUseSubpartitionsStorageTemplate);
        this.cbUseSubpartitionsStorageTemplate.addActionListener(new PartitionTypeListener());
        this.cbUseSubpartitionsStorageTemplate.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbUseSubpartitionsStorageTemplate);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 50);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbUseSubpartitionsStorageTemplate, 50);
    }

    private void initHashPQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.HashPQuantity"));
        this.hashPTS.add(jLabel);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.hashPTS.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 20);
        this.setObjectConstraints(this.getHashPTSLayout(), this.ifHashPQuantity, 20);
    }

    private void initAllHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.hashPTS.add(jLabel);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 8, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 6, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.HashPTableSpaces"));
        this.hashPTS.add(jLabel);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 292, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 135);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 165);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.hashPTS.add(jLabel);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 8, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 6, 312);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTOverflowTS"));
        this.hashPTS.add(jLabel);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 292, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 290, 312);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddIOTOverflowHashPTS, 175, 370);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 400);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private void reinitPartitioning(boolean bl) {
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        this.allSubPartColumnsModel.clear();
        this.selectedSubPartColumnsModel.clear();
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        this.cbPartType.setEnabled(bl);
        String string = "";
        if (bl) {
            string = (String)this.cbPartType.getSelectedItem();
        }
        this.enableRelevantPartitionFields(string);
        if (bl) {
            this.initPartColumns(this.partList);
            this.initHashPTS(this.partList);
            this.initIOTOverflowHashPTS(this.partList);
            this.initSubPartColumns(this.partList);
            this.initSubPartTS(this.partList);
        }
    }

    private void enableRelevantPartitionFields(String string) {
        boolean bl;
        boolean bl2 = !string.equals("");
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl2) {
            bl3 = string.equalsIgnoreCase("HASH BY QUANTITY");
            bl5 = string.equalsIgnoreCase("COMPOSITE BY HASH");
            bl4 = bl5 || string.equalsIgnoreCase("COMPOSITE BY LIST");
        }
        this.cbUseSubpartitionsStorageTemplate.setEnabled(bl4);
        this.allColumnsList.setEnabled(bl2);
        this.selectedColumnsList.setEnabled(bl2);
        this.bnAdd.setEnabled(bl2 && this.allColumnsList.getSelectedIndex() != -1);
        this.bnRemove.setEnabled(bl2 && this.selectedColumnsList.getSelectedIndex() != -1);
        this.tpPartitions.setEnabledAt(this.subPartColumnsTabIndex, bl4);
        if (bl4) {
            this.bnAddSubPartColumns.setEnabled(this.allSubPartColumnsList.getSelectedIndex() != -1);
            this.bnRemoveSubPartColumns.setEnabled(this.selectedSubPartColumnsList.getSelectedIndex() != -1);
        }
        this.tpPartitions.setEnabledAt(this.hashPTSTabIndex, bl3);
        if (bl3) {
            this.bnAddHashPTS.setEnabled(this.allHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveHashPTS.setEnabled(this.selectedHashPTSList.getSelectedIndex() != -1);
            bl = this.cbOrganization.getSelectedItem().equals("INDEX");
            this.allIOTOverflowHashPTSList.setEnabled(bl);
            this.selectedIOTOverflowHashPTSList.setEnabled(bl);
            this.bnAddIOTOverflowHashPTS.setEnabled(bl && this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveIOTOverflowHashPTS.setEnabled(bl && this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
        }
        bl = bl5 && ((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()).equalsIgnoreCase(NO);
        this.tpPartitions.setEnabledAt(this.subPartTSTabIndex, bl);
        if (bl) {
            this.bnAddSubPartTS.setEnabled(this.allSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveSubPartTS.setEnabled(this.selectedSubPartTSList.getSelectedIndex() != -1);
        }
    }

    private void initPartColumns(PartitionListOraclev9i partitionListOraclev9i) {
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (partitionListOraclev9i != null && partitionListOraclev9i.getColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allColumnsModel.addElement(columnProxy);
        }
    }

    private void initHashPTS(PartitionListOraclev9i partitionListOraclev9i) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev9i != null && partitionListOraclev9i.getHashPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    private void initIOTOverflowHashPTS(PartitionListOraclev9i partitionListOraclev9i) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev9i != null && partitionListOraclev9i.getIOTOverflowHashPTSSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    private void initSubPartColumns(PartitionListOraclev9i partitionListOraclev9i) {
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (partitionListOraclev9i != null && partitionListOraclev9i.getSubPartitionsColumnsSet().contains(columnProxy.getObjectID())) {
                this.selectedSubPartColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allSubPartColumnsModel.addElement(columnProxy);
        }
    }

    private void initSubPartTS(PartitionListOraclev9i partitionListOraclev9i) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev9i != null && partitionListOraclev9i.getSubPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedSubPartTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allSubPartTSModel.addElement(tableSpaceOracle);
        }
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.pnPartGeneral.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 440));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 8, 84);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 6, 102);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.pnPartGeneral.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 440));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 292, 84);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 290, 102);
    }

    private void initButtons() {
        this.bnAdd = new JButton(ADD_CAPTION);
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.pnPartGeneral.add(this.bnAdd);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnAdd, 175, 245);
        this.bnRemove = new JButton(REMOVE_CAPTION);
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.pnPartGeneral.add(this.bnRemove);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnRemove, 175, 275);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initAllSubPartColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.subPartColumns.add(jLabel);
        this.allSubPartColumnsModel = new DefaultListModel();
        this.allSubPartColumnsList = new JList(this.allSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.allSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 520));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.subPartColumns.add(jLabel);
        this.selectedSubPartColumnsModel = new DefaultListModel();
        this.selectedSubPartColumnsList = new JList(this.selectedSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 520));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartColumnsButtons() {
        this.bnAddSubPartColumns = new JButton(ADD_CAPTION);
        this.bnAddSubPartColumns.addActionListener(new AddSubPartColumnsActionListener());
        this.bnAddSubPartColumns.setEnabled(false);
        this.subPartColumns.add(this.bnAddSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnAddSubPartColumns, 175, 230);
        this.bnRemoveSubPartColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartColumns.setEnabled(false);
        this.bnRemoveSubPartColumns.addActionListener(new RemoveSubPartColumnsActionListener());
        this.subPartColumns.add(this.bnRemoveSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnRemoveSubPartColumns, 175, 260);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartColumns, this.bnRemoveSubPartColumns);
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SubPartQuantity"));
        this.subPartTS.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.subPartTS.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 20);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.ifSubPartQuantity, 20);
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 445));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 72);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 445));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 72);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 230);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 260);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    @Override
    public void initProperties() {
        ColumnProxy columnProxy;
        int n;
        this.ordered = false;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        String string = this.table.getBasedOnStructuredType();
        this.tfBasedOnStructuredType.setText(string);
        this.selectObject(this.cbUser, this.table.getUser());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.cbOrganization.setSelectedItem(this.table.getOrganization());
        this.selectObject(this.cbCluster, this.table.getCluster());
        this.cbLogging.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getLogging()));
        this.selectObject(this.cbSegment, this.table.getSegment());
        this.cbCache.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getCache()));
        this.cbMonitoring.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getMonitoring()));
        this.cbRowDependency.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getRowDependency()));
        this.cbPartitioned.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbPartRowMovement.setSelectedItem(this.table.getParttitionedRowMovement());
        this.cbDataSegmentCompression.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.table.getIotCompress());
        this.ifIotPctThreshold.setValue((long)this.table.getIotPctThreshold());
        this.fillComboItems(this.table.getColumnProxies(), this.cbIotIncluding);
        this.cbIotIncluding.setSelectedItem(this.table.getIotIncluding());
        this.cbIotOverflowSegment.setSelectedItem(this.table.getIotOverflowSegment());
        this.cbIotMappingTable.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getIOTMappingTable()));
        this.cbSnapshot.setSelectedItem(this.table.getSnapshot());
        this.table.getPartitions().setForbiddenCreateElement(true);
        this.partitions = new ArrayList();
        this.table.getPartitions().addAllElementsTo(this.partitions);
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (n = 0; n < columnProxyArray.length; ++n) {
            columnProxy = columnProxyArray[n];
            if (this.table.getSuplementalLogColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedSupplementalColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allSupplementalColumnsModel.addElement(columnProxy);
        }
        this.tfSupplementalLogGroupName.setText(this.table.getSuplementalLogGroupName());
        this.cbSupplementalLogCondition.setSelectedItem(this.table.getSuplementalLogConditions());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.oidProperties), !string.equals(""));
        this.tfOidType.setText(this.table.getOidType());
        this.tfOidIndexName.setText(this.table.getOidIndexName());
        this.cbOidIndexSegment.setSelectedItem(this.table.getOidIndexSegment());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.xmlTypeProperties), string.equalsIgnoreCase("XMLTYPE"));
        this.tfXmlSchemaUrl.setText(this.table.getXmlSchemaUrl());
        this.tfXmlSchemaElement.setText(this.table.getXmlSchemaElement());
        this.cbStoreAs.setSelectedItem(this.table.getStoreAs());
        this.tfLobSegmentName.setText(this.table.getLobSegmentName());
        this.selectObject(this.cbXmlTypeTableSpace, this.table.getXmlTypeTableSpace());
        this.cbStorageInRow.setSelectedItem(this.table.getStorageInRow());
        this.cbXmlTypeLogging.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getXmlTypeLogging()));
        this.cbXmlTypeCache.setSelectedItem(this.table.getXmlTypeCache());
        this.ifChunk.setValue((long)this.table.getChunk());
        this.cbOldVersions.setSelectedItem(this.table.getOldVersions());
        this.ifPctVersion.setValue((long)this.table.getPCTVersion());
        this.ifFreePools.setValue((long)this.table.getFreepools());
        for (n = 0; n < columnProxyArray.length; ++n) {
            columnProxy = columnProxyArray[n];
            if (this.table.getClusterColumnsSet().contains(columnProxy.getObjectID())) {
                this.selectedClusterColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allClusterColumnsModel.addElement(columnProxy);
        }
        if (this.partList != null) {
            this.cbPartType.setSelectedItem(this.partList.getPartitionType());
            this.ifHashPQuantity.setValue((long)this.partList.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)this.partList.getSubPartitionsQuantity());
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.partList.getUseSubpartStorageTemplate()));
            this.reinitPartitioning(true);
        } else {
            this.ifHashPQuantity.setValue(1L);
            this.ifSubPartQuantity.setValue(1L);
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(NO);
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        if (this.table.getTemporary().equals("NO")) {
            this.cbTemporary.setSelectedItem(NO);
        } else if (this.table.getTempPreserveRows().equals("YES")) {
            this.cbTemporary.setSelectedItem(YES_PRESERVE);
        } else {
            this.cbTemporary.setSelectedItem(YES_DELETE);
        }
        this.cbParallel.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getParallel()));
        this.tfDegree.setText(this.table.getDegree());
        if (this.cbSnapshot.getSelectedItem() != null) {
            this.snapshotChanged();
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            Object[] objectArray;
            Object[] objectArray2;
            boolean bl;
            this.table.setName(this.tfName.getText());
            Object object = this.cbUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.table.setUser((UserOracle)object);
            } else {
                this.table.setUser(null);
            }
            if (this.cbTemporary.getSelectedItem().equals(NO)) {
                this.table.setTemporary("NO");
            } else {
                this.table.setTemporary("YES");
                if (this.cbTemporary.getSelectedItem().equals(YES_PRESERVE)) {
                    this.table.setTempPreserveRows("YES");
                } else {
                    this.table.setTempPreserveRows("NO");
                }
            }
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.table.setTableSpace((TableSpaceOracle)object);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setOrganization((String)this.cbOrganization.getSelectedItem());
            object = this.cbCluster.getSelectedItem();
            if (object instanceof ClusterOracle) {
                this.table.setCluster((ClusterOracle)object);
            } else {
                this.table.setCluster(null);
            }
            this.table.setLogging(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOracle) {
                this.table.setSegment((SegmentOracle)object);
            } else {
                this.table.setSegment(null);
            }
            this.table.setCache(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.table.setMonitoring(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbMonitoring.getSelectedItem()));
            this.table.setParallel(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.table.setDegree(this.tfDegree.getText());
            this.table.setRowDependency(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.table.setPartitioned(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setParttitionedRowMovement((String)this.cbPartRowMovement.getSelectedItem());
            this.table.setDataSegmentCompression(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDataSegmentCompression.getSelectedItem()));
            this.table.setIotCompress(this.ifIotCompress.getIntValue());
            this.table.setIotPctThreshold(this.ifIotPctThreshold.getIntValue());
            object = this.cbIotIncluding.getSelectedItem();
            if (object instanceof ColumnProxy) {
                this.table.setIotIncluding((ColumnProxy)object);
            } else {
                this.table.setIotIncluding(null);
            }
            object = this.cbIotOverflowSegment.getSelectedItem();
            if (object instanceof SegmentOracle) {
                this.table.setIotOverflowSegment((SegmentOracle)object);
            } else {
                this.table.setIotOverflowSegment(null);
            }
            this.table.setIOTMappingTable(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbIotMappingTable.getSelectedItem()));
            object = this.cbSnapshot.getSelectedItem();
            if (object instanceof SnapshotOracle) {
                this.table.setSnapshot((SnapshotOracle)object);
            } else {
                this.table.setSnapshot(null);
            }
            Object[] objectArray3 = this.selectedSupplementalColumnsModel.toArray();
            this.table.clearSuplementalLogColumns();
            for (int i = 0; i < objectArray3.length; ++i) {
                Object object2 = objectArray3[i];
                if (!(object2 instanceof ColumnProxy)) continue;
                this.table.setSuplementalLogColumns(((ColumnProxy)object2).getObjectID());
            }
            this.table.setSuplementalLogGroupName(this.tfSupplementalLogGroupName.getText());
            this.table.setSuplementalLogConditions((String)this.cbSupplementalLogCondition.getSelectedItem());
            Object[] objectArray4 = this.selectedClusterColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < objectArray4.length; ++i) {
                Object object3 = objectArray4[i];
                if (!(object3 instanceof ColumnProxy)) continue;
                this.table.setClusterColumns(((ColumnProxy)object3).getObjectID());
            }
            this.table.setOidIndexName(this.tfOidIndexName.getText());
            this.table.setOidIndexSegment((SegmentOracle)this.cbOidIndexSegment.getSelectedItem());
            this.table.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
            this.table.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
            String string = (String)this.cbStoreAs.getSelectedItem();
            this.table.setStoreAs(string);
            if (!string.equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.table.setLobSegmentName(this.tfLobSegmentName.getText());
                object = this.cbXmlTypeTableSpace.getSelectedItem();
                if (object instanceof TableSpaceOraclev9i) {
                    this.table.setXmlTypeTableSpace((TableSpaceOraclev9i)object);
                } else {
                    this.table.setXmlTypeTableSpace(null);
                }
                this.table.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                this.table.setXmlTypeLogging(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbXmlTypeLogging.getSelectedItem()));
                this.table.setXmlTypeCache((String)this.cbXmlTypeCache.getSelectedItem());
                this.table.setChunk(this.ifChunk.getIntValue());
                this.table.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                this.table.setFreepools(this.ifFreePools.getIntValue());
                this.table.setPCTVersion(this.ifPctVersion.getIntValue());
            }
            if (bl = String.valueOf(object = this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(YES)) {
                Object object4;
                int n;
                if (this.partList == null) {
                    this.partList = (PartitionListOraclev9i)this.getStorageDesign().getPartitionListSet().createPartitionList();
                }
                this.partList.setPartitionType((String)this.cbPartType.getSelectedItem());
                this.partList.setUseSubpartStorageTemplate(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()));
                this.partList.setHashPQuantity(this.ifHashPQuantity.getIntValue());
                this.partList.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
                this.table.setPartitionList(this.partList);
                this.partList.clear();
                objectArray4 = this.selectedColumnsModel.toArray();
                for (int i = 0; i < objectArray4.length; ++i) {
                    Object object5 = objectArray4[i];
                    if (!(object5 instanceof ColumnProxyOraclev9i)) continue;
                    this.partList.setColumnIDs(((ColumnProxyOraclev9i)object5).getObjectID());
                }
                objectArray2 = this.selectedHashPTSModel.toArray();
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object6 = objectArray2[i];
                    if (!(object6 instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setHashPTableSpaces(((TableSpaceOraclev9i)object6).getObjectID());
                }
                objectArray = this.selectedIOTOverflowHashPTSModel.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    object4 = objectArray[n];
                    if (!(object4 instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setIOTOverflowHashPTSSet(((TableSpaceOraclev9i)object4).getObjectID());
                }
                objectArray4 = this.selectedSubPartColumnsModel.toArray();
                for (n = 0; n < objectArray4.length; ++n) {
                    object4 = objectArray4[n];
                    if (!(object4 instanceof RelationalObjectProxy)) continue;
                    this.partList.setSubPartitionsColumnIDs(((RelationalObjectProxy)object4).getObjectID());
                }
                objectArray2 = this.selectedSubPartTSModel.toArray();
                for (n = 0; n < objectArray2.length; ++n) {
                    object4 = objectArray2[n];
                    if (!(object4 instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setSubPartitionsTableSpaces(((TableSpaceOraclev9i)object4).getObjectID());
                }
                if (this.ordered && this.table.getPartitions().size() == this.partitions.size()) {
                    this.ordered = false;
                    n = this.table.getPartitions().size();
                    for (int i = 0; i < n; ++i) {
                        this.table.getPartitions().justRemove(this.table.getPartitions().getElement(0));
                    }
                    for (int i = 0; i < this.partitions.size(); ++i) {
                        if (this.partitions.get(i) instanceof PartitionOracle) {
                            PartitionOracle partitionOracle = (PartitionOracle)this.partitions.get(i);
                            partitionOracle.addObjectListener(this.table);
                            partitionOracle.setParent(this.table.getPartitions());
                            this.table.getPartitions().add(partitionOracle);
                            partitionOracle.setPosition(i + 1);
                            continue;
                        }
                        this.table.getPartitions().add((ModelObject)this.partitions.get(i));
                    }
                }
            } else if (this.partList != null) {
                this.table.setPartitionList(null);
                this.partList.remove();
                this.partList = null;
            }
            if (StringUtilities.isNotEmpty((String)(objectArray2 = this.getCommentsList().getText())) && !this.comment.equals(objectArray2)) {
                this.table.setComment((String)objectArray2);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            objectArray = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)objectArray) && !this.commentInRDBMS.equals(objectArray)) {
                this.table.setCommentInRDBMS((String)objectArray);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void snapshotChanged() {
        boolean bl = this.cbSnapshot.getSelectedItem() == null;
        this.tfName.setEnabled(bl);
        this.cbUser.setEnabled(bl);
        this.cbTemporary.setEnabled(bl);
        this.cbTableSpace.setEnabled(bl);
        this.cbCluster.setEnabled(bl);
        this.cbLogging.setEnabled(bl);
        this.cbCache.setEnabled(bl);
        this.cbMonitoring.setEnabled(bl);
        this.cbParallel.setEnabled(bl);
        this.tfDegree.setEnabled(bl);
        this.cbPartRowMovement.setEnabled(bl);
        this.cbDataSegmentCompression.setEnabled(bl);
        this.bnPermissions.setEnabled(bl);
        try {
            this.getPane().setEnabledAt(1, bl);
            this.getPane().setEnabledAt(3, bl);
            this.getPane().setEnabledAt(4, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean moveToIndex(Object object, int n) {
        if (this.partitions.contains(object) && this.partitions.size() > n && n >= 0) {
            this.partitions.remove(object);
            this.partitions.add(n, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel defaultListSelectionModel, int[] nArray) {
        defaultListSelectionModel.clearSelection();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                defaultListSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    @Override
    protected void postProcessingInApply() {
        if (this.table != null) {
            this.table.getPartitions().setForbiddenCreateElement(true);
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.table != null) {
            this.table.getPartitions().setForbiddenCreateElement(!"YES".equals(this.table.getPartitioned()) || this.table.getPartitionList() == null || "HASH BY QUANTITY".equalsIgnoreCase(this.table.getPartitionList().getPartitionType()));
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < TablePropertyDialogOraclev9i.this.partitions.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = TablePropertyDialogOraclev9i.this.partitions.get(n);
                    TablePropertyDialogOraclev9i.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                TablePropertyDialogOraclev9i.this.setSelection(TablePropertyDialogOraclev9i.this.partSelectionModel, nArray);
                TablePropertyDialogOraclev9i.this.ordered = true;
                TablePropertyDialogOraclev9i.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = TablePropertyDialogOraclev9i.this.partitions.get(n);
                    TablePropertyDialogOraclev9i.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                TablePropertyDialogOraclev9i.this.setSelection(TablePropertyDialogOraclev9i.this.partSelectionModel, nArray);
                TablePropertyDialogOraclev9i.this.ordered = true;
                TablePropertyDialogOraclev9i.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class PartitionsOrderModel
    extends AbstractTableModel {
        private PartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (TablePropertyDialogOraclev9i.this.partitions == null) {
                return 0;
            }
            return TablePropertyDialogOraclev9i.this.partitions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TablePropertyDialogOracle.PartitionName");
            }
            if (n == 1) {
                return Messages.getString("TablePropertyDialogOracle.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageObject storageObject = (StorageObject)TablePropertyDialogOraclev9i.this.partitions.get(n);
            if (n2 == 0) {
                return storageObject.getName();
            }
            if (n2 == 1) {
                if (storageObject instanceof PartitionOracle) {
                    return ((PartitionOracle)storageObject).getValueList();
                }
                if (storageObject instanceof ListPartitionOracle) {
                    return ((ListPartitionOracle)storageObject).getColumns();
                }
                return "";
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allSubPartTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allSubPartTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSubPartColumnsActionListener
    implements ActionListener {
        private RemoveSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartColumnsActionListener
    implements ActionListener {
        private AddSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSubPartColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartColumns.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST") || ((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("COMPOSITE BY LIST")) {
                    if (TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedIndex() == -1 || TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.toArray().length >= 1) {
                        TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(true);
                    }
                } else if (TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSupplementalColumnsActionListener
    implements ActionListener {
        private RemoveSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddSupplementalColumnsActionListener
    implements ActionListener {
        private AddSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSupplementalSelectionHandler
    implements ListSelectionListener {
        private SelectedListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnSupplementalRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnSupplementalRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSupplementalSelectionHandler
    implements ListSelectionListener {
        private AllListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnSupplementalAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnSupplementalAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST") || ((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("COMPOSITE BY LIST")) {
                    if (TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1 || TablePropertyDialogOraclev9i.this.selectedColumnsModel.toArray().length >= 1) {
                        TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(TablePropertyDialogOraclev9i.this.isEditable());
                    }
                } else if (TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(TablePropertyDialogOraclev9i.this.isEditable());
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedHashPTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allHashPTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allHashPTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allHashPTSModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedHashPTSModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedHashPTSModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem();
            TablePropertyDialogOraclev9i.this.allColumnsList.getSelectionModel().clearSelection();
            TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectionModel().clearSelection();
            if (string.equalsIgnoreCase("LIST") && TablePropertyDialogOraclev9i.this.selectedColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev9i.this.allColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.selectedColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.initPartColumns(TablePropertyDialogOraclev9i.this.partList);
            }
            if (string.equalsIgnoreCase("COMPOSITE BY LIST") && TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.initSubPartColumns(TablePropertyDialogOraclev9i.this.partList);
            }
            TablePropertyDialogOraclev9i.this.enableRelevantPartitionFields(string);
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogOraclev9i.this.partitions.size()) {
                StorageObject storageObject = (StorageObject)TablePropertyDialogOraclev9i.this.partitions.get(n);
                storageObject.showPropertyDialog();
            }
        }
    }

    private class RemoveClusterColumnsActionListener
    implements ActionListener {
        private RemoveClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.allClusterColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.allClusterColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddClusterColumnsActionListener
    implements ActionListener {
        private AddClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.allClusterColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.addElement(object);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private SelectedClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class AllClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private AllClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev9i.this.ifPctVersion.setEnabled(TablePropertyDialogOraclev9i.this.cbOldVersions.getSelectedItem().equals("PCT_VERSION"));
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = TablePropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL");
            TablePropertyDialogOraclev9i.this.enableXMLTypeClobOptions(!bl);
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((String)TablePropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES);
            int n = TablePropertyDialogOraclev9i.this.getPane().indexOfComponent(TablePropertyDialogOraclev9i.this.pnPartitioning);
            if (n > -1) {
                TablePropertyDialogOraclev9i.this.getPane().setEnabledAt(n, bl);
            }
            TablePropertyDialogOraclev9i.this.reinitPartitioning(bl);
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev9i.this.tfDegree.setEnabled(TablePropertyDialogOraclev9i.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TablePropertyDialogOraclev9i.this.cbOrganization.getSelectedItem();
            if (string != null) {
                if (string.equalsIgnoreCase("HEAP")) {
                    TablePropertyDialogOraclev9i.this.cbCache.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.ifIotCompress.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.ifIotPctThreshold.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.cbIotIncluding.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.cbIotOverflowSegment.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.cbIotMappingTable.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.cbCache.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.ifIotCompress.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.ifIotPctThreshold.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.cbIotIncluding.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.cbIotOverflowSegment.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.cbIotMappingTable.setEnabled(true);
                }
            }
        }
    }

    private class ClusterListener
    implements ActionListener {
        private ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(true);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev9i.this.cbTemporary.getSelectedItem().equals(AbstractPropertyDialog.NO)) {
                TablePropertyDialogOraclev9i.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbCluster.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbTableSpace.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbPartRowMovement.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbLogging.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbMonitoring.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev9i.this.cbCluster.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbTableSpace.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbPartRowMovement.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbLogging.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbMonitoring.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbParallel.setEnabled(true);
                if (TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                    TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
                    TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(TablePropertyDialogOraclev9i.this.getAppView(), TablePropertyDialogOraclev9i.this.getStorageDesign(), TablePropertyDialogOraclev9i.this.table);
            TablePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

