/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SequenceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SequenceOraclev9i sequence;
    private JComboBox cbUser;
    private JIntegerField ifStartWith;
    private JIntegerField ifIncrementBy;
    private JIntegerField ifMaxValue;
    private JIntegerField ifMinValue;
    private JComboBox cbCycle;
    private JComboBox cbNoCache;
    private JIntegerField ifCache;
    private JComboBox cbOrder;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private static final int SEQ_VALUE_MAX_DIGITS = 28;

    public SequencePropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.sequence = (SequenceOraclev9i)storageObject;
        this.setHeight(390);
        this.initCommentsView(340);
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogOraclev9i.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initStartWith();
        this.initIncremetBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initStartWith() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.StartWith"));
        this.general.add(jLabel);
        this.ifStartWith = new JIntegerField();
        this.ifStartWith.setColumns(26);
        this.ifStartWith.setLargeIntegerDocument(28);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifStartWith, 80);
    }

    private void initIncremetBy() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.IncrementBy"));
        this.general.add(jLabel);
        this.ifIncrementBy = new JIntegerField();
        this.ifIncrementBy.setColumns(26);
        this.ifIncrementBy.setLargeIntegerDocument(28);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.ifIncrementBy, 110);
    }

    private void initMaxValue() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.MaxValue"));
        this.general.add(jLabel);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.ifMaxValue, 170);
    }

    private void initMinValue() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.MinValue"));
        this.general.add(jLabel);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(28);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifMinValue, 140);
    }

    private void initCycle() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Cycle"));
        this.general.add(jLabel);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbCycle, 200);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.NoCache"));
        this.general.add(jLabel);
        this.cbNoCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNoCache);
        this.cbNoCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNoCache);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbNoCache, 230);
        this.cbNoCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractPropertyDialog.YES.equals(SequencePropertyDialogOraclev9i.this.cbNoCache.getSelectedItem())) {
                    SequencePropertyDialogOraclev9i.this.ifCache.setValue(null);
                    SequencePropertyDialogOraclev9i.this.ifCache.setEditable(false);
                    SequencePropertyDialogOraclev9i.this.ifCache.setFocusable(false);
                } else {
                    try {
                        SequencePropertyDialogOraclev9i.this.ifCache.setValue(Integer.valueOf(SequencePropertyDialogOraclev9i.this.sequence.getCache()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        SequencePropertyDialogOraclev9i.this.ifCache.setValue(null);
                    }
                    SequencePropertyDialogOraclev9i.this.ifCache.setEditable(true);
                    SequencePropertyDialogOraclev9i.this.ifCache.setFocusable(true);
                }
            }
        });
        jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Cache"));
        this.general.add(jLabel);
        this.ifCache = new JIntegerField();
        this.ifCache.setColumns(26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.ifCache, 260);
    }

    private void initOrder() {
        JLabel jLabel = new JLabel(Messages.getString("SequencePropertyDialogOraclev9i.Order"));
        this.general.add(jLabel);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrder);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbOrder, 290);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("SequencePropertyDialogOraclev9i.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(SequencePropertyDialogOraclev9i.this.getStorageDesign().getSequenceSet().getElementsList());
                arrayList.remove(SequencePropertyDialogOraclev9i.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogOraclev9i.this.getAppView(), SequencePropertyDialogOraclev9i.this.sequence, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 320);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("SequencePropertyDialogOraclev9i.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 320);
    }

    @Override
    public void initProperties() {
        double d;
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.selectObject(this.cbUser, this.sequence.getUser());
        try {
            d = Double.parseDouble(this.sequence.getStartWith());
            this.ifStartWith.setText(this.sequence.getStartWith());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifStartWith.setText("");
        }
        try {
            d = Double.parseDouble(this.sequence.getIncrementBy());
            this.ifIncrementBy.setText(this.sequence.getIncrementBy());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifIncrementBy.setText("");
        }
        try {
            double d2 = Double.parseDouble(this.sequence.getMaxValue());
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifMaxValue.setText("");
        }
        try {
            double d3 = Double.parseDouble(this.sequence.getMinValue());
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.ifMinValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getCycle()));
        this.cbNoCache.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getNoCache()));
        try {
            this.ifCache.setValue(Integer.valueOf(this.sequence.getCache()));
        }
        catch (NumberFormatException numberFormatException) {
            this.ifCache.setValue(null);
        }
        this.cbOrder.setSelectedItem(SequencePropertyDialogOraclev9i.translateYesNoForDisplay(this.sequence.getOrder()));
        this.getCommentsList().insert(this.sequence.getComment(), 0);
        this.taNotes.setText(this.sequence.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            double d;
            Object object = this.cbUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.sequence.setUser((UserOracle)object);
            } else {
                this.sequence.setUser(null);
            }
            this.sequence.setName(this.tfName.getText());
            try {
                d = Double.parseDouble(this.ifStartWith.getText());
                this.sequence.setStartWith(this.ifStartWith.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setStartWith("");
            }
            try {
                d = Double.parseDouble(this.ifIncrementBy.getText());
                this.sequence.setIncrementBy(this.ifIncrementBy.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setIncrementBy("");
            }
            try {
                double d2 = Double.parseDouble(this.ifMaxValue.getText());
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setMaxValue("");
            }
            try {
                double d3 = Double.parseDouble(this.ifMinValue.getText());
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.sequence.setMinValue("");
            }
            this.sequence.setCycle(SequencePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
            String string = (String)this.cbNoCache.getSelectedItem();
            this.sequence.setNoCache(SequencePropertyDialogOraclev9i.translateYesNoForStorage(string));
            if (string.equals(NO)) {
                try {
                    int n = Integer.parseInt(this.ifCache.getText());
                    this.sequence.setCache(this.ifCache.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    this.sequence.setCache("");
                }
            }
            this.sequence.setOrder(SequencePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            this.sequence.setComment(this.getCommentsList().getText());
            this.sequence.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbUser.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SequencePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(SequencePropertyDialogOraclev9i.this.getAppView(), SequencePropertyDialogOraclev9i.this.getStorageDesign(), SequencePropertyDialogOraclev9i.this.sequence);
            SequencePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

