/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.SelectObjectsDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ClusterPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.IndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SnapshotPropertyDialogOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.TablePropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;

public class SegmentPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private static final Logger LOGGER = new Logger(SegmentPropertyDialogOraclev9i.class);
    private SegmentOraclev9i segment;
    private JComboBox cbTableSpace;
    private JIntegerField ifPctFree;
    private JIntegerField ifPctUsed;
    private JIntegerField ifInitrans;
    private JIntegerField ifMaxTrans;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;
    private JPanel clusters;
    private DefaultListModel clusterListModel;
    private JList clusterList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;
    private static GUIConfiguration configuration = GUIConfiguration.getInstance();

    public SegmentPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.segment = (SegmentOraclev9i)storageObject;
        this.setHeight(500);
        this.initCommentsView(450);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("SegmentPropertyDialogOracle.SegmentProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initPctFree();
        this.initPctUsed();
        this.initInitrans();
        this.initMaxTrans();
        this.initSCInitialExtent();
        this.initSCNextExtent();
        this.initSCMinExtents();
        this.initSCMaxExtents();
        this.initSCPctIncrease();
        this.initSCBufferPool();
        this.initSCFreeLists();
        this.initSCFreeListsGroups();
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbTableSpace, 50);
    }

    private void initPctFree() {
        JLabel jLabel = new JLabel("PCTFREE");
        this.general.add(jLabel);
        this.ifPctFree = new JIntegerField(0, 26);
        this.general.add(this.ifPctFree);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifPctFree, 80);
    }

    private void initPctUsed() {
        JLabel jLabel = new JLabel("PCTUSED");
        this.general.add(jLabel);
        this.ifPctUsed = new JIntegerField(0, 26);
        this.general.add(this.ifPctUsed);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.ifPctUsed, 110);
    }

    private void initInitrans() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.Initrans"));
        this.general.add(jLabel);
        this.ifInitrans = new JIntegerField(0, 26);
        this.general.add(this.ifInitrans);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifInitrans, 140);
    }

    private void initMaxTrans() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.MaxTrans"));
        this.general.add(jLabel);
        this.ifMaxTrans = new JIntegerField(0, 26);
        this.general.add(this.ifMaxTrans);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.ifMaxTrans, 170);
    }

    private void initSCInitialExtent() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCInitialExtent"));
        this.general.add(jLabel);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCInitialExtent);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifSCInitialExtent, 200);
    }

    private void initSCNextExtent() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCNextExtent"));
        this.general.add(jLabel);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCNextExtent);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifSCNextExtent, 230);
    }

    private void initSCMinExtents() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCMinExtents"));
        this.general.add(jLabel);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.general.add(this.ifSCMinExtents);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.ifSCMinExtents, 260);
    }

    private void initSCMaxExtents() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCMaxExtents"));
        this.general.add(jLabel);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfSCMaxExtents);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfSCMaxExtents, 290);
    }

    private void initSCPctIncrease() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCPCTIncrease"));
        this.general.add(jLabel);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.general.add(this.ifSCPctIncrease);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.ifSCPctIncrease, 320);
    }

    private void initSCBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCBufferPool"));
        this.general.add(jLabel);
        this.cbSCBufferPool = new JComboBox<String>(SegmentOracle.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSCBufferPool);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbSCBufferPool, 350);
    }

    private void initSCFreeLists() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCFreeLists"));
        this.general.add(jLabel);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeLists);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.ifSCFreeLists, 380);
    }

    private void initSCFreeListsGroups() {
        JLabel jLabel = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCFreeListsGrps"));
        this.general.add(jLabel);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.ifSCFreeListsGroups, 410);
    }

    @Override
    protected void addTabs() {
        this.initClustersView();
        this.initTablesView();
        this.initIndexesView();
        this.initSnapshotsView();
    }

    private void initClustersView() {
        this.clusters = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Clusters"), this.clusters);
        this.initClusters();
    }

    private void initClusters() {
        JComponent jComponent;
        if (this.isEditable()) {
            jComponent = new JButton(configuration.getIcon("ADD_ICON", 16));
            jComponent.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToClusters"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    Iterator iterator = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getClusterSet().iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!SegmentPropertyDialogOraclev9i.this.clusterListModel.contains(object)) {
                            arrayList.add(object);
                            continue;
                        }
                        arrayList2.add(object);
                    }
                    object = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), arrayList, arrayList2, Messages.getString("SegmentPropertyDialogOracle.SelectClusters"));
                    if (((SelectObjectsDialog)object).showDialog()) {
                        Object object2;
                        for (int i = SegmentPropertyDialogOraclev9i.this.clusterListModel.size() - 1; i >= 0; --i) {
                            object2 = SegmentPropertyDialogOraclev9i.this.clusterListModel.elementAt(i);
                            try {
                                Method method = object2.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(object2, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.clusterListModel.remove(i);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn(exception.getMessage(), exception);
                            }
                        }
                        for (Object e : arrayList2) {
                            try {
                                object2 = e.getClass().getMethod("setSegment", SegmentOracle.class);
                                ((Method)object2).invoke(e, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.clusterListModel.contains(e)) continue;
                                SegmentPropertyDialogOraclev9i.this.clusterListModel.addElement(e);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
            JButton jButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            jButton.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.clusterListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.clusterList.isSelectedIndex(i)) continue;
                        Object e = SegmentPropertyDialogOraclev9i.this.clusterListModel.elementAt(i);
                        try {
                            Method method = e.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(e, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.clusterListModel.remove(i);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn(exception.getMessage(), exception);
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jComponent);
            jToolBar.add(jButton);
            jToolBar.setPreferredSize(new Dimension(395, 34));
            this.clusters.add(jToolBar);
            this.setObjectConstraints(this.getClusterLayout(), jToolBar, 10, 12);
        }
        this.clusterListModel = new DefaultListModel();
        this.clusterList = new JList(this.clusterListModel);
        this.clusterList.addMouseListener(new ClusterListMouseListener());
        jComponent = new JScrollPane(this.clusterList);
        jComponent.setPreferredSize(new Dimension(395, 415));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusters.add(jComponent);
        this.setObjectConstraints(this.getClusterLayout(), jComponent, 10, 47);
    }

    protected SpringLayout getClusterLayout() {
        return (SpringLayout)this.clusters.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        JComponent jComponent;
        if (this.isEditable()) {
            jComponent = new JButton(configuration.getIcon("ADD_ICON", 16));
            jComponent.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToTables"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    Iterator iterator = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getTableProxySet().iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!SegmentPropertyDialogOraclev9i.this.tableListModel.contains(object)) {
                            arrayList.add(object);
                            continue;
                        }
                        arrayList2.add(object);
                    }
                    object = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), arrayList, arrayList2, Messages.getString("SegmentPropertyDialogOracle.SelectTables"));
                    if (((SelectObjectsDialog)object).showDialog()) {
                        Object object2;
                        for (int i = SegmentPropertyDialogOraclev9i.this.tableListModel.size() - 1; i >= 0; --i) {
                            object2 = SegmentPropertyDialogOraclev9i.this.tableListModel.elementAt(i);
                            try {
                                Method method = object2.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(object2, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.tableListModel.remove(i);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn(exception.getMessage(), exception);
                            }
                        }
                        for (Object e : arrayList2) {
                            try {
                                object2 = e.getClass().getMethod("setSegment", SegmentOracle.class);
                                ((Method)object2).invoke(e, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.tableListModel.contains(e)) continue;
                                SegmentPropertyDialogOraclev9i.this.tableListModel.addElement(e);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
            JButton jButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            jButton.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.tableListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.tableList.isSelectedIndex(i)) continue;
                        Object e = SegmentPropertyDialogOraclev9i.this.tableListModel.elementAt(i);
                        try {
                            Method method = e.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(e, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.tableListModel.remove(i);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn(exception.getMessage(), exception);
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jComponent);
            jToolBar.add(jButton);
            jToolBar.setPreferredSize(new Dimension(395, 34));
            this.tables.add(jToolBar);
            this.setObjectConstraints(this.getTableLayout(), jToolBar, 10, 12);
        }
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        jComponent = new JScrollPane(this.tableList);
        jComponent.setPreferredSize(new Dimension(395, 415));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jComponent);
        this.setObjectConstraints(this.getTableLayout(), jComponent, 10, 47);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        JComponent jComponent;
        if (this.isEditable()) {
            jComponent = new JButton(configuration.getIcon("ADD_ICON", 16));
            jComponent.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToIndexes"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    Iterator iterator = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getIndexProxySet().iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!SegmentPropertyDialogOraclev9i.this.indexListModel.contains(object)) {
                            arrayList.add(object);
                            continue;
                        }
                        arrayList2.add(object);
                    }
                    object = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), arrayList, arrayList2, Messages.getString("SegmentPropertyDialogOracle.SelectIndexes"));
                    if (((SelectObjectsDialog)object).showDialog()) {
                        Object object2;
                        for (int i = SegmentPropertyDialogOraclev9i.this.indexListModel.size() - 1; i >= 0; --i) {
                            object2 = SegmentPropertyDialogOraclev9i.this.indexListModel.elementAt(i);
                            try {
                                Method method = object2.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(object2, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.indexListModel.remove(i);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn(exception.getMessage(), exception);
                            }
                        }
                        for (Object e : arrayList2) {
                            try {
                                object2 = e.getClass().getMethod("setSegment", SegmentOracle.class);
                                ((Method)object2).invoke(e, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.indexListModel.contains(e)) continue;
                                SegmentPropertyDialogOraclev9i.this.indexListModel.addElement(e);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
            JButton jButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            jButton.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.indexListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.indexList.isSelectedIndex(i)) continue;
                        Object e = SegmentPropertyDialogOraclev9i.this.indexListModel.elementAt(i);
                        try {
                            Method method = e.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(e, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.indexListModel.remove(i);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn(exception.getMessage(), exception);
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jComponent);
            jToolBar.add(jButton);
            jToolBar.setPreferredSize(new Dimension(395, 34));
            this.indexes.add(jToolBar);
            this.setObjectConstraints(this.getIndexLayout(), jToolBar, 10, 12);
        }
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        jComponent = new JScrollPane(this.indexList);
        jComponent.setPreferredSize(new Dimension(395, 415));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(jComponent);
        this.setObjectConstraints(this.getIndexLayout(), jComponent, 10, 47);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        JComponent jComponent;
        if (this.isEditable()) {
            jComponent = new JButton(configuration.getIcon("ADD_ICON", 16));
            jComponent.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToSnapshots"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    Iterator iterator = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getSnapshotSet().iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!SegmentPropertyDialogOraclev9i.this.snapshotListModel.contains(object)) {
                            arrayList.add(object);
                            continue;
                        }
                        arrayList2.add(object);
                    }
                    object = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), arrayList, arrayList2, Messages.getString("SegmentPropertyDialogOracle.SelectSnapshots"));
                    if (((SelectObjectsDialog)object).showDialog()) {
                        Object object2;
                        for (int i = SegmentPropertyDialogOraclev9i.this.snapshotListModel.size() - 1; i >= 0; --i) {
                            object2 = SegmentPropertyDialogOraclev9i.this.snapshotListModel.elementAt(i);
                            try {
                                Method method = object2.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(object2, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.snapshotListModel.remove(i);
                                continue;
                            }
                            catch (Exception exception) {
                                LOGGER.warn(exception.getMessage(), exception);
                            }
                        }
                        for (Object e : arrayList2) {
                            try {
                                object2 = e.getClass().getMethod("setSegment", SegmentOracle.class);
                                ((Method)object2).invoke(e, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.snapshotListModel.contains(e)) continue;
                                SegmentPropertyDialogOraclev9i.this.snapshotListModel.addElement(e);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
            JButton jButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            jButton.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.snapshotListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.snapshotList.isSelectedIndex(i)) continue;
                        Object e = SegmentPropertyDialogOraclev9i.this.snapshotListModel.elementAt(i);
                        try {
                            Method method = e.getClass().getMethod(Messages.getString("SegmentPropertyDialogOraclev9i.41"), SegmentOracle.class);
                            method.invoke(e, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.snapshotListModel.remove(i);
                            continue;
                        }
                        catch (Exception exception) {
                            LOGGER.warn(exception.getMessage(), exception);
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jComponent);
            jToolBar.add(jButton);
            jToolBar.setPreferredSize(new Dimension(395, 34));
            this.snapshots.add(jToolBar);
            this.setObjectConstraints(this.getSnapshotLayout(), jToolBar, 10, 12);
        }
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        jComponent = new JScrollPane(this.snapshotList);
        jComponent.setPreferredSize(new Dimension(395, 415));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(jComponent);
        this.setObjectConstraints(this.getSnapshotLayout(), jComponent, 10, 47);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.segment.getName());
        this.tfName.setText(this.segment.getName());
        this.selectObject(this.cbTableSpace, this.segment.getTableSpace());
        this.ifPctFree.setValue((long)this.segment.getPCTFree());
        this.ifPctUsed.setValue((long)this.segment.getPCTUsed());
        this.ifInitrans.setValue((long)this.segment.getInitrans());
        this.ifMaxTrans.setValue((long)this.segment.getMaxTrans());
        this.ifSCInitialExtent.setValue(this.segment.getSCInitialExtent());
        this.ifSCNextExtent.setValue(this.segment.getSCNextExtent());
        this.ifSCMinExtents.setValue((long)this.segment.getSCMinExtents());
        this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
        this.ifSCPctIncrease.setValue((long)this.segment.getSCPctIncrease());
        this.cbSCBufferPool.setSelectedItem(this.segment.getSCBufferPool());
        this.ifSCFreeLists.setValue((long)this.segment.getSCFreeLists());
        this.ifSCFreeListsGroups.setValue((long)this.segment.getSCFreelistGroups());
        Object[] objectArray = this.getStorageDesign().getClusterSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((ClusterOraclev9i)objectArray[i]).getSegment() != this.segment) continue;
            this.clusterListModel.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((TableProxyOraclev9i)objectArray2[i]).getSegment() != this.segment) continue;
            this.tableListModel.addElement(objectArray2[i]);
        }
        Object[] objectArray3 = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            if (((IndexProxyOraclev9i)objectArray3[i]).getSegment() != this.segment) continue;
            this.indexListModel.addElement(objectArray3[i]);
        }
        Object[] objectArray4 = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < objectArray4.length; ++i) {
            if (((SnapshotOraclev9i)objectArray4[i]).getSegment() != this.segment) continue;
            this.snapshotListModel.addElement(objectArray4[i]);
        }
        this.getCommentsList().insert(this.segment.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.segment != null) {
            this.segment.setName(this.tfName.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.segment.setTableSpace((TableSpaceOracle)object);
            } else {
                this.segment.setTableSpace(null);
            }
            this.segment.setPCTFree(this.ifPctFree.getIntValue());
            this.segment.setPCTUsed(this.ifPctUsed.getIntValue());
            this.segment.setInitrans(this.ifInitrans.getIntValue());
            this.segment.setMaxTrans(this.ifMaxTrans.getIntValue());
            this.segment.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
            this.segment.setSCNextExtent(this.ifSCNextExtent.getIntValue());
            this.segment.setSCMinExtents(this.ifSCMinExtents.getIntValue());
            this.segment.setSCMaxExtents(this.tfSCMaxExtents.getText());
            this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
            this.segment.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
            this.segment.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
            this.segment.setSCFreeLists(this.ifSCFreeLists.getIntValue());
            this.segment.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
            this.segment.setComment(this.getCommentsList().getText());
        }
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SnapshotOraclev9i snapshotOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (snapshotOraclev9i = (SnapshotOraclev9i)SegmentPropertyDialogOraclev9i.this.snapshotList.getSelectedValue()) != null && !snapshotOraclev9i.isDialogVisible()) {
                SnapshotPropertyDialogOraclev9i snapshotPropertyDialogOraclev9i = new SnapshotPropertyDialogOraclev9i(SegmentPropertyDialogOraclev9i.this.segment.getDesign().getAppView(), SegmentPropertyDialogOraclev9i.this.getStorageDesign(), snapshotOraclev9i);
                snapshotPropertyDialogOraclev9i.show();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyOraclev9i indexProxyOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (indexProxyOraclev9i = (IndexProxyOraclev9i)SegmentPropertyDialogOraclev9i.this.indexList.getSelectedValue()) != null && !indexProxyOraclev9i.isDialogVisible()) {
                IndexPropertyDialogOraclev9i indexPropertyDialogOraclev9i = new IndexPropertyDialogOraclev9i(SegmentPropertyDialogOraclev9i.this.segment.getDesign().getAppView(), SegmentPropertyDialogOraclev9i.this.getStorageDesign(), indexProxyOraclev9i);
                indexPropertyDialogOraclev9i.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyOraclev9i tableProxyOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (tableProxyOraclev9i = (TableProxyOraclev9i)SegmentPropertyDialogOraclev9i.this.tableList.getSelectedValue()) != null && !tableProxyOraclev9i.isDialogVisible()) {
                TablePropertyDialogOraclev9i tablePropertyDialogOraclev9i = new TablePropertyDialogOraclev9i(SegmentPropertyDialogOraclev9i.this.segment.getDesign().getAppView(), SegmentPropertyDialogOraclev9i.this.getStorageDesign(), tableProxyOraclev9i);
                tablePropertyDialogOraclev9i.show();
            }
        }
    }

    private class ClusterListMouseListener
    extends MouseAdapter {
        private ClusterListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ClusterOraclev9i clusterOraclev9i;
            if (mouseEvent.getClickCount() == 2 && (clusterOraclev9i = (ClusterOraclev9i)SegmentPropertyDialogOraclev9i.this.clusterList.getSelectedValue()) != null && !clusterOraclev9i.isDialogVisible()) {
                ClusterPropertyDialogOraclev9i clusterPropertyDialogOraclev9i = new ClusterPropertyDialogOraclev9i(SegmentPropertyDialogOraclev9i.this.segment.getDesign().getAppView(), SegmentPropertyDialogOraclev9i.this.getStorageDesign(), clusterOraclev9i);
                clusterPropertyDialogOraclev9i.show();
            }
        }
    }
}

