/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class QuotaItemPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private QuotaItemOracle quotaItem;
    private JTextField tfUser;
    private JComboBox cbTableSpace;
    private JTextField tfSize;

    public QuotaItemPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.quotaItem = (QuotaItemOracle)storageObject;
        this.setHeight(170);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("QuotaItemPropertyDialogOraclev9i.QuotaItemProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initTableSpace();
        this.initSize();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("QuotaItemPropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.tfUser = new JTextField("", 26);
        this.tfUser.setEditable(false);
        this.general.add(this.tfUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfUser, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("QuotaItemPropertyDialogOraclev9i.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("QuotaItemPropertyDialogOraclev9i.Size"));
        this.general.add(jLabel);
        this.tfSize = new JTextField("", 26);
        this.general.add(this.tfSize);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfSize, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.quotaItem.getName());
        this.tfName.setText(this.quotaItem.getName());
        this.tfUser.setText(this.quotaItem.getUser().getName());
        this.selectObject(this.cbTableSpace, this.quotaItem.getTableSpace());
        this.tfSize.setText(this.quotaItem.getSize());
        this.getCommentsList().insert(this.quotaItem.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.quotaItem != null) {
            this.quotaItem.setName(this.tfName.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.quotaItem.setTableSpace((TableSpaceOracle)object);
            } else {
                this.quotaItem.setTableSpace(null);
            }
            this.quotaItem.setSize(this.tfSize.getText());
            this.tfSize.setText(this.quotaItem.getSize());
            this.quotaItem.setComment(this.getCommentsList().getText());
        }
    }
}

