/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class PKPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private static final String NO_INDEX = NO;
    private static final String LOCAL_PARTITIONED = "LOCAL PARTITIONED";
    private static final String GLOBAL_PARTITIONED = "GLOBAL PARTITIONED";
    private static final String BY_INDEX_NAME = "BY INDEX NAME";
    private static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] USING_INDEX_CHOICES = new String[]{NO_INDEX, "LOCAL PARTITIONED", "GLOBAL PARTITIONED", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static final String NO_SORT = NO;
    private static final String SORTED = "SORTED";
    private static final String REVERSE = "REVERSE";
    private static final String[] SORT_CHOICES = new String[]{NO_SORT, "SORTED", "REVERSE"};
    private PKProxyOraclev9i pkProxy;
    private JTextField tfTable;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbUsingIndex;
    private JComboBox cbIndexSort;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbExTable;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel partitioning;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel usingIndex;
    private JComboBox cbComputeStatistics;
    private JComboBox cbExistingIndex;
    private JTextArea taCreateIndexStatement;
    private JScrollPane spCreateIndexStatement;
    private String comment;
    private String commentInRDBMS;

    public PKPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.pkProxy = (PKProxyOraclev9i)storageObject;
        this.setHeight(380);
        this.initCommentsView(145);
        this.initCommentsInRDBMS(145);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PKPropertyDialogOracle.PrimaryKeyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initUsingIndex();
        this.initExTable();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initInitially() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Initially"));
        this.general.add(jLabel);
        this.cbInitially = new JComboBox<String>(PKProxyOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbInitially, 80);
    }

    private void initDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Deferrable"));
        this.general.add(jLabel);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDeferrable, 110);
    }

    private void initEnable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Enable"));
        this.general.add(jLabel);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbEnable, 140);
    }

    private void initValidate() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Validate"));
        this.general.add(jLabel);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbValidate, 170);
    }

    private void initUsingIndex() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.UsingIndexL"));
        this.general.add(jLabel);
        this.cbUsingIndex = new JComboBox<String>(USING_INDEX_CHOICES);
        this.cbUsingIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)PKPropertyDialogOraclev9i.this.cbUsingIndex.getSelectedItem();
                if (string.equalsIgnoreCase(PKPropertyDialogOraclev9i.BY_INDEX_NAME)) {
                    Component[] componentArray = PKPropertyDialogOraclev9i.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(true);
                } else if (string.equalsIgnoreCase(PKPropertyDialogOraclev9i.BY_CREATE_INDEX_STATEMENT)) {
                    Component[] componentArray = PKPropertyDialogOraclev9i.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(true);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setSelectedItem(null);
                } else if (string.equalsIgnoreCase(NO_INDEX)) {
                    Component[] componentArray = PKPropertyDialogOraclev9i.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(false);
                    }
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setSelectedItem(null);
                } else {
                    Component[] componentArray = PKPropertyDialogOraclev9i.this.usingIndex.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        Component component = componentArray[i];
                        if (component instanceof JLabel) continue;
                        component.setEnabled(true);
                    }
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setSelectedItem(null);
                }
                if (string.equalsIgnoreCase(PKPropertyDialogOraclev9i.GLOBAL_PARTITIONED)) {
                    PKPropertyDialogOraclev9i.this.setPartitioning(true);
                } else {
                    PKPropertyDialogOraclev9i.this.setPartitioning(false);
                }
            }
        });
        this.setBG(this.cbUsingIndex);
        this.cbUsingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUsingIndex);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbUsingIndex, 200);
    }

    private void initExTable() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ExceptionsTable"));
        this.general.add(jLabel);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbExTable, 230);
    }

    private void initIndexSort() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.IndexSort"));
        this.usingIndex.add(jLabel);
        this.cbIndexSort = new JComboBox<String>(SORT_CHOICES);
        this.setBG(this.cbIndexSort);
        this.cbIndexSort.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbIndexSort);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 20);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbIndexSort, 20);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.TableSpace"));
        this.usingIndex.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbTableSpace);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 50);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbTableSpace, 50);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Logging"));
        this.usingIndex.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbLogging);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 80);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbLogging, 80);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.Segment"));
        this.usingIndex.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbSegment);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 110);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbSegment, 110);
    }

    private void initComputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ComputeStatistics"));
        this.usingIndex.add(jLabel);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbComputeStatistics);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 140);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbComputeStatistics, 140);
    }

    private void initExistingIndex() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.ExistingIndex"));
        this.usingIndex.add(jLabel);
        this.cbExistingIndex = new JComboBox();
        this.setBG(this.cbExistingIndex);
        this.cbExistingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbExistingIndex);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 170);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbExistingIndex, 170);
    }

    private void initCreateIndexStatement() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.CreateIndexStatement"));
        this.usingIndex.add(jLabel);
        this.setLabelConstraints(this.getUsingIndexLayout(), jLabel, 200);
        this.taCreateIndexStatement = new JTextArea();
        this.spCreateIndexStatement = new JScrollPane(this.taCreateIndexStatement);
        int n = this.getPane().getPreferredSize().height;
        this.spCreateIndexStatement.setPreferredSize(new Dimension(395, n));
        this.spCreateIndexStatement.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCreateIndexStatement.setLineWrap(true);
        this.usingIndex.add(this.spCreateIndexStatement);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.spCreateIndexStatement, 10, 230);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initPartitioningView();
        this.initUsingIndexView();
    }

    protected SpringLayout getUsingIndexLayout() {
        return (SpringLayout)this.usingIndex.getLayout();
    }

    private void initUsingIndexView() {
        this.usingIndex = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.UsingIndex"), this.usingIndex);
        this.initIndexSort();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initComputeStatistics();
        this.initExistingIndex();
        this.initCreateIndexStatement();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 310));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initPartitioningView() {
        this.partitioning = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.GlobalPartitioning"), this.partitioning);
        this.initPartitioning();
    }

    protected SpringLayout getPartitioningLayout() {
        return (SpringLayout)this.partitioning.getLayout();
    }

    private void initPartitioning() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.AllColumns"));
        this.partitioning.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 12, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 10, 30);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PKPropertyDialogOracle.SelectedColumns"));
        this.partitioning.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 292, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 290, 30);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("PKPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioning.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnAdd, 175, 145);
        this.bnRemove = new JButton(Messages.getString("PKPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioning.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnRemove, 175, 175);
        PKPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void setPartitioning(boolean bl) {
        this.allColumnsList.setEnabled(bl);
        this.selectedColumnsList.setEnabled(bl);
        this.bnAdd.setEnabled(bl && this.allColumnsList.getSelectedIndex() != -1);
        this.bnAdd.setEnabled(bl && this.selectedColumnsList.getSelectedIndex() != -1);
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        if (bl) {
            this.initPartColumns(this.pkProxy.getIndexGlobalPL());
        }
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.pkProxy.getName());
        this.tfName.setText(this.pkProxy.getName());
        this.tfTable.setText(this.pkProxy.getTable().getName());
        ColumnProxy[] columnProxyArray = this.pkProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            object = columnProxyArray[i];
            this.columnListModel.addElement(object);
        }
        this.cbInitially.setSelectedItem(this.pkProxy.getInitially());
        this.cbDeferrable.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getDeferrable()));
        this.cbEnable.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getEnable()));
        this.cbValidate.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getValidate()));
        this.cbUsingIndex.setSelectedItem(this.translate(this.pkProxy.getUsingIndex(), PKProxyOraclev9i.getUsingIndexChoices(), USING_INDEX_CHOICES));
        this.cbIndexSort.setSelectedItem(this.translate(this.pkProxy.getIndexSort(), PKProxyOraclev9i.getIndexSortChoices(), SORT_CHOICES));
        this.cbTableSpace.setSelectedItem(this.pkProxy.getTableSpace());
        this.cbLogging.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getLogging()));
        this.cbSegment.setSelectedItem(this.pkProxy.getIndexSegment());
        this.cbExTable.setSelectedItem(this.pkProxy.getExceptionsTable());
        this.cbComputeStatistics.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getComputeStatistics()));
        this.cbExistingIndex.addItem(null);
        KeyObjectSet keyObjectSet = this.pkProxy.getTable().getKeySet();
        object = this.pkProxy.getTable().getIndexes().iterator();
        while (object.hasNext()) {
            ContainerObjectPH_ShortName containerObjectPH_ShortName = (ContainerObjectPH_ShortName)object.next();
            Index index = (Index)keyObjectSet.getByName(containerObjectPH_ShortName.toString());
            if (index == null) continue;
            IndexProxyOracle indexProxyOracle = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
            this.cbExistingIndex.addItem(indexProxyOracle);
        }
        this.cbExistingIndex.setSelectedItem(this.pkProxy.getExistingIndex());
        this.taCreateIndexStatement.insert(this.pkProxy.getCreateIndexStatement(), 0);
        if (this.pkProxy.getIndexGlobalPL() != null) {
            this.setPartitioning(true);
        }
        this.comment = this.pkProxy.getObject().getComment();
        this.commentInRDBMS = this.pkProxy.getObject().getCommentInRDBMS();
        if (this.pkProxy.isCommentChanged()) {
            this.getCommentsList().insert(this.pkProxy.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.pkProxy.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.pkProxy.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void initPartColumns(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        ColumnProxy[] columnProxyArray = this.pkProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (indexGlobalPartitionsListOracle != null && indexGlobalPartitionsListOracle.getColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allColumnsModel.addElement(columnProxy);
        }
    }

    @Override
    protected void setProperties() {
        if (this.pkProxy != null) {
            Object object;
            Object object2;
            this.pkProxy.setName(this.tfName.getText());
            this.pkProxy.setInitially((String)this.cbInitially.getSelectedItem());
            this.pkProxy.setDeferrable(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.pkProxy.setEnable(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.pkProxy.setValidate(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            this.pkProxy.setUsingIndex(this.translate((String)this.cbUsingIndex.getSelectedItem(), USING_INDEX_CHOICES, PKProxyOraclev9i.getUsingIndexChoices()));
            this.pkProxy.setIndexSort(this.translate((String)this.cbIndexSort.getSelectedItem(), SORT_CHOICES, PKProxyOraclev9i.getIndexSortChoices()));
            this.pkProxy.setComputeStatistics(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.pkProxy.setExistingIndex((IndexProxyOracle)this.cbExistingIndex.getSelectedItem());
            this.pkProxy.setCreateIndexStatement(this.taCreateIndexStatement.getText());
            Object object3 = this.cbTableSpace.getSelectedItem();
            if (object3 instanceof TableSpaceOracle) {
                this.pkProxy.setTableSpace((TableSpaceOracle)object3);
            } else {
                this.pkProxy.setTableSpace(null);
            }
            this.pkProxy.setLogging(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object3 = this.cbSegment.getSelectedItem();
            if (object3 instanceof SegmentOracle) {
                this.pkProxy.setIndexSegment((SegmentOracle)object3);
            } else {
                this.pkProxy.setIndexSegment(null);
            }
            object3 = this.cbExTable.getSelectedItem();
            if (object3 instanceof TableProxyOracle) {
                this.pkProxy.setExceptionsTable((TableProxyOracle)object3);
            } else {
                this.pkProxy.setExceptionsTable(null);
            }
            if (((String)this.cbUsingIndex.getSelectedItem()).equalsIgnoreCase(GLOBAL_PARTITIONED)) {
                if (this.pkProxy.getIndexGlobalPL() != null) {
                    object2 = this.pkProxy.getIndexGlobalPL();
                } else {
                    object2 = this.getStorageDesign().getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    this.pkProxy.setIndexGlobalPL((IndexGlobalPartitionsListOracle)object2);
                }
                object = this.selectedColumnsModel.toArray();
                ((IndexGlobalPartitionsListOracle)object2).clear();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    Object object4 = object[i];
                    if (!(object4 instanceof RelationalObjectProxy)) continue;
                    ((IndexGlobalPartitionsListOracle)object2).setGlobalPartColumns(((RelationalObjectProxy)object4).getObjectID());
                }
            } else {
                object2 = this.pkProxy.getIndexGlobalPL();
                if (object2 != null) {
                    this.pkProxy.setIndexGlobalPL(null);
                    this.getStorageDesign().getIndexGlobalPartitionsListSet().remove((ModelObject)object2);
                }
            }
            if (StringUtilities.isNotEmpty((String)(object2 = this.getCommentsList().getText())) && !this.comment.equals(object2)) {
                this.pkProxy.setComment((String)object2);
                this.pkProxy.setCommentChanged(true);
            } else {
                this.pkProxy.setComment("");
                this.pkProxy.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equals(object)) {
                this.pkProxy.setCommentInRDBMS((String)object);
                this.pkProxy.setCommentInRDBMSChanged(true);
            } else {
                this.pkProxy.setCommentInRDBMS("");
                this.pkProxy.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev9i.this.allColumnsModel.contains(object)) continue;
                    PKPropertyDialogOraclev9i.this.allColumnsModel.addElement(object);
                    PKPropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PKPropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = PKPropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PKPropertyDialogOraclev9i.this.selectedColumnsModel.contains(object)) continue;
                    PKPropertyDialogOraclev9i.this.selectedColumnsModel.addElement(object);
                    PKPropertyDialogOraclev9i.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PKPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev9i.this.bnAdd.setEnabled(true);
                }
            }
        }
    }
}

