/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.NotNullConstraintOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NotNullConstraintPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private NotNullConstraintOraclev9i constraint;
    private JTextField tfTable;
    private JTextField tfColumn;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbExTable;

    public NotNullConstraintPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.constraint = (NotNullConstraintOraclev9i)storageObject;
        this.setHeight(290);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("NotNullConstraintPropertyDialogOraclev9i.NotNullConstraintProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initColumn();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initExTable();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initColumn() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Column"));
        this.general.add(jLabel);
        this.tfColumn = new JTextField("", 26);
        this.tfColumn.setEditable(false);
        this.general.add(this.tfColumn);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfColumn, 80);
    }

    private void initInitially() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Initially"));
        this.general.add(jLabel);
        this.cbInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbInitially, 110);
    }

    private void initDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Deferrable"));
        this.general.add(jLabel);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbDeferrable, 140);
    }

    private void initEnable() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Enable"));
        this.general.add(jLabel);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbEnable, 170);
    }

    private void initValidate() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.Validate"));
        this.general.add(jLabel);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbValidate, 200);
    }

    private void initExTable() {
        JLabel jLabel = new JLabel(Messages.getString("NotNullConstraintPropertyDialogOraclev9i.ExceptionsTable"));
        this.general.add(jLabel);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbExTable, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.constraint.getName());
        this.tfName.setText(this.constraint.getName());
        this.tfTable.setText(this.constraint.getTable().getName());
        this.tfColumn.setText(this.constraint.getColumn().getName());
        this.cbInitially.setSelectedItem(this.constraint.getInitially());
        this.cbDeferrable.setSelectedItem(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForDisplay(this.constraint.getDeferrable()));
        this.cbEnable.setSelectedItem(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForDisplay(this.constraint.getEnable()));
        this.cbValidate.setSelectedItem(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForDisplay(this.constraint.getValidate()));
        this.cbExTable.setSelectedItem(this.constraint.getExceptionsTable());
        this.getCommentsList().insert(this.constraint.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.constraint != null) {
            this.constraint.setName(this.tfName.getText());
            this.constraint.setInitially((String)this.cbInitially.getSelectedItem());
            this.constraint.setDeferrable(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.constraint.setEnable(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.constraint.setValidate(NotNullConstraintPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            Object object = this.cbExTable.getSelectedItem();
            if (object instanceof TableProxyOracle) {
                this.constraint.setExceptionsTable((TableProxyOracle)object);
            } else {
                this.constraint.setExceptionsTable(null);
            }
            this.constraint.setComment(this.getCommentsList().getText());
        }
    }
}

