/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class MethodPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private MethodProxyOraclev9i method;
    private JComboBox cbStatic;
    private JTextField tfMethodType;
    private JTextField tfReturnType;
    private JComboBox cbImplLanguage;
    private JTextArea taPLSQLBody;
    private JTextField tfJavaName;
    private JTextField tfCName;
    private JTextField tfCLibrary;
    private JComboBox cbWithContext;
    private JTextField tfCParameters;
    private JTextArea taPragmaClause;
    private JComboBox cbConstructor;
    private JComboBox cbOverriding;
    private JComboBox cbFinal;
    private JComboBox cbInstantiable;
    private JComboBox cbCopySelf;
    private JTextField tfAgentArguments;
    private JComboBox cbDeterministic;
    private JComboBox cbParallel;
    private JTextArea taPartitioningAndSteaming;
    private JComboBox cbPipelineAndAggregation;
    private JTextArea taPipelineAndAggregationImpl;
    private JPanel plsqlPanel;
    private JPanel pragmaPanel;
    private JPanel functionPanel;

    public MethodPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.method = (MethodProxyOraclev9i)storageObject;
        this.setHeight(530);
        this.initCommentsView(450);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodPropertyDialogOraclev9i.MethodProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initStatic();
        this.initMethodType();
        this.initReturnType();
        this.initImplLanguage();
        this.initJavaName();
        this.initCName();
        this.initCLibrary();
        this.initWithContext();
        this.initCParameters();
        this.initConstructor();
        this.initOverriding();
        this.initFinal();
        this.initInstantiable();
        this.initCopySelf();
        this.initAgentArguments();
    }

    @Override
    protected void addTabs() {
        this.initPLSQLBodyView();
        this.initPragmaClauseView();
        this.initFunctionPropsView();
    }

    private void initPLSQLBodyView() {
        this.plsqlPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("MethodPropertyDialogOraclev9i.PLSQLBody"), this.plsqlPanel);
        this.initPLSQLBody();
    }

    private void initPLSQLBody() {
        this.taPLSQLBody = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taPLSQLBody);
        jScrollPane.setPreferredSize(new Dimension(395, 450));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.plsqlPanel.add(jScrollPane);
        this.setObjectConstraints(this.getPLSQLLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getPLSQLLayout() {
        return (SpringLayout)this.plsqlPanel.getLayout();
    }

    private void initPragmaClauseView() {
        this.pragmaPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("MethodPropertyDialogOraclev9i.PragmaClause"), this.pragmaPanel);
        this.initPragmaClause();
    }

    private void initPragmaClause() {
        this.taPragmaClause = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taPragmaClause);
        jScrollPane.setPreferredSize(new Dimension(395, 450));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pragmaPanel.add(jScrollPane);
        this.setObjectConstraints(this.getPragmaLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getPragmaLayout() {
        return (SpringLayout)this.pragmaPanel.getLayout();
    }

    private void initFunctionPropsView() {
        this.functionPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("MethodPropertyDialogOraclev9i.FunctionProperties"), this.functionPanel);
        this.initFunctionProps();
    }

    private void initFunctionProps() {
        this.initDeterministic();
        this.initParallel();
        this.initPartitioningAndSteaming();
        this.initPipelineAndAggregation();
        this.initPipelineAndAggregationImpl();
    }

    private void initDeterministic() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Deterministic"));
        this.functionPanel.add(jLabel);
        this.cbDeterministic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeterministic);
        this.cbDeterministic.setPreferredSize(this.tfName.getPreferredSize());
        this.functionPanel.add(this.cbDeterministic);
        this.setLabelConstraints(this.getFunctionLayout(), jLabel, 20);
        this.setObjectConstraints(this.getFunctionLayout(), this.cbDeterministic, 20);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.ParallelEnable"));
        this.functionPanel.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.cbDeterministic.getPreferredSize());
        this.cbParallel.addActionListener(new ParallelListener());
        this.functionPanel.add(this.cbParallel);
        this.setLabelConstraints(this.getFunctionLayout(), jLabel, 50);
        this.setObjectConstraints(this.getFunctionLayout(), this.cbParallel, 50);
    }

    private void initPartitioningAndSteaming() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.PartitioningAndSteaming"));
        this.functionPanel.add(jLabel);
        this.taPartitioningAndSteaming = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taPartitioningAndSteaming);
        jScrollPane.setPreferredSize(new Dimension(395, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.functionPanel.add(jScrollPane);
        this.setLabelConstraints(this.getFunctionLayout(), jLabel, 80);
        this.setObjectConstraints(this.getFunctionLayout(), jScrollPane, 10, 100);
    }

    private void initPipelineAndAggregation() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.PipelineAndAggregation"));
        this.functionPanel.add(jLabel);
        this.cbPipelineAndAggregation = new JComboBox<String>(MethodProxyOraclev9i.PIPELINING_AND_AGGREGATION);
        this.setBG(this.cbPipelineAndAggregation);
        this.cbPipelineAndAggregation.setPreferredSize(this.cbDeterministic.getPreferredSize());
        this.functionPanel.add(this.cbPipelineAndAggregation);
        this.cbPipelineAndAggregation.addActionListener(new PipeliningAndAggregationListener());
        this.setLabelConstraints(this.getFunctionLayout(), jLabel, 270);
        this.setObjectConstraints(this.getFunctionLayout(), this.cbPipelineAndAggregation, 270);
    }

    private void initPipelineAndAggregationImpl() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.PipelineAndAggregationImpl"));
        this.functionPanel.add(jLabel);
        this.taPipelineAndAggregationImpl = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taPipelineAndAggregationImpl);
        jScrollPane.setPreferredSize(new Dimension(395, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.functionPanel.add(jScrollPane);
        this.setLabelConstraints(this.getFunctionLayout(), jLabel, 300);
        this.setObjectConstraints(this.getFunctionLayout(), jScrollPane, 10, 320);
    }

    protected SpringLayout getFunctionLayout() {
        return (SpringLayout)this.functionPanel.getLayout();
    }

    private void initStatic() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Static"));
        this.general.add(jLabel);
        this.cbStatic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbStatic);
        this.cbStatic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStatic);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbStatic, 50);
    }

    private void initMethodType() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.MethodType"));
        this.general.add(jLabel);
        this.tfMethodType = new JTextField("", 26);
        this.tfMethodType.setEnabled(false);
        this.general.add(this.tfMethodType);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfMethodType, 80);
    }

    private void initReturnType() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.ReturnType"));
        this.general.add(jLabel);
        this.tfReturnType = new JTextField("", 26);
        this.tfReturnType.setEnabled(false);
        this.general.add(this.tfReturnType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfReturnType, 110);
    }

    private void initImplLanguage() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.ImplLanguage"));
        this.general.add(jLabel);
        this.cbImplLanguage = new JComboBox<String>(MethodProxyOracle.IMPL_LANGUAGES);
        this.setBG(this.cbImplLanguage);
        this.cbImplLanguage.setPreferredSize(this.tfName.getPreferredSize());
        this.cbImplLanguage.addActionListener(new ImplLanguageListener());
        this.general.add(this.cbImplLanguage);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbImplLanguage, 140);
    }

    private void initJavaName() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.JavaName"));
        this.general.add(jLabel);
        this.tfJavaName = new JTextField("", 26);
        this.general.add(this.tfJavaName);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfJavaName, 170);
    }

    private void initCName() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.CName"));
        this.general.add(jLabel);
        this.tfCName = new JTextField("", 26);
        this.general.add(this.tfCName);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfCName, 200);
    }

    private void initCLibrary() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.CLibrary"));
        this.general.add(jLabel);
        this.tfCLibrary = new JTextField("", 26);
        this.general.add(this.tfCLibrary);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfCLibrary, 230);
    }

    private void initWithContext() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.WithContext"));
        this.general.add(jLabel);
        this.cbWithContext = new JComboBox<String>(YES_NO);
        this.setBG(this.cbWithContext);
        this.cbWithContext.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWithContext);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbWithContext, 260);
    }

    private void initCParameters() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.CParameters"));
        this.general.add(jLabel);
        this.tfCParameters = new JTextField("", 26);
        this.general.add(this.tfCParameters);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfCParameters, 290);
    }

    private void initConstructor() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Constructor"));
        this.general.add(jLabel);
        this.cbConstructor = new JComboBox<String>(YES_NO);
        this.setBG(this.cbConstructor);
        this.cbConstructor.setPreferredSize(this.tfName.getPreferredSize());
        this.cbConstructor.addActionListener(new ConstructorListener());
        this.general.add(this.cbConstructor);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbConstructor, 320);
    }

    private void initOverriding() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Overriding"));
        this.general.add(jLabel);
        this.cbOverriding = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOverriding);
        this.cbOverriding.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOverriding);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbOverriding, 350);
    }

    private void initFinal() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Final"));
        this.general.add(jLabel);
        this.cbFinal = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFinal);
        this.cbFinal.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFinal);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbFinal, 380);
    }

    private void initInstantiable() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.Instantiable"));
        this.general.add(jLabel);
        this.cbInstantiable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInstantiable);
        this.cbInstantiable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInstantiable);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbInstantiable, 410);
    }

    private void initCopySelf() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.CopySelfParameter"));
        this.general.add(jLabel);
        this.cbCopySelf = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopySelf);
        this.cbCopySelf.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopySelf);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbCopySelf, 440);
    }

    private void initAgentArguments() {
        JLabel jLabel = new JLabel(Messages.getString("MethodPropertyDialogOraclev9i.AgentArguments"));
        this.general.add(jLabel);
        this.tfAgentArguments = new JTextField("", 26);
        this.general.add(this.tfAgentArguments);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.tfAgentArguments, 470);
    }

    @Override
    public void initProperties() {
        String string;
        this.initCaption(this.method.getName());
        this.tfName.setText(this.method.getName());
        this.cbStatic.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getIsStatic()));
        this.tfMethodType.setText(this.method.getMethodType());
        if (((Method)this.method.getObject()).getReturnValue() != null) {
            this.tfReturnType.setText(((Method)this.method.getObject()).getReturnValue().toString());
        }
        this.cbImplLanguage.setSelectedItem(this.method.getImplLanguage());
        this.taPLSQLBody.setText(this.method.getPLSQLBody());
        this.tfJavaName.setText(this.method.getJavaName());
        this.tfCName.setText(this.method.getCName());
        this.tfCLibrary.setText(this.method.getCLibrary());
        this.cbWithContext.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getWithContext()));
        this.tfCParameters.setText(this.method.getCPartemeters());
        this.taPragmaClause.setText(this.method.getPragmaClause());
        this.cbConstructor.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getConstructor()));
        this.cbOverriding.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getOverriding()));
        this.cbFinal.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getIsFinal()));
        this.cbInstantiable.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getInstantiable()));
        this.cbCopySelf.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getCopySelf()));
        this.tfAgentArguments.setText(this.method.getAgentArguments());
        this.cbDeterministic.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getDeterministic()));
        this.cbParallel.setSelectedItem(MethodPropertyDialogOraclev9i.translateYesNoForDisplay(this.method.getParallel()));
        this.taPartitioningAndSteaming.setText(this.method.getPartitioningAndStreaming());
        this.cbPipelineAndAggregation.setSelectedItem(this.method.getPipeliningAndAggregation());
        this.taPipelineAndAggregationImpl.setText(this.method.getPipeliningAndAggregationImpl());
        String string2 = this.method.getPipeliningAndAggregation();
        if (MethodProxyOraclev9i.PIPELINING_AND_AGGREGATION[2].equalsIgnoreCase(string2) || MethodProxyOraclev9i.PIPELINING_AND_AGGREGATION[3].equalsIgnoreCase(string2)) {
            this.taPipelineAndAggregationImpl.setEnabled(false);
            this.cbImplLanguage.setEnabled(false);
            this.taPLSQLBody.setEnabled(false);
            this.tfJavaName.setEnabled(false);
            this.tfCName.setEnabled(false);
            this.tfCLibrary.setEnabled(false);
            this.tfAgentArguments.setEnabled(false);
            this.cbWithContext.setEnabled(false);
            this.tfCParameters.setEnabled(false);
            this.taPragmaClause.setEnabled(false);
        } else {
            this.taPipelineAndAggregationImpl.setEnabled(true);
            this.cbImplLanguage.setEnabled(true);
            this.taPragmaClause.setEnabled(true);
            string = this.method.getImplLanguage();
            if (string.equalsIgnoreCase("PL/SQL")) {
                this.taPLSQLBody.setEnabled(true);
                this.tfJavaName.setEnabled(false);
                this.tfCName.setEnabled(false);
                this.tfCLibrary.setEnabled(false);
                this.cbWithContext.setEnabled(false);
                this.tfCParameters.setEnabled(false);
            } else if (string.equalsIgnoreCase("Java")) {
                this.taPLSQLBody.setEnabled(false);
                this.tfJavaName.setEnabled(true);
                this.tfCName.setEnabled(false);
                this.tfCLibrary.setEnabled(false);
                this.cbWithContext.setEnabled(false);
                this.tfCParameters.setEnabled(false);
            } else if (string.equalsIgnoreCase("C")) {
                this.taPLSQLBody.setEnabled(false);
                this.tfJavaName.setEnabled(false);
                this.tfCName.setEnabled(true);
                this.tfCLibrary.setEnabled(true);
                this.cbWithContext.setEnabled(true);
                this.tfCParameters.setEnabled(true);
            }
        }
        string = this.method.getParallel();
        if ("YES".equalsIgnoreCase(string)) {
            this.taPartitioningAndSteaming.setEnabled(true);
        } else {
            this.taPartitioningAndSteaming.setEnabled(false);
        }
        String string3 = this.method.getConstructor();
        if ("YES".equalsIgnoreCase(string3)) {
            this.cbOverriding.setEnabled(false);
            this.cbFinal.setEnabled(false);
            this.cbInstantiable.setEnabled(false);
            this.cbFinal.setSelectedItem(YES);
            this.cbInstantiable.setSelectedItem(YES);
        } else {
            this.cbOverriding.setEnabled(true);
            this.cbFinal.setEnabled(true);
            this.cbInstantiable.setEnabled(true);
        }
        this.getCommentsList().insert(this.method.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.method != null) {
            this.method.setName(this.tfName.getText());
            this.method.setIsStatic(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbStatic.getSelectedItem()));
            this.method.setImplLanguage((String)this.cbImplLanguage.getSelectedItem());
            this.method.setPLSQLBody(this.taPLSQLBody.getText());
            this.method.setJavaName(this.tfJavaName.getText());
            this.method.setCName(this.tfCName.getText());
            this.method.setCLibrary(this.tfCLibrary.getText());
            this.method.setWithContext(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbWithContext.getSelectedItem()));
            this.method.setCPartemeters(this.tfCParameters.getText());
            this.method.setPragmaClause(this.taPragmaClause.getText());
            this.method.setConstructor(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbConstructor.getSelectedItem()));
            this.method.setOverriding(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOverriding.getSelectedItem()));
            this.method.setIsFinal(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbFinal.getSelectedItem()));
            this.method.setInstantiable(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbInstantiable.getSelectedItem()));
            this.method.setCopySelf(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCopySelf.getSelectedItem()));
            this.method.setAgentArguments(this.tfAgentArguments.getText());
            this.method.setDeterministic(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeterministic.getSelectedItem()));
            this.method.setParallel(MethodPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.method.setPartitioningAndStreaming(this.taPartitioningAndSteaming.getText());
            this.method.setPipeliningAndAggregation((String)this.cbPipelineAndAggregation.getSelectedItem());
            this.method.setPipeliningAndAggregationImpl(this.taPipelineAndAggregationImpl.getText());
            this.method.setComment(this.getCommentsList().getText());
        }
    }

    class ImplLanguageListener
    implements ActionListener {
        ImplLanguageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)MethodPropertyDialogOraclev9i.this.cbImplLanguage.getSelectedItem();
            if (string.equalsIgnoreCase("PL/SQL")) {
                MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(false);
            } else if (string.equalsIgnoreCase("Java")) {
                MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(false);
            } else if (string.equalsIgnoreCase("C")) {
                MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(true);
            }
        }
    }

    class PipeliningAndAggregationListener
    implements ActionListener {
        PipeliningAndAggregationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)MethodPropertyDialogOraclev9i.this.cbPipelineAndAggregation.getSelectedItem();
            if (MethodProxyOraclev9i.PIPELINING_AND_AGGREGATION[2].equalsIgnoreCase(string) || MethodProxyOraclev9i.PIPELINING_AND_AGGREGATION[3].equalsIgnoreCase(string)) {
                MethodPropertyDialogOraclev9i.this.taPipelineAndAggregationImpl.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbImplLanguage.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfAgentArguments.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.taPragmaClause.setEnabled(false);
            } else {
                MethodPropertyDialogOraclev9i.this.taPipelineAndAggregationImpl.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.cbImplLanguage.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.taPragmaClause.setEnabled(true);
                String string2 = (String)MethodPropertyDialogOraclev9i.this.cbImplLanguage.getSelectedItem();
                if (string2.equalsIgnoreCase("PL/SQL")) {
                    MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(true);
                    MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(false);
                } else if (string2.equalsIgnoreCase("Java")) {
                    MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(true);
                    MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(false);
                } else if (string2.equalsIgnoreCase("C")) {
                    MethodPropertyDialogOraclev9i.this.taPLSQLBody.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfJavaName.setEnabled(false);
                    MethodPropertyDialogOraclev9i.this.tfCName.setEnabled(true);
                    MethodPropertyDialogOraclev9i.this.tfCLibrary.setEnabled(true);
                    MethodPropertyDialogOraclev9i.this.cbWithContext.setEnabled(true);
                    MethodPropertyDialogOraclev9i.this.tfCParameters.setEnabled(true);
                }
            }
        }
    }

    class ParallelListener
    implements ActionListener {
        ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)MethodPropertyDialogOraclev9i.this.cbParallel.getSelectedItem();
            if (AbstractPropertyDialog.YES.equalsIgnoreCase(string)) {
                MethodPropertyDialogOraclev9i.this.taPartitioningAndSteaming.setEnabled(true);
            } else {
                MethodPropertyDialogOraclev9i.this.taPartitioningAndSteaming.setEnabled(false);
            }
        }
    }

    class ConstructorListener
    implements ActionListener {
        ConstructorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)MethodPropertyDialogOraclev9i.this.cbConstructor.getSelectedItem();
            if (AbstractPropertyDialog.YES.equalsIgnoreCase(string)) {
                MethodPropertyDialogOraclev9i.this.cbOverriding.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbFinal.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbInstantiable.setEnabled(false);
                MethodPropertyDialogOraclev9i.this.cbFinal.setSelectedItem(AbstractPropertyDialog.YES);
                MethodPropertyDialogOraclev9i.this.cbInstantiable.setSelectedItem(AbstractPropertyDialog.YES);
            } else {
                MethodPropertyDialogOraclev9i.this.cbOverriding.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.cbFinal.setEnabled(true);
                MethodPropertyDialogOraclev9i.this.cbInstantiable.setEnabled(true);
            }
        }
    }
}

