/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LocalIndexPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private IndexProxyOraclev9i index = null;
    private BitmapJoinIndexOraclev9i bji = null;
    private UniqueOraclev9i unique = null;
    private PKProxyOraclev9i pk = null;
    private PartitionOraclev9i partition = null;
    private ListPartitionOraclev9i listPartition = null;
    private HashPartitionOraclev9i hashPartition = null;
    private ListStorageTemplatePartitionOraclev9i listTemplate = null;
    private JComboBox cbIndexTableSpace;
    private JComboBox cbIndexLogging;
    private JComboBox cbIndexSegment;
    private JPanel indexHashSubPartTS;
    private JButton bnAddIndexHashSubPartTS;
    private JButton bnRemoveIndexHashSubPartTS;
    private JList allIndexHashSubPartTSList;
    private JList selectedIndexHashSubPartTSList;
    private DefaultListModel allIndexHashSubPartTSModel;
    private DefaultListModel selectedIndexHashSubPartTSModel;
    private InlineList indexHashPTSSet;
    private JTextField tfPartitionName;
    private LocalIndexProperties lip;
    private JComboBox cbSpLayerType;
    private JComboBox cbSpWorkTablespace;

    public LocalIndexPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, StorageObject storageObject2) {
        super(applicationView, storageDesign, storageObject);
        if (storageObject instanceof PartitionOraclev9i) {
            this.partition = (PartitionOraclev9i)storageObject;
        } else if (storageObject instanceof ListPartitionOraclev9i) {
            this.listPartition = (ListPartitionOraclev9i)storageObject;
        } else if (storageObject instanceof HashPartitionOraclev9i) {
            this.hashPartition = (HashPartitionOraclev9i)storageObject;
        } else if (storageObject instanceof ListStorageTemplatePartitionOraclev9i) {
            this.listTemplate = (ListStorageTemplatePartitionOraclev9i)storageObject;
        }
        if (storageObject2 instanceof IndexProxyOraclev9i) {
            this.index = (IndexProxyOraclev9i)storageObject2;
        } else if (storageObject2 instanceof BitmapJoinIndexOraclev9i) {
            this.bji = (BitmapJoinIndexOraclev9i)storageObject2;
        } else if (storageObject2 instanceof UniqueOraclev9i) {
            this.unique = (UniqueOraclev9i)storageObject2;
        } else if (storageObject2 instanceof PKProxyOraclev9i) {
            this.pk = (PKProxyOraclev9i)storageObject2;
        }
        this.lip = this.getPropsForIndex();
        this.setTitle(this.getCaption());
        this.setHeight(310);
        this.initLocalIndexes();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
    }

    public void initLocalIndexes() {
        this.initLocIndexPartitionName();
        this.initLocIndexTableSpace();
        if (this.hashPartition == null) {
            this.initLocIndexLogging();
            this.initIndexSegment();
            this.initSpatialIndex();
        }
    }

    private void initSpatialIndex() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setPreferredSize(new Dimension(this.general.getWidth() - 20, 90));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LocalIndexPropertyDialogOracle.SpatialIndex")));
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.ConstrainToLayerType"));
        jPanel.add(jLabel);
        this.cbSpLayerType = new JComboBox<String>(Index.getConstrainLayerTypeChoices());
        this.cbSpLayerType.setEnabled(false);
        this.cbSpLayerType.setPreferredSize(this.tfName.getPreferredSize());
        jPanel.add(this.cbSpLayerType);
        this.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel, 10);
        this.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.cbSpLayerType, 10);
        JLabel jLabel2 = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.WorkTablespace"));
        jPanel.add(jLabel2);
        this.cbSpWorkTablespace = new JComboBox();
        this.cbSpWorkTablespace.setEnabled(false);
        this.cbSpWorkTablespace.setPreferredSize(this.tfName.getPreferredSize());
        jPanel.add(this.cbSpWorkTablespace);
        this.setLabelConstraints((SpringLayout)jPanel.getLayout(), jLabel2, 40);
        this.setObjectConstraints((SpringLayout)jPanel.getLayout(), this.cbSpWorkTablespace, 40);
        this.general.add(jPanel);
        this.setObjectConstraints(jPanel, 10, 170);
    }

    private void initLocIndexPartitionName() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.PartitionName"));
        this.general.add(jLabel);
        this.tfPartitionName = new JTextField();
        this.tfPartitionName.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfPartitionName);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfPartitionName, 50);
    }

    private void initLocIndexTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexTableSpace"));
        this.general.add(jLabel);
        this.cbIndexTableSpace = new JComboBox();
        this.setBG(this.cbIndexTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTableSpace);
        }
        this.cbIndexTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbIndexTableSpace, 80);
    }

    private void initLocIndexLogging() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexLogging"));
        this.general.add(jLabel);
        this.cbIndexLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbIndexLogging);
        this.cbIndexLogging.setPreferredSize(this.cbIndexTableSpace.getPreferredSize());
        this.general.add(this.cbIndexLogging);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbIndexLogging, 110);
    }

    private void initIndexSegment() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexSegment"));
        this.general.add(jLabel);
        this.cbIndexSegment = new JComboBox();
        this.setBG(this.cbIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIndexSegment);
        }
        this.cbIndexSegment.setPreferredSize(this.cbIndexTableSpace.getPreferredSize());
        this.general.add(this.cbIndexSegment);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbIndexSegment, 140);
    }

    @Override
    public String getCaption() {
        if (this.index != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.LocalIndex"), this.index.getName());
        }
        if (this.bji != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.BitmapJoinIndex"), this.bji.getName());
        }
        if (this.unique != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.UniqueKey"), this.unique.getName());
        }
        if (this.pk != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.PrimaryKey"), this.pk.getName());
        }
        return "";
    }

    protected SpringLayout getIndexHashSubPartTSLayout() {
        return (SpringLayout)this.indexHashSubPartTS.getLayout();
    }

    @Override
    protected void addTabs() {
        this.initIndexHashSubPartTSView();
    }

    private void initIndexHashSubPartTSView() {
        this.indexHashSubPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("LocalIndexPropertyDialogOracle.IndexHashSubPartTableSpaces"), this.indexHashSubPartTS);
        this.initIndexHashSubPartTS();
    }

    private void initIndexHashSubPartTS() {
        this.initAllIndexHashSubPartTSList();
        this.initSelectedIndexHashSubPartTSList();
        this.initIndexHashSubPartTSButtons();
    }

    private void initAllIndexHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.AllTableSpaces"));
        this.indexHashSubPartTS.add(jLabel);
        this.allIndexHashSubPartTSModel = new DefaultListModel();
        this.allIndexHashSubPartTSList = new JList(this.allIndexHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allIndexHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIndexHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allIndexHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 230));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexHashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getIndexHashSubPartTSLayout(), jLabel, 8, 12);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), jScrollPane, 6, 32);
    }

    private void initSelectedIndexHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.SelectedTableSpaces"));
        this.indexHashSubPartTS.add(jLabel);
        this.selectedIndexHashSubPartTSModel = new DefaultListModel();
        this.selectedIndexHashSubPartTSList = new JList(this.selectedIndexHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedIndexHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIndexHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedIndexHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 230));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexHashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getIndexHashSubPartTSLayout(), jLabel, 292, 12);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), jScrollPane, 290, 32);
    }

    private void initIndexHashSubPartTSButtons() {
        this.bnAddIndexHashSubPartTS = new JButton(Messages.getString("LocalIndexPropertyDialogOracle.Add"));
        this.bnAddIndexHashSubPartTS.addActionListener(new AddIndexHashSubPartTSActionListener());
        this.bnAddIndexHashSubPartTS.setEnabled(false);
        this.indexHashSubPartTS.add(this.bnAddIndexHashSubPartTS);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), this.bnAddIndexHashSubPartTS, 160, 110);
        this.bnRemoveIndexHashSubPartTS = new JButton(Messages.getString("LocalIndexPropertyDialogOracle.Remove"));
        this.bnRemoveIndexHashSubPartTS.setEnabled(false);
        this.bnRemoveIndexHashSubPartTS.addActionListener(new RemoveIndexHashSubPartTSActionListener());
        this.indexHashSubPartTS.add(this.bnRemoveIndexHashSubPartTS);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), this.bnRemoveIndexHashSubPartTS, 160, 140);
        LocalIndexPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddIndexHashSubPartTS, this.bnRemoveIndexHashSubPartTS);
    }

    @Override
    public void initProperties() {
        this.tfName.setEnabled(false);
        if (this.lip != null) {
            this.tfName.setText(this.lip.getIndex().getName());
            this.tfPartitionName.setText(this.lip.getPartitionName());
            this.cbIndexTableSpace.setSelectedItem(this.lip.getTableSpace());
            if (this.hashPartition == null) {
                this.cbIndexLogging.setSelectedItem(LocalIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.lip.getLogging()));
                this.cbIndexSegment.setSelectedItem(this.lip.getSegment());
                if (this.lip.isSpatialIndex()) {
                    this.cbSpLayerType.setEnabled(true);
                    this.cbSpLayerType.setSelectedItem(this.lip.getLayerType());
                    this.cbSpWorkTablespace.setEnabled(true);
                    this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbSpWorkTablespace);
                    this.cbSpWorkTablespace.setSelectedItem(this.lip.getWorkTablespace());
                }
            }
            boolean bl = false;
            if (this.partition != null) {
                bl = this.partition.getPartitionList().getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH");
            }
            if (bl) {
                this.recreateIndexHashPTSSet(this.lip.getHashSubPartitionsTableSpaces());
                this.allIndexHashSubPartTSList.setEnabled(bl);
                this.selectedIndexHashSubPartTSList.setEnabled(bl);
                this.bnAddIndexHashSubPartTS.setEnabled(bl && this.allIndexHashSubPartTSList.getSelectedIndex() != -1);
                this.bnRemoveIndexHashSubPartTS.setEnabled(bl && this.selectedIndexHashSubPartTSList.getSelectedIndex() != -1);
                TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
                for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
                    TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
                    if (this.getIndexHashPTSSet().contains(tableSpaceOracle.getObjectID())) {
                        this.selectedIndexHashSubPartTSModel.addElement(tableSpaceOracle);
                        continue;
                    }
                    this.allIndexHashSubPartTSModel.addElement(tableSpaceOracle);
                }
            } else {
                this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.indexHashSubPartTS), false);
            }
            this.getCommentsList().insert(this.lip.getComment(), 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.lip != null) {
            this.lip.setPartitionName(this.tfPartitionName.getText());
            this.lip.setTableSpace((TableSpaceOraclev9i)this.cbIndexTableSpace.getSelectedItem());
            if (this.hashPartition == null) {
                this.lip.setLogging(LocalIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbIndexLogging.getSelectedItem()));
                this.lip.setSegment((SegmentOraclev9i)this.cbIndexSegment.getSelectedItem());
                if (this.lip.isSpatialIndex()) {
                    this.lip.setLayerType((String)this.cbSpLayerType.getSelectedItem());
                    this.lip.setWorkTablespace((TableSpaceOracle)this.cbSpWorkTablespace.getSelectedItem());
                }
            }
            boolean bl = false;
            if (this.partition != null) {
                bl = this.partition.getPartitionList().getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH");
            }
            if (bl) {
                this.lip.clearHashSubPartTSSet();
                Object[] objectArray = this.selectedIndexHashSubPartTSModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (!(object instanceof TableSpaceOraclev9i)) continue;
                    this.lip.setHashSubPartitionsTableSpaces(((TableSpaceOraclev9i)object).getObjectID());
                }
            }
            this.lip.setComment(this.getCommentsList().getText());
            this.lip.setDirty(true);
        }
    }

    public static String getFirstToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = " ";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2.trim();
    }

    private LocalIndexProperties getPropsForIndex() {
        if (this.partition != null) {
            if (this.index != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.partition, this.index);
            }
            if (this.bji != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.partition, this.bji);
            }
            if (this.unique != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.partition, this.unique);
            }
            if (this.pk != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.partition, this.pk);
            }
        } else if (this.listPartition != null) {
            if (this.index != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listPartition, this.index);
            }
            if (this.bji != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listPartition, this.bji);
            }
            if (this.unique != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listPartition, this.unique);
            }
            if (this.pk != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listPartition, this.pk);
            }
        } else if (this.listTemplate != null) {
            if (this.index != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listTemplate, this.index);
            }
            if (this.bji != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listTemplate, this.bji);
            }
            if (this.unique != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listTemplate, this.unique);
            }
            if (this.pk != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.listTemplate, this.pk);
            }
        } else if (this.hashPartition != null) {
            if (this.index != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.hashPartition, this.index);
            }
            if (this.bji != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.hashPartition, this.bji);
            }
            if (this.unique != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.hashPartition, this.unique);
            }
            if (this.pk != null) {
                return this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(this.hashPartition, this.pk);
            }
        }
        return null;
    }

    private void recreateIndexHashPTSSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        this.indexHashPTSSet = new InlineList();
        while (stringTokenizer.hasMoreTokens()) {
            this.getIndexHashPTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getIndexHashPTSSet() {
        if (this.indexHashPTSSet == null) {
            this.indexHashPTSSet = new InlineList();
        }
        return this.indexHashPTSSet;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append("|");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    private class RemoveIndexHashSubPartTSActionListener
    implements ActionListener {
        private RemoveIndexHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSModel.contains(object)) continue;
                    LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSModel.addElement(object);
                    LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddIndexHashSubPartTSActionListener
    implements ActionListener {
        private AddIndexHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSModel.contains(object)) continue;
                    LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSModel.addElement(object);
                    LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedIndexHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIndexHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (LocalIndexPropertyDialogOraclev9i.this.selectedIndexHashSubPartTSList.getSelectedIndex() == -1) {
                    LocalIndexPropertyDialogOraclev9i.this.bnRemoveIndexHashSubPartTS.setEnabled(false);
                } else {
                    LocalIndexPropertyDialogOraclev9i.this.bnRemoveIndexHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIndexHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllIndexHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (LocalIndexPropertyDialogOraclev9i.this.allIndexHashSubPartTSList.getSelectedIndex() == -1) {
                    LocalIndexPropertyDialogOraclev9i.this.bnAddIndexHashSubPartTS.setEnabled(false);
                } else {
                    LocalIndexPropertyDialogOraclev9i.this.bnAddIndexHashSubPartTS.setEnabled(true);
                }
            }
        }
    }
}

