/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListStorageTemplatePartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private ListStorageTemplatePartitionOraclev9i template;
    private JTextField tfValueList;
    private JComboBox cbTableSpace;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public ListStorageTemplatePartitionPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.template = (ListStorageTemplatePartitionOraclev9i)storageObject;
        this.setHeight(140);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.ListSubpartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initTableSpace();
    }

    private void initValueList() {
        JLabel jLabel = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOraclev9i.ValueList"));
        this.general.add(jLabel);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 60));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.LocalIndexes"), jPanel);
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ListStorageTemplatePartitionPropertyDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i localIndexPropertyDialogOraclev9i = new LocalIndexPropertyDialogOraclev9i(this.template.getDesign().getAppView(), this.getStorageDesign(), this.template, (StorageObject)e);
        localIndexPropertyDialogOraclev9i.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    @Override
    public void initProperties() {
        StorageObject storageObject;
        Object object;
        IndexProxy[] indexProxyArray;
        this.initCaption(this.template.getName());
        this.tfName.setText(this.template.getName());
        this.tfValueList.setText(this.template.getValueList());
        this.selectObject(this.cbTableSpace, this.template.getTablespace());
        TableProxyOraclev9i tableProxyOraclev9i = null;
        if (this.template.getPartOfStorageTable() != null) {
            tableProxyOraclev9i = (TableProxyOraclev9i)this.template.getPartOfStorageTable();
        } else {
            indexProxyArray = this.template.getSubPartitionOf();
            object = null;
            if (indexProxyArray instanceof PartitionOracle) {
                object = ((PartitionOracle)indexProxyArray).getPartitionList();
            }
            if (object != null && (tableProxyOraclev9i = (TableProxyOraclev9i)((PartitionListOracle)object).getTable()) == null && (storageObject = ((PartitionListOracle)object).getSnapshot()) != null) {
                tableProxyOraclev9i = (TableProxyOraclev9i)((SnapshotOracle)storageObject).getImplementedTable();
            }
        }
        if (tableProxyOraclev9i != null) {
            indexProxyArray = tableProxyOraclev9i.getIndexProxies();
            for (int i = 0; i < indexProxyArray.length; ++i) {
                storageObject = (IndexProxyOracle)indexProxyArray[i];
                if (storageObject == null || !((IndexProxyOracle)storageObject).getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(storageObject);
            }
            object = tableProxyOraclev9i.getBjIndexes().iterator();
            while (object.hasNext()) {
                storageObject = (BitmapJoinIndexOraclev9i)object.next();
                if (!((BitmapJoinIndexOracle)storageObject).getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(storageObject);
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.listModel.get(i) instanceof IndexProxyOraclev9i) {
                object = (IndexProxyOraclev9i)this.listModel.get(i);
                storageObject = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object);
                if (storageObject != null) continue;
                storageObject = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)storageObject).setPartition(this.template);
                ((LocalIndexProperties)storageObject).setIndex((StorageObject)object);
                continue;
            }
            if (!(this.listModel.get(i) instanceof BitmapJoinIndexOraclev9i)) continue;
            object = (BitmapJoinIndexOraclev9i)this.listModel.get(i);
            storageObject = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, (StorageObject)object);
            if (storageObject != null) continue;
            storageObject = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            ((LocalIndexProperties)storageObject).setPartition(this.template);
            ((LocalIndexProperties)storageObject).setIndex((StorageObject)object);
        }
        this.getCommentsList().insert(this.template.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.template != null) {
            this.template.setName(this.tfName.getText());
            this.template.setValueList(this.tfValueList.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.template.setTablespace((TableSpaceOracle)object);
            } else {
                this.template.setTablespace(null);
            }
            this.template.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ListStorageTemplatePartitionPropertyDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

