/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class HashPartitionDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private HashPartitionOraclev9i partition;
    private JComboBox cbTableSpace;
    private JComboBox cbIOTOverflowTablespace;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public HashPartitionDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partition = (HashPartitionOraclev9i)storageObject;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("HashPartitionDialogOracle.HashPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initIOTOverflowTablespace();
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("HashPartitionDialogOracle.Tablespace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbTableSpace, 50);
    }

    private void initIOTOverflowTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("HashPartitionDialogOracle.IOTTablespace"));
        this.general.add(jLabel);
        this.cbIOTOverflowTablespace = new JComboBox();
        this.setBG(this.cbIOTOverflowTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIOTOverflowTablespace);
        }
        this.cbIOTOverflowTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIOTOverflowTablespace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbIOTOverflowTablespace, 80);
    }

    @Override
    public void initProperties() {
        AbstractStorageObjectOracle abstractStorageObjectOracle;
        Object object;
        Object object2;
        StorageObject storageObject;
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.selectObject(this.cbIOTOverflowTablespace, this.partition.getIotOverflowTablespace());
        PartitionListOracle partitionListOracle = this.partition.getPartitionList();
        if (partitionListOracle == null && (storageObject = this.partition.getSubPartitionOf()) instanceof PartitionOracle) {
            partitionListOracle = ((PartitionOracle)storageObject).getPartitionList();
        }
        storageObject = null;
        if (partitionListOracle != null) {
            storageObject = partitionListOracle.getTable();
            if (storageObject == null && (object2 = partitionListOracle.getSnapshot()) != null) {
                storageObject = ((SnapshotOracle)object2).getImplementedTable();
            }
        } else {
            storageObject = this.partition.getPartOfStorageTable();
        }
        if (storageObject != null) {
            this.cbIOTOverflowTablespace.setEnabled(((TableProxyOracle)storageObject).getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]));
            object2 = ((TableProxy)storageObject).getIndexes().iterator();
            while (object2.hasNext()) {
                object = (IndexProxyOraclev9i)object2.next();
                if (!((IndexProxyOracle)object).getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(object);
            }
            object = ((TableProxyOracle)storageObject).getBjIndexes().iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle = (BitmapJoinIndexOraclev9i)object.next();
                if (!((BitmapJoinIndexOracle)abstractStorageObjectOracle).getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(abstractStorageObjectOracle);
            }
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.listModel.get(i) instanceof IndexProxyOraclev9i) {
                object = (IndexProxyOraclev9i)this.listModel.get(i);
                abstractStorageObjectOracle = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object);
                if (abstractStorageObjectOracle != null) continue;
                abstractStorageObjectOracle = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)abstractStorageObjectOracle).setPartition(this.partition);
                ((LocalIndexProperties)abstractStorageObjectOracle).setIndex((StorageObject)object);
                continue;
            }
            if (!(this.listModel.get(i) instanceof BitmapJoinIndexOraclev9i)) continue;
            object = (BitmapJoinIndexOraclev9i)this.listModel.get(i);
            abstractStorageObjectOracle = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, (StorageObject)object);
            if (abstractStorageObjectOracle != null) continue;
            abstractStorageObjectOracle = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            ((LocalIndexProperties)abstractStorageObjectOracle).setPartition(this.partition);
            ((LocalIndexProperties)abstractStorageObjectOracle).setIndex((StorageObject)object);
        }
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.partition.setTableSpace((TableSpaceOracle)object);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setIotOverflowTablespace((TableSpaceOraclev9i)this.cbIOTOverflowTablespace.getSelectedItem());
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 60));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("HashPartitionDialogOracle.LocalIndexes"), jPanel);
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("HashPartitionDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HashPartitionDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i localIndexPropertyDialogOraclev9i = new LocalIndexPropertyDialogOraclev9i(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)e);
        localIndexPropertyDialogOraclev9i.show();
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                HashPartitionDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

